/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.common.old;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MftOldGenStocksUtils {
    private static final ThreadLocal<Map<String, Object>> queryThreadLocal = new ThreadLocal();
    private static final ThreadLocal<Map<String, Object>> filterThreadLocal = new ThreadLocal();

    public static DynamicObject getManuEntryByEntryID(DynamicObject manuorder, String entryid) {
        DynamicObjectCollection orderentrys = manuorder.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject orderentry : orderentrys) {
            if (!StringUtils.equals((CharSequence)orderentry.getPkValue().toString(), (CharSequence)entryid)) continue;
            return orderentry;
        }
        return null;
    }

    public static DynamicObject loadSingle(Object pkId, String entityType, String selectFields, QFilter[] qFilters) {
        Map<String, Object> filterMap;
        StringBuilder keys = new StringBuilder(entityType);
        Map<String, Object> map = queryThreadLocal.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            queryThreadLocal.set(map);
        }
        if ((filterMap = filterThreadLocal.get()) == null) {
            filterMap = new HashMap<String, Object>();
            filterThreadLocal.set(filterMap);
        }
        boolean isPk = false;
        boolean isFields = false;
        if (pkId != null) {
            keys.append("##").append(pkId);
            isPk = true;
        } else if (qFilters != null) {
            for (int i = 0; i < qFilters.length; ++i) {
                QFilter qFilter = qFilters[i];
                keys.append("##").append(qFilter);
            }
        } else {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)selectFields)) {
            keys.append("##").append(selectFields);
            isFields = true;
        }
        if (keys.length() > 0) {
            DynamicObject loadData;
            Object data = map.get(keys.toString());
            if (data instanceof DynamicObject) {
                return (DynamicObject)data;
            }
            if (map.containsKey(keys.toString())) {
                return null;
            }
            if (isPk) {
                if (isFields) {
                    loadData = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(pkId.toString()), (String)entityType, (String)selectFields);
                    map.put(keys.toString(), loadData);
                    return loadData;
                }
                loadData = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(pkId.toString()), (String)entityType);
                map.put(keys.toString(), loadData);
                return loadData;
            }
            loadData = BusinessDataServiceHelper.loadSingle((String)entityType, (String)selectFields, (QFilter[])qFilters);
            map.put(keys.toString(), loadData);
            return loadData;
        }
        return null;
    }

    public static List<QFilter> getStockFilter() {
        QFilter planFilter = new QFilter("orderentryid.rowterminatestatus", "=", (Object)"A");
        QFilter bizFilter = new QFilter("orderentryid.rowclosestatus", "=", (Object)"A");
        QFilter auditFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter transcationFilter = new QFilter("transactiontypeid.isstockchange", "=", (Object)"1");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(planFilter);
        filters.add(bizFilter);
        filters.add(auditFilter);
        filters.add(transcationFilter);
        return filters;
    }

    public static BigDecimal calculateStandQty(int precision, String qtyType, BigDecimal useratio, BigDecimal orderQty, BigDecimal qtynumerator, BigDecimal qtydenominator) {
        BigDecimal standQty = BigDecimal.ZERO;
        if (StringUtils.equals((CharSequence)qtyType, (CharSequence)"A") || StringUtils.equals((CharSequence)qtyType, (CharSequence)"C")) {
            standQty = orderQty.multiply(useratio).multiply(qtynumerator).divide(qtydenominator, precision, 4);
        } else if (StringUtils.equals((CharSequence)qtyType, (CharSequence)"B")) {
            standQty = useratio.multiply(qtynumerator).divide(qtydenominator, precision, 4);
        }
        return standQty;
    }

    public static BigDecimal calculateDemadQty(int precision, boolean isconsiderloss, BigDecimal standqty, BigDecimal scraprate, BigDecimal fixscrap, String wastagerateformula) {
        BigDecimal demandQty = isconsiderloss ? ("A".equals(wastagerateformula) ? standqty.divide(BigDecimal.ONE.subtract(scraprate), precision, 4).add(fixscrap) : ("B".equals(wastagerateformula) ? standqty.multiply(BigDecimal.ONE.add(scraprate)).add(fixscrap) : standqty)) : standqty;
        demandQty = demandQty.setScale(precision, 4);
        return demandQty;
    }

    public static BigDecimal aculWIPQty(DynamicObject stockEntry) {
        BigDecimal actissueQty = stockEntry.getBigDecimal("actissueqty");
        BigDecimal feedingQty = stockEntry.getBigDecimal("feedingqty");
        BigDecimal rejectedQty = stockEntry.getBigDecimal("rejectedqty");
        BigDecimal useQty = stockEntry.getBigDecimal("useqty");
        return actissueQty.add(feedingQty).subtract(rejectedQty).subtract(useQty);
    }

    public static Object aculUnSendQty(DynamicObject stockEntry) {
        if (stockEntry != null) {
            BigDecimal demand = stockEntry.getBigDecimal("demandqty");
            BigDecimal actissue = stockEntry.getBigDecimal("actissueqty");
            BigDecimal rejecte = stockEntry.getBigDecimal("rejectedqty");
            BigDecimal feeding = stockEntry.getBigDecimal("feedingqty");
            BigDecimal scrap = stockEntry.getBigDecimal("scrapqty");
            BigDecimal cansend = BigDecimal.ZERO;
            cansend = cansend.add(demand == null ? BigDecimal.ZERO : demand);
            cansend = cansend.add(rejecte == null ? BigDecimal.ZERO : rejecte);
            cansend = cansend.subtract(actissue == null ? BigDecimal.ZERO : actissue);
            cansend = cansend.subtract(feeding == null ? BigDecimal.ZERO : feeding);
            cansend = cansend.subtract(scrap == null ? BigDecimal.ZERO : scrap);
            return cansend;
        }
        return null;
    }

    public static Object aculActissueQty(DynamicObject stockEntry) {
        if (stockEntry != null) {
            BigDecimal actissueQty = stockEntry.getBigDecimal("actissueqty");
            if (stockEntry.getBoolean("iscannegative")) {
                actissueQty = stockEntry.getBigDecimal("demandqty");
            }
            return actissueQty;
        }
        return null;
    }

    public static Object aculCanSendQty(DynamicObject stockEntry) {
        if (stockEntry != null) {
            BigDecimal demand = stockEntry.getBigDecimal("extraratioqty");
            BigDecimal actissue = stockEntry.getBigDecimal("actissueqty");
            BigDecimal rejecte = stockEntry.getBigDecimal("rejectedqty");
            BigDecimal feeding = stockEntry.getBigDecimal("feedingqty");
            BigDecimal scrap = stockEntry.getBigDecimal("scrapqty");
            BigDecimal cansend = BigDecimal.ZERO;
            cansend = cansend.add(demand == null ? BigDecimal.ZERO : demand);
            cansend = cansend.add(rejecte == null ? BigDecimal.ZERO : rejecte);
            cansend = cansend.subtract(actissue == null ? BigDecimal.ZERO : actissue);
            cansend = cansend.subtract(feeding == null ? BigDecimal.ZERO : feeding);
            if ((cansend = cansend.subtract(scrap == null ? BigDecimal.ZERO : scrap)).compareTo(BigDecimal.ZERO) < 0) {
                cansend = BigDecimal.ZERO;
            }
            return cansend;
        }
        return null;
    }

    public static BigDecimal aculOMUseQty(DynamicObject stockEntry, Object orderEntryId, DynamicObject transactiontype) {
        if (stockEntry.getBoolean("iscannegative")) {
            return BigDecimal.ZERO;
        }
        String deduction = transactiontype.getString("deduction");
        if ("A".equals(deduction)) {
            return MftOldGenStocksUtils.aculOMUseQtyA(stockEntry, orderEntryId);
        }
        return BigDecimal.ZERO;
    }

    private static BigDecimal aculOMUseQtyA(DynamicObject stockEntry, Object orderEntryId) {
        QFilter filter = new QFilter("billentry.id", "=", orderEntryId);
        DynamicObject orderDym = MftOldGenStocksUtils.loadSingle(null, "pm_om_purorderbill", "billentry.invbaseqty,billentry.baseqty,billentry.returnbaseqty,billentry", new QFilter[]{filter});
        if (orderDym == null) {
            return BigDecimal.ZERO;
        }
        DynamicObjectCollection orderEntryDym = orderDym.getDynamicObjectCollection("billentry");
        if (orderEntryDym == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal orderBaseQty = BigDecimal.ONE;
        BigDecimal stockqty = BigDecimal.ZERO;
        for (DynamicObject orderEntry : orderEntryDym) {
            if (orderEntry == null) {
                return BigDecimal.ZERO;
            }
            if (!orderEntry.getPkValue().equals(orderEntryId)) continue;
            stockqty = orderEntry.getBigDecimal("invbaseqty");
            orderBaseQty = orderEntry.getBigDecimal("baseqty");
        }
        String qtytype = stockEntry.getString("qtytype");
        BigDecimal useQty = BigDecimal.ZERO;
        if (orderBaseQty.compareTo(BigDecimal.ZERO) == 0) {
            orderBaseQty = BigDecimal.ONE;
        }
        if ("A".equals(qtytype) || "C".equals(qtytype)) {
            BigDecimal demandBaseQty = stockEntry.getBigDecimal("demandqty");
            useQty = stockqty.multiply(demandBaseQty).divide(orderBaseQty, 8, 4);
        }
        if ("B".equals(qtytype)) {
            useQty = stockqty.compareTo(orderBaseQty) >= 0 ? stockEntry.getBigDecimal("demandqty") : BigDecimal.ZERO;
        }
        return useQty;
    }
}

