/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.common.old;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.enums.QtyTypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class PurOrderCalMaterialUtils {
    public static void calMaterial(String entitytype, Object pkvalue) {
        switch (entitytype) {
            case "pm_om_purorderbill": {
                PurOrderCalMaterialUtils.claMaterialforpurOrder(entitytype, pkvalue);
                break;
            }
        }
    }

    public static void claMaterialforpurOrder(String entitytype, Object pkvalue) {
        DynamicObject purOrderInfo = BusinessDataServiceHelper.loadSingle((Object)pkvalue, (String)entitytype);
        DynamicObjectCollection billentry = purOrderInfo.getDynamicObjectCollection("billentry");
        for (int i = 0; i < billentry.size(); ++i) {
            DynamicObject entry = (DynamicObject)billentry.get(i);
            DynamicObject unit = entry.getDynamicObject("unit");
            QFilter qfilter = new QFilter("orderentryid", "=", entry.getPkValue());
            boolean isExists = QueryServiceHelper.exists((String)"om_componentlist", (QFilter[])new QFilter[]{qfilter});
            if (!isExists) continue;
            DynamicObject[] ds = BusinessDataServiceHelper.load((String)"om_componentlist", (String)"orderentryid", (QFilter[])new QFilter[]{qfilter});
            if (ds.length <= 0) continue;
            Map map = PurOrderCalMaterialUtils.calMaterialqty(ds[0], entry.getBigDecimal("qty"), unit, purOrderInfo);
            entry.set("pickingpairs", map.get("qty"));
            entry.set("pickstatus", map.get("reqstatus"));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{purOrderInfo});
    }

    private static Map calMaterialqty(DynamicObject dynamicObject, BigDecimal qty, DynamicObject unit, DynamicObject orderInfo) {
        HashMap<String, Object> restul = new HashMap<String, Object>();
        BigDecimal pickQty = BigDecimal.ZERO;
        String status = "A";
        String reqstatus = "A";
        boolean pickflag = false;
        DynamicObject stockInfo = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (String)dynamicObject.getDataEntityType().getName());
        String controlscope = PurOrderCalMaterialUtils.getControlScope(orderInfo);
        DynamicObjectCollection stocks = stockInfo.getDynamicObjectCollection("stockentry");
        for (int i = 0; i < stocks.size(); ++i) {
            DynamicObject stockentry = (DynamicObject)stocks.get(i);
            BigDecimal actissueqty = stockentry.getBigDecimal("actissueqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockentry.getBigDecimal("actissueqty");
            BigDecimal feedingqty = stockentry.getBigDecimal("feedingqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockentry.getBigDecimal("feedingqty");
            BigDecimal rejectedqty = stockentry.getBigDecimal("rejectedqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockentry.getBigDecimal("rejectedqty");
            BigDecimal scrapqty = stockentry.getBigDecimal("scrapqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockentry.getBigDecimal("scrapqty");
            BigDecimal demandqty = stockentry.getBigDecimal("demandqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockentry.getBigDecimal("demandqty");
            BigDecimal standqty = stockentry.getBigDecimal("standqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockentry.getBigDecimal("standqty");
            BigDecimal fixscrap = stockentry.getBigDecimal("fixscrap").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockentry.getBigDecimal("fixscrap");
            String qtytype = stockentry.getString("qtytype");
            String isbackflush = stockentry.getString("isbackflush");
            boolean iskeypart = stockentry.getBoolean("iskeypart");
            String issuemode = stockentry.getString("issuemode");
            if ("C".equals(issuemode) || "A".equals(controlscope) && "B".equals(isbackflush) || !iskeypart && "B".equals(controlscope) || demandqty.compareTo(BigDecimal.ZERO) == 0 || standqty.compareTo(BigDecimal.ZERO) == 0) continue;
            if (QtyTypeEnum.REGULAR.getValue().equals(qtytype)) {
                BigDecimal helpqty = actissueqty.add(feedingqty).subtract(rejectedqty).subtract(scrapqty);
                BigDecimal newpickqty = BigDecimal.ZERO;
                if (helpqty.compareTo(demandqty) >= 0) {
                    newpickqty = qty;
                }
                if (newpickqty.compareTo(pickQty) < 0) {
                    pickQty = newpickqty;
                    pickflag = true;
                    continue;
                }
                if (pickflag || pickQty.compareTo(BigDecimal.ZERO) != 0) continue;
                pickQty = newpickqty;
                pickflag = true;
                continue;
            }
            DynamicObject measureunit = BusinessDataServiceHelper.loadSingleFromCache((Object)unit.getPkValue(), (String)"bd_measureunits");
            int precision = measureunit.getInt("precision");
            String precisionaccount = measureunit.getString("precisionaccount");
            int deal = 4;
            switch (precisionaccount) {
                case "2": {
                    deal = 1;
                    break;
                }
                case "3": {
                    deal = 0;
                    break;
                }
                default: {
                    deal = 4;
                }
            }
            BigDecimal helpqty = actissueqty.add(feedingqty).subtract(rejectedqty).subtract(scrapqty);
            BigDecimal newpickqty = helpqty.multiply(qty).divide(demandqty.subtract(fixscrap), precision, deal);
            if (newpickqty.compareTo(pickQty) < 0) {
                pickQty = newpickqty;
                pickflag = true;
                continue;
            }
            if (pickflag || pickQty.compareTo(BigDecimal.ZERO) != 0) continue;
            pickQty = newpickqty;
            pickflag = true;
        }
        restul.put("qty", pickQty);
        boolean isExistsMaterialReq = false;
        Map mftproorderMap = BFTrackerServiceHelper.findTargetBills((String)"om_componentlist", (Long[])new Long[]{(Long)stockInfo.getPkValue()});
        if (CollectionUtils.isNotEmpty((Collection)((Collection)mftproorderMap.get("im_mdc_omproorder")))) {
            boolean exists;
            QFilter qFilter = new QFilter("id", "in", mftproorderMap.get("im_mdc_omproorder"));
            QFilter qFilter_1 = new QFilter("billstatus", "=", (Object)"C");
            isExistsMaterialReq = exists = QueryServiceHelper.exists((String)"im_mdc_omproorder", (QFilter[])new QFilter[]{qFilter, qFilter_1});
        }
        if (!isExistsMaterialReq && pickQty.compareTo(BigDecimal.ZERO) == 0) {
            reqstatus = "A";
            status = "B";
        } else if (isExistsMaterialReq && pickQty.compareTo(BigDecimal.ZERO) == 0) {
            reqstatus = "B";
            status = "B";
        } else if (pickQty.compareTo(BigDecimal.ZERO) > 0 && pickQty.compareTo(qty) < 0) {
            reqstatus = "B";
            status = "B";
        } else if (pickQty.compareTo(qty) == 0) {
            reqstatus = "C";
            status = "C";
        } else if (pickQty.compareTo(qty) > 0) {
            reqstatus = "D";
            status = "D";
        }
        restul.put("reqstatus", reqstatus);
        restul.put("status", status);
        return restul;
    }

    public static String getControlScope(DynamicObject manuBill) {
        String transactiontype = manuBill.getString("transactiontype");
        DynamicObject transactiontypeInfo = BusinessDataServiceHelper.loadSingle((Object)transactiontype, (String)"mpdm_transactout");
        String controlscope = transactiontypeInfo.getString("controlscope");
        return controlscope;
    }
}

