/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.common.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.manuftech.utils.ManuftechCreateBillUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.SourceRowReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class OrderChangedHelper {
    public static List<OperateErrorInfo> updateManftechBill(Object[] pks) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"om_mftorder");
        DynamicObject[] dataEntities = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)type);
        return OrderChangedHelper.updateManftechBill(dataEntities);
    }

    public static List<OperateErrorInfo> updateManftechBill(DynamicObject[] dataEntities) {
        String mgs;
        OperateErrorInfo errorInfo;
        Object pkValue;
        String message;
        Object title;
        List allErrorOrValidateInfo;
        DynamicObject[] update_technicDyObjs;
        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>(6);
        HashSet<Object> delete_technicIds = new HashSet<Object>(6);
        HashSet<Object> update_technicIds = new HashSet<Object>(6);
        HashSet<Object> creat_mftentryId = new HashSet<Object>(6);
        HashMap<Long, DynamicObject> techId_orderEntryMap = new HashMap<Long, DynamicObject>(6);
        OrderChangedHelper.dealTechnicIds(dataEntities, delete_technicIds, update_technicIds, creat_mftentryId, techId_orderEntryMap);
        if (!delete_technicIds.isEmpty()) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("orderBillType", "om_mftorder");
            operateOption.setVariableValue("orderBillName", ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355", (String)"OrderChangedHelper_0", (String)"mmc-om-common", (Object[])new Object[0]));
            operateOption.setVariableValue("stockBillType", "om_mftstock");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"om_mfttechnics", (Object[])delete_technicIds.toArray(), (OperateOption)operateOption);
            if (!operationResult.isSuccess()) {
                List allErrorOrValidateInfo2 = operationResult.getAllErrorOrValidateInfo();
                for (IOperateInfo iOperateInfo : allErrorOrValidateInfo2) {
                    String title2 = iOperateInfo.getTitle();
                    String message2 = iOperateInfo.getMessage();
                    Object pkValue2 = iOperateInfo.getPkValue();
                    OperateErrorInfo errorInfo2 = new OperateErrorInfo("deleteTechnicsError", ErrorLevel.FatalError, pkValue2);
                    errorInfo2.setMessage(message2);
                    errorInfo2.setTitle(title2);
                    errorInfos.add(errorInfo2);
                }
            }
        }
        if ((update_technicDyObjs = BusinessDataServiceHelper.load((Object[])update_technicIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"om_mfttechnics"))).length > 0) {
            List<DynamicObject> technicDyObjs = Arrays.stream(update_technicDyObjs).collect(Collectors.toList());
            List<DynamicObject> update_objs = OrderChangedHelper.dealTechnicsData(technicDyObjs, techId_orderEntryMap);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("orderBillType", "om_mftorder");
            operateOption.setVariableValue("orderBillName", ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355", (String)"OrderChangedHelper_0", (String)"mmc-om-common", (Object[])new Object[0]));
            operateOption.setVariableValue("stockBillType", "om_mftstock");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"om_mfttechnics", (DynamicObject[])update_objs.toArray(new DynamicObject[0]), (OperateOption)operateOption);
            if (!operationResult.isSuccess()) {
                allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                    title = iOperateInfo.getTitle();
                    message = iOperateInfo.getMessage();
                    pkValue = iOperateInfo.getPkValue();
                    errorInfo = new OperateErrorInfo("saveTechnicsError", ErrorLevel.FatalError, pkValue);
                    mgs = String.format(ResManager.loadKDString((String)"\u81ea\u52a8[%1$s]\u59d4\u5916\u5de5\u5e8f\u8ba1\u5212\u5931\u8d25:%2$s", (String)"OrderChangedHelper_1", (String)"mmc-om-common", (Object[])new Object[0]), title, message);
                    errorInfo.setMessage(mgs);
                    errorInfos.add(errorInfo);
                }
            }
        }
        ArrayList<Map<String, Object>> mftOrderInfos = new ArrayList<Map<String, Object>>(8);
        for (DynamicObject dataEntity : dataEntities) {
            Object pkValue3 = dataEntity.getPkValue();
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : entryEntity) {
                if (!creat_mftentryId.contains(entry.get("id"))) continue;
                HashMap<String, Object> mftOrderInfo = new HashMap<String, Object>(4);
                mftOrderInfo.put("id", pkValue3);
                mftOrderInfo.put("entryid", entry.getPkValue());
                mftOrderInfo.put("entryseq", entry.get("seq"));
                mftOrderInfos.add(mftOrderInfo);
            }
        }
        List<DynamicObject> tchDyObjs = OrderChangedHelper.push(mftOrderInfos, errorInfos);
        if (!tchDyObjs.isEmpty()) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("orderBillType", "om_mftorder");
            operateOption.setVariableValue("stockBillType", "om_mftstock");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"om_mfttechnics", (DynamicObject[])tchDyObjs.toArray(new DynamicObject[0]), (OperateOption)operateOption);
            if (!operationResult.isSuccess()) {
                allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                    title = iOperateInfo.getTitle();
                    message = iOperateInfo.getMessage();
                    pkValue = iOperateInfo.getPkValue();
                    errorInfo = new OperateErrorInfo("saveTechnicsError", ErrorLevel.FatalError, pkValue);
                    mgs = String.format(ResManager.loadKDString((String)"\u81ea\u52a8[%1$s]\u59d4\u5916\u5de5\u5e8f\u8ba1\u5212\u5931\u8d25:%2$s", (String)"OrderChangedHelper_1", (String)"mmc-om-common", (Object[])new Object[0]), title, message);
                    errorInfo.setMessage(mgs);
                    errorInfos.add(errorInfo);
                }
            }
        }
        return errorInfos;
    }

    private static List<DynamicObject> dealTechnicsData(List<DynamicObject> technicDyObjs, Map<Long, DynamicObject> techId_orderEntryMap) {
        for (DynamicObject manftech : technicDyObjs) {
            int j;
            long technicDyObjId = manftech.getLong("id");
            DynamicObject orderEntryObj = techId_orderEntryMap.get(technicDyObjId);
            manftech.set("baseqty", (Object)orderEntryObj.getBigDecimal("baseqty"));
            manftech.set("qty", (Object)orderEntryObj.getBigDecimal("qty"));
            manftech.set("headsupplier", (Object)orderEntryObj.getLong("supplier.id"));
            manftech.set("planstarttime", orderEntryObj.get("planbegintime"));
            manftech.set("planfinishtime", orderEntryObj.get("planendtime"));
            manftech.set("productionworkshop", orderEntryObj.get("producedept"));
            manftech.set("configuredcode", orderEntryObj.get("configuredcode"));
            manftech.set("tracknumber", orderEntryObj.get("tracknumber"));
            manftech.set("batchno", orderEntryObj.get("batchno"));
            manftech.set("lot", orderEntryObj.get("lot"));
            DynamicObjectCollection proentryentity = manftech.getDynamicObjectCollection("proentryentity");
            for (int j2 = 0; j2 < proentryentity.size(); ++j2) {
                DynamicObject srcObj = (DynamicObject)proentryentity.get(j2);
                srcObj.set("processplanbegintime", orderEntryObj.get("planbegintime"));
                srcObj.set("processplanendtime", orderEntryObj.get("planendtime"));
            }
            DynamicObjectCollection col = manftech.getDynamicObjectCollection("oprentryentity");
            for (j = 0; j < col.size(); ++j) {
                BigDecimal bigDecimal = orderEntryObj.getBigDecimal("qty");
                DynamicObject srcObj = (DynamicObject)col.get(j);
                ManuftechCreateBillUtil.recalculateEntryQty((DynamicObject)srcObj, (DynamicObject)orderEntryObj);
                srcObj.set("oprproductionqty", (Object)bigDecimal);
                srcObj.set("oprplanbegintime", orderEntryObj.get("planbegintime"));
                srcObj.set("oprplanfinishtime", orderEntryObj.get("planendtime"));
                srcObj.set("oprearliestbegintime", orderEntryObj.get("planbegintime"));
                srcObj.set("oprlatestbegintime", orderEntryObj.get("planbegintime"));
                srcObj.set("oprearliestfinishtime", orderEntryObj.get("planendtime"));
                srcObj.set("oprlatestfinishtime", orderEntryObj.get("planendtime"));
                DynamicObjectCollection collection = srcObj.getDynamicObjectCollection("actsubentryentity");
                for (DynamicObject object : collection) {
                    object.set("actplanbegintime", orderEntryObj.get("planbegintime"));
                    object.set("actplanfinishtime", orderEntryObj.get("planendtime"));
                    ManuftechCreateBillUtil.runFormula((DynamicObject)object, (String)"om_mfttechnics");
                }
            }
            for (j = 0; j < proentryentity.size(); ++j) {
                OrderChangedHelper.updateProentry(manftech, proentryentity, j);
            }
        }
        return technicDyObjs;
    }

    private static void updateProentry(DynamicObject manftech, DynamicObjectCollection proentryentity, int j) {
        DynamicObject srcObj = (DynamicObject)proentryentity.get(j);
        DynamicObjectCollection oprentryentity = manftech.getDynamicObjectCollection("oprentryentity");
        BigDecimal qty = BigDecimal.ZERO;
        Date begintime = null;
        Date endtime = null;
        for (DynamicObject obj : oprentryentity) {
            if (!srcObj.getString("processseq").equals(obj.getString("oprparent"))) continue;
            if (qty.compareTo(obj.getBigDecimal("oprqty")) < 0) {
                qty = obj.getBigDecimal("oprqty");
            }
            if (begintime == null || begintime.compareTo(obj.getDate("oprplanbegintime")) > 0) {
                begintime = obj.getDate("oprplanbegintime");
            }
            if (endtime != null && endtime.compareTo(obj.getDate("oprplanfinishtime")) >= 0) continue;
            endtime = obj.getDate("oprplanfinishtime");
        }
        srcObj.set("processseqqty", (Object)qty);
        srcObj.set("processplanbegintime", begintime);
        srcObj.set("processplanendtime", endtime);
    }

    private static void dealTechnicIds(DynamicObject[] dataEntities, Set<Object> delete_technicIds, Set<Object> update_technicIds, Set<Object> creat_mftentryId, Map<Long, DynamicObject> techId_orderEntryMap) {
        HashSet<String> billIds = new HashSet<String>(6);
        HashMap billEntryId_billEntryObjMap = new HashMap(6);
        for (DynamicObject dataEntity : dataEntities) {
            billIds.add(dataEntity.getString("id"));
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("treeentryentity");
            entryColl.forEach(a -> billEntryId_billEntryObjMap.put(a.getLong("id"), a));
        }
        HashSet<Long> tMftentryIds = new HashSet<Long>(6);
        if (!billIds.isEmpty()) {
            QFilter[] tQf = new QFilter[]{new QFilter("manufactureorderid", "in", billIds)};
            String algoKey = "kd.mmc.om.opplugin.order.OrderCreateManftechBill.getWillDeleteTechnicIds";
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"om_mfttechnics", (String)"id,mftentryseq.id,material.id", (QFilter[])tQf, null);){
                while (dataSet.hasNext()) {
                    Row manftech = dataSet.next();
                    Long technicId = manftech.getLong("id");
                    Long mftentryId = manftech.getLong("mftentryseq.id");
                    tMftentryIds.add(mftentryId);
                    DynamicObject mftentryObj = (DynamicObject)billEntryId_billEntryObjMap.get(mftentryId);
                    techId_orderEntryMap.put(technicId, mftentryObj);
                    if (mftentryObj != null) {
                        Long masterId = mftentryObj.getLong("material.masterid.id");
                        Long materialId = manftech.getLong("material.id");
                        if (masterId != 0L && materialId != 0L && masterId.equals(materialId)) {
                            update_technicIds.add(technicId);
                            continue;
                        }
                        delete_technicIds.add(technicId);
                        creat_mftentryId.add(mftentryId);
                        continue;
                    }
                    delete_technicIds.add(technicId);
                }
            }
        }
        Set billEntryIds = billEntryId_billEntryObjMap.keySet();
        for (Long billEntryId : billEntryIds) {
            if (tMftentryIds.contains(billEntryId)) continue;
            creat_mftentryId.add(billEntryId);
        }
    }

    private static List<DynamicObject> push(List<Map<String, Object>> mftOrderInfos, List<OperateErrorInfo> errorInfos) {
        String sourceEntity = "om_mftorder";
        String targetEntity = "om_mfttechnics";
        String ruleId = "1208488871990419456";
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(16);
        for (Map<String, Object> mftOrderItem : mftOrderInfos) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue(mftOrderItem.get("id"));
            row.setEntryEntityKey("treeentryentity");
            row.setEntryPrimaryKeyValue(mftOrderItem.get("entryid"));
            selectedRows.add(row);
        }
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(targetEntity);
        args.setRuleId(ruleId);
        args.setSelectedRows(selectedRows);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        List billReports = result.getBillReports();
        for (SourceBillReport billReport : billReports) {
            boolean success = billReport.isSuccess();
            List linkEntityRowReports = billReport.getLinkEntityRowReports();
            if (success) continue;
            String billNo = billReport.getBillNo();
            Object billId = billReport.getBillId();
            for (SourceRowReport linkEntityRowReport : linkEntityRowReports) {
                String failMessage1 = linkEntityRowReport.getFailMessage();
                int entrySeq = linkEntityRowReport.getEntrySeq();
                OperateErrorInfo errorInfo = new OperateErrorInfo("pushError", ErrorLevel.FatalError, billId);
                String mgs = String.format(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355%1$s\u7b2c%2$s\u5206\u5f55\u751f\u6210\u5de5\u5e8f\u8ba1\u5212\u5931\u8d25\uff1a%3$s\u3002", (String)"OrderChangedHelper_2", (String)"mmc-om-common", (Object[])new Object[0]), billNo, entrySeq, failMessage1);
                errorInfo.setMessage(mgs);
                errorInfos.add(errorInfo);
            }
        }
        IRefrencedataProvider refDataProvider = BusinessDataServiceHelper::loadRefence;
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
        return result.loadTargetDataObjects(refDataProvider, mainType);
    }
}

