/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.common.order;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import kd.bd.mpdm.common.manuftech.utils.ManuftechCreateBillUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.ext.mmc.business.query.helper.BillTypeQueryHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderConvertHelper {
    private static final Log logger = LogFactory.getLog(OrderConvertHelper.class);

    public static List<DynamicObject> dealTechnicsData(List<DynamicObject> dataEntitys) {
        HashSet<Object> ids = new HashSet<Object>(dataEntitys.size());
        HashMap<Object, DynamicObject> orderMap = new HashMap<Object, DynamicObject>(dataEntitys.size());
        for (DynamicObject obj : dataEntitys) {
            ids.add(obj.getDynamicObject("mftentryseq").getPkValue());
        }
        QFilter qFilter = new QFilter("treeentryentity.id", "in", ids);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"om_mftorder", (String)"treeentryentity.expendbomtime,treeentryentity.headbillno,treeentryentity.id,treeentryentity.qty,treeentryentity.planbegintime,treeentryentity.planendtime,treeentryentity.material,treeentryentity.baseqty,treeentryentity.baseunit,treeentryentity.processroute,treeentryentity.supplier,treeentryentity.producedept", (QFilter[])new QFilter[]{qFilter});
        HashSet<Object> routeIds = new HashSet<Object>(load.length);
        for (DynamicObject order : load) {
            DynamicObjectCollection entry = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entryrow : entry) {
                if (ids.contains(entryrow.getPkValue())) {
                    orderMap.put(entryrow.getPkValue(), entryrow);
                }
                if (entryrow.get("processroute") == null) continue;
                routeIds.add(entryrow.getDynamicObject("processroute").getPkValue());
            }
        }
        HashMap<Object, DynamicObject> routeMap = new HashMap<Object, DynamicObject>(routeIds.size());
        if (!routeIds.isEmpty()) {
            DynamicObject[] reoutArr;
            for (DynamicObject route : reoutArr = BusinessDataServiceHelper.load((Object[])routeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pdm_route"))) {
                routeMap.put(route.getPkValue(), route);
            }
        }
        for (int i = 0; i < dataEntitys.size(); ++i) {
            DynamicObject obj = dataEntitys.get(i);
            DynamicObject orderEntry = (DynamicObject)orderMap.get(obj.getDynamicObject("mftentryseq").getPkValue());
            if (orderEntry.get("processroute") == null) {
                OrderConvertHelper.putHeadData(obj, null, orderEntry);
                for (int j = 0; j < obj.getDynamicObjectCollection("proentryentity").size(); ++j) {
                    DynamicObject newEntryObj = (DynamicObject)obj.getDynamicObjectCollection("proentryentity").get(j);
                    newEntryObj.set("processseq", (Object)(j + 1));
                    if (j == 0) {
                        newEntryObj.set("processseqname", (Object)ResManager.loadKDString((String)"\u4e3b\u5e8f\u5217", (String)"OrderConvertHelper_0", (String)"mmc-om-common", (Object[])new Object[0]));
                        continue;
                    }
                    newEntryObj.set("processseqname", (Object)ResManager.loadKDString((String)"\u5e76\u884c\u5e8f\u5217", (String)"OrderConvertHelper_1", (String)"mmc-om-common", (Object[])new Object[0]));
                }
                continue;
            }
            OrderConvertHelper.putHeadData(obj, (DynamicObject)routeMap.get(orderEntry.getDynamicObject("processroute").getPkValue()), orderEntry);
            OrderConvertHelper.putProcessEntryData(obj, orderEntry);
            OrderConvertHelper.putOperationEntryData(obj, orderEntry);
            ManuftechCreateBillUtil.setPorValue((DynamicObject)obj, (String)"processreference");
        }
        return dataEntitys;
    }

    private static void putHeadData(DynamicObject obj, DynamicObject route, DynamicObject orderEntry) {
        if (!CodeRuleServiceHelper.isExist((String)obj.getDataEntityType().getName(), (DynamicObject)obj, (String)obj.getDynamicObject("org").getPkValue().toString())) {
            obj.set("billno", (Object)UUID.randomUUID().toString().substring(0, 30));
        } else {
            obj.set("billno", (Object)CodeRuleServiceHelper.getNumber((String)obj.getDataEntityType().getName(), (DynamicObject)obj, (String)obj.getDynamicObject("org").getPkValue().toString()));
        }
        obj.set("billstatus", (Object)"A");
        obj.set("manufactureorder", (Object)orderEntry.getString("headbillno"));
        obj.set("headsupplier", (Object)orderEntry.getLong("supplier.id"));
        if (route != null) {
            DynamicObject bom;
            DynamicObject dynamicObject = bom = route.get("bomversion") == null ? null : route.getDynamicObject("bomversion");
            if (bom != null && bom.getDataEntityType().getProperties().containsKey((Object)"version")) {
                obj.set("bomversion", bom.get("version") == null ? "" : bom.getDynamicObject("version").get("name"));
            }
        }
        obj.set("productionworkshop", orderEntry.get("producedept"));
        obj.set("processroute", (Object)route);
    }

    public static Long getDefaultBillType(String billName) {
        DynamicObject dy = BillTypeQueryHelper.getBillTypesCache((String)billName);
        return dy == null ? 0L : dy.getLong("id");
    }

    private static void putProcessEntryData(DynamicObject obj, DynamicObject orderEntry) {
        DynamicObject processRouteObj = obj.getDynamicObject("processroute");
        processRouteObj = BusinessDataServiceHelper.loadSingleFromCache((Object)processRouteObj.getPkValue(), (String)"pdm_route");
        processRouteObj.getDynamicObjectCollection("entryentity").sort((arg0, arg1) -> {
            int result = -1;
            if (arg0.getInt("processseq") > arg1.getInt("processseq")) {
                result = 1;
            }
            return result;
        });
        obj.getDynamicObjectCollection("proentryentity").clear();
        for (int i = 0; i < processRouteObj.getDynamicObjectCollection("entryentity").size(); ++i) {
            DynamicObject entryObj = (DynamicObject)processRouteObj.getDynamicObjectCollection("entryentity").get(i);
            DynamicObject newEntryObj = obj.getDynamicObjectCollection("proentryentity").addNew();
            ManuftechCreateBillUtil.setProEntryEntityValue((DynamicObject)entryObj, (DynamicObject)orderEntry, (DynamicObject)newEntryObj);
            newEntryObj.set("seq", (Object)(i + 1));
        }
    }

    private static void putOperationEntryData(DynamicObject obj, DynamicObject orderEntry) {
        DynamicObject processRouteObj = obj.getDynamicObject("processroute");
        processRouteObj = BusinessDataServiceHelper.loadSingleFromCache((Object)processRouteObj.getPkValue(), (String)"pdm_route");
        processRouteObj.getDynamicObjectCollection("processentry").sort((arg0, arg1) -> {
            int result = -1;
            if (arg0.getInt("parent") > arg1.getInt("parent")) {
                result = 1;
            } else if (arg0.getInt("parent") == arg1.getInt("parent") && arg0.getInt("operationno") > arg1.getInt("operationno")) {
                result = 1;
            }
            return result;
        });
        obj.getDynamicObjectCollection("oprentryentity").clear();
        int seq = 0;
        for (int i = 0; i < processRouteObj.getDynamicObjectCollection("processentry").size(); ++i) {
            DynamicObject entryObj = (DynamicObject)processRouteObj.getDynamicObjectCollection("processentry").get(i);
            Date processRouteValidDate = entryObj.getDate("entryvaliddate");
            Date processRouteInvalidDate = entryObj.getDate("entryinvaliddate");
            Date expendTime = orderEntry.getDate("expendbomtime");
            if (processRouteInvalidDate != null && processRouteValidDate != null && (!processRouteInvalidDate.after(expendTime) || !processRouteValidDate.before(expendTime))) continue;
            DynamicObject newEntryObj = obj.getDynamicObjectCollection("oprentryentity").addNew();
            ManuftechCreateBillUtil.setOprEntryEntityValue((DynamicObject)entryObj, (DynamicObject)orderEntry, (DynamicObject)newEntryObj);
            newEntryObj.set("oprproductionqty", (Object)obj.getBigDecimal("qty"));
            newEntryObj.set("seq", (Object)(++seq));
            ManuftechCreateBillUtil.setActSubEntryEntityValue((DynamicObject)entryObj, (DynamicObject)orderEntry, (DynamicObject)newEntryObj, (String)"om_mfttechnics");
        }
    }
}

