/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.common.order.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.OrderCloseUtils;
import kd.bd.mpdm.common.utils.MftOrderCalMaterialUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class OmOrderCloseUtils {
    private static final Log logger = LogFactory.getLog(OmOrderCloseUtils.class);
    private static String orderEntity = "om_mftorder";
    private static String stockEntity = "om_mftstock";

    private static Map<String, String[]> getPushBilInfoMap() {
        HashMap<String, String[]> BILLANDINFOCORRESPODINGMAP = new HashMap<String, String[]>();
        BILLANDINFOCORRESPODINGMAP.put("om_processreport", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u59d4\u5916\u5de5\u5e8f\u6c47\u62a5\u5355\u3002", (String)"OmOrderCloseUtils_0", (String)"mmc-om-common", (Object[])new Object[0]), "sumentry.manufactureentryid"});
        BILLANDINFOCORRESPODINGMAP.put("im_mdc_omcmplinbill", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u59d4\u5916\u5b8c\u5de5\u5165\u5e93\u5355\u3002", (String)"OmOrderCloseUtils_1", (String)"mmc-om-common", (Object[])new Object[0]), "billentry.manuentryid"});
        BILLANDINFOCORRESPODINGMAP.put("im_mdc_omoutbill", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u59d4\u5916\u9886\u6599\u5355\u3002", (String)"OmOrderCloseUtils_2", (String)"mmc-om-common", (Object[])new Object[0]), "billentry.manuentryid"});
        BILLANDINFOCORRESPODINGMAP.put("im_mdc_omreturnbill", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u59d4\u5916\u9000\u6599\u5355\u3002", (String)"OmOrderCloseUtils_3", (String)"mmc-om-common", (Object[])new Object[0]), "billentry.manuentryid"});
        BILLANDINFOCORRESPODINGMAP.put("im_mdc_omfeedbill", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u59d4\u5916\u8865\u6599\u5355\u3002", (String)"OmOrderCloseUtils_4", (String)"mmc-om-common", (Object[])new Object[0]), "billentry.manuentryid"});
        BILLANDINFOCORRESPODINGMAP.put("om_xmftorder", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u59d4\u5916\u5de5\u5355\u53d8\u66f4\u5355\u3002", (String)"OmOrderCloseUtils_5", (String)"mmc-om-common", (Object[])new Object[0]), "treeentryentity.srcbillentryid"});
        BILLANDINFOCORRESPODINGMAP.put("om_xmftstock", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355\u3002", (String)"OmOrderCloseUtils_6", (String)"mmc-om-common", (Object[])new Object[0]), "stockentry.entryorderentryid"});
        BILLANDINFOCORRESPODINGMAP.put("pm_purapplybill", new String[]{ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u59d4\u5916\u91c7\u8d2d\u7533\u8bf7\u5355\u3002", (String)"OmOrderCloseUtils_7", (String)"mmc-om-common", (Object[])new Object[0]), "billentry.mftorderentryid"});
        BILLANDINFOCORRESPODINGMAP.put("pm_purorderbill", new String[]{ResManager.loadKDString((String)"\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u672a\u5ba1\u6838\u3002", (String)"OmOrderCloseUtils_8", (String)"mmc-om-common", (Object[])new Object[0]), "billentry.mftorderentryid"});
        return BILLANDINFOCORRESPODINGMAP;
    }

    private static <T> T clone(T obj) {
        Object clonedObj = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            clonedObj = ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            logger.info(String.format("map\u6df1\u62f7\u8d1d\u51fa\u9519:%s\u3002", e));
        }
        return (T)clonedObj;
    }

    public static void batchCloseOrder(Set<Long> orderEntryidSet) {
        if (orderEntryidSet == null || orderEntryidSet.isEmpty()) {
            return;
        }
        OmOrderCloseUtils.calMaterial(orderEntryidSet);
        OmOrderCloseUtils.checkPushInfoAndClose(orderEntryidSet, true);
    }

    private static void calMaterial(Set<Long> orderEntryidSet) {
        Long startCalMaterial = System.currentTimeMillis();
        Map entityMap = OrderCloseUtils.setEntityName((String)orderEntity);
        logger.info(String.format("\u59d4\u5916\u5de5\u5355\u81ea\u52a8\u5173\u95ed->\u8ba1\u7b97\u9886\u6599\u5957\u6570\u4f20\u53c2\uff1a%s", orderEntryidSet.toString()));
        MftOrderCalMaterialUtils.calMaterial(orderEntryidSet, (boolean)true, (String)orderEntity, (Map)entityMap);
        logger.info("\u59d4\u5916\u5de5\u5355\u81ea\u52a8\u5173\u95ed->\u8ba1\u7b97\u9886\u6599\u5957\u6570\uff0c\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startCalMaterial));
    }

    private static void closeOrder(Map<Object, Map<String, Object>> orderMap, Map<Object, DynamicObject> stockMap) {
        if (null != orderMap && null != orderMap.keySet()) {
            Long startcloseOrder = System.currentTimeMillis();
            logger.info(String.format("\u51c6\u5907\u8c03\u7528\u5de5\u5355\u5173\u95ed\u63a5\u53e3\uff0c\u4f20\u53c2:%s", orderMap.keySet().toString()));
            OrderCloseUtils.closeOrder(orderMap, stockMap, (String)orderEntity);
            logger.info("\u5de5\u5355\u81ea\u52a8\u5173\u95ed->\u5c06\u7b26\u5408\u5173\u95ed\u6761\u4ef6\u7684\u5de5\u5355\u5206\u5f55\u5173\u95ed\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startcloseOrder));
        }
    }

    public static Map<Long, List<String>> checkPushInfoAndClose(Set<Long> orderEntryidSet, boolean closeOpFlag) {
        HashMap<Long, List<String>> infoMap = new HashMap<Long, List<String>>(16);
        if (orderEntryidSet == null || orderEntryidSet.isEmpty()) {
            return infoMap;
        }
        HashMap<String, String> entityMap = new HashMap<String, String>(20);
        entityMap.put("transactEntity", "mpdm_transactproduct");
        entityMap.put("tableName", "t_om_mftorderentry");
        entityMap.put("reqoutEntity", "im_mdc_omoutbill");
        entityMap.put("orderEntity", "om_mftorder");
        entityMap.put("stockEntity", "om_mftstock");
        entityMap.put("manftechEntity", "om_mfttechnics");
        Map orderMap = OrderCloseUtils.getOrderCloseMapByAutoFlag(infoMap, orderEntryidSet, entityMap, (boolean)closeOpFlag);
        Map orderMapCopy = OmOrderCloseUtils.clone(orderMap);
        if (null != orderMap && null != orderMap.keySet() && null != orderMapCopy && null != orderMapCopy.keySet()) {
            logger.info(String.format("\u5de5\u5355\u81ea\u52a8\u5173\u95ed->\u67e5\u627e\u5bf9\u5e94\u7684\u5de5\u5355\u8fc7\u6ee4\u6389\u672a\u5b8c\u5168\u9886\u6599\u7684\u5206\u5f55\uff0c\u4f20\u53c2:%s", orderMapCopy.keySet().toString()));
            Map<String, String[]> pushBillMap = OmOrderCloseUtils.getPushBilInfoMap();
            for (Map.Entry<String, String[]> m : pushBillMap.entrySet()) {
                String key = m.getKey();
                String[] value = m.getValue();
                String info = value[0];
                String srcBillEntryIdName = value[1];
                Set<String> filterList = OmOrderCloseUtils.filterUnAuditBillByEntityId(orderMapCopy, key, srcBillEntryIdName);
                OmOrderCloseUtils.dealFilerData(orderMap, filterList, infoMap, info);
            }
            Map stockMap = OrderCloseUtils.getStockMap(orderMapCopy.keySet(), (String)stockEntity);
            OmOrderCloseUtils.filterUnProStock(orderMapCopy, orderMap, stockMap, infoMap);
            if (closeOpFlag) {
                OmOrderCloseUtils.checkOmMftTechnics(orderMap);
                OmOrderCloseUtils.closeOrder(orderMap, stockMap);
            }
        }
        return infoMap;
    }

    private static void checkOmMftTechnics(Map<Object, Map<String, Object>> orderMap) {
        if (null != orderMap && null != orderMap.keySet()) {
            logger.info(String.format("\u8fc7\u6ee4\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b.\u542f\u7528\u5de5\u5e8f\u7ba1\u7406=\u662f+\u4e0b\u6e38\u5de5\u5e8f\u8ba1\u5212\u5de5\u5e8f\u5168\u90e8\u5b8c\u5de5\u4e0d\u7b26\u5408\u6570\u636e\uff0c\u4f20\u53c2:%s", orderMap.keySet().toString()));
            String entityid = "om_mfttechnics";
            String srcBillEntryIdName = "mftentryseq.id";
            Set<String> filterList = OmOrderCloseUtils.filterUnAuditBillByEntityId(orderMap, entityid, srcBillEntryIdName);
            if (null != orderMap && null != filterList && filterList.size() > 0) {
                for (String id : filterList) {
                    Iterator<Map.Entry<Object, Map<String, Object>>> iterator = orderMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Object idInMap;
                        Map.Entry<Object, Map<String, Object>> item = iterator.next();
                        if (null == item || null == (idInMap = item.getKey()) || !StringUtils.equals((CharSequence)idInMap.toString(), (CharSequence)id)) continue;
                        iterator.remove();
                        logger.info(String.format("\u59d4\u5916\u5de5\u5355\u5173\u95ed\u8fc7\u6ee4\u6570\u636e\uff1a%s,\u539f\u56e0:\u5df2\u542f\u7528\u5de5\u5e8f\u7ba1\u7406\u4f46\u4e0b\u6e38\u5de5\u5e8f\u672a\u5168\u90e8\u5b8c\u5de5\u6216\u4f5c\u5e9f", id));
                    }
                }
            }
        }
    }

    private static void dealFilerData(Map<Object, Map<String, Object>> orderMap, Set<String> filterList, Map<Long, List<String>> infoMap, String info) {
        if (null != orderMap && null != filterList && filterList.size() > 0) {
            logger.info(String.format("\u51c6\u5907\u8fc7\u6ee4\u6570\u636e:%s,\u539f\u56e0\uff1a%s", filterList.toString(), info));
            for (String id : filterList) {
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                Long idL = Long.parseLong(id);
                List<String> infoList = infoMap.get(idL);
                if (null == infoList) {
                    ArrayList<String> tempInfoList = new ArrayList<String>();
                    tempInfoList.add(info);
                    infoMap.put(idL, tempInfoList);
                } else {
                    infoList.add(info);
                }
                Iterator<Map.Entry<Object, Map<String, Object>>> iterator = orderMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object idInMap;
                    Map.Entry<Object, Map<String, Object>> item = iterator.next();
                    if (null == item || null == (idInMap = item.getKey()) || !StringUtils.equals((CharSequence)idInMap.toString(), (CharSequence)id)) continue;
                    iterator.remove();
                    logger.info(String.format("\u59d4\u5916\u5de5\u5355\u5173\u95ed\u8fc7\u6ee4\u6570\u636e\uff1a%s,\u539f\u56e0:%s", id, info));
                }
            }
        }
    }

    private static void filterUnProStock(Map<Object, Map<String, Object>> copyOrderMap, Map<Object, Map<String, Object>> orderMap, Map<Object, DynamicObject> stockMap, Map<Long, List<String>> infoMap) {
        if (null != orderMap && null != orderMap.keySet()) {
            String info = ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355\u5b58\u5728\u9000\u6599\u4e3a\u662f\u4e14\u672a\u5b8c\u5168\u9000\u6599\u7684\u5206\u5f55\u3002", (String)"OmOrderCloseUtils_9", (String)"mmc-om-common", (Object[])new Object[0]);
            logger.info(String.format("\u51c6\u5907\u8fc7\u6ee4\u6570\u636e:%s,\u539f\u56e0\uff1a%s", orderMap.keySet().toString(), info));
            String controlscope = "";
            ArrayList<Object> orderEntryList = new ArrayList<Object>(16);
            for (Map.Entry<Object, Map<String, Object>> entry : copyOrderMap.entrySet()) {
                Object key = entry.getKey();
                Map<String, Object> value = entry.getValue();
                controlscope = (String)value.get("controlscope");
                DynamicObject dynamicObject = stockMap.get(key);
                if (null == dynamicObject) continue;
                DynamicObjectCollection stockEntrys = dynamicObject.getDynamicObjectCollection("stockentry");
                if ("C".equals(controlscope) || "A".equals(controlscope)) {
                    for (DynamicObject stockEntry : stockEntrys) {
                        if (!stockEntry.getBoolean("iscannegative") || stockEntry.getBigDecimal("wipqty").compareTo(BigDecimal.ZERO) <= 0) continue;
                        orderEntryList.add(key);
                    }
                    continue;
                }
                if (!"B".equals(controlscope)) continue;
                for (DynamicObject stockEntry : stockEntrys) {
                    if (!stockEntry.getBoolean("iscannegative") || !stockEntry.getBoolean("iskeypart") || stockEntry.getBigDecimal("wipqty").compareTo(BigDecimal.ZERO) <= 0) continue;
                    orderEntryList.add(key);
                }
            }
            for (Map.Entry<Object, Map<String, Object>> entry : orderEntryList) {
                List<String> infoList = infoMap.get(entry);
                if (null != infoList && infoList.size() > 0) {
                    infoList.add(info);
                } else {
                    infoList = new ArrayList<String>(10);
                    infoList.add(info);
                }
                infoMap.put((Long)((Object)entry), infoList);
                if (null == orderMap.get(entry)) continue;
                orderMap.remove(entry);
                logger.info(String.format("\u59d4\u5916\u5de5\u5355\u5173\u95ed\u8fc7\u6ee4\u6570\u636e\uff1a%s,\u539f\u56e0:%s", entry, info));
            }
        }
    }

    private static Set<String> filterUnAuditBillByEntityId(Map<Object, Map<String, Object>> orderMap, String entityid, String srcBillEntryIdName) {
        HashSet<String> result = new HashSet<String>(10);
        if (null != orderMap && null != orderMap.keySet()) {
            QFilter filter = OmOrderCloseUtils.genFilterByEntityId(orderMap, entityid, srcBillEntryIdName);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OmOrderCloseUtilsFilter", (String)entityid, (String)srcBillEntryIdName, (QFilter[])new QFilter[]{filter}, (String)"");){
                while (dataSet.hasNext()) {
                    String id;
                    Row row = dataSet.next();
                    if (null == row || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{id = row.getString(srcBillEntryIdName)})) continue;
                    result.add(id);
                }
            }
            if (null != result && result.size() > 0) {
                logger.info(String.format("\u5de5\u5355\u5173\u95ed\u65f6\u6821\u9a8c\u4e0b\u6e38\u672a\u5ba1\u6838\u7684%s\u6570\u636e\uff0c\u8fc7\u6ee4\u6570\u636e\uff1a%s", entityid, ((Object)result).toString()));
            }
        }
        return result;
    }

    private static QFilter genFilterByEntityId(Map<Object, Map<String, Object>> orderMap, String entityid, String orderEntryName) {
        ArrayList<String> srcEntryIdStrList = new ArrayList<String>(10);
        for (Object key : orderMap.keySet()) {
            if (null == key) continue;
            String keyStr = key.toString();
            srcEntryIdStrList.add(keyStr);
        }
        QFilter filter = new QFilter("1", "=", (Object)1);
        switch (entityid) {
            case "om_processreport": {
                filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
                filter.and(new QFilter("billstatus", "!=", (Object)"C"));
                break;
            }
            case "im_mdc_omcmplinbill": {
                filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
                filter.and(new QFilter("billstatus", "!=", (Object)"C"));
                filter.and(new QFilter("billtype.billformid", "=", (Object)entityid));
                break;
            }
            case "im_mdc_omoutbill": {
                filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
                filter.and(new QFilter("billstatus", "!=", (Object)"C"));
                filter.and(new QFilter("billtype.billformid", "=", (Object)entityid));
                break;
            }
            case "im_mdc_omreturnbill": {
                filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
                filter.and(new QFilter("billstatus", "!=", (Object)"C"));
                filter.and(new QFilter("billtype.billformid", "=", (Object)entityid));
                break;
            }
            case "im_mdc_omfeedbill": {
                filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
                filter.and(new QFilter("billstatus", "!=", (Object)"C"));
                filter.and(new QFilter("billtype.billformid", "=", (Object)entityid));
                break;
            }
            case "om_xmftorder": {
                filter.and(new QFilter(orderEntryName, "in", srcEntryIdStrList));
                filter.and(new QFilter("billstatus", "!=", (Object)"C"));
                break;
            }
            case "om_xmftstock": {
                filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
                filter.and(new QFilter("billstatus", "!=", (Object)"C"));
                break;
            }
            case "pm_purapplybill": {
                filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
                filter.and(new QFilter("billstatus", "!=", (Object)"C"));
                break;
            }
            case "pm_purorderbill": {
                filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
                filter.and(new QFilter("billstatus", "!=", (Object)"C"));
                break;
            }
            case "om_mfttechnics": {
                filter.and(new QFilter(orderEntryName, "in", orderMap.keySet()));
                filter.and(new QFilter("oprentryentity.oprstatus", "!=", (Object)"F"));
                filter.and(new QFilter("oprentryentity.oprinvalid", "=", (Object)"0"));
                break;
            }
            default: {
                filter.and(new QFilter("1", "!=", (Object)1));
            }
        }
        return filter;
    }
}

