/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.common.stock.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.mftorder.utils.CreateStockByBomUtils;
import kd.bd.mpdm.common.mftorder.utils.CreateStockUtils;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.mftorderbom.utils.BomBaseData;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsBomQueryHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.mmc.business.query.helper.OrgQueryHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mmc.om.common.stock.utils.OutPurApplyData;
import org.apache.commons.lang3.math.NumberUtils;

public class CreateStockPlanUtils {
    private static final Log logger = LogFactory.getLog(CreateStockPlanUtils.class);

    public static OutPurApplyData getStockPlans(DynamicObject[] outPurapplybills, String operation, String mftstockplanName) {
        OutPurApplyData baseData = null;
        if ("save".equals(operation) || "submit".equals(operation)) {
            baseData = CreateStockPlanUtils.getOutPurapplyBasedataMap(outPurapplybills, mftstockplanName);
            CreateStockPlanUtils.readDelPurApplyEntryIds(baseData, outPurapplybills);
            CreateStockPlanUtils.readStockPlans(baseData, mftstockplanName);
            CreateStockPlanUtils.expandStocks(baseData, mftstockplanName);
        } else if ("audit".equals(operation) || "unsubmit".equals(operation) || "unaudit".equals(operation)) {
            baseData = CreateStockPlanUtils.getStockPlanMap(outPurapplybills, mftstockplanName);
        } else if ("delete".equals(operation)) {
            baseData = new OutPurApplyData();
            Set<Long> deleteOrderEntryIds = baseData.getDeleteOrderEntryIds();
            HashSet<Long> orderEntryids = new HashSet<Long>();
            for (DynamicObject order : outPurapplybills) {
                DynamicObjectCollection orderEntrys = order.getDynamicObjectCollection("billentry");
                for (DynamicObject orderEntry : orderEntrys) {
                    orderEntryids.add((Long)orderEntry.getPkValue());
                }
            }
            deleteOrderEntryIds.addAll(orderEntryids);
        }
        return baseData;
    }

    public static OutPurApplyData getOutPurapplyBasedataMap(DynamicObject[] outPurapplybills, String mftstockplanName) {
        ArrayList<Object> outPurapplyIdList = new ArrayList<Object>(outPurapplybills.length);
        for (DynamicObject outPurapplybill : outPurapplybills) {
            outPurapplyIdList.add(outPurapplybill.getPkValue());
        }
        OutPurApplyData baseData = new OutPurApplyData();
        CreateStockPlanUtils.putStockPlanMap(outPurapplyIdList, baseData, mftstockplanName);
        CreateStockPlanUtils.putOrderMap(outPurapplybills, baseData);
        CreateStockPlanUtils.putStockPlanCodeMap(outPurapplybills, baseData, mftstockplanName);
        QFilter filter = new QFilter("number", "=", (Object)"STR-0001");
        DynamicObject tran = TransactionTypeQueryHelper.getSingleDataCacheByQFilter((QFilter[])filter.toArray());
        baseData.setTranscationType(tran);
        baseData.setBilltype(MPDMMftGenStocksUtils.getDefalutBillType((String)"om_mftstockplan"));
        baseData.setUser(UserServiceHelper.getCurrentUser((String)"id"));
        baseData.setNowDate(TimeServiceHelper.now());
        return baseData;
    }

    public static void putStockPlanMap(List<Object> outPurapplyIdList, OutPurApplyData baseData, String mftstockplanName) {
        DynamicObject[] stockPlans;
        HashMap<Long, DynamicObject> stockPlanMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject stockPlan : stockPlans = BusinessDataServiceHelper.load((String)mftstockplanName, (String)CreateStockPlanUtils.selectStockplanProperties(), (QFilter[])new QFilter[]{new QFilter("orderentryid", "in", outPurapplyIdList)})) {
            Object sourceBillIDObj = stockPlan.get("sourcebillid");
            if (sourceBillIDObj == null) continue;
            stockPlanMap.put(Long.parseLong(sourceBillIDObj.toString()), stockPlan);
        }
        baseData.setStockMap(stockPlanMap);
    }

    private static OutPurApplyData getStockPlanMap(DynamicObject[] outPurapplybills, String mftstockplanName) {
        ArrayList<Object> outPurapplyIdList = new ArrayList<Object>(outPurapplybills.length);
        for (DynamicObject outPurapplybill : outPurapplybills) {
            outPurapplyIdList.add(outPurapplybill.getPkValue());
        }
        OutPurApplyData baseData = new OutPurApplyData();
        baseData.setUser(UserServiceHelper.getCurrentUser((String)"id"));
        baseData.setNowDate(TimeServiceHelper.now());
        CreateStockPlanUtils.putStockPlanMap(outPurapplyIdList, baseData, mftstockplanName);
        Map<Long, DynamicObject> stockMap = baseData.getStockMap();
        if (stockMap.size() > 0) {
            baseData.setUpdateStocks(stockMap.values().stream().collect(Collectors.toList()));
        }
        return baseData;
    }

    public static void putOrderMap(DynamicObject[] outPurapplybills, OutPurApplyData baseData) {
        logger.info("\u5f00\u59cb\u8bbe\u7f6e \u83b7\u53d6\u5de5\u5355\u76f8\u5173\u5bf9\u8c61\u96c6\u5408,\u7269\u6599\u751f\u4ea7\u4fe1\u606f,BOM\u96c6\u5408 ");
        HashMap<Long, DynamicObject> orderMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> orderEntryMap = new HashMap<Long, DynamicObject>(16);
        ArrayList<Long> orderEntryList = new ArrayList<Long>(16);
        Map<Long, Object> orgMaterialMftInfoMap = baseData.getOrgMaterialMftInfoMap();
        HashMap<Long, DynamicObject> purApplyEntryBomMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, Set<Long>> planAndpurApplyMap = new HashMap<Long, Set<Long>>(16);
        HashMap<Long, Set> masterOrg = new HashMap<Long, Set>(16);
        HashSet<Object> materialIdset = new HashSet<Object>(16);
        String orderEntryName = "billentry";
        for (DynamicObject order : outPurapplybills) {
            DynamicObjectCollection entrys = order.getDynamicObjectCollection(orderEntryName);
            if (entrys == null) continue;
            for (DynamicObject entry : entrys) {
                DynamicObject materialPur;
                Long pkValue = (Long)entry.getPkValue();
                DynamicObject linetype = entry.getDynamicObject("linetype");
                if (!StringUtils.equals((CharSequence)"010", (CharSequence)linetype.getString("number"))) continue;
                String srcBillEntity = entry.getString("srcbillentity");
                if ("om_mftorder".equals(srcBillEntity)) {
                    Long mftOrderId = entry.getLong("mftorderid");
                    Long mftOrderEntryId = entry.getLong("mftorderentryid");
                    if (mftOrderId > 0L && mftOrderEntryId > 0L) continue;
                }
                if ((materialPur = entry.getDynamicObject("material")) == null) continue;
                DynamicObject material = materialPur.getDynamicObject("masterid");
                DynamicObject entryreqorg = entry.getDynamicObject("entryreqorg");
                Object srcbillentity = entry.get("srcbillentity");
                if (StringUtils.isNotBlank((Object)srcbillentity) && StringUtils.equals((CharSequence)"mrp_planorder", (CharSequence)srcbillentity.toString())) {
                    long srcbillid = entry.get("srcbillid") == null ? 0L : entry.getLong("srcbillid");
                    planAndpurApplyMap.computeIfAbsent(srcbillid, k -> new HashSet(16)).add(pkValue);
                }
                long orgPk = Long.parseLong(entryreqorg.getPkValue().toString());
                long materialPk = Long.parseLong(material.getPkValue().toString());
                masterOrg.computeIfAbsent(orgPk, k -> new HashSet(16)).add(materialPk);
                materialIdset.add(material.getPkValue());
                orderMap.put(pkValue, order);
                orderEntryMap.put(pkValue, entry);
                orderEntryList.add(pkValue);
            }
        }
        for (Map.Entry entry : masterOrg.entrySet()) {
            Map materialMft = MaterialMftQueryHelper.getDataCacheByMaterialSet((Set)((Set)entry.getValue()), (Long)((Long)entry.getKey()));
            orgMaterialMftInfoMap.put((Long)entry.getKey(), materialMft);
        }
        baseData.setMaterialSet(MaterialQueryHelper.getDataCacheBySet(materialIdset));
        CreateStockPlanUtils.setBOM(orderEntryMap, orderEntryList, baseData, purApplyEntryBomMap);
        CreateStockPlanUtils.setPlanOrderBOM(planAndpurApplyMap, purApplyEntryBomMap);
        baseData.setOutPurApplyEntrybomMap(purApplyEntryBomMap);
        baseData.setOrderMap(orderMap);
        baseData.setOrderEntryMap(orderEntryMap);
        baseData.setOrderEntryList(orderEntryList);
    }

    private static void setBOM(Map<Long, DynamicObject> orderEntryMap, List<Long> orderEntryList, OutPurApplyData baseData, Map<Long, DynamicObject> purApplyEntryBomMap) {
        logger.info("\u5f00\u59cb \u6839\u636e\u7269\u6599\u67e5\u8be2BOM");
        Map<Object, DynamicObject> materialSet = baseData.getMaterialSet();
        for (Long outPurapplyEntryid : orderEntryList) {
            DynamicObject bom;
            DynamicObject material;
            DynamicObject outPurapplyEntry = orderEntryMap.get(outPurapplyEntryid);
            DynamicObject materialPur = outPurapplyEntry.getDynamicObject("material");
            if (materialPur == null || (material = materialPur.getDynamicObject("masterid")) == null) continue;
            material = materialSet.get(material.getPkValue());
            Object configproperties = material.get("configproperties");
            boolean isConfig = false;
            if (configproperties != null && StringUtils.equals((CharSequence)"2", (CharSequence)configproperties.toString())) {
                isConfig = true;
            }
            DynamicObject entryreqorg = outPurapplyEntry.getDynamicObject("entryreqorg");
            Object srcbillentity = outPurapplyEntry.get("srcbillentity");
            if (!StringUtils.isBlank((Object)srcbillentity) && StringUtils.equals((CharSequence)"mrp_planorder", (CharSequence)srcbillentity.toString()) || (bom = CreateStockPlanUtils.queryBomByMaterial(outPurapplyEntry, material, entryreqorg, isConfig)) == null) continue;
            logger.info("\u7269\u6599[" + material.get("number") + "]+\u7ec4\u7ec7[" + entryreqorg.get("number") + "]\u67e5\u8be2\u5230BOM[" + bom.get("number") + "]");
            purApplyEntryBomMap.put(outPurapplyEntryid, bom);
        }
    }

    private static void setPlanOrderBOM(Map<Long, Set<Long>> planAndpurApplyMap, Map<Long, DynamicObject> purApplyEntryBomMap) {
        HashMap<Long, Long> entryBomMap = new HashMap<Long, Long>(planAndpurApplyMap.size());
        QFilter filter = new QFilter("id", "in", planAndpurApplyMap.keySet());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CreateStockPlanUtils.class.getName(), (String)"mrp_planorder", (String)"id,bom.id", (QFilter[])filter.toArray(), null);){
            for (Row row : dataSet) {
                long bomid;
                Long planorderId = row.getLong("id");
                long l = bomid = row.get("bom.id") == null ? 0L : row.getLong("bom.id");
                if (!planAndpurApplyMap.containsKey(planorderId)) continue;
                Set<Long> applyBillEntryIds = planAndpurApplyMap.get(planorderId);
                for (Long applyBillEntryId : applyBillEntryIds) {
                    entryBomMap.put(applyBillEntryId, bomid);
                }
            }
        }
        QFilter bomFilter = new QFilter("id", "in", entryBomMap.values());
        bomFilter.and(new QFilter("status", "=", (Object)"C"));
        bomFilter.and(new QFilter("enable", "=", (Object)"1"));
        Map mftboms = BusinessDataServiceHelper.loadFromCache((String)"pdm_mftbom", (QFilter[])bomFilter.toArray());
        for (Map.Entry map : entryBomMap.entrySet()) {
            if (!mftboms.containsKey(map.getValue())) continue;
            purApplyEntryBomMap.put((Long)map.getKey(), (DynamicObject)mftboms.get(map.getValue()));
            logger.info("\u83b7\u53d6\u8ba1\u5212\u8ba2\u5355\u5ba1\u6838\u53ef\u7528BOM\u3010" + mftboms.get(map.getValue()) + "\u3011");
        }
    }

    private static DynamicObject queryBomByMaterial(DynamicObject entry, DynamicObject material, DynamicObject entryreqorg, boolean isConfig) {
        Date expendbomdate;
        DynamicObject configuredcode = entry.getDynamicObject("configuredcode");
        long configuredcodeID = 0L;
        HashSet<Long> bomTypeIDSet = new HashSet<Long>(1);
        Date date = expendbomdate = entry.get("bomtime") == null ? new Date() : entry.getDate("bomtime");
        if (isConfig) {
            DynamicObject PP01Dym;
            Map PP01Load = BusinessDataServiceHelper.loadFromCache((String)"mpdm_bomexpandconfig", (String)"number,entryentity.bomtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)1637711947497568256L)});
            if (!PP01Load.isEmpty() && (PP01Dym = (DynamicObject)PP01Load.get(1637711947497568256L)) != null) {
                DynamicObjectCollection entryentity = PP01Dym.getDynamicObjectCollection("entryentity");
                for (DynamicObject entryDym : entryentity) {
                    DynamicObject bomtype = entryDym.getDynamicObject("bomtype");
                    if (bomtype == null) continue;
                    bomTypeIDSet.add((Long)bomtype.getPkValue());
                }
            }
            logger.info("-------------BomSearch---bomTypeIDSet:" + ((Object)bomTypeIDSet).toString());
            if (configuredcode != null) {
                configuredcodeID = configuredcode.getLong("id");
            }
        }
        DynamicObject bom = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"MsBomQueryService", (String)"queryBomCacheByMaterial", (Object[])new Object[]{material, entryreqorg.getPkValue(), null, bomTypeIDSet, expendbomdate, "id,number,type,version,replaceno,replaceno.number,auxproperty,auditdate", "auditdate", null, configuredcodeID});
        return bom;
    }

    private static void readDelPurApplyEntryIds(OutPurApplyData baseData, DynamicObject[] outPurapplybills) {
        String purApplyEntryName = "billentry";
        HashSet<Object> existspurApplyEntryIds = new HashSet<Object>(16);
        for (DynamicObject order : outPurapplybills) {
            DynamicObjectCollection entrys = order.getDynamicObjectCollection(purApplyEntryName);
            if (entrys == null || entrys.size() <= 0) continue;
            for (DynamicObject entry : entrys) {
                existspurApplyEntryIds.add(entry.getPkValue());
            }
        }
        Set<Long> deleteOrderEntryIds = baseData.getDeleteOrderEntryIds();
        Map<Long, DynamicObject> stockMap = baseData.getStockMap();
        for (Map.Entry<Long, DynamicObject> map : stockMap.entrySet()) {
            Long key = map.getKey();
            if (existspurApplyEntryIds.contains(key)) continue;
            deleteOrderEntryIds.add(key);
        }
    }

    private static void readStockPlans(OutPurApplyData baseData, String stockname) {
        ORM orm = ORM.create();
        List<Long> orderEntryIdList = baseData.getOrderEntryList();
        Map<Long, DynamicObject> stockMap = baseData.getStockMap();
        Map<Long, DynamicObject> orderEntryMap = baseData.getOrderEntryMap();
        Map<Long, DynamicObject> orderMap = baseData.getOrderMap();
        List<DynamicObject> saveStocks = baseData.getSaveStocks();
        List<DynamicObject> updateStocks = baseData.getUpdateStocks();
        Set<Long> deleteOrderEntryIds = baseData.getDeleteOrderEntryIds();
        for (Long orderEntryId : orderEntryIdList) {
            DynamicObject stock = stockMap.get(orderEntryId);
            DynamicObject orderEntry = orderEntryMap.get(orderEntryId);
            DynamicObject outPurApply = orderMap.get(orderEntryId);
            if (stock == null) {
                DynamicObject stockPlan = CreateStockPlanUtils.getNewDynamicObject(stockname, orm);
                CreateStockPlanUtils.createHeadOfStockInfo(outPurApply, orderEntry, stockPlan, baseData);
                stockMap.put(orderEntryId, stockPlan);
                saveStocks.add(stockPlan);
                continue;
            }
            if (CreateStockPlanUtils.isUpdateStock(baseData, stock, orderEntry)) {
                CreateStockPlanUtils.updateStock(orderMap.get(orderEntryId), orderEntry, stock, baseData);
                updateStocks.add(stock);
                continue;
            }
            deleteOrderEntryIds.add(orderEntryId);
            DynamicObject orderStock = CreateStockPlanUtils.getNewDynamicObject(stockname, orm);
            CreateStockPlanUtils.createHeadOfStockInfo(outPurApply, orderEntry, orderStock, baseData);
            stockMap.put(orderEntryId, orderStock);
            saveStocks.add(orderStock);
        }
        CreateStockPlanUtils.batchSetBillNumber(baseData, stockname);
    }

    private static void updateStock(DynamicObject order, DynamicObject orderEntry, DynamicObject stock, OutPurApplyData baseData) {
        if (order == null || orderEntry == null || stock == null) {
            return;
        }
        stock.set("modifytime", (Object)baseData.getNowDate());
        stock.set("modifier", (Object)baseData.getUser());
        stock.set("qty", orderEntry.get("qty"));
        stock.set("unitid", orderEntry.get("unit"));
        BigDecimal baseqty = orderEntry.getBigDecimal("baseqty");
        BigDecimal oldQty = stock.getBigDecimal("baseqty");
        stock.set("baseqty", (Object)baseqty);
        stock.set("baseunitid", orderEntry.get("baseunit"));
        stock.set("orderno", orderEntry.get("seq"));
        stock.set("configuredcode", orderEntry.get("configuredcode"));
        stock.set("bdproject", orderEntry.get("project"));
        stock.set("tracknumber", orderEntry.get("tracknumber"));
        stock.set("auxproperty", orderEntry.get("auxpty"));
        stock.set("billauxqty", orderEntry.get("auxqty"));
        stock.set("billauxunit", orderEntry.get("auxunit"));
        stock.set("supplier", orderEntry.get("supplier"));
        Boolean isQtyChange = true;
        if (oldQty.compareTo(baseqty) == 0) {
            isQtyChange = false;
        }
        CreateStockPlanUtils.updateStockEntrys(stock, orderEntry, isQtyChange);
    }

    private static void updateStockEntrys(DynamicObject stock, DynamicObject orderEntry, Boolean isQtyChange) {
        DynamicObjectCollection stockEntrys = stock.getDynamicObjectCollection("stockentry");
        DynamicObject transactiontype = stock.getDynamicObject("transactiontypeid");
        for (DynamicObject stockEntry : stockEntrys) {
            if (stockEntry.getBoolean("isstep") && isQtyChange.booleanValue()) {
                CreateStockPlanUtils.setQtyByType(stockEntry, stock, orderEntry);
            }
            stockEntry.set("demanddate", (Object)orderEntry.getDate("deliverdate"));
        }
        if (isQtyChange.booleanValue()) {
            CreateStockPlanUtils.changeStockQtyByOrder(stock, orderEntry, transactiontype);
        }
    }

    public static void setQtyByType(DynamicObject stockEntry, DynamicObject stock, DynamicObject orderEntry) {
        DynamicObject bomDym = stock.getDynamicObject("bomid");
        if (bomDym != null && stockEntry.getBoolean("isbomextend")) {
            BigDecimal qty = orderEntry.getBigDecimal("baseqty");
            Date expendbomtime = orderEntry.getDate("bomtime");
            String bomFilterStr = CreateStockByBomUtils.getBomFilterStr((Long)((Long)bomDym.getPkValue()), (BigDecimal)qty, (Date)expendbomtime);
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-fmm-bomsearch");
            String res = (String)cache.get(bomFilterStr);
            List<Object> bbdList = new ArrayList(16);
            if (res != null && !"".equals(res)) {
                bbdList = CreateStockPlanUtils.getBBDList(res);
            } else {
                JSONArray filterArray = new JSONArray(1);
                filterArray.add((Object)CreateStockByBomUtils.getBomFilterJson((Long)((Long)bomDym.getPkValue()), (BigDecimal)qty, (Date)expendbomtime));
                String string = CreateStockByBomUtils.getQueryDataRes((String)filterArray.toString());
                if (string.indexOf("true") >= 0) {
                    res = (String)cache.get(bomFilterStr);
                    bbdList = CreateStockPlanUtils.getBBDList(res);
                }
            }
            if (stockEntry.getBoolean("isbomextend")) {
                for (BomBaseData bomBaseData : bbdList) {
                    if (!stockEntry.get("bomentryid").equals(bomBaseData.getBomEntryId())) continue;
                    CreateStockByBomUtils.setStockEntryQtyByBomBaseData((DynamicObject)stockEntry, (BomBaseData)bomBaseData);
                }
            }
        }
    }

    private static List<BomBaseData> getBBDList(String res) {
        ArrayList<BomBaseData> bbdList = new ArrayList<BomBaseData>(10);
        if (res != null && !"".equals(res)) {
            JSONArray resArray = JSONArray.parseArray((String)res);
            for (int i = 0; i < resArray.size(); ++i) {
                JSONObject resJson = (JSONObject)resArray.get(i);
                bbdList.add(CreateStockByBomUtils.getBomBaseData((JSONObject)resJson));
            }
        }
        return bbdList;
    }

    private static void changeStockQtyByOrder(DynamicObject stock, DynamicObject orderEntry, DynamicObject transactiontype) {
        boolean isconsiderloss = transactiontype.getBoolean("isconsiderloss");
        BigDecimal baseqty = orderEntry.getBigDecimal("baseqty");
        DynamicObjectCollection stockEntrys = stock.getDynamicObjectCollection("stockentry");
        for (DynamicObject stockEntry : stockEntrys) {
            DynamicObject unit = stockEntry.getDynamicObject("materialunitid");
            String wastagerateformula = (String)stockEntry.get("wastagerateformula");
            int precision = MPDMMftGenStocksUtils.getPrecision((DynamicObject)unit);
            String qtyType = stockEntry.getString("qtytype");
            BigDecimal useratio = stockEntry.getBigDecimal("useratio").divide(BigDecimal.valueOf(100L), 4, 4);
            BigDecimal qtynumerator = stockEntry.getBigDecimal("qtynumerator");
            BigDecimal qtydenominator = stockEntry.getBigDecimal("qtydenominator");
            BigDecimal standqty = MPDMMftGenStocksUtils.calculateStandQty((DynamicObject)unit, (String)qtyType, (BigDecimal)useratio, (BigDecimal)baseqty, (BigDecimal)qtynumerator, (BigDecimal)qtydenominator);
            stockEntry.set("standqty", (Object)standqty);
            BigDecimal scraprate = stockEntry.getBigDecimal("scraprate");
            BigDecimal fixscrap = stockEntry.getBigDecimal("fixscrap");
            BigDecimal demandQty = MPDMMftGenStocksUtils.calculateDemadQty((int)precision, (boolean)isconsiderloss, (BigDecimal)standqty, (BigDecimal)scraprate, (BigDecimal)fixscrap, (String)wastagerateformula);
            stockEntry.set("demandqty", (Object)demandQty);
        }
    }

    private static void expandStocks(OutPurApplyData baseData, String stockname) {
        List<DynamicObject> saveStocks = baseData.getSaveStocks();
        if (saveStocks.isEmpty()) {
            return;
        }
        Map<Long, DynamicObject> outPurApplyEntrybomMap = baseData.getOutPurApplyEntrybomMap();
        ArrayList<DynamicObject> saveBomStocks = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> savePlanStocks = new ArrayList<DynamicObject>(16);
        for (DynamicObject saveStock : saveStocks) {
            DynamicObject orderEntryDym = null;
            Map<Long, DynamicObject> orderEntryMap = baseData.getOrderEntryMap();
            if (null != orderEntryMap) {
                for (Map.Entry<Long, DynamicObject> entry : orderEntryMap.entrySet()) {
                    Long orderEntryIdInStock;
                    Long orderEntryId;
                    DynamicObject orderEntryDyn = entry.getValue();
                    if (null == orderEntryDyn || !(orderEntryId = Long.valueOf(orderEntryDyn.getLong("id"))).equals(orderEntryIdInStock = Long.valueOf(saveStock.getLong("sourcebillid")))) continue;
                    orderEntryDym = orderEntryDyn;
                    break;
                }
            }
            if (null == orderEntryDym) continue;
            if (orderEntryDym.getBoolean("isredordermate")) {
                long purapplyEntryid = orderEntryDym.getLong("id");
                DynamicObject bom = outPurApplyEntrybomMap.get(purapplyEntryid);
                if (bom != null) {
                    saveBomStocks.add(saveStock);
                    continue;
                }
                savePlanStocks.add(saveStock);
                continue;
            }
            savePlanStocks.add(saveStock);
        }
        if (!saveBomStocks.isEmpty()) {
            logger.info("\u6309BOM\u5c55\u5f00");
            CreateStockPlanUtils.expandBomStocks(saveBomStocks, baseData);
        }
        if (!savePlanStocks.isEmpty()) {
            logger.info("\u6309\u8ba1\u5212\u5efa\u8bae\u8ba2\u5355\u7269\u6599\u751f\u6210\u59d4\u5916\u7528\u6599\u8ba1\u5212");
            CreateStockPlanUtils.putPlanStockMap(savePlanStocks, baseData, stockname);
            CreateStockPlanUtils.expandPlanStocks(savePlanStocks, baseData, stockname);
        }
    }

    private static void expandPlanStocks(List<DynamicObject> savePlanStocks, OutPurApplyData baseData, String stockname) {
        Map<Long, DynamicObject> orderEntryMap = baseData.getOrderEntryMap();
        Map<Long, DynamicObject> outPurApplyEntrybomMap = baseData.getOutPurApplyEntrybomMap();
        for (DynamicObject savePlanStock : savePlanStocks) {
            Long orderEntryId = CreateStockPlanUtils.getOrderEntryIdByStock(savePlanStock);
            DynamicObject orderEntry = orderEntryMap.get(orderEntryId);
            if (orderEntry.getBoolean("isredordermate") || !"om_mftstockplan".equals(stockname) && !"mrp_planorder".equals(orderEntry.getString("srcbillentity"))) continue;
            CreateStockPlanUtils.expandPlanStockentry(savePlanStock, orderEntry, baseData, stockname);
            DynamicObject bom = outPurApplyEntrybomMap.get(orderEntryId);
            if (bom == null) continue;
            savePlanStock.set("bomid", (Object)bom);
            Object replaceno = bom.get("replaceno");
            if (replaceno == null) continue;
            savePlanStock.set("replaceno", ((DynamicObject)replaceno).get("number"));
        }
        CreateStockPlanUtils.setIsStep(savePlanStocks);
        MPDMMftGenStocksUtils.updateRepPid(savePlanStocks);
    }

    public static void setIsStep(List<DynamicObject> saveBomStocks) {
        HashSet<Long> bomEntryIdSet = new HashSet<Long>(16);
        for (DynamicObject saveBomStock : saveBomStocks) {
            DynamicObjectCollection stockEntrys = saveBomStock.getDynamicObjectCollection("stockentry");
            for (DynamicObject stockEntry : stockEntrys) {
                bomEntryIdSet.add(stockEntry.getLong("bomentryid"));
            }
        }
        if (bomEntryIdSet == null || bomEntryIdSet.isEmpty()) {
            return;
        }
        Map bomentryMap = MsBomQueryHelper.getBomEntryFromCache(bomEntryIdSet);
        HashMap<Long, Boolean> stepMap = new HashMap<Long, Boolean>(16);
        if (bomentryMap == null || bomentryMap.size() < 1) {
            return;
        }
        for (Map.Entry entry : bomentryMap.entrySet()) {
            DynamicObject query = (DynamicObject)entry.getValue();
            if (!"C".equals(query.getString("entryqtytype"))) continue;
            stepMap.put(query.getLong("id"), Boolean.TRUE);
        }
        for (DynamicObject saveBomStock : saveBomStocks) {
            DynamicObjectCollection stockEntrys = saveBomStock.getDynamicObjectCollection("stockentry");
            for (DynamicObject stockEntry : stockEntrys) {
                if (stepMap != null && stepMap.containsKey(stockEntry.getLong("bomentryid"))) {
                    stockEntry.set("isstep", (Object)Boolean.TRUE);
                    continue;
                }
                stockEntry.set("isstep", (Object)Boolean.FALSE);
            }
        }
    }

    private static void expandPlanStockentry(DynamicObject savePlanStock, DynamicObject orderEntry, OutPurApplyData baseData, String stockname) {
        Map<Long, DynamicObject> planStockMap = baseData.getPlanStockMap();
        logger.info("\u8ba1\u5212\u5c55\u5f00\uff1a");
        String srcbillentryidStr = "srcbillentryid";
        String planBillId = orderEntry.getString(srcbillentryidStr);
        if (planBillId != null && !planBillId.isEmpty()) {
            DynamicObject stock = planStockMap.get(Long.parseLong(planBillId));
            if (stock == null) {
                return;
            }
            logger.info("\u8ba1\u5212\u5efa\u8bae\u5c55\u5f00\u59d4\u5916\u7528\u6599\u8ba1\u5212\u5355\u636e\u4f53\uff1a");
            savePlanStock.set("stockentry", stock.get("stockentry"));
        }
        DynamicObject mtfOrg = savePlanStock.getDynamicObject("org");
        Long orgId = (Long)mtfOrg.getPkValue();
        Map<Long, DynamicObject> bomEntryMap = baseData.getBomEntryMap();
        DynamicObjectCollection stockEntrys = savePlanStock.getDynamicObjectCollection("stockentry");
        CreateStockPlanUtils.checkMterialErr(baseData, stockEntrys, orgId);
        for (DynamicObject stockEntry : stockEntrys) {
            DynamicObject orgfield;
            DynamicObject orgMaterialMftInfo = baseData.getOrgMaterialMftInfo(orgId, (Long)stockEntry.getDynamicObject("materielmasterid").getPkValue());
            if (orgMaterialMftInfo == null) continue;
            if (stockEntry.getBoolean("isbomextend")) {
                DynamicObject bomEntry = bomEntryMap.get(stockEntry.getLong("bomentryid"));
                CreateStockPlanUtils.setStockEntryByBomInfo(stockEntry, bomEntry);
            } else {
                CreateStockPlanUtils.setStockEntryByMftInfo(stockEntry, orgMaterialMftInfo);
                stockEntry.set("supplymode", (Object)"bos_org");
            }
            if (!"bos_org".equals(stockEntry.get("supplymode")) || (orgfield = (DynamicObject)stockEntry.get("supplyorgid")) == null) continue;
            stockEntry.set("supplierid", baseData.getSupply((Long)orgfield.getPkValue()));
        }
    }

    public static void setStockEntryByMftInfo(DynamicObject stockEntry, DynamicObject orgMaterialMftInfo) {
        stockEntry.set("materialid", (Object)orgMaterialMftInfo);
        stockEntry.set("iskeypart", orgMaterialMftInfo.get("iskeypart"));
        String issuemodestr = MPDMMftGenStocksUtils.getIssuemode((Object)orgMaterialMftInfo.get("issuemode"));
        stockEntry.set("issuemode", (Object)issuemodestr);
        stockEntry.set("supplyorgid", (Object)orgMaterialMftInfo.getDynamicObject("supplyorgunitid"));
        stockEntry.set("warehouseid", orgMaterialMftInfo.get("warehouse"));
        stockEntry.set("location", orgMaterialMftInfo.get("location"));
        stockEntry.set("isbulkmaterial", orgMaterialMftInfo.get("isbulkmaterial"));
        stockEntry.set("isstockallot", orgMaterialMftInfo.get("isstockallot"));
        stockEntry.set("isbackflush", orgMaterialMftInfo.get("isbackflush"));
        stockEntry.set("outorgunitid", orgMaterialMftInfo.get("outstorageunit"));
        stockEntry.set("outwarehouseid", orgMaterialMftInfo.get("outwarehouse"));
        stockEntry.set("outorgunitid", orgMaterialMftInfo.get("outstorageunit"));
        stockEntry.set("outwarehouseid", orgMaterialMftInfo.get("outwarehouse"));
        stockEntry.set("outlocation", orgMaterialMftInfo.get("outwarelocation"));
        DataEntityPropertyCollection properties = stockEntry.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"processseq")) {
            stockEntry.set("processseq", (Object)"1");
            stockEntry.set("oprno", (Object)"10");
        }
    }

    public static void setStockEntryByBomInfo(DynamicObject stockEntry, DynamicObject bomEntry) {
        if (bomEntry == null) {
            logger.info("bom\u5206\u5f55id\u5bf9\u5e94\u7684bom\u4e3a\u7a7a\uff0c" + stockEntry.getLong("bomentryid"));
            return;
        }
        stockEntry.set("iskeypart", bomEntry.get("entryiskey"));
        String issuemodestr = MPDMMftGenStocksUtils.getIssuemode((Object)bomEntry.get("entryissuemode"));
        stockEntry.set("issuemode", (Object)issuemodestr);
        stockEntry.set("supplyorgid", (Object)bomEntry.getDynamicObject("entrysupplyorg"));
        stockEntry.set("isbulkmaterial", bomEntry.get("entryisbulkmaterial"));
        stockEntry.set("isstockallot", bomEntry.get("entryisstockalloc"));
        stockEntry.set("isbackflush", bomEntry.get("entryisbackflush"));
        stockEntry.set("warehouseid", bomEntry.get("entrywarehouse"));
        stockEntry.set("location", bomEntry.get("entrylocation"));
        stockEntry.set("outorgunitid", bomEntry.get("entryoutorg"));
        stockEntry.set("outwarehouseid", bomEntry.get("entryoutwarehouse"));
        stockEntry.set("outlocation", bomEntry.get("entryoutlocation"));
        stockEntry.set("supplymode", bomEntry.get("entryownertype"));
        stockEntry.set("childauxpropertyid", bomEntry.get("entryauxproperty"));
        stockEntry.set("oprno", bomEntry.get("entryoperationnumber"));
        DataEntityPropertyCollection properties = stockEntry.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"processseq")) {
            stockEntry.set("processseq", bomEntry.get("entryprocessseq"));
        }
        stockEntry.set("useratio", (Object)0);
        stockEntry.set("pid", (Object)1L);
        if (bomEntry != null && !bomEntry.getBoolean("entryisreplace")) {
            stockEntry.set("useratio", (Object)100);
            stockEntry.set("pid", (Object)0L);
        }
    }

    public static void checkMterialErr(OutPurApplyData baseData, DynamicObjectCollection stockEntrys, Long orgId) {
        StringBuilder sb = new StringBuilder();
        for (DynamicObject stockEntry : stockEntrys) {
            DynamicObject orgMaterialMftInfo;
            DynamicObject master = stockEntry.getDynamicObject("materielmasterid");
            if (master == null || (orgMaterialMftInfo = baseData.getOrgMaterialMftInfo(orgId, (Long)master.getPkValue())) != null && orgMaterialMftInfo.getBoolean("enable") && "C".equalsIgnoreCase(orgMaterialMftInfo.getString("status"))) continue;
            if ("".equals(sb.toString())) {
                sb.append(master.getString("number"));
                continue;
            }
            sb.append(",");
            sb.append(master.getString("number"));
        }
        if (!"".equals(sb.toString())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u751f\u6210\u59d4\u5916\u7528\u6599\u6e05\u5355\u5931\u8d25\uff1a\u7269\u6599\u7f16\u7801%s\u65e0\u53ef\u7528\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"CreateStockPlanUtils_2", (String)"mmc-om-common", (Object[])new Object[0]), sb.toString()));
        }
    }

    private static void putPlanStockMap(List<DynamicObject> savePlanStocks, OutPurApplyData baseData, String stockname) {
        HashSet<Long> planIdList = new HashSet<Long>(10);
        for (DynamicObject savePlanStock : savePlanStocks) {
            String planBillId;
            Long orderEntryId = CreateStockPlanUtils.getOrderEntryIdByStock(savePlanStock);
            DynamicObject orderEntry = baseData.getOrderEntry(orderEntryId);
            if (!"mrp_planorder".equals(orderEntry.getString("srcbillentity")) || (planBillId = orderEntry.getString("srcbillentryid")) == null || planBillId.isEmpty()) continue;
            planIdList.add(Long.parseLong(planBillId));
        }
        if (!planIdList.isEmpty()) {
            Map<Long, DynamicObject> planStockMap = CreateStockPlanUtils.planToStock(planIdList, stockname);
            baseData.setPlanStockMap(planStockMap);
            CreateStockPlanUtils.setPlanStockBaseData(baseData);
        }
    }

    private static Map<Long, DynamicObject> planToStock(Set<Long> planIdList, String stockname) {
        HashMap<Long, DynamicObject> planStockMap = new HashMap<Long, DynamicObject>(16);
        PushArgs pushArgs = new PushArgs();
        pushArgs.setTargetEntityNumber(stockname);
        pushArgs.setHasRight(true);
        pushArgs.setRuleId("1522450512966852608");
        pushArgs.setBuildConvReport(true);
        pushArgs.setSourceEntityNumber("mrp_planorder");
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(16);
        for (Long planId : planIdList) {
            ListSelectedRow srcBill = new ListSelectedRow((Object)planId);
            needPushRows.add(srcBill);
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)stockname);
        if (!pushResult.isSuccess()) {
            logger.info("\u8ba1\u5212\uff08\u5efa\u8bae\uff09\u8ba2\u5355\u4e0b\u63a8\u59d4\u5916\u7528\u6599\u8ba1\u5212\u5931\u8d25:" + MPDMMftGenStocksUtils.getErrByRes((ConvertOperationResult)pushResult));
            throw new KDBizException(new ErrorCode("PlanAutoGenerateStockplan", MPDMMftGenStocksUtils.getErrByRes((ConvertOperationResult)pushResult)), new Object[0]);
        }
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        for (DynamicObject targetBillObj : targetBillObjs) {
            planStockMap.put(targetBillObj.getLong("sourcebillid"), targetBillObj);
        }
        return planStockMap;
    }

    private static void setPlanStockBaseData(OutPurApplyData baseData) {
        Map<Long, DynamicObject> planStockMap = baseData.getPlanStockMap();
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        HashMap orgMasterMap = new HashMap(16);
        HashSet<Long> supplyOrgIdSet = new HashSet<Long>(16);
        HashSet<Long> bomEntryIdSet = new HashSet<Long>(16);
        for (Map.Entry<Long, DynamicObject> r : planStockMap.entrySet()) {
            DynamicObject stock = r.getValue();
            DynamicObject org = stock.getDynamicObject("org");
            Long orgId = (Long)org.getPkValue();
            orgIdSet.add(orgId);
            HashSet<Long> masterSet = (HashSet<Long>)orgMasterMap.get(orgId);
            if (masterSet == null) {
                masterSet = new HashSet<Long>(16);
            }
            for (DynamicObject stockEntry : stock.getDynamicObjectCollection("stockentry")) {
                DynamicObject proMaster = stockEntry.getDynamicObject("materialid");
                proMaster = proMaster.getDynamicObject("masterid");
                masterSet.add((Long)proMaster.getPkValue());
                bomEntryIdSet.add(stockEntry.getLong("bomentryid"));
            }
            orgMasterMap.put(orgId, masterSet);
        }
        Map<Long, Object> orgMasterWastMap = baseData.getOrgMasterWastMap();
        Map<Long, Object> orgMaterialMftInfoMap = baseData.getOrgMaterialMftInfoMap();
        for (Long orgId : orgIdSet) {
            CreateStockUtils.getInfoByMaster((Long)orgId, orgMasterWastMap, orgMaterialMftInfoMap, orgMasterMap, supplyOrgIdSet);
        }
        Map<Long, Object> supplyMap = baseData.getSupplyMap();
        CreateStockPlanUtils.getSupplyMap(supplyMap, supplyOrgIdSet);
        CreateStockPlanUtils.setBomEntryMapById(bomEntryIdSet, baseData);
        baseData.setOrgMasterWastMap(orgMasterWastMap);
        baseData.setOrgMaterialMftInfoMap(orgMaterialMftInfoMap);
        baseData.setSupplyMap(supplyMap);
    }

    public static void getSupplyMap(Map<Long, Object> supplyMap, Set<Long> supplyOrgIdSet) {
        if (!supplyOrgIdSet.isEmpty()) {
            Map loadFromCache = OrgQueryHelper.getOrgBySet(supplyOrgIdSet);
            for (Long supplyOrgId : supplyOrgIdSet) {
                List owners = MPDMMftGenStocksUtils.getOwners((Long)supplyOrgId);
                DynamicObject supplyOrg = (DynamicObject)loadFromCache.get(supplyOrgId);
                if (((Boolean)supplyOrg.get("fisaccounting")).booleanValue()) {
                    owners.add(supplyOrg.getPkValue());
                }
                if (owners.isEmpty()) continue;
                supplyMap.put(supplyOrgId, owners.get(0));
            }
        }
    }

    public static DynamicObject getNewDynamicObject(String name, ORM orm) {
        return orm.newDynamicObject(name);
    }

    private static void createHeadOfStockInfo(DynamicObject manufactureOrder, DynamicObject orderEntry, DynamicObject orderStock, OutPurApplyData baseData) {
        DynamicObject masterid;
        String orderEntryid = orderEntry.getPkValue().toString();
        orderStock.set("orderno", (Object)orderEntry.getInt("seq"));
        orderStock.set("billstatus", (Object)"A");
        orderStock.set("sourcebillid", (Object)orderEntryid);
        orderStock.set("orderentryid", (Object)manufactureOrder);
        orderStock.set("supplier", orderEntry.get("supplier"));
        orderStock.set("bdproject", orderEntry.get("project"));
        orderStock.set("tracknumber", orderEntry.get("tracknumber"));
        orderStock.set("unfoldbomdate", orderEntry.get("bomtime"));
        orderStock.set("transactiontypeid", (Object)baseData.getTranscationType());
        orderStock.set("unitid", orderEntry.get("unit"));
        orderStock.set("baseunitid", orderEntry.get("baseunit"));
        orderStock.set("billauxunit", orderEntry.get("auxunit"));
        orderStock.set("billauxqty", orderEntry.get("auxqty"));
        orderStock.set("auxproperty", orderEntry.get("auxpty"));
        orderStock.set("qty", orderEntry.get("applyqty"));
        orderStock.set("baseqty", orderEntry.get("baseqty"));
        DynamicObject org = orderEntry.getDynamicObject("entryreqorg");
        DynamicObject material = orderEntry.getDynamicObject("material");
        if (null != material && org != null && (masterid = material.getDynamicObject("masterid")) != null && org != null) {
            DynamicObject orgMaterialMftInfo = baseData.getOrgMaterialMftInfo(org.getLong("id"), masterid.getLong("id"));
            orderStock.set("productid", (Object)orgMaterialMftInfo);
        }
        orderStock.set("org", (Object)org);
        orderStock.set("applyorg", manufactureOrder.get("org"));
        orderStock.set("billtype", (Object)baseData.getBilltype());
        orderStock.set("productmasterid", (Object)orderEntry.getDynamicObject("materialmasterid"));
        orderStock.set("createtime", (Object)baseData.getNowDate());
        orderStock.set("modifytime", (Object)baseData.getNowDate());
        orderStock.set("creator", (Object)baseData.getUser());
        orderStock.set("modifier", (Object)baseData.getUser());
    }

    public static void putStockPlanCodeMap(DynamicObject[] outPurapplybills, OutPurApplyData baseData, String stockname) {
        HashSet<String> orgIdSet = new HashSet<String>(16);
        for (DynamicObject order : outPurapplybills) {
            DynamicObject org = order.getDynamicObject("org");
            orgIdSet.add(org.getPkValue().toString());
        }
        HashMap<String, Object> warehouseOrgMap = new HashMap<String, Object>(orgIdSet.size());
        for (String orgId : orgIdSet) {
            Map pmAppParameterMap = MPDMMftGenStocksUtils.getPmAppParameterMap((Long)Long.parseLong(orgId), (String)stockname);
            Object warehousesource = pmAppParameterMap.get("fwarehousesource");
            warehouseOrgMap.put(orgId, warehousesource);
        }
        baseData.setWarehouseOrgMap(warehouseOrgMap);
    }

    private static void batchSetBillNumber(OutPurApplyData baseData, String stockname) {
        Long orgID;
        List<DynamicObject> saveStocks = baseData.getSaveStocks();
        HashMap<Long, DynamicObjectCollection> orgStockNumberMap = new HashMap<Long, DynamicObjectCollection>(16);
        DynamicObjectCollection coll = null;
        for (DynamicObject dynamicObject : saveStocks) {
            orgID = dynamicObject.getDynamicObject("org").getLong("id");
            if (!StringUtils.isBlank((Object)dynamicObject.get("billno"))) continue;
            coll = orgStockNumberMap.containsKey(orgID) ? (DynamicObjectCollection)orgStockNumberMap.get(orgID) : new DynamicObjectCollection();
            coll.add((Object)dynamicObject);
            orgStockNumberMap.put(orgID, coll);
        }
        for (Map.Entry entry : orgStockNumberMap.entrySet()) {
            orgID = (Long)entry.getKey();
            coll = (DynamicObjectCollection)entry.getValue();
            String[] numbers = CodeRuleServiceHelper.getBatchNumber((String)stockname, (DynamicObject)((DynamicObject)coll.get(0)), (String)orgID.toString(), (int)coll.size());
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject orderStock = (DynamicObject)coll.get(i);
                if (numbers == null || numbers.length < i + 1 || numbers[i] == null) {
                    orderStock.set("billno", (Object)("MR_" + orderStock.get("sourcebillid")));
                    continue;
                }
                orderStock.set("billno", (Object)numbers[i]);
            }
        }
    }

    private static boolean isUpdateStock(OutPurApplyData baseData, DynamicObject stock, DynamicObject orderEntry) {
        boolean expendBomTimeChange = true;
        long orderEntryid = orderEntry.getLong("id");
        Map<Long, DynamicObject> outPurApplyEntrybomMap = baseData.getOutPurApplyEntrybomMap();
        String newbomId = outPurApplyEntrybomMap.get(orderEntryid) == null ? "0" : outPurApplyEntrybomMap.get(orderEntryid).getPkValue().toString();
        String oldbomId = CreateStockPlanUtils.getFieldId(stock, "bomid");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date modifytime = stock.getDate("unfoldbomdate");
        expendBomTimeChange = sdf.format(orderEntry.getDate("bomtime")).equals(sdf.format(modifytime));
        return expendBomTimeChange && newbomId.equals(oldbomId);
    }

    private static String getFieldId(DynamicObject orderEntry, String key) {
        DynamicObject field = orderEntry.getDynamicObject(key);
        String fieldId = "0";
        if (field != null) {
            fieldId = field.getPkValue().toString();
        }
        return fieldId;
    }

    public static void expandBomStocks(List<DynamicObject> saveBomStocks, OutPurApplyData baseData) {
        JSONArray filterArrayNew = new JSONArray(16);
        HashMap<Long, String> orderEntryBomMap = new HashMap<Long, String>(16);
        Map<Long, List<BomBaseData>> orderEntryBaseMap = baseData.getOrderEntryBaseMap();
        HashSet<Long> bomEntryIdSet = new HashSet<Long>(16);
        CreateStockPlanUtils.setQueryData(filterArrayNew, orderEntryBomMap, baseData, saveBomStocks);
        if (filterArrayNew.size() > 0) {
            JSONArray result = JSON.parseArray((String)CreateStockByBomUtils.getQueryDataResMulType((String)filterArrayNew.toString()));
            JSONObject object = (JSONObject)result.get(0);
            if (result != null && StringUtils.equalsIgnoreCase((CharSequence)"false", (CharSequence)object.getString("success"))) {
                String errorInfo = object.getString("msg");
                logger.info("-------------BomExpad error:" + errorInfo);
                throw new KDBizException(new ErrorCode("bomexpanderror", errorInfo), new Object[0]);
            }
        }
        CreateStockPlanUtils.setResData(orderEntryBaseMap, bomEntryIdSet, saveBomStocks, orderEntryBomMap);
        baseData.setOrderEntryBaseMap(orderEntryBaseMap);
        CreateStockPlanUtils.setBomEntryMapById(bomEntryIdSet, baseData);
        Map<Long, DynamicObject> bomEntryMap = baseData.getBomEntryMap();
        if (!bomEntryMap.isEmpty() && !saveBomStocks.isEmpty()) {
            ArrayList<DynamicObject> bomEntrys = new ArrayList<DynamicObject>(16);
            for (Map.Entry entry : bomEntryMap.entrySet()) {
                bomEntrys.add((DynamicObject)entry.getValue());
            }
            CreateStockPlanUtils.setBOMBaseData(bomEntrys, baseData, saveBomStocks);
        }
        Map<Long, DynamicObject> outPurApplyEntrybomMap = baseData.getOutPurApplyEntrybomMap();
        for (DynamicObject dynamicObject : saveBomStocks) {
            Long orderEntryId = CreateStockPlanUtils.getOrderEntryIdByStock(dynamicObject);
            DynamicObject orderEntry = baseData.getOrderEntry(orderEntryId);
            List<BomBaseData> bbdList = orderEntryBaseMap.get(orderEntryId);
            if (bbdList == null) continue;
            DynamicObject bom = outPurApplyEntrybomMap.get(orderEntryId);
            if (bom != null) {
                dynamicObject.set("bomid", (Object)bom);
                Object replaceno = bom.get("replaceno");
                if (replaceno != null) {
                    dynamicObject.set("replaceno", ((DynamicObject)replaceno).get("number"));
                }
            }
            StringBuilder materialName = new StringBuilder(200);
            ArrayList<String> materialNameList = new ArrayList<String>(16);
            for (BomBaseData bbd : bbdList) {
                Long bomEntryId;
                DynamicObject bomEntry;
                String res;
                if (bbd.getIsJump() || "0".equals(res = CreateStockPlanUtils.createAndSetStockEntryValueByBom(orderEntry, dynamicObject, baseData, bomEntry = bomEntryMap.get(bomEntryId = bbd.getBomEntryId()), bbd)) || "1".equals(res)) continue;
                materialNameList.add(res);
            }
            CreateStockPlanUtils.appendErrInfo(materialNameList, materialName);
            if (materialName.length() <= 0) continue;
            CreateStockPlanUtils.throwException(materialName, orderEntry);
        }
        CreateStockUtils.setIsStep(saveBomStocks);
        MPDMMftGenStocksUtils.updateRepPid(saveBomStocks);
    }

    private static void setQueryData(JSONArray filterArrayNew, Map<Long, String> orderEntryBomMap, OutPurApplyData baseData, List<DynamicObject> saveBomStocks) {
        Map<Long, DynamicObject> outPurApplyEntrybomMap = baseData.getOutPurApplyEntrybomMap();
        for (DynamicObject saveBomStock : saveBomStocks) {
            Long orderEntryId = CreateStockPlanUtils.getOrderEntryIdByStock(saveBomStock);
            DynamicObject orderEntry = baseData.getOrderEntry(orderEntryId);
            DynamicObject bom = outPurApplyEntrybomMap.get(orderEntryId);
            if (bom == null) continue;
            Date expandtime = orderEntry.getDate("bomtime");
            Long masterid = CreateStockPlanUtils.getPkid(saveBomStock.get("productmasterid"));
            Long orgId = CreateStockPlanUtils.getPkid(saveBomStock.get("org"));
            Long entryConfigCodeid = CreateStockPlanUtils.getPkid(orderEntry.get("configuredcode"));
            HashMap<String, Object> paramMap = CreateStockPlanUtils.getParamsMap(masterid, expandtime, orgId, entryConfigCodeid, orderEntry.getBigDecimal("qty"), bom);
            JSONObject jsonParams = CreateStockByBomUtils.getMulBOMJsonObjectParam(paramMap);
            filterArrayNew.add((Object)jsonParams);
            String resStr = CreateStockByBomUtils.getMulBomFilterStr((JSONObject)jsonParams);
            orderEntryBomMap.put(orderEntryId, resStr);
        }
    }

    private static HashMap<String, Object> getParamsMap(Long masterid, Date expendbomtime, Long orgId, Long entryConfigCodeid, BigDecimal demandQty, DynamicObject bom) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(10);
        paramMap.put("bomId", bom == null ? Long.valueOf(0L) : bom.getPkValue());
        paramMap.put("materialid", masterid);
        paramMap.put("searchDate", expendbomtime);
        paramMap.put("configcode", entryConfigCodeid);
        paramMap.put("expandConfig", 1637711947497568256L);
        paramMap.put("org", orgId);
        paramMap.put("num", demandQty);
        paramMap.put("showtype", "E");
        paramMap.put("purexpand", false);
        paramMap.put("model", "model_pom");
        return paramMap;
    }

    private static Long getPkid(Object obj) {
        Long objId = 0L;
        if (obj instanceof DynamicObject) {
            objId = ((DynamicObject)obj).getLong("id");
        }
        if (obj instanceof Long) {
            objId = (Long)obj;
        }
        return objId;
    }

    private static void setResData(Map<Long, List<BomBaseData>> orderEntryBaseMap, Set<Long> bomEntryIdSet, List<DynamicObject> saveBomStocks, Map<Long, String> orderEntryBomMap) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-fmm-bomsearch");
        for (DynamicObject saveBomStock : saveBomStocks) {
            Long orderEntryId = CreateStockPlanUtils.getOrderEntryIdByStock(saveBomStock);
            String resStr = orderEntryBomMap.get(orderEntryId);
            if (StringUtils.isEmpty((CharSequence)resStr)) continue;
            CreateStockPlanUtils.setBbdList(cache, resStr, bomEntryIdSet, orderEntryBaseMap, orderEntryId);
        }
    }

    private static void setBbdList(DistributeSessionlessCache cache, String resStr, Set<Long> bomEntryIdSet, Map<Long, List<BomBaseData>> orderEntryBaseMap, Long orderEntryId) {
        String res = (String)cache.get(resStr);
        if (StringUtils.isEmpty((CharSequence)res)) {
            return;
        }
        logger.info("\u8c03\u7528\u5fae\u670d\u52a1\u83b7\u53d6BOM resStr = " + resStr + ",res--------------:" + res);
        JSONArray resArray = JSONArray.parseArray((String)res);
        ArrayList<BomBaseData> bbdList = new ArrayList<BomBaseData>(10);
        if (resArray != null) {
            logger.info("\u8c03\u7528\u5fae\u670d\u52a1\u83b7\u53d6BOM resStr = " + resStr + ",res.size--------------:" + resArray.size());
            for (int i = 0; i < resArray.size(); ++i) {
                JSONObject resJson = (JSONObject)resArray.get(i);
                bbdList.add(CreateStockByBomUtils.getBomBaseData((JSONObject)resJson));
                bomEntryIdSet.add(resJson.getLong("entry_Id"));
            }
            orderEntryBaseMap.put(orderEntryId, bbdList);
        }
    }

    public static void setBomEntryMapById(Set<Long> bomEntryIdSet, OutPurApplyData baseData) {
        Map bomEntryMap = baseData.getBomEntryMap();
        bomEntryMap = MsBomQueryHelper.getBomEntryFromCache(bomEntryIdSet);
        baseData.setBomEntryMap(bomEntryMap);
    }

    public static Long getOrderEntryIdByStock(DynamicObject saveBomStock) {
        Object orderEntryObj = saveBomStock.get("sourcebillid");
        if (orderEntryObj != null) {
            return NumberUtils.toLong((String)orderEntryObj.toString());
        }
        return 0L;
    }

    private static void setBOMBaseData(List<DynamicObject> bomEntrys, OutPurApplyData baseData, List<DynamicObject> saveBomStocks) {
        Long orgId;
        DynamicObject org;
        Map<Long, Object> orgMaterialMftInfoMap = baseData.getOrgMaterialMftInfoMap();
        Map<Long, Object> orgMasterWastMap = baseData.getOrgMasterWastMap();
        HashMap<Long, Set> orgMasterMap = new HashMap<Long, Set>(16);
        HashSet supplyOrgIdSet = new HashSet(16);
        for (DynamicObject saveBomStock : saveBomStocks) {
            org = saveBomStock.getDynamicObject("org");
            if (org == null) continue;
            orgId = (Long)org.getPkValue();
            for (DynamicObject bomEntry : bomEntrys) {
                DynamicObject master = bomEntry.getDynamicObject("entrymaterial").getDynamicObject("masterid");
                if (master == null) continue;
                orgMasterMap.computeIfAbsent(orgId, k -> new HashSet(16)).add((Long)master.getPkValue());
            }
        }
        for (DynamicObject saveBomStock : saveBomStocks) {
            org = saveBomStock.getDynamicObject("org");
            if (org == null) continue;
            orgId = (Long)org.getPkValue();
            CreateStockUtils.getInfoByMaster((Long)orgId, orgMasterWastMap, orgMaterialMftInfoMap, orgMasterMap, supplyOrgIdSet);
        }
    }

    private static String createAndSetStockEntryValueByBom(DynamicObject orderEntry, DynamicObject saveBomStock, OutPurApplyData baseData, DynamicObject bomEntry, BomBaseData bbd) {
        DynamicObject orgfield;
        DynamicObject entrymaterial;
        Long masterid;
        String stockName = saveBomStock.getDataEntityType().getName();
        DynamicObject org = saveBomStock.getDynamicObject("org");
        if (org == null) {
            throw new KDBizException(new ErrorCode("outstockplan", "outstockplan org is null\u3002"), new Object[0]);
        }
        Long orgId = (Long)org.getPkValue();
        DynamicObject materialmftInfo = baseData.getOrgMaterialMftInfo(orgId, masterid = (Long)(entrymaterial = bomEntry.getDynamicObject("entrymaterial")).getDynamicObject("masterid").getPkValue());
        if (materialmftInfo == null || !materialmftInfo.getBoolean("enable") || !"C".equalsIgnoreCase(materialmftInfo.getString("status"))) {
            logger.info("\u627e\u4e0d\u5230\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff1a:" + entrymaterial.getDynamicObject("masterid").getPkValue().toString());
            DynamicObject resDym = entrymaterial.getDynamicObject("masterid");
            return resDym.getString("number") + "," + resDym.getString("name");
        }
        DynamicObjectCollection stockEntrys = saveBomStock.getDynamicObjectCollection("stockentry");
        DynamicObject stockEntry = ORM.create().newDynamicObject(stockName + ".stockentry");
        stockEntry.set("leadtime", bomEntry.get("entryleadtime"));
        stockEntry.set("entryconfiguredcode", bomEntry.get("entryconfiguredcode"));
        stockEntry.set("demanddate", orderEntry.get("deliverdate"));
        boolean isconsiderloss = true;
        String materialsource = "A";
        if ("B".equals(materialsource)) {
            CreateStockUtils.setStockEntryByMftInfo((DynamicObject)stockEntry, (DynamicObject)materialmftInfo);
        } else {
            boolean isstockallot;
            Object outstorageunit;
            CreateStockUtils.setStockEntryByBomInfo((DynamicObject)stockEntry, (DynamicObject)bomEntry);
            Object supplyorgunitid = materialmftInfo.get("supplyorgunitid");
            if (supplyorgunitid != null) {
                stockEntry.set("supplyorgid", supplyorgunitid);
                stockEntry.set("warehouseid", materialmftInfo.get("warehouse"));
                stockEntry.set("location", materialmftInfo.get("location"));
            }
            if ((outstorageunit = materialmftInfo.get("outstorageunit")) != null) {
                stockEntry.set("outorgunitid", outstorageunit);
                stockEntry.set("outwarehouseid", materialmftInfo.get("outwarehouse"));
                stockEntry.set("outlocation", materialmftInfo.get("outwarelocation"));
            }
            if (isstockallot = materialmftInfo.getBoolean("isstockallot")) {
                stockEntry.set("isstockallot", (Object)isstockallot);
                stockEntry.set("outorgunitid", materialmftInfo.get("outstorageunit"));
            }
        }
        stockEntry.set("isbomextend", (Object)Boolean.TRUE);
        DynamicObject entryunit = MPDMMftGenStocksUtils.getEntryUnit((DynamicObject)bomEntry, (DynamicObject)materialmftInfo);
        stockEntry.set("materialunitid", (Object)entryunit);
        stockEntry.set("materialid", (Object)materialmftInfo);
        stockEntry.set("materielmasterid", (Object)masterid);
        stockEntry.set("useratio", (Object)1);
        stockEntry.set("pid", (Object)1L);
        if (!bomEntry.getBoolean("entryisreplace")) {
            stockEntry.set("useratio", (Object)100);
            stockEntry.set("pid", (Object)0L);
        }
        CreateStockByBomUtils.setStockEntryQtyByBomBaseData((DynamicObject)stockEntry, (BomBaseData)bbd);
        stockEntry.set("standqty", (Object)MPDMMftGenStocksUtils.getStandQty((DynamicObject)bomEntry, (DynamicObject)orderEntry, (DynamicObject)stockEntry));
        String wastagerateformula = "B";
        String orgMasterWast = baseData.getOrgMasterWast(orgId, masterid);
        if (orgMasterWast != null) {
            wastagerateformula = orgMasterWast;
        } else if (!isconsiderloss) {
            wastagerateformula = "";
        }
        stockEntry.set("wastagerateformula", (Object)wastagerateformula);
        stockEntry.set("demandqty", (Object)MPDMMftGenStocksUtils.getDemandQty((DynamicObject)bomEntry, (boolean)isconsiderloss, (DynamicObject)stockEntry, (String)wastagerateformula));
        stockEntry.set("bomreversion", (Object)bomEntry.getDynamicObject("entryversion"));
        stockEntry.set("childauxpropertyid", bomEntry.get("entryauxproperty"));
        stockEntry.set("supplymode", bomEntry.get("entryownertype"));
        stockEntry.set("supplierid", bomEntry.get("entryowner"));
        if ("bos_org".equals(bomEntry.get("entryownertype")) && (orgfield = (DynamicObject)stockEntry.get("supplyorgid")) != null) {
            Long orgfieldId = (Long)orgfield.getPkValue();
            stockEntry.set("supplierid", CreateStockPlanUtils.getSupplyByBaseData(baseData, orgfieldId));
        }
        stockEntry.set("bomentryid", bomEntry.getPkValue());
        stockEntry.set("priority", bomEntry.get("reppriority"));
        stockEntry.set("ismainreplace", bomEntry.get("entryisreplaceplanmm"));
        stockEntry.set("replaceplan", bomEntry.get("entryreplaceplan"));
        stockEntry.set("sourcetype", (Object)"A");
        stockEntrys.add((Object)stockEntry);
        return "0";
    }

    public static Object getSupplyByBaseData(OutPurApplyData baseData, Long orgfieldId) {
        if (baseData.getSupply(orgfieldId) == null) {
            Map<Long, Object> supplyMap = baseData.getSupplyMap();
            HashSet<Long> supplyOrgIdSet = new HashSet<Long>(16);
            supplyOrgIdSet.add(orgfieldId);
            CreateStockUtils.getSupplyMap(supplyMap, supplyOrgIdSet);
            baseData.setSupplyMap(supplyMap);
        }
        return baseData.getSupply(orgfieldId);
    }

    private static void appendErrInfo(List<String> materialNameList, StringBuilder materialName) {
        if (!materialNameList.isEmpty()) {
            if (materialNameList.size() == 1) {
                materialName.append("\u3010");
                materialName.append(materialNameList.get(0));
                materialName.append("\u3011");
            } else if (materialNameList.size() > 1) {
                for (int i = 0; i < materialNameList.size(); ++i) {
                    if (i == materialNameList.size() - 1) {
                        materialName.append("\u3010");
                        materialName.append(materialNameList.get(i));
                        materialName.append("\u3011");
                        continue;
                    }
                    materialName.append("\u3010");
                    materialName.append(materialNameList.get(i));
                    materialName.append("\u3011");
                    materialName.append(",");
                }
            }
        }
    }

    private static void throwException(StringBuilder materialName, DynamicObject orderEntry) {
        String mtfOrgName = orderEntry.getDynamicObject("entryreqorg").getString("name");
        throw new KDBizException(new ErrorCode("stock", String.format(ResManager.loadKDString((String)"%1$s\u7684BOM\u7ec4\u4ef6%2$s\uff0c\u6ca1\u6709\u53ef\u7528\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"CreateStockPlanUtils_1", (String)"mmc-om-common", (Object[])new Object[0]), mtfOrgName, materialName)), new Object[0]);
    }

    public static String selectStockplanProperties() {
        StringBuilder selector = new StringBuilder(800);
        selector.append("supplier,configuredcode,tracknumber,bdproject,id,billno,productid,billstatus,orderno,orderid,qty,baseqty,billauxqty,mftdeptorgid,sourcebillid,orderentryid,unfoldbomdate,billhead_lk,");
        selector.append("baseunitid,unitid,billauxunit,org,bomid,replaceno,modifytime,modifier,auditdate,auditor,auxproperty,processroute,stockentry,stockentry.materialid,stockentry.qtytype,");
        selector.append("stockentry.productqty,stockentry.useratio,stockentry.qtynumerator,stockentry.oprno,stockentry.processseq,stockentry.wipqty,");
        selector.append("stockentry.qtydenominator,stockentry.fixscrap,stockentry.scraprate,stockentry.standqty,stockentry.demandqty,stockentry.actissueqty,stockentry.feedingqty,");
        selector.append("stockentry.rejectedqty,stockentry.scrapqty,stockentry.cansendqty,stockentry.unissueqty,stockentry.outsqty,stockentry.iscannegative,stockentry.operationdesc,");
        selector.append("stockentry.wastagerateformula,stockentry.isbackflush,stockentry.useqty,stockentry.iskeypart,stockentry.issuemode,stockentry.isbomextend,stockentry.childauxpropertyid,");
        selector.append("stockentry.materialid,stockentry.materialid.scraprateexpr,stockentry.overissuecontrl,stockentry.issinhighlimit,stockentry.extraratioqty,stockentry.batchno,");
        selector.append("stockentry.issinlowlimit,stockentry.lackraitioqty,stockentry.oprworkcenter,stockentry.warehouseid,stockentry.location,").append("stockentry.bomentryid,stockentry.isstep,");
        selector.append("stockentry.leadtimeunit,stockentry.leadtime,stockentry.demanddate,stockentry.materialunitid,stockentry.materialunitid.precision,stockentry.promaterentryid,stockentry.entryconfiguredcode,");
        selector.append("transactiontypeid,transactiontypeid.isconsiderloss,stockentry.outlocation,stockentry.lot,stockentry.rework,childauxpropertyid");
        return selector.toString();
    }
}

