/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DynamicObjConverUtils {
    public static final String ID = "$id";
    public static final String PK = "$pk";

    public static Map<String, Object> convertDynamicObjToMap(DynamicObject object) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        if (object != null) {
            objectMap.put(ID, object.getPkValue());
            objectMap.put(PK, "id");
            String key = object.getDynamicObjectType().getName();
            objectMap.put("$key", key);
            object = BusinessDataServiceHelper.loadSingle((Object)object.getPkValue(), (DynamicObjectType)object.getDynamicObjectType());
            DataEntityPropertyCollection properties = object.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                String propertyName = property.getName();
                if (propertyName.equals("multilanguagetext")) continue;
                Object propValue = object.get(propertyName);
                if (property instanceof BasedataProp) {
                    if (propValue instanceof DynamicObject) {
                        objectMap.put(propertyName, DynamicObjConverUtils.convertDynamicObjToMap((DynamicObject)propValue));
                        continue;
                    }
                    objectMap.put(propertyName, propValue);
                    continue;
                }
                if (property instanceof EntryProp) {
                    ArrayList<Map<String, Object>> objects = new ArrayList<Map<String, Object>>();
                    DynamicObjectCollection dynamicObjectCollection = object.getDynamicObjectCollection(propertyName);
                    for (DynamicObject obj : dynamicObjectCollection) {
                        objects.add(DynamicObjConverUtils.convertDynamicObjToMap(obj));
                    }
                    objectMap.put(propertyName, objects);
                    continue;
                }
                if (property instanceof MuliLangTextProp) {
                    LocaleDynamicObjectCollection collection = (LocaleDynamicObjectCollection)object.get("multilanguagetext");
                    HashMap<String, Object> localeMap = new HashMap<String, Object>();
                    for (DynamicObject tempObj : collection) {
                        localeMap.put(tempObj.getString("localeid"), tempObj.get(propertyName));
                    }
                    objectMap.put(propertyName, localeMap);
                    continue;
                }
                if (property instanceof MulBasedataProp) {
                    Object val = object.get(propertyName);
                    if (!(val instanceof DynamicObjectCollection)) continue;
                    objectMap.put(propertyName, DynamicObjConverUtils.getMulBaseDataOfId(object.getDynamicObjectCollection(propertyName)));
                    continue;
                }
                if (!DynamicObjConverUtils.isSimpleProp(property)) continue;
                objectMap.put(propertyName, object.get(propertyName));
            }
        }
        return objectMap;
    }

    private static boolean isSimpleProp(IDataEntityProperty property) {
        return property instanceof ComboProp || property instanceof FieldProp || property instanceof BooleanProp || property instanceof DateTimeProp;
    }

    private static List<Object> getMulBaseDataOfId(DynamicObjectCollection dynamicObjects) {
        ArrayList<Object> reList = new ArrayList<Object>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (null == dynamicObject || dynamicObject.toString().length() == 0) continue;
            reList.add(dynamicObject.getPkValue());
        }
        return reList;
    }
}

