/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import java.util.stream.Stream;

public class OMDateUtil {
    public static Date getDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date addDay(Date date, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, amount);
        return calendar.getTime();
    }

    public static Date parseDateTime(String dateTime, String format) {
        Date returnDate = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            returnDate = dateFormat.parse(dateTime);
            return returnDate;
        }
        catch (ParseException var4) {
            return null;
        }
    }

    public static Date getCurrentDay0hour() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.get(5) + 1);
        cal.set(5, cal.get(5) - 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getNextDay0hour() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.get(5) + 1);
        cal.set(5, cal.get(5));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static int getDay(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(5);
    }

    public static Date getDateFormat(Date date, boolean isStart) {
        SimpleDateFormat shortdate = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = shortdate.format(date);
        String suffix = " 00:00:00";
        if (!isStart) {
            suffix = " 23:59:59";
        }
        try {
            SimpleDateFormat longdate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return longdate.parse(dateStr + suffix);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isSameDay(Date date, Date anotherDate) {
        SimpleDateFormat shortdate = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = shortdate.format(date);
        String anotherDateStr = shortdate.format(anotherDate);
        return dateStr.equals(anotherDateStr);
    }

    public static int getShortOfYear(Date date, Date anotherDate) {
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(date);
        int dateYear = dateCal.get(1);
        Calendar anotherDateCal = Calendar.getInstance();
        anotherDateCal.setTime(anotherDate);
        int anotherDateYear = anotherDateCal.get(1);
        return dateYear - anotherDateYear;
    }

    public static int getShortOfMonth(Date date, Date anotherDate) {
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(date);
        int dateMonth = dateCal.get(2);
        Calendar anotherDateCal = Calendar.getInstance();
        anotherDateCal.setTime(anotherDate);
        int anotherDateMonth = anotherDateCal.get(2);
        return dateMonth - anotherDateMonth;
    }

    public static int getDateOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.setFirstDayOfWeek(1);
        return cal.get(7);
    }

    public static String getHour(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int hour = cal.get(11);
        return hour + ":00";
    }

    public static int getHourOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(11);
    }

    public static int getMinuteOfHour(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(12);
    }

    public static Date getCurrentDayStart(Date curDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(curDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getCurrentDayEnd(Date curDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(curDate);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static int getDiffMonths(Date begindate, Date enddate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
        int begin = Integer.parseInt(df.format(begindate));
        int end = Integer.parseInt(df.format(enddate));
        return (end / 100 - begin / 100) * 12 + (end % 100 - begin % 100);
    }

    public static Date maxDate(Date ... dates) {
        Optional<Date> optional = Stream.of(dates).max(Date::compareTo);
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    public static int compareDate(Date d1, Date d2) {
        long dateDiff = d1.getTime() - d2.getTime();
        if (Math.abs(dateDiff) < 86400000L) {
            return 0;
        }
        return dateDiff > 0L ? 1 : -1;
    }
}

