/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.common.utils;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class UnitRateConvertUtil {
    private static final Log logger = LogFactory.getLog(UnitRateConvertUtil.class);

    public static BigDecimal getUnitRateConvert(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = null;
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            unitRate = BigDecimal.ZERO;
        } else if (srcUnitId.longValue() == desUnitId.longValue()) {
            unitRate = BigDecimal.ONE;
        } else {
            DynamicObject muConv = null;
            DynamicObject measureUnits = BusinessDataServiceHelper.loadSingle((Object)desUnitId, (String)"bd_measureunits");
            String precisionAccount = measureUnits.getString("precisionaccount");
            int type = 4;
            switch (precisionAccount) {
                case "1": {
                    type = 4;
                    break;
                }
                case "2": {
                    type = 1;
                    break;
                }
                case "3": {
                    type = 0;
                }
            }
            try {
                muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
                if (muConv != null && muConv.getInt("denominator") != 0) {
                    unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")));
                }
            }
            catch (ArithmeticException e) {
                if (muConv != null && muConv.getInt("denominator") != 0) {
                    unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), measureUnits.getInt("precision"), type);
                }
                return unitRate;
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UnitRateConvertUtil_0", (String)"mmc-om-common", (Object[])new Object[0]));
            }
        }
        if (unitRate == null) {
            unitRate = BigDecimal.ZERO;
        }
        return unitRate;
    }

    public static int getUnitPrecisionAccount(DynamicObject measureUnits) {
        String precisionAccount = measureUnits.getString("precisionaccount");
        int type = 4;
        switch (precisionAccount) {
            case "1": {
                type = 4;
                break;
            }
            case "2": {
                type = 1;
                break;
            }
            case "3": {
                type = 0;
            }
        }
        return type;
    }
}

