/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.common.utils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.om.common.consts.XOmMftOrderChangeLogConsts;
import kd.mmc.om.common.order.consts.OmManuBillConsts;
import kd.mmc.om.common.stock.utils.ChangeObject;

public class XOmMftOrderChangeLogUtils {
    private static int precision = 2;
    private static int deal = 4;
    private static boolean isCheckOldValue = false;
    private static String entrychangetype;
    private static int srcbillseq;

    public static DynamicObject makeUpXMftorderChangeLog(String changeStatus, DynamicObject xmtforderChangeBill, DynamicObject xmtfOrderChangeEntry, Map<String, Integer> addSeqMap, Date bookDate) {
        DynamicObject xmftOrderlog = BusinessDataServiceHelper.newDynamicObject((String)"om_xmftorderlog");
        entrychangetype = xmtfOrderChangeEntry.getString("changetype");
        if (StringUtils.isEmpty((CharSequence)entrychangetype)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u4ea7\u53d8\u66f4\u5355\u5206\u5f55\u53d8\u66f4\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"XOmMftOrderChangeLogUtils_0", (String)"mmc-om-common", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)changeStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u72b6\u6001\u672a\u8bbe\u7f6e\u3002", (String)"XOmMftOrderChangeLogUtils_1", (String)"mmc-om-common", (Object[])new Object[0]));
        }
        isCheckOldValue = StringUtils.equals((CharSequence)"B", (CharSequence)entrychangetype);
        DynamicObject materialUnitid = xmtfOrderChangeEntry.getDynamicObject("unit");
        if (null != materialUnitid && materialUnitid.get("precision") != null) {
            String precisionaccount;
            precision = materialUnitid.getInt("precision");
            switch (precisionaccount = materialUnitid.getString("precisionaccount")) {
                case "2": {
                    deal = 1;
                    break;
                }
                case "3": {
                    deal = 0;
                    break;
                }
                default: {
                    deal = 4;
                }
            }
        }
        String srcBillID = xmtfOrderChangeEntry.getString("srcbillid");
        String srcBillNo = xmtfOrderChangeEntry.getString("srcbillno");
        if (StringUtils.isEmpty((CharSequence)srcBillID)) {
            if (StringUtils.isNotEmpty((CharSequence)srcBillNo)) {
                QFilter filter = new QFilter("billno", "=", (Object)srcBillNo);
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(filter);
                QFilter[] filterArray = new QFilter[filters.size()];
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"om_mftorder", (String)"id", (QFilter[])filters.toArray(filterArray));
                if (dynamicObject != null) {
                    srcBillID = dynamicObject.getPkValue().toString();
                }
                xmtfOrderChangeEntry.set("srcbillid", (Object)srcBillID);
            }
            if (StringUtils.isEmpty((CharSequence)srcBillID)) {
                return xmftOrderlog;
            }
        }
        int n = srcbillseq = StringUtils.isBlank((Object)xmtfOrderChangeEntry.get("srcbillentryseq")) ? 0 : xmtfOrderChangeEntry.getInt("srcbillentryseq");
        if (StringUtils.equals((CharSequence)"A", (CharSequence)entrychangetype)) {
            DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(srcBillID), (String)"om_mftorder");
            DynamicObjectCollection srcBillEntry = srcBill.getDynamicObjectCollection("treeentryentity");
            if (srcBillEntry.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u5206\u5f55\u4e3a\u7a7a\u3002", (String)"XOmMftOrderChangeLogUtils_2", (String)"mmc-om-common", (Object[])new Object[0]));
            }
            if (addSeqMap.containsKey(srcBillID) && addSeqMap.get(srcBillID) != null) {
                addSeqMap.put(srcBillID, addSeqMap.get(srcBillID) + 1);
            } else {
                addSeqMap.put(srcBillID, srcBillEntry.size() + 1);
            }
            srcbillseq = addSeqMap.get(srcBillID);
        }
        XOmMftOrderChangeLogUtils.dealXMftOrderChangeLog(changeStatus, xmftOrderlog, xmtforderChangeBill, xmtfOrderChangeEntry, bookDate);
        XOmMftOrderChangeLogUtils.dealXMftOrderChangeLogEntry(xmftOrderlog, xmtfOrderChangeEntry);
        return xmftOrderlog;
    }

    private static void dealXMftOrderChangeLog(String changeStatus, DynamicObject xmftOrderlog, DynamicObject xmtforderChangeBill, DynamicObject xmtfOrderChangeEntry, Date bookDate) {
        xmftOrderlog.set("changestatus", (Object)changeStatus);
        xmftOrderlog.set("changetype", (Object)entrychangetype);
        xmftOrderlog.set("xbillid", xmtforderChangeBill.getPkValue());
        xmftOrderlog.set("xbillno", xmtforderChangeBill.get("billno"));
        xmftOrderlog.set("biztime", xmtforderChangeBill.get("billdate"));
        xmftOrderlog.set("beginbookdate", (Object)bookDate);
        xmftOrderlog.set("xreason", xmtforderChangeBill.get("reason"));
        xmftOrderlog.set("org", xmtforderChangeBill.get("org"));
        xmftOrderlog.set("srcbillid", xmtfOrderChangeEntry.get("srcbillid"));
        xmftOrderlog.set("srcbillno", xmtfOrderChangeEntry.get("srcbillno"));
        xmftOrderlog.set("srcbillentryid", StringUtils.isBlank((Object)xmtfOrderChangeEntry.get("srcbillentryid")) ? Integer.valueOf(0) : xmtfOrderChangeEntry.get("srcbillentryid"));
        xmftOrderlog.set("srcbillentryseq", (Object)srcbillseq);
        xmftOrderlog.set("xbillentryid", xmtfOrderChangeEntry.getPkValue());
        xmftOrderlog.set("xbillentryseq", xmtfOrderChangeEntry.get("seq"));
        xmftOrderlog.set("creator", xmtforderChangeBill.get("creator"));
    }

    private static void dealXMftOrderChangeLogEntry(DynamicObject xmftOrderlog, DynamicObject xmtfOrderChangeEntry) {
        DynamicObjectCollection entryentity = xmftOrderlog.getDynamicObjectCollection("entryentity");
        DynamicObject addNew = entryentity.addNew();
        addNew.set("producttype", (Object)xmtfOrderChangeEntry.getString("producttype"));
        DynamicObject materialProdInfo = xmtfOrderChangeEntry.getDynamicObject("material");
        addNew.set("material", (Object)materialProdInfo);
        addNew.set("srcbillnoentry", xmtfOrderChangeEntry.get("srcbillno"));
        addNew.set("srcbillseqentry", (Object)srcbillseq);
        XOmMftOrderChangeLogUtils.xMftOrderChangeLogEntryMod(addNew, xmtfOrderChangeEntry);
    }

    private static void xMftOrderChangeLogEntryMod(DynamicObject addNew, DynamicObject xmtfOrderChangeEntry) {
        List<ChangeObject> changeList = XOmMftOrderChangeLogUtils.makeUpChangeList(xmtfOrderChangeEntry, addNew);
        Map<String, String> xmftLogAndOrderCorrespodingMap = XOmMftOrderChangeLogConsts.getXMFTLogMap(addNew);
        block0: for (Map.Entry<String, String> m : xmftLogAndOrderCorrespodingMap.entrySet()) {
            String xMftOrderChangeLogColName = m.getKey();
            String xmtforderChangeBillColName = m.getValue();
            for (ChangeObject changeObject : changeList) {
                String colName = String.valueOf(changeObject.getColName());
                if (!StringUtils.equals((CharSequence)xmtforderChangeBillColName, (CharSequence)colName)) continue;
                addNew.set(xMftOrderChangeLogColName, (Object)changeObject.getCombinValue());
                continue block0;
            }
        }
    }

    private static List<ChangeObject> makeUpChangeList(DynamicObject xmtfOrderChangeEntry, DynamicObject addNew) {
        Map<String, String> xmftLogAndOrderCorrespodingMap = XOmMftOrderChangeLogConsts.getXMFTLogMap(addNew);
        ArrayList<ChangeObject> changelist = new ArrayList<ChangeObject>(xmftLogAndOrderCorrespodingMap.size());
        if (StringUtils.equals((CharSequence)"A", (CharSequence)entrychangetype)) {
            for (Map.Entry<String, String> m : xmftLogAndOrderCorrespodingMap.entrySet()) {
                ChangeObject changeObject = new ChangeObject();
                String xmtforderChangeLogColName = m.getKey();
                String xmtforderChangeBillColName = m.getValue();
                changeObject.setColName(xmtforderChangeLogColName);
                if (!xmtfOrderChangeEntry.containsProperty(xmtforderChangeLogColName)) continue;
                changeObject.setCombinValue(XOmMftOrderChangeLogUtils.dealCombineValue(null, XOmMftOrderChangeLogUtils.getValue(xmtforderChangeBillColName, xmtfOrderChangeEntry.get(xmtforderChangeLogColName))));
                changelist.add(changeObject);
            }
        } else {
            String seq;
            String srcBillPK = xmtfOrderChangeEntry.getString("srcbillid");
            String srcBillEntryPK = xmtfOrderChangeEntry.get("srcbillentryid") == null ? null : xmtfOrderChangeEntry.getString("srcbillentryid");
            DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(srcBillPK), (String)"om_mftorder");
            DynamicObjectCollection srcEntry = srcBill.getDynamicObjectCollection("treeentryentity");
            if (StringUtils.isEmpty((CharSequence)srcBillEntryPK) && StringUtils.isNotBlank((CharSequence)(seq = xmtfOrderChangeEntry.getString("srcbillentryseq"))) && srcEntry.size() >= Integer.parseInt(seq)) {
                DynamicObject entry = (DynamicObject)srcEntry.get(Integer.parseInt(seq) - 1);
                srcBillEntryPK = entry.getPkValue().toString();
            }
            for (int i = 0; i < srcEntry.size(); ++i) {
                DynamicObject srcBillEntryRow = (DynamicObject)srcEntry.get(i);
                if (srcBillEntryRow == null || !StringUtils.equals((CharSequence)srcBillEntryRow.getPkValue().toString(), (CharSequence)srcBillEntryPK)) continue;
                XOmMftOrderChangeLogUtils.makeUpChangeObject(srcBillEntryRow, xmtfOrderChangeEntry, changelist, addNew);
            }
        }
        return changelist;
    }

    private static void makeUpChangeObject(DynamicObject srcBillEntryRow, DynamicObject xmtfOrderChangeEntry, List<ChangeObject> changelist, DynamicObject addNew) {
        DynamicObject materialOld = srcBillEntryRow.getDynamicObject("material");
        DynamicObject materialNew = xmtfOrderChangeEntry.getDynamicObject("material");
        if (materialOld == null || materialNew == null || !materialOld.getPkValue().equals(materialNew.getPkValue())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u4fee\u6539\u65f6\u751f\u4ea7\u5de5\u5355\u4e0e\u751f\u4ea7\u5de5\u5355\u53d8\u66f4\u5355\u7269\u6599\u4e0d\u4e00\u81f4\u3002", (String)"XOmMftOrderChangeLogUtils_3", (String)"mmc-om-common", (Object[])new Object[0]));
        }
        String[] xFields = OmManuBillConsts.getEntryFields("b");
        Map<String, String> xmftLogAndOrderCorrespodingMap = XOmMftOrderChangeLogConsts.getXMFTLogMap(addNew);
        block0: for (Map.Entry<String, String> m : xmftLogAndOrderCorrespodingMap.entrySet()) {
            String mtforderChangeBillColName = m.getValue();
            for (int i = 0; i < xFields.length; ++i) {
                String propertyName = xFields[i];
                Object srcFieldObject = srcBillEntryRow.get(propertyName);
                Object xFieldObject = xmtfOrderChangeEntry.get(propertyName);
                if (StringUtils.isBlank((Object)srcFieldObject)) {
                    srcFieldObject = "";
                }
                if (StringUtils.isBlank((Object)xFieldObject)) {
                    xFieldObject = "";
                }
                if (!StringUtils.equals((CharSequence)propertyName, (CharSequence)mtforderChangeBillColName)) continue;
                String xmtforderChangeBillColName = m.getKey();
                ChangeObject changeObjectTemp = new ChangeObject();
                changeObjectTemp.setColName(xmtforderChangeBillColName);
                String combinValue = XOmMftOrderChangeLogUtils.dealCombineValue(XOmMftOrderChangeLogUtils.getValue(propertyName, srcFieldObject), XOmMftOrderChangeLogUtils.getValue(propertyName, xFieldObject));
                changeObjectTemp.setCombinValue(combinValue);
                changelist.add(changeObjectTemp);
                continue block0;
            }
        }
    }

    private static String dealCombineValue(Object srcBillEntryRow, Object xmtfOrderChangeEntry) {
        String combineValue = ResManager.loadKDString((String)"\u65e0", (String)"XOmMftOrderChangeLogUtils_4", (String)"mmc-om-common", (Object[])new Object[0]);
        if (srcBillEntryRow == null && xmtfOrderChangeEntry == null) {
            return combineValue;
        }
        String oldValueStr = "";
        String newValueStr = "";
        String changeFlag = "";
        if (xmtfOrderChangeEntry instanceof Boolean) {
            if (isCheckOldValue && srcBillEntryRow != null) {
                oldValueStr = XOmMftOrderChangeLogUtils.transBoolean(srcBillEntryRow);
            }
            newValueStr = XOmMftOrderChangeLogUtils.transBoolean(xmtfOrderChangeEntry);
        } else if (xmtfOrderChangeEntry instanceof Date) {
            if (isCheckOldValue && srcBillEntryRow != null) {
                oldValueStr = XOmMftOrderChangeLogUtils.transDate(srcBillEntryRow);
            }
            newValueStr = XOmMftOrderChangeLogUtils.transDate(xmtfOrderChangeEntry);
        } else if (xmtfOrderChangeEntry instanceof BigDecimal) {
            int scale = ((BigDecimal)xmtfOrderChangeEntry).scale();
            int scalePrecision = scale > precision ? scale : precision;
            BigDecimal newValueBigDecimal = ((BigDecimal)xmtfOrderChangeEntry).setScale(scalePrecision, deal);
            if (isCheckOldValue && srcBillEntryRow != null) {
                BigDecimal oldValueBigDecimal = ((BigDecimal)srcBillEntryRow).setScale(scalePrecision, deal);
                int compareResult = oldValueBigDecimal.compareTo(newValueBigDecimal);
                if (compareResult < 0) {
                    changeFlag = "\u2191";
                } else if (compareResult > 0) {
                    changeFlag = "\u2193";
                }
                oldValueStr = oldValueBigDecimal.stripTrailingZeros().toPlainString();
            }
            newValueStr = newValueBigDecimal.stripTrailingZeros().toPlainString();
        } else {
            if (isCheckOldValue && srcBillEntryRow != null) {
                oldValueStr = srcBillEntryRow.toString();
            }
            if (xmtfOrderChangeEntry != null) {
                newValueStr = xmtfOrderChangeEntry.toString();
            }
        }
        if (!isCheckOldValue) {
            combineValue = XOmMftOrderChangeLogUtils.transEmpty(newValueStr);
        } else if (StringUtils.isNotEmpty((CharSequence)oldValueStr) || StringUtils.isNotEmpty((CharSequence)newValueStr)) {
            combineValue = StringUtils.equals((CharSequence)newValueStr, (CharSequence)oldValueStr) ? XOmMftOrderChangeLogUtils.transEmpty(oldValueStr) : XOmMftOrderChangeLogUtils.transEmpty(oldValueStr) + " -> " + XOmMftOrderChangeLogUtils.transEmpty(newValueStr) + changeFlag;
        }
        return combineValue;
    }

    private static String transEmpty(String value) {
        return StringUtils.isEmpty((CharSequence)value) ? ResManager.loadKDString((String)"\u65e0", (String)"XOmMftOrderChangeLogUtils_4", (String)"mmc-om-common", (Object[])new Object[0]) : value;
    }

    private static String transDate(Object value) {
        return new SimpleDateFormat("yyyy/MM/dd HH:mm").format((Date)value);
    }

    private static String transBoolean(Object value) {
        return value.toString().replace("false", ResManager.loadKDString((String)"\u5426", (String)"XOmMftOrderChangeLogUtils_5", (String)"mmc-om-common", (Object[])new Object[0])).replace("true", ResManager.loadKDString((String)"\u662f", (String)"XOmMftOrderChangeLogUtils_6", (String)"mmc-om-common", (Object[])new Object[0]));
    }

    private static Object getValue(String stock, Object changefield) {
        Object value = changefield instanceof DynamicObject ? ("materialid".equals(stock) ? ((DynamicObject)changefield).getString("masterid.name") : (changefield.toString().contains(",name,") ? ((DynamicObject)changefield).getString("name") : ((DynamicObject)changefield).getPkValue())) : changefield;
        return value;
    }
}

