/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.botp;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.collections.MapUtils;

public class StockOrgCurrencyBotpPlugin
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(tgtMainType);
        for (int i = 0; i < entitys.length; ++i) {
            ExtendedDataEntity entity = entitys[i];
            if (entity == null) continue;
            DynamicObject obj = entity.getDataEntity();
            this.setCurrency(obj, obj.getDynamicObject("org").getLong("id"));
            for (DynamicObject dym : obj.getDynamicObjectCollection("billentry")) {
                dym.set("unpickqty", (Object)dym.getBigDecimal("auditqty").subtract(dym.getBigDecimal("useoutqty")));
                dym.set("unpickbaseqty", (Object)dym.getBigDecimal("auditbaseqty").subtract(dym.getBigDecimal("useoutbaseqty")));
            }
        }
    }

    private void setOrg(DynamicObject obj) {
        DynamicObject bizOrg = obj.getDynamicObject("org");
        if (bizOrg != null) {
            Long bizOrgId = (Long)bizOrg.getPkValue();
            Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)bizOrgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            Object settleOrgId = null;
            if (map != null) {
                settleOrgId = map.get("id");
            }
            obj.set("accountorg", (Object)BusinessDataServiceHelper.loadSingle(settleOrgId, (String)"bos_org", (String)"id"));
        }
    }

    private void setCurrency(DynamicObject obj, Long orgId) {
        Long currency;
        Map<String, Long> currencyinfo = StockOrgCurrencyBotpPlugin.getCurrencyAndExRateTable(orgId);
        HashMap<Long, Long> currencyMap = new HashMap<Long, Long>(128);
        if (null != currencyinfo && MapUtils.isNotEmpty(currencyinfo) && (currency = currencyinfo.get("baseCurrencyID")) != null && !currency.equals(0L)) {
            currencyMap.put(orgId, currency);
            HashSet baseCurrencyIds = new HashSet(currencyMap.values());
            QFilter filter = new QFilter("id", "in", baseCurrencyIds);
            Map bdCurrency = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (QFilter[])new QFilter[]{filter});
            if (MapUtils.isNotEmpty((Map)bdCurrency)) {
                Long currencyId = (Long)currencyMap.get(orgId);
                obj.set("settlecurrency", bdCurrency.get(currencyId));
            }
        }
    }

    public static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map map;
        Map mapOrg;
        if (orgId != 0L && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)false, (Boolean)true)) != null && mapOrg.get("id") != null && (map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")))) != null && map.size() != 0) {
            return map;
        }
        return Collections.emptyMap();
    }
}

