/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.manuftech.event;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.utils.MPDMCustFormulaFuntions;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.platform.api.IFormulaFunctions;
import kd.bos.formula.platform.engine.FormulaEngine;
import kd.bos.formula.platform.engine.RunFormulaException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.om.common.inbill.OmInBillHelper;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutoCreateProcessReportEventService
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(AutoCreateProcessReportEventService.class);
    private static final String BOTP_ID = "1229660370013037568";
    private static final String AUDIT = "audit";
    private static final String KEY_IM_MDC_OMCMPLINBILL = "im_mdc_omcmplinbill";
    private static final String KEY_OM_MFTORDER = "om_mftorder";
    private static final String KEY_OM_MFTTECHNICS = "om_mfttechnics";
    private static final String KEY_OM_PROCESSREPORT = "om_processreport";

    public Object handleEvent(KDBizEvent evt) {
        if (evt instanceof EntityEvent) {
            EntityEvent e = (EntityEvent)evt;
            List businessKeys = e.getBusinesskeys();
            String operation = e.getOperation();
            if (AUDIT.equals(operation)) {
                Set billIds = businessKeys.stream().map(NumberUtils::toLong).collect(Collectors.toSet());
                QFilter ischargeoff = new QFilter("ischargeoff", "=", (Object)Boolean.FALSE);
                String selects = "id,modeltype,billentry.id,billentry.manubillid,billentry.qty,billentry.producttype,billentry.qualitystatus,billentry.baseqty,billentry.techid,billentry.oprentryid";
                QFilter[] idQf = new QFilter[]{new QFilter("id", "in", (Object)OmInBillHelper.filterOpmBill(billIds)), ischargeoff};
                DynamicObject[] omCmpInBills = BusinessDataServiceHelper.load((String)KEY_IM_MDC_OMCMPLINBILL, (String)selects, (QFilter[])idQf);
                if (omCmpInBills.length > 0) {
                    this.handle(omCmpInBills);
                }
            }
        }
        return evt.getEventId();
    }

    private void handle(DynamicObject[] omCmpInBills) {
        HashSet mftOrderIdSet = new HashSet(16);
        for (DynamicObject omCmpInBill : omCmpInBills) {
            mftOrderIdSet.addAll(omCmpInBill.getDynamicObjectCollection("billentry").stream().map(entry -> entry.getLong("manubillid")).collect(Collectors.toSet()));
        }
        HashMap<String, DynamicObject> mftOrderMap = new HashMap<String, DynamicObject>(16);
        if (!mftOrderIdSet.isEmpty()) {
            QFilter[] mftIdQf = new QFilter[]{new QFilter("id", "in", mftOrderIdSet)};
            StringBuilder sb = new StringBuilder();
            sb.append("id");
            sb.append(",transactiontype");
            sb.append(",transactiontype.transactiontype");
            sb.append(",transactiontype.isprocedure");
            DynamicObjectCollection mftOrderColl = QueryServiceHelper.query((String)KEY_OM_MFTORDER, (String)sb.toString(), (QFilter[])mftIdQf);
            for (DynamicObject mftOrder : mftOrderColl) {
                mftOrderMap.put(mftOrder.getString("id"), mftOrder);
            }
        }
        List<String> service = null;
        for (int i = 0; i < omCmpInBills.length; ++i) {
            DynamicObjectCollection cmpInBillEntryColl = omCmpInBills[i].getDynamicObjectCollection("billentry");
            for (DynamicObject cmpInBillEntry : cmpInBillEntryColl) {
                String mftBillId;
                DynamicObject mftOrder;
                if (!"C".equals(cmpInBillEntry.getString("producttype")) || (mftOrder = (DynamicObject)mftOrderMap.get(mftBillId = cmpInBillEntry.getString("manubillid"))) == null || !mftOrder.getBoolean("transactiontype.isprocedure")) continue;
                QFilter[] mftBillIdQf = new QFilter[]{new QFilter("manufactureorderid", "=", (Object)mftBillId)};
                DynamicObject[] mftTechBills = BusinessDataServiceHelper.load((String)KEY_OM_MFTTECHNICS, (String)"id", (QFilter[])mftBillIdQf);
                logger.info((Object)"---------------\u5f00\u59cb\u8c03\u7528\u5de5\u5e8f\u8ba1\u5212BOTP\u751f\u6210\u5de5\u5e8f\u6c47\u62a5\u5fae\u670d\u52a1-------------------");
                service = this.autoPushAndSubmit(mftTechBills, cmpInBillEntry);
                logger.info((Object)"---------------\u8c03\u7528\u5de5\u5e8f\u8ba1\u5212BOTP\u751f\u6210\u5de5\u5e8f\u6c47\u62a5\u5fae\u670d\u52a1\u6267\u884c\u6210\u529f-------------------");
            }
        }
        if (service != null && service.size() > 0) {
            ErrorCode ec = new ErrorCode("autoPushRepBill", ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u81ea\u52a8\u4e0b\u8fbe\u51fa\u73b0\u9519\u8bef\u3002", (String)"AutoCreateProcessReportEventService_0", (String)"mmc-om-opplugin", (Object[])new Object[0]));
            throw new KDBizException(ec, new Object[]{service});
        }
    }

    public List<String> autoPushAndSubmit(DynamicObject[] mftTechBills, DynamicObject cmpInBillEntry) {
        Object pkValue = cmpInBillEntry.getPkValue();
        BigDecimal qty = cmpInBillEntry.getBigDecimal("qty");
        String qualityStatus = cmpInBillEntry.getString("qualitystatus");
        ArrayList<String> result = new ArrayList<String>();
        for (DynamicObject techBill : mftTechBills) {
            SourceBillReport billReport2;
            DynamicObject mftTechBill = BusinessDataServiceHelper.loadSingle((Object)techBill.getPkValue(), (String)KEY_OM_MFTTECHNICS);
            DynamicObjectCollection techBillEntry = mftTechBill.getDynamicObjectCollection("oprentryentity");
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber(KEY_OM_MFTTECHNICS);
            pushArgs.setTargetEntityNumber(KEY_OM_PROCESSREPORT);
            pushArgs.setHasRight(true);
            pushArgs.setAppId("om");
            pushArgs.setRuleId(BOTP_ID);
            pushArgs.setBuildConvReport(true);
            int size = techBillEntry.size();
            ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(size);
            for (int j = 0; j < size; ++j) {
                ListSelectedRow srcBill = new ListSelectedRow(mftTechBill.getPkValue());
                srcBill.setEntryEntityKey("oprentryentity");
                srcBill.setEntryPrimaryKeyValue(((DynamicObject)techBillEntry.get(j)).getPkValue());
                selectedRows.add(srcBill);
                pushArgs.setSelectedRows(selectedRows);
            }
            ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (!pushResult.isSuccess()) {
                StringBuilder errMessage = new StringBuilder().append(pushResult.getMessage());
                for (SourceBillReport billReport2 : pushResult.getBillReports()) {
                    if (billReport2.isSuccess()) continue;
                    errMessage.append(billReport2.getFailMessage());
                }
                String mgs = String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25:%s", (String)"AutoCreateProcessReportEventService_5", (String)"mmc-om-opplugin", (Object[])new Object[0]), errMessage);
                throw new KDBizException(mgs);
            }
            MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)KEY_OM_PROCESSREPORT);
            List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
            billReport2 = targetBillObjs.iterator();
            while (billReport2.hasNext()) {
                DynamicObject targetBill = (DynamicObject)billReport2.next();
                DynamicObjectCollection targetBillEntryCol = targetBill.getDynamicObjectCollection("sumentry");
                for (DynamicObject targetBillEntry : targetBillEntryCol) {
                    targetBillEntry.set("completqty", (Object)qty);
                    targetBillEntry.set("manuinbillentryid", pkValue);
                    DynamicObjectCollection detailColl = targetBillEntry.getDynamicObjectCollection("repsubentryentity");
                    for (DynamicObject detail : detailColl) {
                        detail.set("repactualqty", this.runFormula(detail));
                    }
                    if ("A".equals(qualityStatus) || "B".equals(qualityStatus)) {
                        targetBillEntry.set("qualifyqty", (Object)qty);
                        continue;
                    }
                    if (!"D".equals(qualityStatus)) continue;
                    targetBillEntry.set("qualifyqty", (Object)0);
                    targetBillEntry.set("workwasteqty", (Object)0);
                    targetBillEntry.set("reworkqty", (Object)0);
                    targetBillEntry.set("scrapqty", (Object)qty);
                    targetBillEntry.set("junkqty", (Object)qty);
                }
            }
            OperateOption saveOption = this.createOperateOption();
            OperationResult saveResult = SaveServiceHelper.saveOperate((String)KEY_OM_PROCESSREPORT, (DynamicObject[])targetBillObjs.toArray(new DynamicObject[targetBillObjs.size()]), (OperateOption)saveOption);
            if (!saveResult.isSuccess()) {
                String mgs = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"AutoCreateProcessReportEventService_6", (String)"mmc-om-opplugin", (Object[])new Object[0]), this.getErrDetail(saveResult));
                throw new KDBizException(mgs);
            }
            OperationResult submitResult = this.operate("submit", saveResult.getSuccessPkIds().toArray());
            if (!submitResult.isSuccess()) {
                String mgs = String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a%s", (String)"AutoCreateProcessReportEventService_7", (String)"mmc-om-opplugin", (Object[])new Object[0]), this.getErrDetail(submitResult));
                throw new KDBizException(mgs);
            }
            OperationResult auditResult = this.operate(AUDIT, saveResult.getSuccessPkIds().toArray());
            if (auditResult.isSuccess()) continue;
            String mgs = String.format(ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\uff1a%s", (String)"AutoCreateProcessReportEventService_8", (String)"mmc-om-opplugin", (Object[])new Object[0]), this.getErrDetail(auditResult));
            throw new KDBizException(mgs);
        }
        return result;
    }

    private OperationResult operate(String opKey, Object[] ids) {
        OperateOption operateOption = this.createOperateOption();
        OperationResult result = OperationServiceHelper.executeOperate((String)opKey, (String)KEY_OM_PROCESSREPORT, (Object[])ids, (OperateOption)operateOption);
        return result;
    }

    private OperateOption createOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignorewarn", String.valueOf(true));
        operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        operateOption.setVariableValue("strictvalidation", String.valueOf(true));
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        operateOption.setVariableValue("ignoreValidation", String.valueOf(true));
        operateOption.setVariableValue("WF", "false");
        return operateOption;
    }

    private String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        errDetail.append(optResult.getMessage());
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage());
        }
        return errDetail.toString();
    }

    private Object runFormula(DynamicObject detail) {
        DynamicObject formula = detail.getDynamicObject("actstandardformula");
        if (formula == null || StringUtils.isBlank((CharSequence)formula.getString("formula"))) {
            return null;
        }
        Object result = null;
        HashMap<String, DynamicObject> varValues = new HashMap<String, DynamicObject>(16);
        DynamicObjectCollection repEntryColl = new DynamicObjectCollection();
        DynamicObject sumEntry = (DynamicObject)OrmUtils.clone((IDataEntityBase)((DynamicObject)detail.getParent()), (boolean)false, (boolean)true);
        repEntryColl.add((Object)((DynamicObject)OrmUtils.clone((IDataEntityBase)detail, (boolean)false, (boolean)true)));
        sumEntry.set("repsubentryentity", (Object)repEntryColl);
        DynamicObject cloneProcessReport = (DynamicObject)OrmUtils.clone((IDataEntityBase)((IDataEntityBase)((DynamicObject)detail.getParent()).getParent()), (boolean)false, (boolean)true);
        DynamicObjectCollection dynamicObjectCollection = cloneProcessReport.getDynamicObjectCollection("sumentry");
        dynamicObjectCollection.clear();
        dynamicObjectCollection.add((Object)sumEntry);
        varValues.put(KEY_OM_PROCESSREPORT, cloneProcessReport);
        try {
            FormulaEngine.registerFunctions((IFormulaFunctions)new MPDMCustFormulaFuntions());
            result = FormulaEngine.runFormula((String)formula.getString("formula"), varValues);
        }
        catch (RunFormulaException exp) {
            logger.error((Object)String.format("\u516c\u5f0f\u8ba1\u7b97\u65f6\u51fa\u73b0\u5f02\u5e38 - \u53c2\u65701 %s  \u53c2\u65702 %s ", formula.getString("formula"), ((Object)varValues).toString()), (Throwable)exp);
            logger.error((Object)"FormulaEngine.runFormula", (Throwable)exp);
        }
        return result;
    }
}

