/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.order.validator;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OmOrderBOMTypeValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap<Long, Long> bomTypeCacheMap = new HashMap<Long, Long>(16);
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject mftOrderBill = extendedDataEntity.getDataEntity();
            DynamicObject transactiontype = mftOrderBill.getDynamicObject("transactiontype");
            if (transactiontype == null) {
                return;
            }
            DynamicObjectCollection bomTypes = transactiontype.getDynamicObjectCollection("bomtypes");
            HashSet<Long> bomTypeIds = new HashSet<Long>(16);
            if (!bomTypes.isEmpty()) {
                for (DynamicObject bomType : bomTypes) {
                    bomTypeIds.add(bomType.getLong("fbasedataid_id"));
                }
            }
            DynamicObjectCollection entrys = mftOrderBill.getDynamicObjectCollection("treeentryentity");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                DynamicObject bomId = entry.getDynamicObject("bomid");
                if (bomId == null) continue;
                Long bomTypeId = (Long)bomTypeCacheMap.get(bomId.getLong("id"));
                if (bomTypeId == null || bomTypeId.equals(0L)) {
                    DynamicObject bom = BusinessDataServiceHelper.loadSingleFromCache((Object)bomId.getPkValue(), (String)"pdm_mftbom", (String)"type");
                    bomTypeId = bom.getDynamicObject("type").getLong("id");
                    bomTypeCacheMap.put(bomId.getLong("id"), bomTypeId);
                }
                if (!"A".equals(transactiontype.get("stockmaterials")) || bomTypeIds.contains(bomTypeId)) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55BOM\u7684BOM\u7c7b\u578b\u4e0d\u5728\u4e8b\u52a1\u7c7b\u578bBOM\u7c7b\u578b\u7684\u53ef\u9009\u8303\u56f4\u5185\u3002", (String)"OmOrderBOMTypeValidator_0", (String)"mmc-om-opplugin", (Object[])new Object[0]), i + 1);
                this.addErrorMessage(extendedDataEntity, msg);
            }
        }
    }
}

