/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.order.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.om.common.botp.BotpTrackerHelper;
import kd.mmc.om.common.utils.OMBillUtil;

public class OrderUnTransmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.checkPurBill(dataEntities);
        List<ExtendedDataEntity> collect = Arrays.stream(dataEntities).filter(a -> !a.getDataEntity().getBoolean("transactiontype.isreleasetechnis")).collect(Collectors.toList());
        this.checkMfttechnics(collect);
    }

    private void checkMfttechnics(List<ExtendedDataEntity> dataEntities) {
        HashSet<Long> entryIdSet = new HashSet<Long>(6);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject obj = dataEntity.getDataEntity();
            String billNo = obj.getString("billno");
            String operateOptionStr = this.getOption().getVariableValue("operateOption");
            long[] entryIds = null;
            if (StringUtils.isNotEmpty((CharSequence)operateOptionStr)) {
                List list = OMBillUtil.getBillSelectRowInfo((String)operateOptionStr, (String)billNo);
                entryIds = list.stream().mapToLong(Long::valueOf).toArray();
            } else {
                DynamicObjectCollection dynamicObjectCollection = obj.getDynamicObjectCollection("treeentryentity");
                entryIds = dynamicObjectCollection.stream().mapToLong(a -> a.getLong("id")).toArray();
            }
            if (entryIds == null) continue;
            for (long entryId : entryIds) {
                entryIdSet.add(entryId);
            }
        }
        long[] sEntryIds = entryIdSet.stream().mapToLong(Long::valueOf).toArray();
        ArrayList<String> targetEntitys = new ArrayList<String>(2);
        targetEntitys.add("om_mfttechnics");
        Map entryId_tBillId = BotpTrackerHelper.trackDown((String)"om_mftorder", (String)"treeentryentity", targetEntitys, (Long[])ArrayUtils.toObject((long[])sEntryIds));
        HashSet mfttechnicsIds = new HashSet(6);
        entryId_tBillId.values().forEach(mfttechnicsIds::addAll);
        String algoKey = "kd.mmc.om.opplugin.order.validator.OrderUnTransmitValidator#checkMfttechnics";
        String selects = "id,oprentryentity.oprstatus";
        QFilter[] qFilterArray = new QFilter[]{new QFilter("id", "in", mfttechnicsIds)};
        HashMap<Long, String> id_oprstatusMap = new HashMap<Long, String>(6);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"om_mfttechnics", (String)selects, (QFilter[])qFilterArray, null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                Long id = next.getLong("id");
                String oprstatus = next.getString("oprentryentity.oprstatus");
                id_oprstatusMap.put(id, oprstatus);
            }
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject obj = dataEntity.getDataEntity();
            DynamicObjectCollection entity = obj.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : entity) {
                long entryId = entry.getLong("id");
                int seq = entry.getInt("seq");
                Set tBillIds = (Set)entryId_tBillId.get(entryId);
                if (tBillIds == null) continue;
                for (Object tBillId : tBillIds) {
                    String oprStatus = (String)id_oprstatusMap.get(tBillId);
                    if (!StringUtils.equals((CharSequence)"D", (CharSequence)oprStatus) && !StringUtils.equals((CharSequence)"E", (CharSequence)oprStatus) && !StringUtils.equals((CharSequence)"F", (CharSequence)oprStatus) && !StringUtils.equals((CharSequence)"G", (CharSequence)oprStatus)) continue;
                    String mgs = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u53cd\u4e0b\u8fbe\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5de5\u5e8f\u8ba1\u5212\u7684\u5de5\u5e8f\u72b6\u6001\u4e0d\u80fd\u5b58\u5728\u4e0b\u8fbe\u3001\u5f00\u5de5\u3001\u5b8c\u5de5\u3001\u5173\u95ed\u72b6\u6001\u3002", (String)"OrderUnTransmitValidator_0", (String)"mmc-om-opplugin", (Object[])new Object[0]), seq);
                    this.addErrorMessage(dataEntity, mgs);
                }
            }
        }
    }

    private void checkPurBill(ExtendedDataEntity[] dataEntities) {
        HashSet<Long> entryIdSet = new HashSet<Long>(6);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject obj = dataEntity.getDataEntity();
            String billNo = obj.getString("billno");
            String operateOptionStr = this.getOption().getVariableValue("operateOption");
            long[] entryIds = null;
            if (StringUtils.isNotEmpty((CharSequence)operateOptionStr)) {
                List list = OMBillUtil.getBillSelectRowInfo((String)operateOptionStr, (String)billNo);
                entryIds = list.stream().mapToLong(Long::valueOf).toArray();
            } else {
                DynamicObjectCollection dynamicObjectCollection = obj.getDynamicObjectCollection("treeentryentity");
                entryIds = dynamicObjectCollection.stream().mapToLong(a -> a.getLong("id")).toArray();
            }
            if (entryIds == null) continue;
            for (long entryId : entryIds) {
                entryIdSet.add(entryId);
            }
        }
        long[] sEntryIds = entryIdSet.stream().mapToLong(Long::valueOf).toArray();
        ArrayList<String> targetEntitys = new ArrayList<String>(2);
        targetEntitys.add("pm_purapplybill");
        targetEntitys.add("pm_purorderbill");
        Map entryId_tBillId = BotpTrackerHelper.trackDown((String)"om_mftorder", (String)"treeentryentity", targetEntitys, (Long[])ArrayUtils.toObject((long[])sEntryIds));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject obj = dataEntity.getDataEntity();
            DynamicObjectCollection dynamicObjectCollection = obj.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : dynamicObjectCollection) {
                long entryId;
                entryId = entry.getLong("id");
                int seq = entry.getInt("seq");
                if (!entryId_tBillId.containsKey(entryId)) continue;
                String mgs = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u53cd\u4e0b\u8fbe\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5df2\u4ea7\u751f\u4e0b\u6e38\u91c7\u8d2d\u7533\u8bf7\u5355/\u91c7\u8d2d\u8ba2\u5355\u3002", (String)"OrderUnTransmitValidator_1", (String)"mmc-om-opplugin", (Object[])new Object[0]), seq);
                this.addErrorMessage(dataEntity, mgs);
            }
        }
    }
}

