/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.processreport;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bd.mpdm.common.utils.MmcLockHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ProcessReportBeginOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(ProcessReportBeginOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("reportdate");
        e.getFieldKeys().add("opra");
        e.getFieldKeys().add("oprentryid");
        e.getFieldKeys().add("confirmoprstatus");
        e.getFieldKeys().add("manufacturenun");
        e.getFieldKeys().add("mfttechnics");
        e.getFieldKeys().add("oprno");
        e.getFieldKeys().add("completqty");
        e.getFieldKeys().add("otherproductentity");
        e.getFieldKeys().add("srcorderid2");
        e.getFieldKeys().add("srcorderentryid2");
        e.getFieldKeys().add("qualifyqty2");
        e.getFieldKeys().add("repsubentryentity");
        e.getFieldKeys().add("repactivity");
        e.getFieldKeys().add("repbaseqty");
        e.getFieldKeys().add("repactualqty");
        e.getFieldKeys().add("repactualbegintime");
        e.getFieldKeys().add("repactualfinishtime");
        e.getFieldKeys().add("manufacturenun3");
        e.getFieldKeys().add("manufacturerow3");
        e.getFieldKeys().add("matertype3");
        e.getFieldKeys().add("material3");
        e.getFieldKeys().add("auxproperty3");
        e.getFieldKeys().add("qualifyqty3");
        e.getFieldKeys().add("scrapqty3");
        e.getFieldKeys().add("inwarehouseorg3");
        e.getFieldKeys().add("batchno3");
        e.getFieldKeys().add("ownertype3");
        e.getFieldKeys().add("inwarconsigner3");
        e.getFieldKeys().add("warehouse3");
        e.getFieldKeys().add("position3");
        e.getFieldKeys().add("matertype");
        e.getFieldKeys().add("manufacturerow");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("material2");
        e.getFieldKeys().add("auxproperty");
        e.getFieldKeys().add("qualifyqty");
        e.getFieldKeys().add("scrapqty");
        e.getFieldKeys().add("workwasteqty");
        e.getFieldKeys().add("batchno2");
        e.getFieldKeys().add("batchno");
        e.getFieldKeys().add("qualifyqty2");
        e.getFieldKeys().add("scrapqty2");
        e.getFieldKeys().add("workwasteqty2");
        e.getFieldKeys().add("outputtype2");
        e.getFieldKeys().add("unitfield3");
        e.getFieldKeys().add("oprunit");
        e.getFieldKeys().add("repactivityunit2");
        e.getFieldKeys().add("warehousepoint");
        e.getFieldKeys().add("checkcoopation");
        e.getFieldKeys().add("qtyfield");
        e.getFieldKeys().add("staffreport");
        e.getFieldKeys().add("proportion");
        e.getFieldKeys().add("manufactureid");
        e.getFieldKeys().add("manufactureentryid");
        e.getFieldKeys().add("inwarehouseorg2");
        e.getFieldKeys().add("ownertype2");
        e.getFieldKeys().add("inwarconsigner2");
        e.getFieldKeys().add("warehouse2");
        e.getFieldKeys().add("position2");
        e.getFieldKeys().add("processseq");
        e.getFieldKeys().add("oprno");
        e.getFieldKeys().add("manufactureentryid3");
        e.getFieldKeys().add("manuinbillentryid");
        e.getFieldKeys().add("otherproductentity.seq");
        e.getFieldKeys().add("subentryentity1.seq");
        e.getFieldKeys().add("repsubentryentity.seq");
        e.getFieldKeys().add("represources");
        e.getFieldKeys().add("produceunit3");
        e.getFieldKeys().add("produceunit2");
        e.getFieldKeys().add("receiveqty");
        e.getFieldKeys().add("receiveqty2");
        e.getFieldKeys().add("receiveqty3");
        e.getFieldKeys().add("repairqty");
        e.getFieldKeys().add("repairqty2");
        e.getFieldKeys().add("repairqty3");
        e.getFieldKeys().add("conformityqty3");
        e.getFieldKeys().add("discardqty3");
        e.getFieldKeys().add("badconformityqty3");
        e.getFieldKeys().add("badqualifyqty3");
        e.getFieldKeys().add("reworkqty2");
        e.getFieldKeys().add("checkreworkqty");
        e.getFieldKeys().add("junkqty");
        e.getFieldKeys().add("junkqty2");
        e.getFieldKeys().add("bookdate");
        e.getFieldKeys().add("ischargeoff");
        e.getFieldKeys().add("sumentry.ecostcenter");
        e.getFieldKeys().add("productworkshop");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<String> orderEntryIds = new HashSet<String>(20);
        HashSet<String> orderIds = new HashSet<String>(20);
        ArrayList<Long> ids = new ArrayList<Long>(20);
        for (DynamicObject repOut : dataEntities) {
            DynamicObjectCollection entryCol = repOut.getDynamicObjectCollection("sumentry");
            for (DynamicObject billEntry : entryCol) {
                DynamicObject manufactureEntry = billEntry.getDynamicObject("manufactureentryid");
                orderIds.add(billEntry.getString("manufactureid"));
                if (manufactureEntry == null) continue;
                Object billEntityId = manufactureEntry.getPkValue();
                orderEntryIds.add(billEntityId.toString());
                ids.add(manufactureEntry.getLong("id"));
            }
        }
        switch (operationKey) {
            case "audit": {
                this.autoAculUseAndCloseOrder(operationKey, orderEntryIds, orderIds);
                this.culUseQty(ids);
                this.auditWithOutTrans(dataEntities);
                break;
            }
            case "unaudit": {
                this.culUseQty(ids);
                break;
            }
        }
    }

    private void culUseQty(List<Long> ids) {
        try {
            DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMftOrderService", (String)"batchCulUseQtyByOrderEntryId", (Object[])new Object[]{ids, "om_mftorder"});
        }
        catch (Exception ex) {
            throw new KDException((Throwable)ex, new ErrorCode("MmcServiceOrderCloseOpAction", ex.getMessage() != null ? ex.getMessage() : ex.toString()), new Object[0]);
        }
    }

    private void autoAculUseAndCloseOrder(String operationKey, Set<String> orderEntryids, Set<String> orderids) {
        HashMap<String, Object> calparam = new HashMap<String, Object>();
        calparam.put("orderentryids", orderEntryids);
        calparam.put("orderids", orderids);
        calparam.put("operate", operationKey);
        calparam.put("iscloseorder", "1");
        calparam.put("isautocal", "0");
        calparam.put("isautoflag", "0");
        calparam.put("modetype", "2");
        String jsonString = JSON.toJSONString(calparam);
        EventServiceHelper.triggerEventSubscribe((String)"auditCalMaterial", (String)jsonString);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operateKey = e.getOperationKey();
        DynamicObject[] bills = e.getDataEntities();
        switch (operateKey) {
            case "audit": {
                this.audit(bills);
                break;
            }
            case "unaudit": {
                this.unAudit(bills);
            }
        }
        e.setDataEntities(bills);
    }

    private void audit(DynamicObject[] bills) {
        for (DynamicObject reportbill : bills) {
            DynamicObjectCollection sumentitys = reportbill.getDynamicObjectCollection("sumentry");
            if (reportbill.getBoolean("ischargeoff")) continue;
            for (DynamicObject obj : sumentitys) {
                this.rewriteRep(obj, true);
                obj.getDynamicObjectCollection("subentryentity1").clear();
            }
        }
    }

    private void auditWithOutTrans(DynamicObject[] bills) {
        HashSet<Long> orderEntryids = new HashSet<Long>(16);
        for (DynamicObject reportbill : bills) {
            DynamicObjectCollection sumentitys = reportbill.getDynamicObjectCollection("sumentry");
            for (DynamicObject obj : sumentitys) {
                String matertype = obj.getString("matertype");
                if (!StringUtils.equals((CharSequence)"C", (CharSequence)matertype)) continue;
                Long mftentryid = obj.get("manufactureentryid") == null ? 0L : obj.getDynamicObject("manufactureentryid").getLong("id");
                orderEntryids.add(mftentryid);
            }
        }
        this.updateOrderBeginBookDate(bills, orderEntryids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOrderBeginBookDate(DynamicObject[] bills, Set<Long> orderEntryids) {
        if (bills == null || bills.length < 1 || orderEntryids == null || orderEntryids.isEmpty()) {
            return;
        }
        HashSet<String> lockKeys = new HashSet<String>(orderEntryids.size());
        HashMap<Long, DynamicObject> orderBills = new HashMap<Long, DynamicObject>(16);
        for (Long orderentryid : orderEntryids) {
            lockKeys.add("updateorderdbookdate/" + orderentryid.toString());
        }
        Map dLocks = MmcLockHelper.createDLocks(lockKeys, (boolean)false);
        try {
            Map successdLocks = MmcLockHelper.tryDLocks((Map)dLocks, (Long)100L);
            if (successdLocks == null || successdLocks.isEmpty()) {
                return;
            }
            HashSet<Long> updateorderEntryids = new HashSet<Long>(successdLocks.size());
            for (String successdLock : successdLocks.keySet()) {
                String[] split = successdLock.split("/");
                updateorderEntryids.add(Long.parseLong(split[1]));
            }
            QFilter filters = new QFilter("treeentryentity.id", "in", updateorderEntryids);
            DynamicObject[] orders = BusinessDataServiceHelper.load((String)"om_mftorder", (String)this.getOrderSelecors(), (QFilter[])filters.toArray());
            for (String string : orders) {
                orderBills.put(string.getLong("id"), (DynamicObject)string);
            }
            if (orderBills.size() > 0) {
                HashSet<DynamicObject> updateData = new HashSet<DynamicObject>(bills.length);
                HashSet<Long> updateEntryids = new HashSet<Long>(bills.length);
                HashSet<Long> updateOrderids = new HashSet<Long>(bills.length);
                for (DynamicObject reportBill : bills) {
                    Date bookdate = reportBill.getDate("bookdate");
                    DynamicObjectCollection sumentrys = reportBill.getDynamicObjectCollection("sumentry");
                    for (DynamicObject sumentry : sumentrys) {
                        Long orderbillId = sumentry.getLong("manufactureid");
                        DynamicObject orderBill = (DynamicObject)orderBills.get(orderbillId);
                        DynamicObjectCollection treeentryentitys = orderBill.getDynamicObjectCollection("treeentryentity");
                        for (DynamicObject treeentryentity : treeentryentitys) {
                            Date beginbookdate;
                            Long entryid = treeentryentity.getLong("id");
                            Long pid = treeentryentity.getLong("pid");
                            if (!updateorderEntryids.contains(entryid) && !updateorderEntryids.contains(pid) || (beginbookdate = treeentryentity.getDate("beginbookdate")) != null && !beginbookdate.after(bookdate)) continue;
                            treeentryentity.set("beginbookdate", (Object)(bookdate != null ? DateUtils.getShortDate((Date)bookdate) : null));
                            updateData.add(orderBill);
                            updateEntryids.add(entryid);
                            updateOrderids.add(orderbillId);
                        }
                    }
                }
                if (updateData.size() > 0) {
                    SaveServiceHelper.update((DynamicObject[])updateData.toArray(new DynamicObject[updateData.size()]));
                    this.updateChangeLog(orderBills, updateEntryids, updateOrderids);
                }
            }
        }
        finally {
            if (dLocks != null && dLocks.size() > 0) {
                MmcLockHelper.unDLocks(new ArrayList(dLocks.values()));
            }
        }
    }

    private void updateChangeLog(Map<Long, DynamicObject> orderBills, Set<Long> updateEntryids, Set<Long> updateOrderids) {
        DynamicObject[] changelogs;
        if (updateEntryids == null || updateOrderids == null || updateEntryids.size() < 1 || updateOrderids.size() < 1) {
            return;
        }
        HashSet<DynamicObject> changelogUpdateData = new HashSet<DynamicObject>(updateOrderids.size());
        QFilter qf = new QFilter("srcbillid", "in", updateOrderids);
        qf.and(new QFilter("srcbillentryid", "in", updateEntryids));
        for (DynamicObject changelog : changelogs = BusinessDataServiceHelper.load((String)"om_xmftorderlog", (String)"srcbillid,srcbillentryid,beginbookdate", (QFilter[])qf.toArray())) {
            Object beginbookdateObj;
            Long odentryid;
            Date beginbookdate;
            long orderid = changelog.getLong("srcbillid");
            DynamicObject orderBill = orderBills.get(orderid);
            if (orderBill == null || (beginbookdate = this.getOrderBeginBookDate(orderBill, odentryid = Long.valueOf(changelog.getLong("srcbillentryid")))) == null || (beginbookdateObj = changelog.get("beginbookdate")) != null) continue;
            changelog.set("beginbookdate", (Object)(beginbookdate != null ? DateUtils.getShortDate((Date)beginbookdate) : null));
            changelogUpdateData.add(changelog);
        }
        if (changelogUpdateData.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])changelogUpdateData.toArray(new DynamicObject[changelogUpdateData.size()]));
        }
    }

    private Date getOrderBeginBookDate(DynamicObject orderBill, Long odentryid) {
        if (orderBill == null || odentryid == null) {
            return null;
        }
        Date beginbookdate = null;
        DynamicObjectCollection treeentryentitys = orderBill.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject treeentryentity : treeentryentitys) {
            Long entryid = treeentryentity.getLong("id");
            if (!odentryid.equals(entryid)) continue;
            beginbookdate = treeentryentity.getDate("beginbookdate");
        }
        return beginbookdate;
    }

    private String getOrderSelecors() {
        StringBuilder fileds = new StringBuilder(200);
        fileds.append("billno");
        fileds.append(",treeentryentity");
        fileds.append(",treeentryentity.pid");
        fileds.append(",treeentryentity.beginbookdate");
        fileds.append(",treeentryentity.closebookdate");
        return fileds.toString();
    }

    private void unAudit(DynamicObject[] bills) {
        for (DynamicObject reportbill : bills) {
            DynamicObjectCollection sumentitys = reportbill.getDynamicObjectCollection("sumentry");
            for (DynamicObject obj : sumentitys) {
                this.rewriteRep(obj, false);
                obj.getDynamicObjectCollection("subentryentity1").clear();
            }
        }
    }

    private void rewriteRep(DynamicObject reportbill, boolean isaudit) {
        DynamicObjectCollection repsubentryentitys = reportbill.getDynamicObjectCollection("repsubentryentity");
        Long oprentryid = Long.valueOf(reportbill.getString("oprentryid"));
        DynamicObject manftech = BusinessDataServiceHelper.loadSingle((String)"om_mfttechnics", (String)this.selectProperties(), (QFilter[])new QFilter[]{new QFilter("oprentryentity.id", "=", (Object)oprentryid)});
        if (manftech == null) {
            return;
        }
        DynamicObjectCollection manftechentrys = manftech.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject manftechentry : manftechentrys) {
            if (!manftechentry.getPkValue().toString().equals(oprentryid.toString())) continue;
            DynamicObjectCollection repentitys = manftechentry.getDynamicObjectCollection("repsubentryentity");
            for (int k = 0; k < repsubentryentitys.size(); ++k) {
                DynamicObject repentry = (DynamicObject)repsubentryentitys.get(k);
                if (isaudit) {
                    DynamicObject rep = repentitys.addNew();
                    rep.set("repactivity", repentry.get("repactivity"));
                    rep.set("repbaseqty", repentry.get("repbaseqty"));
                    rep.set("repactualqty", repentry.get("repactualqty"));
                    rep.set("repactualbegintime", repentry.get("repactualbegintime"));
                    rep.set("repactualfinishtime", repentry.get("repactualfinishtime"));
                    rep.set("represources", repentry.get("represources"));
                    rep.set("srcentryid", (Object)repentry.getPkValue().toString());
                    rep.set("seq", repentry.get("seq"));
                    continue;
                }
                for (int i = 0; i < repentitys.size(); ++i) {
                    if (!repentry.getPkValue().toString().equals(((DynamicObject)repentitys.get(i)).getString("srcentryid"))) continue;
                    repentitys.remove(i);
                    --i;
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{manftech});
    }

    private String selectProperties() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("id,");
        strBuilder.append("qty").append(',');
        strBuilder.append("processroute").append(',');
        strBuilder.append("planstarttime").append(',');
        strBuilder.append("planfinishtime").append(',');
        strBuilder.append("baseqty").append(',');
        strBuilder.append("mftentryseq").append(',');
        strBuilder.append("billno").append(',');
        strBuilder.append("billstatus").append(',');
        strBuilder.append("modifytime").append(',');
        strBuilder.append("modifier").append(',');
        strBuilder.append("manufactureorderseq").append(',');
        strBuilder.append("proentryentity").append('.').append("processseqqty").append(',');
        strBuilder.append("proentryentity").append('.').append("processseq").append(',');
        strBuilder.append("proentryentity").append('.').append("processplanbegintime").append(',');
        strBuilder.append("proentryentity").append('.').append("processplanendtime").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprplanbegintime").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprno").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprplanfinishtime").append(',');
        strBuilder.append("oprentryentity").append('.').append("headqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("operationqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("operationunit").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprstandardqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprproductionqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprstatus").append(',');
        strBuilder.append("oprentryentity").append('.').append("oproperation").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprtotalqualifiedqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprparent").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repactivity").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repbaseqty").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repactualqty").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repactualbegintime").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repactualfinishtime").append(',');
        strBuilder.append("repsubentryentity").append('.').append("srcentryid").append(',');
        strBuilder.append("repsubentryentity").append('.').append("represources").append(',');
        strBuilder.append("repsubentryentity").append('.').append("seq").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprinvalid");
        return strBuilder.toString();
    }
}

