/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.processreport.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.om.common.manuftech.utils.CheckManuOrderUtil;
import kd.mmc.om.common.processreport.ProcessReportUtil;
import kd.mmc.om.common.utils.AcctOrgCloseDateUtil;

public class ProcessReportValidator
extends AbstractValidator {
    public void validate() {
        String operate;
        switch (operate = this.getOperateKey()) {
            case "submit": {
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    this.submitCheck(i, operate);
                }
                break;
            }
            case "audit": {
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    this.auditCheck(i);
                }
                this.transactionTypeCheck();
                break;
            }
            case "unaudit": {
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    List list = ProcessReportUtil.mftOrderBizStatus((DynamicObject)this.dataEntities[i].getDataEntity(), (String)"om_processreport");
                    for (String msg : list) {
                        this.addErrorMessage(this.dataEntities[i], msg);
                    }
                    this.checkAcctOrgCloseDate(i, operate);
                }
                break;
            }
        }
    }

    private void auditCheck(int i) {
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        for (DynamicObject sumentry : obj.getDynamicObjectCollection("sumentry")) {
            String entryPkvalue = sumentry.getString("oprentryid");
            if (!StringUtils.isNotBlank((CharSequence)entryPkvalue)) continue;
            DynamicObject manftech = BusinessDataServiceHelper.loadSingle((String)"om_mfttechnics", (String)this.selectProperties(), (QFilter[])new QFilter[]{new QFilter("oprentryentity.id", "=", (Object)Long.valueOf(entryPkvalue))});
            DynamicObjectCollection manftechEntrys = manftech.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject manftechentry : manftechEntrys) {
                List<String> error;
                if (!manftechentry.getPkValue().toString().equals(entryPkvalue)) continue;
                if (StringUtils.equals((CharSequence)"10070", (CharSequence)sumentry.getString("confirmoprstatus"))) {
                    if (manftechentry.getBigDecimal("oprqty").compareTo(manftechentry.getBigDecimal("oprtotalqualifiedqty")) <= 0) {
                        error = ProcessReportValidator.CheckEntryStatus("row_finish", entryPkvalue, manftech, manftechEntrys);
                        for (String err : error) {
                            this.addWarningMessage(this.dataEntities[i], err);
                        }
                        continue;
                    }
                    error = ProcessReportValidator.CheckEntryStatus("row_start", entryPkvalue, manftech, manftechEntrys);
                    for (String err : error) {
                        this.addWarningMessage(this.dataEntities[i], err);
                    }
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"10080", (CharSequence)sumentry.getString("confirmoprstatus"))) continue;
                error = ProcessReportValidator.CheckEntryStatus("row_finish", entryPkvalue, manftech, manftechEntrys);
                for (String err : error) {
                    this.addWarningMessage(this.dataEntities[i], err);
                }
            }
        }
    }

    private void transactionTypeCheck() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        HashSet<Long> entryIDs = new HashSet<Long>();
        HashSet<Long> orderF7Ids = new HashSet<Long>();
        HashMap<Long, Integer> mapping = new HashMap<Long, Integer>();
        for (int i1 = 0; i1 < dataEntities.length; ++i1) {
            if (dataEntities[i1] == null) continue;
            DynamicObject dataEntity = dataEntities[i1].getDataEntity();
            DynamicObjectCollection sumentrys = dataEntity.getDynamicObjectCollection("sumentry");
            for (int i2 = 0; i2 < sumentrys.size(); ++i2) {
                DynamicObject dynamicObject = (DynamicObject)sumentrys.get(i2);
                if (dynamicObject == null) continue;
                Long entryid = (Long)dynamicObject.getPkValue();
                DynamicObject manufactureentryid = dynamicObject.getDynamicObject("manufactureentryid");
                if (manufactureentryid != null) {
                    orderF7Ids.add((Long)manufactureentryid.getPkValue());
                }
                entryIDs.add(entryid);
                mapping.put(entryid, i1);
            }
        }
        QFilter billnoFiliter = new QFilter("sumentry.id", "in", entryIDs);
        try (DataSet processReports = QueryServiceHelper.queryDataSet((String)"query_om_processreport", (String)"om_processreport", (String)this.getSelectProperties("om_processreport"), (QFilter[])new QFilter[]{billnoFiliter}, null);){
            DataSet result = null;
            QFilter qFilter = new QFilter("treeentryentity.id", "in", orderF7Ids);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"query_ommftorder", (String)"om_mftorder", (String)this.getSelectProperties("om_mftorder"), (QFilter[])new QFilter[]{qFilter}, (String)"");){
                HashSet<Long> transactiontypeIds = new HashSet<Long>();
                DataSet copyDS = ds.copy();
                while (copyDS.hasNext()) {
                    Row next = copyDS.next();
                    transactiontypeIds.add(next.getLong("transactiontype"));
                }
                QFilter qfilter1 = new QFilter("id", "in", transactiontypeIds);
                try (DataSet transactiontypeIdRows = QueryServiceHelper.queryDataSet((String)"query_transactiontype", (String)"mpdm_transactproduct", (String)this.getSelectProperties("mpdm_omtransactproduct"), (QFilter[])new QFilter[]{qfilter1}, (String)"");){
                    DataSet dataSet = ds.join(transactiontypeIdRows).select(new String[]{"billno", "baseqty", "isprocedure", "isreportpick", "reportcontrol", "reportcontrolrang", "entryId"}).on("transactiontype", "id").finish();
                    result = processReports.join(dataSet).select(new String[]{"entryid", "oprentryid", "manufactureentryid", "completqty", "baseqty", "isprocedure", "isreportpick", "reportcontrol", "reportcontrolrang", "masterid", "opra", "processseq", "oprno", "totalcompletqty"}).on("manufactureentryid", "entryId").finish();
                }
                DataSet res = result.where("isprocedure=true").where("isreportpick=true");
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query_om_mftstock", (String)"om_mftstock", (String)this.getSelectProperties("om_mftstock"), (QFilter[])new QFilter[]{new QFilter("orderentryid.id", "in", orderF7Ids)}, (String)"");){
                    DataSet stock = res.join(dataSet).select(new String[]{"entryid", "oprentryid", "manufactureentryid", "completqty", "baseqty", "isprocedure", "isreportpick", "reportcontrol", "reportcontrolrang", "masterid", "stockMasterId", "isbackflush", "issuemode", "isbulkmaterial", "iskeypart", "overissuecontrl", "lackraitioqty", "qtytype", "actissueqty", "rejectedqty", "feedingqty", "fixscrap", "demandqty", "totalcompletqty"}).on("manufactureentryid", "orderentryid").on("opra", "stockworkprocedureid").on("processseq", "stockprocessseq").on("oprno", "stockoprno").finish();
                    DataSet copy = stock.copy();
                    HashSet<Long> oprentryids = new HashSet<Long>(16);
                    while (copy.hasNext()) {
                        Row next = copy.next();
                        Long oprentryid = next.getLong("oprentryid");
                        oprentryids.add(oprentryid);
                    }
                    try (DataSet mfttechnicsDataSet = QueryServiceHelper.queryDataSet((String)"query_om_mfttechnics", (String)"om_mfttechnics", (String)this.getSelectProperties("om_mfttechnics"), (QFilter[])new QFilter[]{new QFilter("oprentryentity.id", "in", oprentryids)}, (String)"");){
                        DataSet select = mfttechnicsDataSet.select(new String[]{"cast(mfttechnics as String) mfttechnics", "oprtotalreportqty", "headqty", "headunit", "operationqty", "oprunit", "precisionaccount"});
                        DataSet result1 = stock.join(select).select(new String[]{"entryid", "completqty", "baseqty", "isprocedure", "isreportpick", "reportcontrol", "reportcontrolrang", "masterid", "stockMasterId", "isbackflush", "issuemode", "isbulkmaterial", "precisionaccount", "iskeypart", "overissuecontrl", "lackraitioqty", "qtytype", "actissueqty", "rejectedqty", "feedingqty", "fixscrap", "demandqty", "oprtotalreportqty", "headqty", "headunit", "operationqty", "oprunit", "totalcompletqty"}).on("oprentryid", "mfttechnics").finish();
                        DataSet copyResult = result1.copy();
                        HashSet masterids = new HashSet();
                        HashSet stockMasterIds = new HashSet();
                        copyResult.forEach(t -> {
                            stockMasterIds.add(t.getLong("stockMasterId"));
                            masterids.add(t.getLong("masterid"));
                        });
                        try (DataSet materials = QueryServiceHelper.queryDataSet((String)"queryMaterial", (String)"bd_material", (String)this.getSelectProperties("masterid"), (QFilter[])new QFilter[]{new QFilter("id", "in", masterids)}, (String)"");){
                            DataSet on = result1.join(materials).select(new String[]{"entryid", "completqty", "baseqty", "isprocedure", "isreportpick", "reportcontrol", "reportcontrolrang", "number", "name", "stockMasterId", "isbackflush", "issuemode", "isbulkmaterial", "precisionaccount", "iskeypart", "overissuecontrl", "lackraitioqty", "qtytype", "actissueqty", "rejectedqty", "feedingqty", "fixscrap", "demandqty", "oprtotalreportqty", "headqty", "headunit", "operationqty", "oprunit", "totalcompletqty"}).on("masterid", "id").finish();
                            try (DataSet stockMaterials = QueryServiceHelper.queryDataSet((String)"queryStockMaterial", (String)"bd_material", (String)this.getSelectProperties("stockMasterId"), (QFilter[])new QFilter[]{new QFilter("id", "in", stockMasterIds)}, (String)"");){
                                DataSet result2 = on.join(stockMaterials).select(new String[]{"entryid", "completqty", "baseqty", "isprocedure", "isreportpick", "reportcontrol", "reportcontrolrang", "number", "name", "materialnumber", "materialname", "isbackflush", "issuemode", "isbulkmaterial", "iskeypart", "overissuecontrl", "lackraitioqty", "qtytype", "actissueqty", "rejectedqty", "feedingqty", "fixscrap", "precisionaccount", "demandqty", "oprtotalreportqty", "headqty", "headunit", "operationqty", "oprunit", "totalcompletqty"}).on("stockMasterId", "id").finish();
                                while (result2.hasNext()) {
                                    Row next = result2.next();
                                    String reportcontrolrang = next.getString("reportcontrolrang");
                                    String isbackflush = next.getString("isbackflush");
                                    Boolean isbulkmaterial = next.getBoolean("isbulkmaterial");
                                    String issuemode = next.getString("issuemode");
                                    Boolean iskeypart = next.getBoolean("iskeypart");
                                    switch (reportcontrolrang) {
                                        case "A": {
                                            if (!"A".equals(isbackflush) || isbulkmaterial.booleanValue() || "C".equals(issuemode)) break;
                                            this.verifyFullySuse(next, mapping);
                                            break;
                                        }
                                        case "B": {
                                            if (!iskeypart.booleanValue() || isbulkmaterial.booleanValue() || "C".equals(issuemode)) break;
                                            this.verifyFullySuse(next, mapping);
                                            break;
                                        }
                                        case "C": {
                                            if (isbulkmaterial.booleanValue() || "C".equals(issuemode)) break;
                                            this.verifyFullySuse(next, mapping);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void verifyFullySuse(Row row, Map<Long, Integer> mapping) {
        BigDecimal actissueqty = row.getBigDecimal("actissueqty");
        BigDecimal rejectedqty = row.getBigDecimal("rejectedqty");
        BigDecimal feedingqty = row.getBigDecimal("feedingqty");
        BigDecimal oprtotalreportqty = row.getBigDecimal("oprtotalreportqty");
        BigDecimal completqty = row.getBigDecimal("completqty");
        BigDecimal headqty = row.getBigDecimal("headqty");
        Integer headunit = row.getInteger("headunit");
        Integer precisionaccount = row.getInteger("precisionaccount");
        BigDecimal operationqty = row.getBigDecimal("operationqty");
        Integer oprunit = row.getInteger("oprunit");
        BigDecimal demandqty = row.getBigDecimal("demandqty");
        BigDecimal fixscrap = row.getBigDecimal("fixscrap");
        BigDecimal baseqty = row.getBigDecimal("baseqty");
        String qtytype = row.getString("qtytype");
        String overissuecontrl = row.getString("overissuecontrl");
        BigDecimal lackraitioqty = row.getBigDecimal("lackraitioqty");
        String reportcontrol = row.getString("reportcontrol");
        BigDecimal totalcompletqty = oprtotalreportqty.add(completqty);
        Long entryid = row.getLong("entryid");
        BigDecimal a = actissueqty.subtract(rejectedqty).add(feedingqty);
        BigDecimal divided = demandqty.subtract(fixscrap).multiply(oprtotalreportqty.add(completqty)).multiply(headqty);
        BigDecimal divide = baseqty.multiply(operationqty);
        BigDecimal c = divided.divide(divide, (int)headunit, precisionaccount);
        BigDecimal b = null;
        block5 : switch (qtytype) {
            case "B": {
                b = demandqty;
                break;
            }
            case "A": 
            case "C": {
                switch (overissuecontrl) {
                    case "A": {
                        b = c;
                        break block5;
                    }
                    case "B": {
                        b = c.compareTo(lackraitioqty) < 0 ? c : lackraitioqty;
                    }
                }
            }
        }
        if (a == null) {
            a = BigDecimal.ZERO;
        }
        if (b == null) {
            b = BigDecimal.ZERO;
        }
        if (a.compareTo(b) < 0) {
            Integer i = mapping.get(entryid);
            String materialnumber = row.getString("materialnumber");
            String materialname = row.getString("materialname");
            String number = row.getString("number");
            String name = row.getString("name");
            String message = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u5168\u9886\u6599\u7684\u7269\u6599\uff1a\u5de5\u5e8f\u6c47\u62a5\u4ea7\u54c1\u7f16\u7801\u201c%1$s\u201d \u4ea7\u54c1\u540d\u79f0\u201c%2$s\u201d \u7d2f\u8ba1\u6c47\u62a5\u6570\u91cf\u201c%3$s\u201d\uff0c\u7269\u6599\u7f16\u7801\u201c%4$s\u201d \u7269\u6599\u540d\u79f0\u201c%5$s\u201d\u5e94\u9886\u7528\u201c%6$s\u201d\uff0c\u5b9e\u9645\u9886\u7528\u201c%7$s\u201d\u3002", (String)"ProcessReportValidator_8", (String)"mmc-om-opplugin", (Object[])new Object[0]), number, name, totalcompletqty.setScale(oprunit).toPlainString(), materialnumber, materialname, b.setScale(headunit).toPlainString(), a.setScale(headunit).toPlainString());
            switch (reportcontrol) {
                case "A": {
                    this.addWarningMessage(this.dataEntities[i], message);
                    break;
                }
                case "B": {
                    this.addErrorMessage(this.dataEntities[i], message);
                }
            }
        }
    }

    private String getSelectProperties(String billType) {
        StringJoiner stringJoiner = new StringJoiner(",");
        switch (billType) {
            case "om_mftorder": {
                stringJoiner.add("transactiontype");
                stringJoiner.add("treeentryentity.id as entryId");
                stringJoiner.add("treeentryentity.baseqty AS baseqty");
                stringJoiner.add("billno");
                break;
            }
            case "mpdm_omtransactproduct": {
                stringJoiner.add("id");
                stringJoiner.add("isprocedure");
                stringJoiner.add("isreportpick");
                stringJoiner.add("reportcontrol");
                stringJoiner.add("reportcontrolrang");
                break;
            }
            case "om_mftstock": {
                stringJoiner.add("orderentryid.id as orderentryid");
                stringJoiner.add("stockentry.materialid.masterid as stockMasterId");
                stringJoiner.add("stockentry.isbackflush as isbackflush");
                stringJoiner.add("stockentry.issuemode as issuemode");
                stringJoiner.add("stockentry.isbulkmaterial as isbulkmaterial");
                stringJoiner.add("stockentry.iskeypart as iskeypart");
                stringJoiner.add("stockentry.overissuecontrl as overissuecontrl");
                stringJoiner.add("stockentry.lackraitioqty as lackraitioqty");
                stringJoiner.add("stockentry.qtytype as qtytype");
                stringJoiner.add("stockentry.workprocedureid as stockworkprocedureid");
                stringJoiner.add("stockentry.processseq as stockprocessseq");
                stringJoiner.add("stockentry.oprno as stockoprno");
                stringJoiner.add("stockentry.actissueqty as actissueqty");
                stringJoiner.add("stockentry.rejectedqty as rejectedqty");
                stringJoiner.add("stockentry.feedingqty as feedingqty");
                stringJoiner.add("stockentry.fixscrap as fixscrap");
                stringJoiner.add("stockentry.demandqty as demandqty");
                break;
            }
            case "om_processreport": {
                stringJoiner.add("sumentry.id AS entryid");
                stringJoiner.add("sumentry.oprentryid AS oprentryid");
                stringJoiner.add("sumentry.completqty AS completqty");
                stringJoiner.add("sumentry.manufacturenun AS manufacturenun");
                stringJoiner.add("sumentry.manufactureentryid.id AS manufactureentryid");
                stringJoiner.add("sumentry.material.masterid AS masterid");
                stringJoiner.add("sumentry.opra as opra");
                stringJoiner.add("sumentry.processseq as processseq");
                stringJoiner.add("sumentry.oprno as oprno");
                stringJoiner.add("sumentry.totalcompletqty as totalcompletqty");
                break;
            }
            case "om_mfttechnics": {
                stringJoiner.add("oprentryentity.id as mfttechnics");
                stringJoiner.add("oprentryentity.oprtotalreportqty as oprtotalreportqty");
                stringJoiner.add("oprentryentity.headqty as headqty");
                stringJoiner.add("oprentryentity.headunit.precision as headunit");
                stringJoiner.add("oprentryentity.headunit.precisionaccount as precisionaccount");
                stringJoiner.add("oprentryentity.operationqty as operationqty");
                stringJoiner.add("oprentryentity.oprunit.precision as oprunit");
                break;
            }
            case "masterid": {
                stringJoiner.add("id");
                stringJoiner.add("number");
                stringJoiner.add("name");
                break;
            }
            case "stockMasterId": {
                stringJoiner.add("id");
                stringJoiner.add("number As materialnumber");
                stringJoiner.add("name As materialname");
            }
        }
        return stringJoiner.toString();
    }

    private void submitCheck(int i, String var) {
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        if (!obj.getBoolean("checkcoopation")) {
            if ("qty".equals(obj.getString("staffreport"))) {
                DynamicObjectCollection sumentrys = obj.getDynamicObjectCollection("sumentry");
                for (DynamicObject sumentry : sumentrys) {
                    DynamicObjectCollection reportentrys = sumentry.getDynamicObjectCollection("childreportentity");
                    if (reportentrys == null || reportentrys.size() == 0) continue;
                    BigDecimal sumQty = BigDecimal.ZERO;
                    for (DynamicObject repent : reportentrys) {
                        sumQty = sumQty.add(repent.getBigDecimal("qtyfield"));
                    }
                    if (sumQty.compareTo(sumentry.getBigDecimal("completqty")) == 0) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u6c47\u62a5\u6570\u91cf\u5e94\u7b49\u4e8e\u6c47\u62a5\u4eba\u5458\u603b\u6570\u3002", (String)"ProcessReportValidator_0", (String)"mmc-om-opplugin", (Object[])new Object[0]), new Object[0]));
                }
            } else if ("cooportion".equals(obj.getString("staffreport"))) {
                DynamicObjectCollection sumentrys = obj.getDynamicObjectCollection("sumentry");
                for (DynamicObject sumentry : sumentrys) {
                    DynamicObjectCollection reportentrys = sumentry.getDynamicObjectCollection("childreportentity");
                    if (reportentrys == null || reportentrys.size() == 0) continue;
                    BigDecimal sumQty = BigDecimal.ZERO;
                    for (DynamicObject repent : reportentrys) {
                        sumQty = sumQty.add(repent.getBigDecimal("proportion"));
                    }
                    if (sumQty.compareTo(new BigDecimal(100)) == 0) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6c47\u62a5\u6bd4\u4f8b\u4e4b\u548c\u5e94\u4e3a\u767e\u5206\u4e4b\u767e\u3002", (String)"ProcessReportValidator_1", (String)"mmc-om-opplugin", (Object[])new Object[0]), new Object[0]));
                }
            }
        }
        this.checkAcctOrgCloseDate(i, var);
    }

    private void checkAcctOrgCloseDate(int i, String var) {
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        Date date = AcctOrgCloseDateUtil.getAcctOrgCloseDate((Long)obj.getDynamicObject("org").getLong("id"));
        Date reportDate = obj.getDate("bookdate");
        if (date != null && reportDate != null && date.compareTo(reportDate) >= 0) {
            String acctOrgName = AcctOrgCloseDateUtil.getAcctOrgName((Long)obj.getDynamicObject("org").getLong("id"));
            if ("unaudit".equals(var)) {
                String format = ResManager.loadKDString((String)"\u5de5\u5e8f\u6c47\u62a5\u5355\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u7684\u6838\u7b97\u7ec4\u7ec7(%s)\u5df2\u5173\u8d26\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ProcessReportValidator_2", (String)"mmc-om-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(this.dataEntities[i], String.format(format, acctOrgName));
            }
        }
    }

    public static List<String> CheckEntryStatus(String operateKey, Object object, DynamicObject technicsBill, DynamicObjectCollection entryCol) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!"C".equals(technicsBill.getString("billstatus"))) {
            errors.add(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212[%s]\u672a\u5ba1\u6838\u3002", (String)"ProcessReportValidator_3", (String)"mmc-om-opplugin", (Object[])new Object[0]), technicsBill.getString("billno")));
            return errors;
        }
        for (int j = 0; j < entryCol.size(); ++j) {
            if (!object.toString().equals(((DynamicObject)entryCol.get(j)).getPkValue().toString())) continue;
            StringBuffer error = new StringBuffer();
            if (((DynamicObject)entryCol.get(j)).getBoolean("oprinvalid")) {
                String format = String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u201c%1$s\u201d\uff0c\u5de5\u5e8f\u5e8f\u5217\u201c%2$s\u201d\uff0c\u5de5\u5e8f\u53f7\u201c%3$s\u201d\u5df2\u4f5c\u5e9f\u3002", (String)"ProcessReportValidator_7", (String)"mmc-om-opplugin", (Object[])new Object[0]), technicsBill.getString("billno"), ((DynamicObject)entryCol.get(j)).getString("oprparent"), ((DynamicObject)entryCol.get(j)).getString("oprno"));
                errors.add(format);
                continue;
            }
            switch (operateKey) {
                case "row_start": {
                    error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkBizStatus", (String)technicsBill.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5f00\u5de5", (String)"ProcessReportValidator_5", (String)"mmc-om-opplugin", (Object[])new Object[0]), (Object)technicsBill.getDynamicObject("mftentryseq").getPkValue());
                    break;
                }
                case "row_finish": {
                    error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkBizStatus", (String)technicsBill.getString("billno"), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5b8c\u5de5", (String)"ProcessReportValidator_6", (String)"mmc-om-opplugin", (Object[])new Object[0]), (Object)technicsBill.getDynamicObject("mftentryseq").getPkValue());
                    break;
                }
            }
            if (error.length() <= 0) break;
            errors.add(error.toString());
        }
        return errors;
    }

    private String selectProperties() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("id,");
        strBuilder.append("qty").append(',');
        strBuilder.append("processroute").append(',');
        strBuilder.append("planstarttime").append(',');
        strBuilder.append("planfinishtime").append(',');
        strBuilder.append("baseqty").append(',');
        strBuilder.append("mftentryseq").append(',');
        strBuilder.append("billno").append(',');
        strBuilder.append("billstatus").append(',');
        strBuilder.append("modifytime").append(',');
        strBuilder.append("modifier").append(',');
        strBuilder.append("manufactureorderseq").append(',');
        strBuilder.append("proentryentity").append('.').append("processseqqty").append(',');
        strBuilder.append("proentryentity").append('.').append("processseq").append(',');
        strBuilder.append("proentryentity").append('.').append("processplanbegintime").append(',');
        strBuilder.append("proentryentity").append('.').append("processplanendtime").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprplanbegintime").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprno").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprplanfinishtime").append(',');
        strBuilder.append("oprentryentity").append('.').append("headqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("operationqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("operationunit").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprstandardqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprproductionqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprstatus").append(',');
        strBuilder.append("oprentryentity").append('.').append("oproperation").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprtotalqualifiedqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprparent").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprinvalid");
        return strBuilder.toString();
    }
}

