/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.stock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.om.common.botp.BotpTrackerHelper;

public class OmStockAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("orderentryid.id");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        HashSet<Long> orderEntryIds = new HashSet<Long>(16);
        for (DynamicObject stock : e.getDataEntities()) {
            orderEntryIds.add(stock.getLong("orderentryid.id"));
        }
        Map entryIdMap = BotpTrackerHelper.trackDown((String)"om_mftorder", (String)"treeentryentity", (String)"pm_purorderbill", (Long[])orderEntryIds.toArray(new Long[0]));
        if (!entryIdMap.isEmpty()) {
            HashMap<Long, Long> orderId2orderEntryId = new HashMap<Long, Long>();
            for (Map.Entry entry : entryIdMap.entrySet()) {
                for (Object obj : (Set)entry.getValue()) {
                    orderId2orderEntryId.put(Long.parseLong(obj + ""), Long.parseLong(entry.getKey() + ""));
                }
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            filters.add(new QFilter("id", "in", orderId2orderEntryId.keySet()));
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
            Set auditOrderBillIds = QueryServiceHelper.queryPrimaryKeys((String)"pm_purorderbill", (QFilter[])filters.toArray(new QFilter[2]), null, (int)-1).stream().map(v -> Long.parseLong(v.toString())).collect(Collectors.toSet());
            if (auditOrderBillIds.isEmpty()) {
                return;
            }
            HashSet orderEntryids = new HashSet(auditOrderBillIds.size());
            for (Long auditOrderBillId : auditOrderBillIds) {
                orderEntryids.add(orderId2orderEntryId.get(auditOrderBillId));
            }
            HashMap orderEntryIdsMap = new HashMap();
            orderEntryIdsMap.put("orderEntryIds", orderEntryids);
            Map pushResult = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"om", (String)"MftstockAutoPushService", (String)"mftstockAutoPushByOrderEntryIds", (Object[])new Object[]{orderEntryIdsMap});
            boolean isSuccess = (Boolean)pushResult.get("isSuccess");
            if (!isSuccess) {
                String msg = String.format(ResManager.loadKDString((String)"\u59d4\u5916\u7ec4\u5c06\u6e05\u5355\u5bf9\u5e94\u7684\u534f\u540c\u7ec4\u4ef6\u6e05\u5355\u751f\u6210\u5931\u8d25\uff1a%1$s", (String)"OmStockAuditOp_0", (String)"mmc-om-opplugin", (Object[])new Object[0]), pushResult.get("errorMsg").toString());
                throw new KDBizException(msg);
            }
        }
    }
}

