/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.stock;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mmc.om.common.utils.OMDyObjUtil;

public class OmStockSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("isinitbill");
        e.getFieldKeys().add("transactiontypeid");
        e.getFieldKeys().add("stockentry.useqty");
        e.getFieldKeys().add("stockentry.wipqty");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        String name = this.billEntityType.getName();
        if (!"om_mftstock".equals(name)) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            boolean isinitbill = dataEntity.getBoolean("isinitbill");
            if (!isinitbill) continue;
            Long orderentryid = OMDyObjUtil.getDyObjId((Object)dataEntity.get("orderentryid"));
            DynamicObject transactiontype = dataEntity.getDynamicObject("transactiontypeid");
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("stockentry");
            for (DynamicObject entry : entryColl) {
                BigDecimal useQty = MPDMMftGenStocksUtils.aculUseQty((DynamicObject)entry, (Object)orderentryid, (DynamicObject)transactiontype, (String)"om_mftorder");
                entry.set("useqty", (Object)useQty);
                BigDecimal wipqty = MPDMMftGenStocksUtils.aculWIPQty((DynamicObject)entry);
                entry.set("wipqty", (Object)wipqty);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String name = this.billEntityType.getName();
        if (!"om_mftstock".equals(name)) {
            return;
        }
        DynamicObject[] objs = e.getDataEntities();
        ArrayList<Long> updateOrder = new ArrayList<Long>(16);
        for (DynamicObject obj : objs) {
            boolean isinitbill = obj.getBoolean("isinitbill");
            if (!isinitbill) continue;
            String orderidStr = obj.getString("orderid");
            updateOrder.add(Long.valueOf(orderidStr));
        }
        if (updateOrder != null && updateOrder.size() > 0) {
            OperationServiceHelper.executeOperate((String)"calmaterial", (String)"om_mftorder", (Object[])updateOrder.toArray(), (OperateOption)OperateOption.create());
        }
    }
}

