/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.stockchange;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bd.mpdm.common.stockchange.utils.ChangeConfigUtils;
import kd.bd.mpdm.common.stockchange.utils.StockChangeUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.om.opplugin.stockchange.validator.StockChangeAuditValidator;

public class StockChangeAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("stockentry");
        filds.add("id");
        filds.add("reason");
        filds.add("createtime");
        filds.add("creator");
        filds.add("stockentry.entryidf");
        filds.add("stockentry.entryorderentryid");
        filds.add("stockentry.stockentry_lk");
        filds.add("stockentry.stockentry_lk_stableid");
        filds.add("stockentry.stockentry_lk_sbillid");
        filds.add("stockentry.stockentry_lk_sid");
        filds.add("stockentry.stockno");
        filds.add("stockentry.stockid");
        filds.add("stockentry.productno");
        filds.add("stockentry.materielmasterid");
        filds.add("stockentry.stockentryid");
        filds.add("stockentry.stockentryseq");
        filds.add("stockentry.seq");
        filds.add("stockentry.sourcetype");
        filds.add("stockentry.entryorderentryid");
        filds.add("stockentry.considerminbatch");
        Set stockchange = StockChangeUtils.getAllStockEentryFields((String)"om_xxcomponentlist");
        for (String field : stockchange) {
            filds.add("stockentry." + field);
        }
        filds.add("setuplocation");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new StockChangeAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] stockChangeBills = e.getDataEntities();
        for (int i = 0; i < stockChangeBills.length; ++i) {
            DynamicObject stockChangeBill = stockChangeBills[i];
            DynamicObjectCollection entryCol = stockChangeBill.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject stockChangeEntry = (DynamicObject)entryCol.get(j);
                this.changeManuBillAfterAudit(stockChangeEntry, stockChangeBill);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)"om_componentlist", (String)"om_componentlist");
        DynamicObject[] stockChangeBills = e.getDataEntities();
        HashSet<Long> orderEntryIds = new HashSet<Long>(stockChangeBills.length);
        for (int i = 0; i < stockChangeBills.length; ++i) {
            DynamicObject stockChangeBill = stockChangeBills[i];
            DynamicObject stockChangeBillNew = BusinessDataServiceHelper.loadSingle((Object)stockChangeBill.getPkValue(), (String)"om_xxcomponentlist");
            DynamicObjectCollection entryCol = stockChangeBillNew.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObjectCollection linkRows;
                DynamicObject stockChangeEntry = (DynamicObject)entryCol.get(j);
                if (stockChangeEntry.containsProperty("entryorderentryid")) {
                    orderEntryIds.add(stockChangeEntry.getLong("entryorderentryid.id"));
                }
                if (!(linkRows = stockChangeEntry.getDynamicObjectCollection("stockentry_lk")).isEmpty()) continue;
                String stockeid = stockChangeEntry.getString("stockid");
                if (StringUtils.isEmpty((CharSequence)stockeid)) {
                    return;
                }
                DynamicObject stockBill = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(stockeid), (String)"om_componentlist");
                int stockentryseq = Integer.parseInt(stockChangeEntry.getString("stockentryseq"));
                DynamicObject stockEntry = (DynamicObject)stockBill.getDynamicObjectCollection("stockentry").get(stockentryseq - 1);
                stockChangeEntry.set("stockentryid", stockEntry.getPkValue());
                DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
                linkRow.set("stockentry_lk_stableid", (Object)srcTableDefine.getTableId());
                linkRow.set("stockentry_lk_sbillid", (Object)stockeid);
                linkRow.set("stockentry_lk_sid", stockEntry.getPkValue());
                linkRows.add((Object)linkRow);
            }
            OperateOption create = OperateOption.create();
            create.setVariableValue("aduitToSave", "aduitToSave");
            SaveServiceHelper.saveOperate((String)"om_xxcomponentlist", (DynamicObject[])new DynamicObject[]{stockChangeBillNew}, (OperateOption)create);
        }
        this.calMaterial(orderEntryIds);
    }

    private void calMaterial(Set<Long> orderEntryIds) {
        if (!orderEntryIds.isEmpty() && "om_xxcomponentlist".equals(this.billEntityType.getName())) {
            HashSet<Object> orderIds = new HashSet<Object>(orderEntryIds.size());
            String algoKey = "kd.mmc.om.opplugin.stockchange.StockChangeAuditOp.calMaterial";
            Throwable throwable = null;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pm_om_purorderbill", (String)"id", (QFilter[])new QFilter("billentry.id", "in", orderEntryIds).toArray(), null);){
                for (Row row : dataSet) {
                    orderIds.add(row.get("id"));
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            for (Object e : orderIds) {
                this.calMaterialByOrderId(e);
            }
        }
    }

    private void calMaterialByOrderId(Object orderId) {
        DispatchServiceHelper.invokeBizService((String)"mmc", (String)"om", (String)"PurOrderCalMaterialUtils", (String)"calMaterial", (Object[])new Object[]{"pm_om_purorderbill", orderId});
    }

    private void changeManuBillAfterAudit(DynamicObject stockChangeEntry, DynamicObject stockChangeBill) {
        String changeType = stockChangeEntry.getString("entrychangetype");
        if (StringUtils.equals((CharSequence)"A", (CharSequence)changeType)) {
            this.changeBillForNew(stockChangeEntry, stockChangeBill);
        } else if (StringUtils.equals((CharSequence)"B", (CharSequence)changeType)) {
            this.changeBillForChange(stockChangeEntry, stockChangeBill);
        }
    }

    private void changeBillForChange(DynamicObject stockChangeEntry, DynamicObject stockChangeBill) {
        String stockEntryid;
        String stockeid = stockChangeEntry.getString("stockid");
        if (StringUtils.isEmpty((CharSequence)stockeid)) {
            return;
        }
        String string = stockEntryid = stockChangeEntry.get("stockentryid") == null ? null : stockChangeEntry.getString("stockentryid");
        if (StringUtils.isEmpty((CharSequence)stockEntryid)) {
            return;
        }
        DynamicObject stockBill = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(stockeid), (String)"om_componentlist");
        DynamicObjectCollection entryCol = stockBill.getDynamicObjectCollection("stockentry");
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject stockBillEntry = (DynamicObject)entryCol.get(i);
            if (!StringUtils.equals((CharSequence)stockBillEntry.getPkValue().toString(), (CharSequence)stockEntryid)) continue;
            this.updateStockEntry(stockBillEntry, stockChangeEntry, stockChangeBill);
        }
        stockBill.set("ischanged", (Object)Boolean.FALSE);
        SaveServiceHelper.update((DynamicObject)stockBill);
    }

    private void updateStockEntry(DynamicObject stockBillEntry, DynamicObject stockChangeEntry, DynamicObject stockChangeBill) {
        String stockChangeName = stockChangeBill.getDataEntityType().getName();
        String[] stock = ChangeConfigUtils.getEntryFields((String)stockChangeName, (String)"b");
        for (int i = 0; i < stock.length; ++i) {
            Object stockfield = stockBillEntry.get(stock[i]);
            Object stockchangefield = stockChangeEntry.get(stock[i]);
            if (ObjectUtils.isEmpty((Object)stockfield)) {
                stockfield = "";
            }
            if (ObjectUtils.isEmpty((Object)stockchangefield)) {
                stockchangefield = "";
            }
            if (stockfield.toString().equals(stockchangefield.toString()) || stockfield.hashCode() == stockchangefield.hashCode()) continue;
            stockBillEntry.set(stock[i], stockChangeEntry.get(stock[i]));
        }
    }

    private void changeBillForNew(DynamicObject stockChangeEntry, DynamicObject stockChangeBill) {
        String stockeid = stockChangeEntry.getString("stockid");
        if (StringUtils.isEmpty((CharSequence)stockeid)) {
            return;
        }
        DynamicObject stock = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(stockeid), (String)"om_componentlist");
        DynamicObjectCollection stockEntryCol = stock.getDynamicObjectCollection("stockentry");
        DynamicObject stockEntry = ORM.create().newDynamicObject("om_componentlist.stockentry");
        String stockChangeName = stockChangeBill.getDataEntityType().getName();
        Set stockFields = StockChangeUtils.getAllStockEentryFields((String)stockChangeName);
        for (String stockField : stockFields) {
            stockEntry.set(stockField, stockChangeEntry.get(stockField));
        }
        int seq = stockEntryCol.size() + 1;
        IDataEntityType type = stockEntry.getDataEntityType();
        DBRoute rt = new DBRoute(type.getDBRouteKey());
        SequenceReader seqReader = new SequenceReader(rt);
        seqReader.autoSetPrimaryKey((Object[])new DynamicObject[]{stockEntry}, type);
        stockEntry.set("seq", (Object)seq);
        stockEntryCol.add((Object)stockEntry);
        stock.set("ischanged", (Object)Boolean.FALSE);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stock});
        DynamicObject stockChangeBillNew = BusinessDataServiceHelper.loadSingle((Object)stockChangeBill.getPkValue(), (String)"om_xxcomponentlist");
        int changeSeq = (Integer)stockChangeEntry.get("seq");
        if (changeSeq >= 1) {
            DynamicObject stockChangeBillEntry = (DynamicObject)stockChangeBillNew.getDynamicObjectCollection("stockentry").get(changeSeq - 1);
            stockChangeBillEntry.set("stockentryseq", (Object)stockEntryCol.size());
            SaveServiceHelper.update((DynamicObject)stockChangeBillNew);
        }
    }
}

