/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.stockchange;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.om.common.utils.MftGenStocksUtils;
import kd.mmc.om.opplugin.stockchange.validator.StockChangeAuditValidator;

public class StockChangeSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("billstatus");
        filds.add("stockentry");
        filds.add("stockentry.stockid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new StockChangeAuditValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] stockChangeBills = e.getDataEntities();
        for (int i = 0; i < stockChangeBills.length; ++i) {
            DynamicObject stockChangeBill = stockChangeBills[i];
            DynamicObjectCollection entryCol = stockChangeBill.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject stockChangeEntry = (DynamicObject)entryCol.get(j);
                if (!stockChangeEntry.getBoolean("islead")) continue;
                this.changeManuBillAfterSubmit(stockChangeEntry, stockChangeBill);
            }
        }
    }

    private void changeManuBillAfterSubmit(DynamicObject stockChangeEntry, DynamicObject stockChangeBill) {
        String changeType = stockChangeEntry.getString("entrychangetype");
        if (StringUtils.equals((CharSequence)"A", (CharSequence)changeType)) {
            this.changeBillForNew(stockChangeEntry, stockChangeBill);
        } else if (StringUtils.equals((CharSequence)"B", (CharSequence)changeType)) {
            this.changeBillForChange(stockChangeEntry, stockChangeBill);
        }
    }

    private void changeBillForChange(DynamicObject stockChangeEntry, DynamicObject stockChangeBill) {
        String stockNo = stockChangeEntry.getString("stockno");
        String stockSeq = stockChangeEntry.getString("stockentryseq");
        QFilter filter = new QFilter("billno", "=", (Object)stockNo);
        List filters = MftGenStocksUtils.getStockFilter();
        filters.add(filter);
        QFilter[] filterArray = new QFilter[filters.size()];
        DynamicObject stockDymOld = BusinessDataServiceHelper.loadSingle((String)"om_componentlist", (String)"org,transactiontypeid,transactiontypeid.isconsiderloss,transactiontypeid.isprocedure,transactiontypeid.deduction,productid,orderentryid,baseunitid,baseqty,orderno,stockentry,stockentry.qtytype,stockentry.seq,stockentry.actissueqty,stockentry.rejectedqty,stockentry.feedingqty,stockentry.scrapqty,stockentry.outqty", (QFilter[])filters.toArray(filterArray));
        if (stockDymOld == null) {
            return;
        }
        String stockeid = stockDymOld.getPkValue().toString();
        DynamicObject stockEntry = this.getEntryIdBySeq(stockDymOld, stockSeq);
        if (stockEntry == null) {
            return;
        }
        String stockEntryid = stockEntry.getPkValue().toString();
        stockChangeBill.set("org", stockDymOld.get("org"));
        stockChangeBill.set("transactiontypeid", stockDymOld.get("transactiontypeid"));
        stockChangeEntry.set("productno", stockDymOld.get("productid"));
        stockChangeEntry.set("productbaseunit", stockDymOld.get("baseunitid"));
        stockChangeEntry.set("productbaseqty", stockDymOld.get("baseqty"));
        stockChangeEntry.set("componentno", stockDymOld.get("orderno"));
        stockChangeEntry.set("actissueqty", stockEntry.get("actissueqty"));
        stockChangeEntry.set("rejectedqty", stockEntry.get("rejectedqty"));
        stockChangeEntry.set("feedingqty", stockEntry.get("feedingqty"));
        stockChangeEntry.set("scrapqty", stockEntry.get("scrapqty"));
        stockChangeEntry.set("outqty", stockEntry.get("outqty"));
        DynamicObject materialInfo = stockChangeEntry.getDynamicObject("materialid");
        DynamicObject masterid = materialInfo.getDynamicObject("masterid");
        stockChangeEntry.set("materialunitid", (Object)masterid.getDynamicObject("baseunit"));
        stockChangeEntry.set("materielmasterid", (Object)masterid);
        this.autoFillStockChange(stockChangeEntry, stockEntry.getString("qtytype"), stockDymOld);
        stockChangeEntry.set("stockid", (Object)stockeid);
        stockChangeEntry.set("stockentryid", (Object)stockEntryid);
        SaveServiceHelper.update((DynamicObject)stockChangeBill);
    }

    private void autoFillStockChange(DynamicObject stockChangeEntry, String qtyType, DynamicObject stockDymOld) {
        stockChangeEntry.set("qtytype", (Object)qtyType);
        DynamicObject baseUnit = stockChangeEntry.getDynamicObject("materialunitid");
        int precision = 2;
        if (baseUnit != null) {
            precision = baseUnit.get("precision") == null ? 2 : baseUnit.getInt("precision");
        }
        BigDecimal useratio = stockChangeEntry.getBigDecimal("useratio").divide(BigDecimal.valueOf(100L), 4, 4);
        BigDecimal orderQty = stockChangeEntry.getBigDecimal("productbaseqty");
        BigDecimal qtynumerator = stockChangeEntry.getBigDecimal("qtynumerator");
        BigDecimal qtydenominator = stockChangeEntry.getBigDecimal("qtydenominator");
        String wastagerateformula = stockChangeEntry.getString("wastagerateformula");
        if (!"A".equals(wastagerateformula) && !"B".equals(wastagerateformula)) {
            wastagerateformula = "B";
            stockChangeEntry.set("wastagerateformula", (Object)wastagerateformula);
        }
        stockChangeEntry.set("standqty", (Object)MftGenStocksUtils.calculateStandQty((int)precision, (String)qtyType, (BigDecimal)useratio, (BigDecimal)orderQty, (BigDecimal)qtynumerator, (BigDecimal)qtydenominator));
        BigDecimal standqty = stockChangeEntry.getBigDecimal("standqty");
        BigDecimal scraprate = stockChangeEntry.getBigDecimal("scraprate");
        BigDecimal fixscrap = stockChangeEntry.getBigDecimal("fixscrap");
        stockChangeEntry.set("demandqty", (Object)MftGenStocksUtils.calculateDemadQty((int)precision, (boolean)stockDymOld.getBoolean("transactiontypeid.isconsiderloss"), (BigDecimal)standqty, (BigDecimal)scraprate, (BigDecimal)fixscrap, (String)wastagerateformula));
        stockChangeEntry.set("extraratioqty", (Object)stockChangeEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.add(stockChangeEntry.getBigDecimal("issinhighlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
        stockChangeEntry.set("lackraitioqty", (Object)stockChangeEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.subtract(stockChangeEntry.getBigDecimal("issinlowlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
        stockChangeEntry.set("actissueqty", MftGenStocksUtils.aculActissueQty((DynamicObject)stockChangeEntry));
        stockChangeEntry.set("cansendqty", MftGenStocksUtils.aculCanSendQty((DynamicObject)stockChangeEntry));
        stockChangeEntry.set("unissueqty", MftGenStocksUtils.aculUnSendQty((DynamicObject)stockChangeEntry));
        stockChangeEntry.set("useqty", (Object)MftGenStocksUtils.aculOMUseQty((DynamicObject)stockChangeEntry, (Object)stockDymOld.getDynamicObject("orderentryid").getPkValue(), (DynamicObject)stockDymOld.getDynamicObject("transactiontypeid")));
        stockChangeEntry.set("wipqty", (Object)MftGenStocksUtils.aculWIPQty((DynamicObject)stockChangeEntry));
    }

    private void changeBillForNew(DynamicObject stockChangeEntry, DynamicObject stockChangeBill) {
        String stockNo = stockChangeEntry.getString("stockno");
        QFilter filter = new QFilter("billno", "=", (Object)stockNo);
        List filters = MftGenStocksUtils.getStockFilter();
        filters.add(filter);
        QFilter[] filterArray = new QFilter[filters.size()];
        DynamicObject stockDymOld = BusinessDataServiceHelper.loadSingle((String)"om_componentlist", (String)"org,transactiontypeid,transactiontypeid.isconsiderloss,productid,orderentryid,baseunitid,baseqty,orderno,stockentry,stockentry.seq,stockentry.actissueqty,stockentry.rejectedqty,stockentry.feedingqty,stockentry.scrapqty,stockentry.outqty", (QFilter[])filters.toArray(filterArray));
        if (stockDymOld == null) {
            return;
        }
        String stockeid = stockDymOld.getPkValue().toString();
        stockChangeBill.set("org", stockDymOld.get("org"));
        stockChangeBill.set("transactiontypeid", stockDymOld.get("transactiontypeid"));
        stockChangeEntry.set("productno", stockDymOld.get("productid"));
        stockChangeEntry.set("productbaseunit", stockDymOld.get("baseunitid"));
        stockChangeEntry.set("productbaseqty", stockDymOld.get("baseqty"));
        stockChangeEntry.set("componentno", stockDymOld.get("orderno"));
        stockChangeEntry.set("entryorderentryid", stockDymOld.get("orderentryid"));
        DynamicObject materialInfo = stockChangeEntry.getDynamicObject("materialid");
        DynamicObject masterid = materialInfo.getDynamicObject("masterid");
        stockChangeEntry.set("materialunitid", (Object)masterid.getDynamicObject("baseunit"));
        stockChangeEntry.set("materielmasterid", (Object)masterid);
        String qtyType = stockChangeEntry.getString("qtytype");
        if (!("A".equals(qtyType) || "B".equals(qtyType) || "C".equals(qtyType))) {
            qtyType = "A";
        }
        stockChangeEntry.set("qtytype", (Object)qtyType);
        this.autoFillStockChange(stockChangeEntry, qtyType, stockDymOld);
        stockChangeEntry.set("stockid", (Object)stockeid);
        SaveServiceHelper.update((DynamicObject)stockChangeBill);
    }

    private DynamicObject getEntryIdBySeq(DynamicObject stockDymOld, String stockSeq) {
        DynamicObjectCollection entryCol = stockDymOld.getDynamicObjectCollection("stockentry");
        if (entryCol == null) {
            return null;
        }
        for (DynamicObject stockBillEntry : entryCol) {
            if (!StringUtils.equals((CharSequence)stockBillEntry.getString("seq"), (CharSequence)stockSeq)) continue;
            return stockBillEntry;
        }
        return null;
    }
}

