/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.stockchange;

import java.util.List;
import java.util.Set;
import kd.bd.mpdm.common.stockchange.utils.StockChangeUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.om.opplugin.stockchange.validator.StockChangeSubmitValidator;

public class StockChangeSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("mftdeptorgid");
        filds.add("stockentry.seq");
        e.getFieldKeys().add("orderid");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("orderentryid");
        e.getFieldKeys().add("transactiontypeid");
        e.getFieldKeys().add("transactiontypeid.isstockchange");
        e.getFieldKeys().add("transactiontypeid.isconsiderloss");
        e.getFieldKeys().add("transactiontypeid.isauditstock");
        filds.add("stockentry");
        filds.add("stockentry.stockid");
        filds.add("stockentry.productno");
        filds.add("stockentry.materielmasterid");
        filds.add("stockentry.entryidf");
        filds.add("stockentry.stockentryid");
        filds.add("stockentry.stockentryseq");
        filds.add("stockentry.seq");
        filds.add("stockentry.stockno");
        filds.add("stockentry.entryorderentryid");
        Set stockchange = StockChangeUtils.getAllStockEentryFields((String)"om_xxcomponentlist");
        for (String field : stockchange) {
            filds.add("stockentry." + field);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] stockChangeBills = e.getDataEntities();
        for (int i = 0; i < stockChangeBills.length; ++i) {
            DynamicObject stockChangeBill = stockChangeBills[i];
            DynamicObjectCollection entryCol = stockChangeBill.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject stockChangeEntry = (DynamicObject)entryCol.get(j);
                Long stockid = stockChangeEntry.getLong("stockid");
                if (StringUtils.isBlank((Object)stockid)) continue;
                this.changeBillForChange(stockid);
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new StockChangeSubmitValidator());
    }

    private void changeBillForChange(Long stockid) {
        DynamicObject stockBill = BusinessDataServiceHelper.loadSingle((Object)stockid, (String)"om_componentlist");
        stockBill.set("ischanged", (Object)Boolean.TRUE);
        SaveServiceHelper.update((DynamicObject)stockBill);
    }
}

