/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.stockchange.botp;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.helper.CloseDateHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.om.common.utils.UnitRateConvertUtil;

public class InvOuterBotpPlugin
extends AbstractConvertPlugIn {
    private static final String OM_COMPONENT_LIST = "om_componentlist";
    private static final String PM_OM_PUR_ORDER_BILL = "pm_om_purorderbill";
    private static Map<String, String> BILL_MAP = new HashMap<String, String>();

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("considerminbatch");
    }

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        super.afterGetSourceData(e);
        String name = this.getTgtMainType().getName();
        Set stockIds = e.getSourceRows().stream().filter(Objects::nonNull).map(t -> t.get("id")).collect(Collectors.toSet());
        HashSet<Long> orderIds = new HashSet<Long>();
        HashMap<Long, Object[]> stockIdMap = new HashMap<Long, Object[]>();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryOmComponentList", (String)OM_COMPONENT_LIST, (String)"id, orderid, billno", (QFilter[])new QFilter[]{new QFilter("id", "in", stockIds)}, null);
        Object object = null;
        try {
            for (Object row : dataSet) {
                stockIdMap.put(row.getLong("id"), new Object[]{row.getLong("orderid"), row.getString("billno")});
                orderIds.add(row.getLong("orderid"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        HashMap<Long, String[]> orderIdMap = new HashMap<Long, String[]>();
        DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)"queryPmOmPurOrderBill", (String)PM_OM_PUR_ORDER_BILL, (String)"id, closestatus, billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", orderIds)}, null);
        Object object2 = null;
        try {
            for (Row row : dataSet2) {
                orderIdMap.put(row.getLong("id"), new String[]{row.getString("closestatus"), row.getString("billstatus")});
            }
        }
        catch (Throwable row) {
            object2 = row;
            throw row;
        }
        finally {
            if (dataSet2 != null) {
                if (object2 != null) {
                    try {
                        dataSet2.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object2).addSuppressed(row);
                    }
                } else {
                    dataSet2.close();
                }
            }
        }
        for (DynamicObject object3 : e.getSourceRows()) {
            if (object3 == null) continue;
            Long orderid = (Long)((Object[])stockIdMap.get(object3.getLong("id")))[0];
            String billno = (String)((Object[])stockIdMap.get(object3.getLong("id")))[1];
            if (!orderIdMap.containsKey(orderid)) {
                String format = String.format(ResManager.loadKDString((String)"\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355%1$s\u7f3a\u5c11\u5173\u8054\u7684\u59d4\u5916\u8ba2\u5355\uff0c\u65e0\u6cd5\u4e0b\u63a8%2$s\u3002", (String)"InvOuterBotpPlugin_6", (String)"mmc-om-opplugin", (Object[])new Object[0]), billno, BILL_MAP.get(name) == null ? "" : BILL_MAP.get(name));
                ErrorCode ec = new ErrorCode("botp", format);
                throw new KDBizException(ec, new Object[0]);
            }
            String closestatus = ((String[])orderIdMap.get(orderid))[0];
            String billstatus = ((String[])orderIdMap.get(orderid))[1];
            if ("B".equals(closestatus) || "C".equals(billstatus)) continue;
            String format = String.format(ResManager.loadKDString((String)"\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355%1$s\u5173\u8054\u7684\u59d4\u5916\u8ba2\u5355\u4e0d\u4e3a\u5ba1\u6838\uff0c\u65e0\u6cd5\u4e0b\u63a8%2$s\u3002", (String)"InvOuterBotpPlugin_7", (String)"mmc-om-opplugin", (Object[])new Object[0]), billno, BILL_MAP.get(name) == null ? "" : BILL_MAP.get(name));
            ErrorCode ec = new ErrorCode("botp", format);
            throw new KDBizException(ec, new Object[0]);
        }
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] entities = e.getTargetExtDataEntitySet().FindByEntityKey("billentry");
        Map fldProperties = e.getFldProperties();
        if (entities == null || entities.length == 0) {
            return;
        }
        for (ExtendedDataEntity entity : entities) {
            boolean considerMinBatch;
            DynamicObject dym = entity.getDataEntity();
            DynamicObject material = dym.getDynamicObject("material");
            if (material == null) continue;
            entity.getDataEntity().set("unit", (Object)material.getDynamicObject("inventoryunit"));
            DynamicObject masterId = material.getDynamicObject("masterid");
            if (masterId == null) continue;
            DynamicProperty dynamicProperty = (DynamicProperty)fldProperties.get("considerminbatch");
            List srcRows = (List)entity.getValue("ConvertSource");
            DynamicObject srcEntry = (DynamicObject)srcRows.get(0);
            if (dynamicProperty != null && (considerMinBatch = ((Boolean)dynamicProperty.getValue((Object)srcEntry)).booleanValue())) {
                this.reCalBaseqty(masterId, dym);
            }
            if (masterId.getDynamicObject("auxptyunit") == null) continue;
            entity.getDataEntity().set("unit2nd", (Object)masterId.getDynamicObject("auxptyunit"));
        }
    }

    private void reCalBaseqty(DynamicObject masterId, DynamicObject dym) {
        String tgtMainType = this.getTgtMainType().toString();
        HashSet<String> billnames = new HashSet<String>();
        billnames.add("im_mdc_omproorder");
        billnames.add("im_mdc_omfeedorder");
        if (!billnames.contains(tgtMainType)) {
            return;
        }
        Object masterIdPkValue = masterId.getPkValue();
        DynamicObject baseunit = dym.getDynamicObject("baseunit");
        int precision = baseunit.getInt("precision");
        int precisionaccount = baseunit.getInt("precisionaccount");
        QFilter materialInfoFiliter = new QFilter("masterid", "=", masterIdPkValue);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query_bd_materialmftinfo", (String)"bd_materialmftinfo", (String)"minbatchnum,minbatchunit", (QFilter[])materialInfoFiliter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                BigDecimal minBatch = next.getBigDecimal("minbatchnum") == null ? BigDecimal.ONE : next.getBigDecimal("minbatchnum");
                Long minBatchUnit = next.getLong("minbatchunit") == null ? (Long)masterId.getDynamicObject("baseunit").getPkValue() : next.getLong("minbatchunit");
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)masterIdPkValue), (Long)minBatchUnit, (Long)((Long)baseunit.getPkValue()));
                if (muConv == null || muConv.getInt("numerator") == 0) continue;
                BigDecimal baseqty = dym.getBigDecimal("qty");
                BigDecimal multy = baseqty.multiply(new BigDecimal(muConv.getInt("denominator"))).divide(minBatch.multiply(new BigDecimal(muConv.getInt("numerator"))), 0, 2);
                BigDecimal newBaseQty = multy.multiply(minBatch).multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), precision, precisionaccount);
                dym.set("qty", (Object)newBaseQty);
            }
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entities;
        for (ExtendedDataEntity entity : entities = e.getTargetExtDataEntitySet().FindByEntityKey("billentry")) {
            DynamicObject masterId;
            DynamicObject dym = entity.getDataEntity();
            DynamicObject material = dym.getDynamicObject("material");
            if (material == null || (masterId = material.getDynamicObject("masterid")) == null || masterId.getDynamicObject("auxptyunit") == null) continue;
            BigDecimal unitRateConvert = UnitRateConvertUtil.getUnitRateConvert((Long)masterId.getLong("id"), (Long)masterId.getDynamicObject("baseunit").getLong("id"), (Long)masterId.getDynamicObject("auxptyunit").getLong("id"));
            entity.getDataEntity().set("qtyunit2nd", (Object)entity.getDataEntity().getBigDecimal("baseqty").multiply(unitRateConvert));
        }
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] entitys = e.getTargetExtDataEntitySet().FindByEntityKey(tgtMainType);
        for (int i = 0; i < entitys.length; ++i) {
            ExtendedDataEntity entity;
            entity = entitys[i];
            DynamicObject obj = entity.getDataEntity();
            DynamicObjectCollection entrycols = obj.getDynamicObjectCollection("billentry");
            DynamicObject result = null;
            if (!entrycols.isEmpty()) {
                result = this.setProp(tgtMainType, obj, entrycols);
            }
            if (result != null) {
                obj.set("supplyowner", result.get("supplyowner"));
                obj.set("settlecurrency", result.get("settlecurrency"));
                obj.set("billentry", result.get("billentry"));
            }
            CloseDateHelper.initBookDate((String)tgtMainType, (DynamicObject)obj, (BillEntityType)this.getSrcMainType());
        }
    }

    private DynamicObject setProp(String tgtMainType, DynamicObject obj, DynamicObjectCollection entrycols) {
        DynamicObject result;
        try {
            result = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"MdcCheckMftorderService", (String)"setProp", (Object[])new Object[]{tgtMainType, obj, entrycols});
        }
        catch (Exception ex) {
            throw new KDException((Throwable)ex, new ErrorCode("MdcCheckMftorderService", ex.getMessage() != null ? ex.getMessage() : ex.toString()), new Object[0]);
        }
        return result;
    }

    static {
        BILL_MAP.put("im_mdc_omproorder", ResManager.loadKDString((String)"\u59d4\u5916\u9886\u6599\u5355", (String)"InvOuterBotpPlugin_4", (String)"mmc-om-opplugin", (Object[])new Object[0]));
        BILL_MAP.put("im_mdc_omreturnorder", ResManager.loadKDString((String)"\u59d4\u5916\u9000\u6599\u5355", (String)"InvOuterBotpPlugin_5", (String)"mmc-om-opplugin", (Object[])new Object[0]));
    }
}

