/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.stockchange.botp;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildDrawFilterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class XComponentBotpPlugin
extends AbstractConvertPlugIn {
    private static final String OM_COMPONENT_LIST = "om_componentlist";
    private static final String PM_OM_PUR_ORDER_BILL = "pm_om_purorderbill";

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        super.afterGetSourceData(e);
        for (DynamicObject object : e.getSourceRows()) {
            if (object == null) continue;
            DynamicObject single = BusinessDataServiceHelper.loadSingle((Object)object.get(0), (String)OM_COMPONENT_LIST);
            Long orderId = single.getLong("orderid");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)PM_OM_PUR_ORDER_BILL);
            if (dynamicObject == null) {
                String format = String.format(ResManager.loadKDString((String)"\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355%s\u6ca1\u6709\u5173\u8054\u7684\u59d4\u5916\u8ba2\u5355\uff0c\u65e0\u6cd5\u4e0b\u63a8\u3002", (String)"XComponentBotpPlugin_6", (String)"mmc-om-opplugin", (Object[])new Object[0]), single.getString("billno"));
                ErrorCode ec = new ErrorCode("botp", format);
                throw new KDBizException(ec, new Object[0]);
            }
            if ("B".equals(dynamicObject.getString("closestatus"))) {
                String format = String.format(ResManager.loadKDString((String)"\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355%s\u5173\u8054\u7684\u59d4\u5916\u8ba2\u5355\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u4e0b\u63a8\u3002", (String)"XComponentBotpPlugin_7", (String)"mmc-om-opplugin", (Object[])new Object[0]), single.getString("billno"));
                ErrorCode ec = new ErrorCode("botp", format);
                throw new KDBizException(ec, new Object[0]);
            }
            if ("C".equals(dynamicObject.getString("billstatus"))) continue;
            String format = String.format(ResManager.loadKDString((String)"\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355%s\u5173\u8054\u7684\u59d4\u5916\u8ba2\u5355\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u4e0b\u63a8\u3002", (String)"XComponentBotpPlugin_8", (String)"mmc-om-opplugin", (Object[])new Object[0]), single.getString("billno"));
            ErrorCode ec = new ErrorCode("botp", format);
            throw new KDBizException(ec, new Object[0]);
        }
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] entities = e.getTargetExtDataEntitySet().FindByEntityKey(tgtMainType);
        if (entities == null || entities.length == 0) {
            return;
        }
        for (ExtendedDataEntity entity : entities) {
            DynamicObject dyn = entity.getDataEntity();
            DynamicObject transactiontype = dyn.getDynamicObject("transactiontypeid");
            if (transactiontype != null) continue;
            Object transDyn = this.setTransactionType(dyn);
            if (null == transDyn) {
                return;
            }
            dyn.set("transactiontypeid", transDyn);
        }
    }

    public void afterBuildDrawFilter(AfterBuildDrawFilterEventArgs e) {
        DynamicObject transactionDyn = e.getTargetDataEntity().getDynamicObject("transactiontypeid");
        if (null != transactionDyn) {
            e.setPlugFilter(new QFilter("transactiontypeid", "=", transactionDyn.getPkValue()));
        }
    }

    private Object setTransactionType(DynamicObject dyn) {
        DynamicObject transDyn = null;
        DynamicObjectCollection stockColls = dyn.getDynamicObjectCollection("stockentry");
        if (CollectionUtils.isEmpty((Collection)stockColls)) {
            return null;
        }
        for (DynamicObject stockObj : stockColls) {
            DynamicObject compentent = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(stockObj.getString("stockid")), (String)OM_COMPONENT_LIST);
            transDyn = compentent.getDynamicObject("transactiontypeid");
            stockObj.set("producttransid", (Object)transDyn);
        }
        return transDyn;
    }
}

