/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.stockchange.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class StockChangeSubmitValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<Integer> unauditList = new ArrayList<Integer>();
        ArrayList<Integer> qtyList = new ArrayList<Integer>();
        ArrayList<Integer> ischangedList = new ArrayList<Integer>();
        for (int i = 0; i < this.dataEntities.length; ++i) {
            Map pmAppParameterMap;
            Boolean isMftStockCtrlBusExe;
            unauditList.clear();
            qtyList.clear();
            ischangedList.clear();
            DynamicObject manuChangeBill = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection entryCol = manuChangeBill.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject stockChangeEntry = (DynamicObject)entryCol.get(j);
                String stockid = stockChangeEntry.getString("stockid");
                if (StringUtils.isEmpty((CharSequence)stockid)) continue;
                String stockEntryid = stockChangeEntry.get("stockentryid") == null ? null : stockChangeEntry.getString("stockentryid");
                BigDecimal newdemandqty = stockChangeEntry.getBigDecimal("demandqty");
                DynamicObject stock = BusinessDataServiceHelper.loadSingle((Object)stockid, (String)"om_componentlist", (String)"id,billno,billstatus,ischanged,stockentry,stockentry.demandqty,stockentry.cansendqty,stockentry.actissueqty,stockentry.rejectedqty,stockentry.feedingqty,orderno,orderentryid,orderentryid.entryseq,orderentryid.bizstatus,orderentryid.planstatus,orderentryid.taskstatus");
                if (!StringUtils.equals((CharSequence)stock.getString("billstatus"), (CharSequence)"C")) {
                    unauditList.add(j + 1);
                }
                DynamicObject[] load = BusinessDataServiceHelper.load((String)"om_componentlist", (String)"", (QFilter[])new QFilter[]{new QFilter("id", "=", manuChangeBill.getPkValue())});
                if (this.changeExistUnAuditChange(stockChangeEntry) && ("0".equals(manuChangeBill.getPkValue().toString()) || load == null || load.length == 0)) {
                    ischangedList.add(j + 1);
                }
                if (!this.checkqty(stock, stockEntryid, newdemandqty).booleanValue()) continue;
                qtyList.add(j + 1);
            }
            if (!unauditList.isEmpty()) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355\u672a\u5ba1\u6838\u3002", (String)"StockChangeSubmitValidator_0", (String)"mmc-om-opplugin", (Object[])new Object[0]), ((Object)unauditList).toString()));
            }
            if ((isMftStockCtrlBusExe = (Boolean)(pmAppParameterMap = MPDMMftGenStocksUtils.getPmAppParameterMap((Long)((Long)manuChangeBill.getDynamicObject("org").getPkValue()), (String)"om_xmftstock")).get("ismftstockctrlbusexe")).booleanValue() && !ischangedList.isEmpty()) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355\u5206\u5f55\u5b58\u5728\u672a\u5ba1\u6838\u7684\u53d8\u66f4\u5355\u3002", (String)"StockChangeSubmitValidator_1", (String)"mmc-om-opplugin", (Object[])new Object[0]), ((Object)ischangedList).toString()));
            }
            if (qtyList.isEmpty()) continue;
            this.addWarningMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u9700\u6c42\u6570\u91cf\u5c0f\u4e8e\u5df2\u9886\u6570\u91cf\u3002", (String)"StockChangeSubmitValidator_2", (String)"mmc-om-opplugin", (Object[])new Object[0]), ((Object)qtyList).toString()));
        }
    }

    private Boolean checkqty(DynamicObject stock, String stockEntryid, BigDecimal newdemandqty) {
        DynamicObjectCollection entryCol = stock.getDynamicObjectCollection("stockentry");
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject stockBillEntry = (DynamicObject)entryCol.get(i);
            if (!StringUtils.equals((CharSequence)stockBillEntry.getPkValue().toString(), (CharSequence)stockEntryid)) continue;
            BigDecimal actissueqty = stockBillEntry.getBigDecimal("actissueqty");
            BigDecimal rejectedqty = stockBillEntry.getBigDecimal("rejectedqty");
            BigDecimal feedingqty = stockBillEntry.getBigDecimal("feedingqty");
            BigDecimal canqty = actissueqty.subtract(rejectedqty).add(feedingqty);
            if (newdemandqty.compareTo(canqty) >= 0) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean changeExistUnAuditChange(DynamicObject stockChangeEntry) {
        Object stockEntryId = stockChangeEntry.get("stockentryid");
        if (StringUtils.isBlank((Object)stockEntryId)) {
            return false;
        }
        QFilter filter = new QFilter("stockentry.stockentryid", "=", stockEntryId);
        filter.and(new QFilter("billstatus", "!=", (Object)"C"));
        filter.and(new QFilter("stockentry.id", "!=", stockChangeEntry.getPkValue()));
        boolean exists = QueryServiceHelper.exists((String)"om_xxcomponentlist", (QFilter[])new QFilter[]{filter});
        return exists;
    }
}

