/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.transfer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.om.common.utils.OMDyObjUtil;
import org.apache.commons.collections.MapUtils;

public class OrderSavaTransferWarehouseOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("treeentryentity.supplier");
        e.getFieldKeys().add("treeentryentity.scheduler");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap<Long, Object> workcenterMaps = new HashMap<Long, Object>(16);
        HashMap<Long, Object> personMaps = new HashMap<Long, Object>(16);
        this.setVersionMap(dataEntities, workcenterMaps, personMaps);
        for (DynamicObject data : dataEntities) {
            DynamicObjectCollection colls = data.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject coll : colls) {
                Object manuVersion = coll.get("manuversion");
                Long manuVersionId = OMDyObjUtil.getDyObjId((Object)manuVersion);
                DynamicObject workCenter = coll.getDynamicObject("workcenter");
                DynamicObject person = coll.getDynamicObject("scheduler");
                if (manuVersion != null && workCenter == null) {
                    coll.set("workcenter", workcenterMaps.get(manuVersionId));
                }
                if (manuVersion == null || person != null) continue;
                coll.set("scheduler", personMaps.get(manuVersionId));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> orderEntryIds = new HashSet<Long>(16);
        HashMap<Long, Long> supplierMaps = new HashMap<Long, Long>(dataEntities.length);
        for (DynamicObject data : dataEntities) {
            DynamicObjectCollection colls = data.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject coll : colls) {
                orderEntryIds.add(coll.getLong("id"));
                if (coll.getDynamicObject("supplier") == null) continue;
                supplierMaps.put(coll.getLong("id"), coll.getDynamicObject("supplier").getLong("id"));
            }
        }
        QFilter stockQf = new QFilter("orderentryid", "in", orderEntryIds);
        DynamicObject[] dynmicObjs = BusinessDataServiceHelper.load((String)"om_mftstock", (String)"org,orderentryid,stockentry.isstockallot,stockentry.supplyorgid,stockentry.warehouseid,stockentry.location", (QFilter[])new QFilter[]{stockQf});
        Long supplierId = 0L;
        for (DynamicObject dynmicObj : dynmicObjs) {
            DynamicObject org = dynmicObj.getDynamicObject("org");
            DynamicObject orderentryid = dynmicObj.getDynamicObject("orderentryid");
            if (null == orderentryid) continue;
            if (supplierMaps.containsKey(orderentryid.getLong("id"))) {
                supplierId = (Long)supplierMaps.get(orderentryid.getLong("id"));
            }
            DynamicObjectCollection colls = dynmicObj.getDynamicObjectCollection("stockentry");
            for (DynamicObject coll : colls) {
                if (!coll.getBoolean("isstockallot")) continue;
                QFilter qf = new QFilter("orgfield", "=", org.getPkValue());
                if (null == coll.getDynamicObject("supplyorgid") || null == coll.getDynamicObject("supplyorgid")) continue;
                qf.and(new QFilter("inorg", "=", coll.getDynamicObject("supplyorgid").getPkValue()));
                qf.and(new QFilter("enable", "=", (Object)"1"));
                if (0L == supplierId) continue;
                qf.and(new QFilter("supplier", "=", (Object)supplierId));
                this.setWareHouse(coll, qf);
            }
        }
        SaveServiceHelper.save((DynamicObject[])dynmicObjs);
    }

    private void setVersionMap(DynamicObject[] dataEntities, Map<Long, Object> workcenterMaps, Map<Long, Object> personMaps) {
        DynamicObject[] manuVersions;
        HashSet<Long> manuVersionIds = new HashSet<Long>(16);
        for (DynamicObject data : dataEntities) {
            DynamicObjectCollection colls = data.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject coll : colls) {
                Object manuVersion = coll.get("manuversion");
                Long manuVersionId = OMDyObjUtil.getDyObjId((Object)manuVersion);
                if (!OMDyObjUtil.isNotEmptyId((Long)manuVersionId)) continue;
                manuVersionIds.add(manuVersionId);
            }
        }
        QFilter filter = new QFilter("id", "in", manuVersionIds);
        for (DynamicObject manuVersion : manuVersions = BusinessDataServiceHelper.load((String)"pdm_manuversion", (String)"id,workcenter,person", (QFilter[])new QFilter[]{filter})) {
            workcenterMaps.put(manuVersion.getLong("id"), manuVersion.getDynamicObject("workcenter"));
            personMaps.put(manuVersion.getLong("id"), manuVersion.getDynamicObject("person"));
        }
    }

    private void setWareHouse(DynamicObject coll, QFilter qf) {
        Map datas = BusinessDataServiceHelper.loadFromCache((String)"om_warehouseset", (QFilter[])new QFilter[]{qf});
        if (MapUtils.isEmpty((Map)datas)) {
            return;
        }
        for (DynamicObject obj : datas.values()) {
            coll.set("warehouseid", (Object)obj.getDynamicObject("inwarehouse"));
            coll.set("location", (Object)obj.getDynamicObject("inlocation"));
        }
    }
}

