/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.transfer;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OrderTransferWarehouseOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("stockentry.isstockallot");
        e.getFieldKeys().add("stockentry.supplyorgid");
        e.getFieldKeys().add("stockentry.warehouseid");
        e.getFieldKeys().add("stockentry.location");
        e.getFieldKeys().add("orderentryid.supplier");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject data : dataEntities = e.getDataEntities()) {
            DynamicObject org = data.getDynamicObject("org");
            DynamicObject orderentry = data.getDynamicObject("orderentryid");
            if (null == orderentry) continue;
            DynamicObject supplier = orderentry.getDynamicObject("supplier");
            DynamicObjectCollection colls = data.getDynamicObjectCollection("stockentry");
            for (DynamicObject coll : colls) {
                Object wareHouse = coll.get("warehouseid");
                Long wareHouseId = 0L;
                if (wareHouse instanceof DynamicObject) {
                    wareHouseId = ((DynamicObject)wareHouse).getLong("id");
                }
                if (wareHouse instanceof Long) {
                    wareHouseId = (Long)wareHouse;
                }
                if (null != wareHouseId && !"0".equals(wareHouseId.toString()) || !coll.getBoolean("isstockallot")) continue;
                QFilter qf = new QFilter("orgfield", "=", org.getPkValue());
                if (null == coll.getDynamicObject("supplyorgid")) continue;
                qf.and(new QFilter("inorg", "=", coll.getDynamicObject("supplyorgid").getPkValue()));
                qf.and(new QFilter("enable", "=", (Object)"1"));
                if (null == supplier) continue;
                qf.and(new QFilter("supplier", "=", supplier.getPkValue()));
                this.setWareHouse(coll, qf);
            }
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
    }

    private void setWareHouse(DynamicObject coll, QFilter qf) {
        Map datas = BusinessDataServiceHelper.loadFromCache((String)"om_warehouseset", (QFilter[])new QFilter[]{qf});
        for (DynamicObject obj : datas.values()) {
            coll.set("warehouseid", (Object)obj.getDynamicObject("inwarehouse"));
            coll.set("location", (Object)obj.getDynamicObject("inlocation"));
        }
    }
}

