/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.transfer.validator;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OmOrderWareHouseValidator
extends AbstractValidator {
    private static final String IN_ORG = "inorg";
    private static final String SUPPLIER = "supplier";

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<String> keys = new ArrayList<String>(dataEntities.length);
        String key = "";
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            Row row;
            long id;
            DynamicObject wareHouseBill = extendedDataEntity.getDataEntity();
            long pkObj = (Long)wareHouseBill.getPkValue();
            QFilter qf = new QFilter("enable", "=", (Object)"1");
            DynamicObject inorg = wareHouseBill.getDynamicObject(IN_ORG);
            qf.and(new QFilter(IN_ORG, "=", inorg.getPkValue()));
            DynamicObject supplier = wareHouseBill.getDynamicObject(SUPPLIER);
            qf.and(new QFilter(SUPPLIER, "=", supplier.getPkValue()));
            key = inorg.getPkValue() + "," + supplier.getPkValue();
            if (keys.contains(key)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e00\u4e2a\"\u751f\u4ea7\u7ec4\u7ec7\"\u4e0b\u540c\u4e00\u4e2a\"\u8c03\u5165\u7ec4\u7ec7\"\u3001\"\u4f9b\u5e94\u5546\"\u53ea\u5141\u8bb8\u5b58\u5728\u4e00\u4e2a\"\u4ed3\u5e93\"\u3002", (String)"OmOrderWareHouseValidator_0", (String)"mmc-om-opplugin", (Object[])new Object[0]));
                continue;
            }
            keys.add(key);
            DataSet result = QueryServiceHelper.queryDataSet((String)"queryWareHouseSet", (String)"om_warehouseset", (String)"id", (QFilter[])new QFilter[]{qf}, null);
            if (!result.hasNext() || (id = ((Long)(row = result.next()).get("id")).longValue()) == pkObj) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e00\u4e2a\"\u751f\u4ea7\u7ec4\u7ec7\"\u4e0b\u540c\u4e00\u4e2a\"\u8c03\u5165\u7ec4\u7ec7\"\u3001\"\u4f9b\u5e94\u5546\"\u53ea\u5141\u8bb8\u5b58\u5728\u4e00\u4e2a\"\u4ed3\u5e93\"\u3002", (String)"OmOrderWareHouseValidator_0", (String)"mmc-om-opplugin", (Object[])new Object[0]));
        }
    }
}

