/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.xommftorder;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.mftorder.MftorderChangeLogUtils;
import kd.bd.mpdm.business.mftorder.OrderBookDateService;
import kd.bd.mpdm.common.mftorder.enums.ManuBillPlanStatusEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillProductTypeEnum;
import kd.bd.mpdm.common.stockchange.utils.ChangeConfigUtils;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.mmc.om.common.order.OrderChangedHelper;
import kd.mmc.om.common.order.consts.OmManuBillConsts;
import kd.mmc.om.common.utils.OperationResultUtil;
import kd.mmc.om.common.utils.RowLinkUtils;
import kd.mmc.om.opplugin.xommftorder.XOmMftOrderSubmitOnAddVaOp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XOmMftOrderAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(XOmMftOrderAuditOp.class);
    private static String[] igNoreFields = new String[]{"purpushqty", "applybillno", "applyentryseq", "orderbillno", "orderentryseq", "purauditqty"};
    Set<Long> billEntityIds = new HashSet<Long>();
    long manuBillId;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("reason");
        e.getFieldKeys().add("billdate");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("treeentryentity.seq");
        Set fieldNames = ChangeConfigUtils.getAllEntryFields((String)"om_xmftorder", (String)"treeentryentity");
        for (String fieldName : fieldNames) {
            e.getFieldKeys().add(fieldName);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new XOmMftOrderSubmitOnAddVaOp());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        List selectedRows = e.getSelectedRows();
        DynamicObject xBillNew1 = null;
        DynamicObject xBillEntryRow1 = null;
        HashSet<String> orderEntryids = new HashSet<String>(20);
        HashSet<String> orderids = new HashSet<String>(20);
        String operationKey = e.getOperationKey();
        Map bookdates = OrderBookDateService.queryXbillEntryAndSrcBookDate((List)selectedRows, (String)"om_mftorder");
        for (ExtendedDataEntity xBill : selectedRows) {
            DynamicObject xBillNew = BusinessDataServiceHelper.loadSingle((Object)xBill.getBillPkId(), (String)"om_xmftorder");
            if (null == xBillNew1 && null != xBillNew) {
                xBillNew1 = xBillNew;
            }
            if (null == xBillNew) continue;
            DynamicObjectCollection xBillEntry = xBillNew.getDynamicObjectCollection("treeentryentity");
            for (int j = 0; j < xBillEntry.size(); ++j) {
                Long newPID;
                String srcid;
                DynamicObject xBillEntryRow = (DynamicObject)xBillEntry.get(j);
                if (null == xBillEntryRow) continue;
                if (null == xBillEntryRow1) {
                    xBillEntryRow1 = xBillEntryRow;
                }
                if (StringUtils.isEmpty((CharSequence)(srcid = xBillEntryRow.getString("srcbillid")))) {
                    return;
                }
                orderids.add(srcid);
                orderEntryids.add(xBillEntryRow.getString("srcbillentryid"));
                DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(srcid), (String)"om_mftorder");
                int srcBillEntrySeq = xBillEntryRow.getInt("srcbillentryseq");
                DynamicObject srcBillEntry = (DynamicObject)srcBill.getDynamicObjectCollection("treeentryentity").get(srcBillEntrySeq - 1);
                Long pid = (Long)xBillEntryRow.get("pid");
                if (pid.compareTo(0L) > 0 && (newPID = this.getNewPID(xBillEntry, pid)).compareTo(0L) > 0) {
                    srcBillEntry.set("pid", (Object)newPID);
                }
                xBillEntryRow.set("srcbillentryid", srcBillEntry.getPkValue());
                xBillEntryRow.set("seq", (Object)srcBillEntrySeq);
                DynamicObjectCollection linkRows = xBillEntryRow.getDynamicObjectCollection("treeentryentity_lk");
                if (!linkRows.isEmpty()) continue;
                String productType = xBillEntryRow.getString("producttype");
                String changetype = xBillEntryRow.getString("changetype");
                if (!"C".equals(productType) && "A".equals(changetype)) {
                    long srcEntryPid = srcBillEntry.getLong("pid");
                    DynamicObjectCollection srcEntrys = srcBill.getDynamicObjectCollection("treeentryentity");
                    for (DynamicObject srcEntry : srcEntrys) {
                        long srcEntryIdTemp = srcEntry.getLong("id");
                        if (srcEntryPid != srcEntryIdTemp) continue;
                        Date beginbookdate = srcEntry.getDate("beginbookdate");
                        srcBillEntry.set("beginbookdate", (Object)(beginbookdate != null ? DateUtils.getShortDate((Date)beginbookdate) : null));
                        Date closebookdate = srcEntry.getDate("closebookdate");
                        srcBillEntry.set("closebookdate", (Object)(closebookdate != null ? DateUtils.getShortDate((Date)closebookdate) : null));
                        break;
                    }
                }
                SaveServiceHelper.update((DynamicObject)srcBill);
                this.autoAuditStock(xBill, srcBill, srcBillEntry, j + 1);
                this.autoAuditTechnis(xBill, srcBill, srcBillEntry, j + 1);
            }
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{xBillNew});
            MftorderChangeLogUtils.updateChangeLog((DynamicObject)xBillNew, (Map)bookdates, (String)"om_xmftorderlog", (String)"om_mftorder");
            if (null == xBillNew1 || null == xBillEntryRow1) continue;
            this.fixRowLink(xBillNew1, xBillEntryRow1);
        }
        this.autoAculUseAndCloseOrder(operationKey, orderEntryids, orderids);
    }

    private void autoAculUseAndCloseOrder(String operationKey, Set<String> orderEntryids, Set<String> orderids) {
        HashMap<String, Object> calparam = new HashMap<String, Object>();
        calparam.put("orderentryids", orderEntryids);
        calparam.put("orderids", orderids);
        calparam.put("operate", operationKey);
        calparam.put("iscloseorder", "1");
        calparam.put("isautocal", "0");
        calparam.put("isautoflag", "0");
        calparam.put("modetype", "2");
        String jsonString = JSON.toJSONString(calparam);
        EventServiceHelper.triggerEventSubscribe((String)"auditCalMaterial", (String)jsonString);
    }

    private void autoAuditTechnis(ExtendedDataEntity dataEntity, DynamicObject srcBill, DynamicObject srcBillEntry, int rowIndex) {
        boolean isaudit;
        DynamicObject transtype = (DynamicObject)srcBill.get("transactiontype");
        if (transtype != null && (isaudit = transtype.getBoolean("isaudittechnis"))) {
            long entryId = (Long)srcBillEntry.getPkValue();
            QFilter technisqfilter = new QFilter("mftentryseq", "=", (Object)entryId);
            String manftechName = "om_mfttechnics";
            HashSet<Object> poIds = new HashSet<Object>();
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrderChangedHelper.updateManftechBill", (String)manftechName, (String)"id", (QFilter[])new QFilter[]{technisqfilter}, (String)"");){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    Object poid = row.get("id");
                    poIds.add(poid);
                }
            }
            if (poIds.isEmpty()) {
                return;
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ishasright", "true");
            operateOption.setVariableValue("ignorewarn", "true");
            operateOption.setVariableValue("ignoreinteraction", "true");
            operateOption.setVariableValue("orderBillType", "om_mftorder");
            operateOption.setVariableValue("orderBillName", ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355", (String)"XOmMftOrderAuditOp_5", (String)"mmc-om-opplugin", (Object[])new Object[0]));
            operateOption.setVariableValue("stockBillType", "om_mftstock");
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)manftechName, (Object[])poIds.toArray(), (OperateOption)operateOption);
            if (!submitResult.isSuccess()) {
                StringBuffer sb = new StringBuffer();
                ValidateResultCollection validateResult = submitResult.getValidateResult();
                if (null != validateResult) {
                    List validateErrors = validateResult.getValidateErrors();
                    for (ValidateResult validate : validateErrors) {
                        List list = validate.getAllErrorInfo();
                        for (OperateErrorInfo operateErrorInfo : list) {
                            sb.append(operateErrorInfo.getMessage());
                        }
                    }
                }
                String mgs = String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\u5206\u5f55\u5bf9\u5e94\u7684\u5de5\u5e8f\u8ba1\u5212\u81ea\u52a8\u63d0\u4ea4\u5931\u8d25\u3002%2$s", (String)"XOmMftOrderAuditOp_8", (String)"mmc-om-opplugin", (Object[])new Object[0]), rowIndex, sb);
                this.addErrMessage(dataEntity, "mfttechnicsSubmit", mgs, rowIndex);
            } else {
                OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)manftechName, (Object[])poIds.toArray(), (OperateOption)operateOption);
                if (!auditResult.isSuccess()) {
                    String mgs = String.format(ResManager.loadKDString((String)"\u7b2c[%d]\u884c\u5206\u5f55\u5bf9\u5e94\u7684\u5de5\u5e8f\u8ba1\u5212\u81ea\u52a8\u5ba1\u6838\u5931\u8d25\u3002", (String)"XOmMftOrderAuditOp_9", (String)"mmc-om-opplugin", (Object[])new Object[0]), rowIndex);
                    this.addErrMessage(dataEntity, "mfttechnicsAudit", mgs, rowIndex);
                }
            }
        }
    }

    private void fixRowLink(DynamicObject xBillNew, DynamicObject xBillEntryRow) {
        String targetEntityNumber = "om_xmftorder";
        String targetEntryKey = "treeentryentity";
        Object targetBillId = xBillNew.getPkValue();
        String srcRowSeqFld = "srcbillentryseq";
        String srcBillNo = xBillEntryRow.getString("srcbillno");
        String srcBillTypeFld = "om_mftorder";
        String srcEntryFld = "treeentryentity";
        RowLinkUtils.fixRowLink((String)targetEntityNumber, (String)targetEntryKey, (String)srcBillTypeFld, (String)srcEntryFld, (String)srcRowSeqFld, (Object)targetBillId, (String)srcBillNo);
    }

    private Long getNewPID(DynamicObjectCollection xBillEntry, Long xPID) {
        for (DynamicObject xBillEntryRow : xBillEntry) {
            Long pkValue;
            String srcEntryID = (String)xBillEntryRow.get("srcbillentryid");
            if (srcEntryID.isEmpty() || !(pkValue = (Long)xBillEntryRow.getPkValue()).equals(xPID)) continue;
            return Long.valueOf(srcEntryID);
        }
        return 0L;
    }

    private void autoAuditStock(ExtendedDataEntity dataEntity, DynamicObject srcBill, DynamicObject srcBillEntry, int rowIndex) {
        QFilter qFilter;
        DynamicObject stock;
        boolean isaudit;
        DynamicObject transtype = (DynamicObject)srcBill.get("transactiontype");
        if (transtype != null && (isaudit = transtype.getBoolean("isauditstock")) && (stock = BusinessDataServiceHelper.loadSingle((String)"om_mftstock", (String)"id", (QFilter[])new QFilter[]{qFilter = new QFilter("orderentryid", "=", srcBillEntry.getPkValue())})) != null) {
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"om_mftstock", (DynamicObject[])new DynamicObject[]{stock = BusinessDataServiceHelper.loadSingle((Object)stock.get("id"), (String)"om_mftstock")}, null);
            if (!submitResult.isSuccess()) {
                this.addErrMessage(dataEntity, "stockSubmit", String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u5206\u5f55\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355\u81ea\u52a8\u63d0\u4ea4\u5931\u8d25\u3002", (String)"XOmMftOrderAuditOp_0", (String)"mmc-om-opplugin", (Object[])new Object[0]), rowIndex), rowIndex);
            } else {
                OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"om_mftstock", (DynamicObject[])new DynamicObject[]{stock}, null);
                if (!auditResult.isSuccess()) {
                    this.addErrMessage(dataEntity, "stockAudit", String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u5206\u5f55\u7684\u7ec4\u4ef6\u6e05\u5355\u81ea\u52a8\u5ba1\u6838\u5931\u8d25\u3002", (String)"XOmMftOrderAuditOp_1", (String)"mmc-om-opplugin", (Object[])new Object[0]), rowIndex), rowIndex);
                }
            }
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        List validExtDataEntities = e.getValidExtDataEntities();
        if ("audit".equals(operationKey)) {
            DynamicObject[] xBills = e.getDataEntities();
            for (int i = 0; i < xBills.length; ++i) {
                DynamicObject xBill = xBills[i];
                DynamicObjectCollection xBillEntry = xBill.getDynamicObjectCollection("treeentryentity");
                for (int j = 0; j < xBillEntry.size(); ++j) {
                    DynamicObject xBillEntryRow = (DynamicObject)xBillEntry.get(j);
                    this.changeManuBillAfterAudit((ExtendedDataEntity)validExtDataEntities.get(i), e, xBillEntryRow, xBill);
                }
            }
        }
    }

    private void changeManuBillAfterAudit(ExtendedDataEntity extendedDataEntity, BeforeOperationArgs e, DynamicObject xBillEntryRow, DynamicObject xBill) {
        String changeType = xBillEntryRow.getString("changetype");
        if (StringUtils.equals((CharSequence)"A", (CharSequence)changeType)) {
            this.changeBillForNew(e, xBillEntryRow, xBill);
        } else if (StringUtils.equals((CharSequence)"B", (CharSequence)changeType)) {
            this.changeBillForChange(e, extendedDataEntity, xBillEntryRow, xBill);
        }
    }

    private void changeBillForChange(BeforeOperationArgs e, ExtendedDataEntity extendedDataEntity, DynamicObject xBillEntryRow, DynamicObject xBill) {
        String srcBillEntryPK;
        String srcBillPK = xBillEntryRow.getString("srcbillid");
        if (StringUtils.isEmpty((CharSequence)srcBillPK)) {
            return;
        }
        this.manuBillId = xBillEntryRow.getLong("srcbillid");
        String string = srcBillEntryPK = xBillEntryRow.get("srcbillentryid") == null ? null : xBillEntryRow.getString("srcbillentryid");
        if (StringUtils.isEmpty((CharSequence)srcBillEntryPK)) {
            return;
        }
        DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(srcBillPK), (String)"om_mftorder");
        DynamicObjectCollection srcEntry = srcBill.getDynamicObjectCollection("treeentryentity");
        srcBill.set("modifier", xBill.get("creator"));
        srcBill.set("modifytime", xBill.get("createtime"));
        for (int i = 0; i < srcEntry.size(); ++i) {
            DynamicObject srcBillEntryRow = (DynamicObject)srcEntry.get(i);
            if (!StringUtils.equals((CharSequence)srcBillEntryRow.getPkValue().toString(), (CharSequence)srcBillEntryPK)) continue;
            this.updateStockEntry(srcBillEntryRow, xBillEntryRow, xBill);
            String producttype = (String)srcBillEntryRow.get("producttype");
            if (ManuBillProductTypeEnum.MAIN.getValue().equals(producttype)) {
                this.updateCoproduct(srcBillEntryRow, srcEntry);
            }
            this.updateTaskstatus(xBillEntryRow, xBill, srcBillEntryRow);
            this.billEntityIds.add((Long)srcBillEntryRow.getPkValue());
        }
        SaveServiceHelper.update((DynamicObject)srcBill);
        try {
            logger.info((Object)"\u5f00\u59cb\u8c03\u7528mpdm\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\u670d\u52a1 ");
            DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMPDMMftGenStocksUtils", (String)"genStocksNew", (Object[])new Object[]{srcBill, "save", "om_mftstock"});
            logger.info((Object)"\u8c03\u7528mpdm\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\u670d\u52a1 ");
        }
        catch (Exception ex) {
            logger.info((Object)("\u8c03\u7528\u670d\u52a1\u51fa\u73b0\u5f02\u5e38" + ex.getMessage()), (Throwable)ex);
        }
        OrderChangedHelper.updateManftechBill((Object[])new Object[]{srcBillPK});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTaskstatus(DynamicObject xBillEntryRow, DynamicObject xBill, DynamicObject srcBillEntryRow) {
        int precision = 0;
        int deal = 4;
        DynamicObject materialUnitid = xBillEntryRow.getDynamicObject("unit");
        if (null != materialUnitid && materialUnitid.get("precision") != null) {
            Object srcBillEntryPkValue;
            String precisionaccount;
            precision = materialUnitid.getInt("precision");
            switch (precisionaccount = materialUnitid.getString("precisionaccount")) {
                case "2": {
                    deal = 1;
                    break;
                }
                case "3": {
                    deal = 0;
                    break;
                }
                default: {
                    deal = 4;
                }
            }
            Object quainwaQty = xBillEntryRow.get("quainwaqty");
            Object unQuainwaQty = xBillEntryRow.get("unquainwaqty");
            Object waitcheckQty = xBillEntryRow.get("waitcheckqty");
            Object scrinwaqtyQty = xBillEntryRow.get("scrinwaqty");
            Object inwarminQty = xBillEntryRow.get("inwarmin");
            BigDecimal quainwaQtyDecimal = ((BigDecimal)quainwaQty).setScale(precision, deal);
            BigDecimal unQuainwaQtyDecimal = ((BigDecimal)unQuainwaQty).setScale(precision, deal);
            BigDecimal waitcheckQtyBigDecimal = ((BigDecimal)waitcheckQty).setScale(precision, deal);
            BigDecimal scrinwaqtyQtyBigDecimal = ((BigDecimal)scrinwaqtyQty).setScale(precision, deal);
            BigDecimal inwarminQtyDecimal = ((BigDecimal)inwarminQty).setScale(precision, deal);
            int compareResult = inwarminQtyDecimal.compareTo(quainwaQtyDecimal.add(unQuainwaQtyDecimal).add(waitcheckQtyBigDecimal).add(scrinwaqtyQtyBigDecimal));
            if (compareResult <= 0 && null != (srcBillEntryPkValue = srcBillEntryRow.getPkValue())) {
                DataSet prblentryDataSet = null;
                DataSet topDataSet = null;
                DataSet dataSet = null;
                try {
                    QFilter prblentryFilter = new QFilter("billentry.manuentryid", "=", srcBillEntryPkValue);
                    prblentryFilter.and(new QFilter("billstatus", "=", (Object)"C"));
                    String prblentryFieldsStr = "auditdate";
                    prblentryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_mdc_omcmplinbill", (String)prblentryFieldsStr, (QFilter[])prblentryFilter.toArray(), (String)"auditdate desc");
                    if (prblentryDataSet.hasNext()) {
                        topDataSet = prblentryDataSet.top(1);
                        dataSet = topDataSet.copy();
                        Date date = new Date();
                        while (dataSet.hasNext()) {
                            Row row = dataSet.next();
                            date = row.getDate("auditdate");
                        }
                        srcBillEntryRow.set("endworktime", (Object)date);
                        srcBillEntryRow.set("taskstatus", (Object)"C");
                    }
                }
                catch (Exception e) {
                    logger.info((Object)(srcBillEntryPkValue + ":set endworktime error"));
                }
                finally {
                    if (null != prblentryDataSet) {
                        prblentryDataSet.close();
                    }
                    if (null != topDataSet) {
                        topDataSet.close();
                    }
                    if (null != dataSet) {
                        dataSet.close();
                    }
                }
            }
        }
    }

    private void updateStockEntry(DynamicObject srcBillEntryRow, DynamicObject xBillEntryRow, DynamicObject xBill) {
        String[] xFields = OmManuBillConsts.getEntryFields((String)"b");
        for (int i = 0; i < xFields.length; ++i) {
            srcBillEntryRow.set(xFields[i], xBillEntryRow.get(xFields[i]));
        }
    }

    private void dealIgnoreCloneFiledFromxBillEntry(DynamicObject xBillEntryRow) {
        String[] igNoreFields = XOmMftOrderAuditOp.igNoreFields;
        for (int i = 0; i < igNoreFields.length; ++i) {
            Object igNoreField = xBillEntryRow.get(igNoreFields[i]);
            if (igNoreField instanceof String) {
                igNoreField = "";
            }
            if (igNoreField instanceof BigDecimal) {
                igNoreField = 0;
            }
            if (igNoreField instanceof Integer) {
                igNoreField = 0;
            }
            xBillEntryRow.set(igNoreFields[i], igNoreField);
        }
    }

    private void changeBillForNew(BeforeOperationArgs e, DynamicObject xBillEntry, DynamicObject xBill) {
        String srcBillID = xBillEntry.getString("srcbillid");
        if (StringUtils.isEmpty((CharSequence)srcBillID)) {
            return;
        }
        DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(srcBillID), (String)"om_mftorder");
        DynamicObjectCollection srcBillEntry = srcBill.getDynamicObjectCollection("treeentryentity");
        if (srcBillEntry.isEmpty()) {
            return;
        }
        DynamicObject xBillEntryRow = (DynamicObject)OrmUtils.clone((IDataEntityBase)((IDataEntityBase)srcBillEntry.get(0)), (boolean)false, (boolean)true);
        this.dealIgnoreCloneFiledFromxBillEntry(xBillEntryRow);
        DynamicObject newSrcBillEntryRow = this.generateEntry(xBillEntryRow, xBillEntry, srcBillEntry.size() + 1, xBill);
        String producttype = newSrcBillEntryRow.getString("producttype");
        if (ManuBillProductTypeEnum.MAIN.getValue().equals(producttype)) {
            newSrcBillEntryRow.set("planstatus", (Object)ManuBillPlanStatusEnum.PLANSURE.getValue());
            newSrcBillEntryRow.set("plansuretime", (Object)new Date());
            newSrcBillEntryRow.set("beginbookdate", null);
            newSrcBillEntryRow.set("closebookdate", null);
        }
        newSrcBillEntryRow.set("planqty", xBillEntry.get("qty"));
        newSrcBillEntryRow.set("lot", xBillEntry.get("lot"));
        newSrcBillEntryRow.set("qualityorg", xBillEntry.get("qualityorg"));
        newSrcBillEntryRow.set("planbaseqty", xBillEntry.get("baseqty"));
        Date planpreparetime = xBillEntry.getDate("planpreparetime");
        if (null != planpreparetime) {
            newSrcBillEntryRow.set("planpreparetime", (Object)planpreparetime);
        }
        Date planbegintime = xBillEntry.getDate("planbegintime");
        if (null != planpreparetime) {
            newSrcBillEntryRow.set("planbegintime", (Object)planbegintime);
        }
        newSrcBillEntryRow.set("manftechstatus", (Object)"F");
        srcBillEntry.add((Object)newSrcBillEntryRow);
        try {
            OperateOption op = OperateOption.create();
            op.setVariableValue("isInvokeByXorderAudit", "true");
            OperationResult saveOperate = SaveServiceHelper.saveOperate((String)"om_mftorder", (DynamicObject[])new DynamicObject[]{srcBill}, (OperateOption)op);
            if (!saveOperate.isSuccess()) {
                String errorMsg = OperationResultUtil.getErrorMsg((OperationResult)saveOperate);
                e.setCancel(true);
                throw new KDBizException(errorMsg);
            }
        }
        catch (Exception e1) {
            e.setCancel(true);
            logger.info((Object)"\u8c03\u7528\u59d4\u5916\u5de5\u5355\u4fdd\u5b58\u65b9\u6cd5\u5931\u8d25:", (Throwable)e1);
            String info = e1.getMessage();
            if (StringUtils.isNotBlank((CharSequence)info)) {
                String mgs = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u59d4\u5916\u5de5\u5355\u4fdd\u5b58\u65b9\u6cd5\u5931\u8d25\uff1a%s", (String)"XOmMftOrderAuditOp_10", (String)"mmc-om-opplugin", (Object[])new Object[0]), info);
                throw new KDBizException(mgs);
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u59d4\u5916\u5de5\u5355\u4fdd\u5b58\u65b9\u6cd5\u5931\u8d25\uff1a%1$s", (String)"XOmMftOrderAuditOp_11", (String)"mmc-om-opplugin", (Object[])new Object[0]), null == e1.getCause() ? ResManager.loadKDString((String)"\u8bf7\u67e5\u770b\u65e5\u5fd7\u4fe1\u606f\u3002", (String)"XOmMftOrderAuditOp_12", (String)"mmc-om-opplugin", (Object[])new Object[0]) : e1.getCause().getMessage()));
        }
        DynamicObject stockChangeBillNew = BusinessDataServiceHelper.loadSingle((Object)xBill.getPkValue(), (String)"om_xmftorder");
        int seq = (Integer)xBillEntry.get("seq");
        if (seq >= 1) {
            DynamicObject stockChangeBillEntry = (DynamicObject)stockChangeBillNew.getDynamicObjectCollection("treeentryentity").get(seq - 1);
            stockChangeBillEntry.set("srcbillentryseq", (Object)srcBillEntry.size());
            SaveServiceHelper.update((DynamicObject)stockChangeBillNew);
        }
    }

    private DynamicObject generateEntry(DynamicObject newEntry, DynamicObject xBillEntry, int seq, DynamicObject xBill) {
        Set fieldNames = ChangeConfigUtils.getAllEntryFields((String)"om_mftorder", (String)"treeentryentity");
        for (String fieldName : fieldNames) {
            newEntry.set(fieldName, xBillEntry.get(fieldName));
        }
        newEntry.set("seq", (Object)seq);
        return newEntry;
    }

    private void updateCoproduct(DynamicObject srcEntryRow, DynamicObjectCollection srcEntry) {
        for (DynamicObject dyRow : srcEntry) {
            Object pid;
            Object fid;
            String producttype = dyRow.getString("producttype");
            if (ManuBillProductTypeEnum.MAIN.getValue().equals(producttype) || !(fid = srcEntryRow.getPkValue()).equals(pid = dyRow.get("pid"))) continue;
            BigDecimal mainqty = (BigDecimal)srcEntryRow.get("qty");
            DynamicObject bom = (DynamicObject)srcEntryRow.get("bomid");
            if (bom != null) {
                DynamicObject copmaterial = (DynamicObject)dyRow.get("material");
                QFilter qFilter = new QFilter("id", "=", (Object)bom.getLong("id"));
                qFilter.and(new QFilter("copentry.copentrymaterial", "=", copmaterial.getPkValue()));
                DynamicObjectCollection coproduct = QueryServiceHelper.query((String)"pdm_mftbom", (String)"copentry.copentryqty", (QFilter[])new QFilter[]{qFilter});
                if (coproduct != null && !coproduct.isEmpty()) {
                    dyRow.set("qty", (Object)((DynamicObject)coproduct.get(0)).getBigDecimal("copentry.copentryqty").multiply(mainqty));
                }
            }
            Object begintime = srcEntryRow.get("planbegintime");
            dyRow.set("planbegintime", begintime);
            Object endtime = srcEntryRow.get("planendtime");
            dyRow.set("planendtime", endtime);
        }
    }

    private void addErrMessage(ExtendedDataEntity dataEntity, String errorCode, String errMsg, int rowIndex) {
        Object pkId = dataEntity.getDataEntity().getPkValue();
        int dataIndex = dataEntity.getDataEntityIndex();
        ErrorLevel errorLevel = ErrorLevel.Error;
        String title = ResManager.loadKDString((String)"\u81ea\u52a8\u5ba1\u6838\u7ec4\u4ef6\u6e05\u5355\u3001\u5de5\u5e8f\u8ba1\u5212", (String)"XOmMftOrderAuditOp_4", (String)"mmc-om-opplugin", (Object[])new Object[0]);
        ValidationErrorInfo errInfo = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, errorCode, title, errMsg, errorLevel);
        this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
    }
}

