/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.xommftorder;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.mftorder.OrderBookDateService;
import kd.bd.mpdm.business.mftorder.OrderCommonService;
import kd.bd.mpdm.common.mftorder.enums.ManuBillPlanStatusEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillProductTypeEnum;
import kd.bd.mpdm.common.stockchange.utils.ChangeConfigUtils;
import kd.bd.mpdm.opplugin.manufacturemodel.validator.OrderSaveOnAddVal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.om.common.utils.XOmMftOrderChangeLogUtils;
import kd.mmc.om.opplugin.xommftorder.XOmMftOrderSaveAndSubmitOnAddVaOp;
import kd.mmc.om.opplugin.xommftorder.XOmMftOrderSubmitOnAddVaOp;

public class XOmMftOrderSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("stockentry");
        filds.add("reason");
        filds.add("billdate");
        filds.add("creator");
        filds.add("createtime");
        filds.add("treeentryentity.pid");
        filds.add("treeentryentity.seq");
        Set fieldNames = ChangeConfigUtils.getAllEntryFields((String)"om_xmftorder", (String)"treeentryentity");
        for (String fieldName : fieldNames) {
            e.getFieldKeys().add(fieldName);
        }
        e.getFieldKeys().add("isinitbill");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new XOmMftOrderSaveAndSubmitOnAddVaOp());
        e.addValidator((AbstractValidator)new XOmMftOrderSubmitOnAddVaOp());
        e.addValidator((AbstractValidator)new OrderSaveOnAddVal());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operateKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit")) {
            DynamicObject[] xMftOrderChangeBills = e.getDataEntities();
            ArrayList<Long> xMtfOrderIds = new ArrayList<Long>(xMftOrderChangeBills.length);
            ArrayList<DynamicObject> xMftOrderChangeLogList = new ArrayList<DynamicObject>();
            HashMap addSeqMap = new HashMap();
            Map productOrgAndBookDateMap = null;
            Map maxInvOrgAndBookDateMap = null;
            boolean bookDateEqualsBizDate = OrderBookDateService.bookDateEqualsBizDate();
            HashSet<Long> mftorderEntryIds = new HashSet<Long>(10);
            for (int i = 0; i < xMftOrderChangeBills.length; ++i) {
                DynamicObject mtforderChangeBill = xMftOrderChangeBills[i];
                if (null == mtforderChangeBill) continue;
                DynamicObjectCollection entryCol = mtforderChangeBill.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject entry : entryCol) {
                    if (null == entry) continue;
                    long mftorderEntryId = entry.getLong("srcbillentryid");
                    mftorderEntryIds.add(mftorderEntryId);
                }
            }
            DynamicObject[] manuBills = OrderCommonService.queryManuBills(mftorderEntryIds, (String)"om_mftorder");
            if (!bookDateEqualsBizDate) {
                Map bookdates = OrderBookDateService.makeupOrgDates(mftorderEntryIds, (DynamicObject[])manuBills);
                productOrgAndBookDateMap = (Map)bookdates.get("productOrgAndBookDateMap");
                maxInvOrgAndBookDateMap = (Map)bookdates.get("maxInvOrgAndBookDateMap");
            }
            for (int i = 0; i < xMftOrderChangeBills.length; ++i) {
                DynamicObject mtforderChangeBill = xMftOrderChangeBills[i];
                Long xMtfOrderId = (Long)mtforderChangeBill.getPkValue();
                xMtfOrderIds.add(xMtfOrderId);
                DynamicObjectCollection entryCol = mtforderChangeBill.getDynamicObjectCollection("treeentryentity");
                for (int j = 0; j < entryCol.size(); ++j) {
                    DynamicObject mtfOrderChangeEntry = (DynamicObject)entryCol.get(j);
                    Date bookDate = null;
                    DynamicObject matchEntry = OrderCommonService.matchEntryInfo((DynamicObject)mtfOrderChangeEntry, (DynamicObjectCollection)entryCol);
                    if (bookDateEqualsBizDate) {
                        if (OrderBookDateService.isXbillFillBeginBookDate((DynamicObject)matchEntry, (DynamicObject[])manuBills)) {
                            bookDate = mtforderChangeBill.getDate("billdate");
                        }
                    } else if (OrderBookDateService.isXbillFillBeginBookDate((DynamicObject)matchEntry, (DynamicObject[])manuBills)) {
                        Date xbillDate = mtforderChangeBill.getDate("billdate");
                        bookDate = OrderBookDateService.queryBookDateWithCompare((DynamicObject)mtforderChangeBill, (DynamicObject)matchEntry, (Map)productOrgAndBookDateMap, (Map)maxInvOrgAndBookDateMap, (Date)xbillDate, null, (boolean)false, null, (boolean)false);
                    }
                    xMftOrderChangeLogList.add(XOmMftOrderChangeLogUtils.makeUpXMftorderChangeLog((String)"A", (DynamicObject)mtforderChangeBill, (DynamicObject)mtfOrderChangeEntry, addSeqMap, (Date)bookDate));
                }
            }
            this.deleteXMftOrderChangeLogByXMtfOrderIds(xMtfOrderIds);
            this.saveXMftOrderChangeLog(xMftOrderChangeLogList);
        }
    }

    private void deleteXMftOrderChangeLogByXMtfOrderIds(List<Long> xMtfOrderIds) {
        QFilter mftOrderLogFilter = new QFilter("xbillid", "in", xMtfOrderIds);
        DeleteServiceHelper.delete((String)"om_xmftorderlog", (QFilter[])mftOrderLogFilter.toArray());
    }

    private void saveXMftOrderChangeLog(List<DynamicObject> xMftOrderChangeLogList) {
        int size = xMftOrderChangeLogList.size();
        if (size > 0) {
            DynamicObject[] param = new DynamicObject[size];
            for (int i = 0; i < param.length; ++i) {
                param[i] = xMftOrderChangeLogList.get(i);
            }
            SaveServiceHelper.save((DynamicObject[])param);
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities2;
        for (DynamicObject dynamicObject : dataEntities2 = e.getDataEntities()) {
            DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entryrow : entry) {
                DynamicObject masterid = entryrow.getDynamicObject("materielmasterid");
                if (masterid != null) continue;
                DynamicObject mftmaterial = entryrow.getDynamicObject("material");
                DynamicObject bdmaterial = mftmaterial.getDynamicObject("masterid");
                entryrow.set("materielmasterid", (Object)bdmaterial);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        List selectedRows = e.getSelectedRows();
        for (ExtendedDataEntity xBill : selectedRows) {
            DynamicObject xBillNew = xBill.getDataEntity();
            DynamicObjectCollection xBillEntry = xBillNew.getDynamicObjectCollection("treeentryentity");
            for (int j = 0; j < xBillEntry.size(); ++j) {
                DynamicObject xBillEntryRow = (DynamicObject)xBillEntry.get(j);
                String changetype = (String)xBillEntryRow.get("changetype");
                String producttype = (String)xBillEntryRow.get("producttype");
                if (!"A".equals(changetype)) continue;
                if (ManuBillProductTypeEnum.MAIN.getValue().equals(producttype)) {
                    xBillEntryRow.set("planstatus", (Object)ManuBillPlanStatusEnum.PLANSURE.getValue());
                    xBillEntryRow.set("plansuretime", (Object)new Date());
                    continue;
                }
                long pid = xBillEntryRow.getLong("pid");
                for (int i = 0; i < xBillEntry.size(); ++i) {
                    DynamicObject entryRow = (DynamicObject)xBillEntry.get(i);
                    long entryId = entryRow.getLong("id");
                    if (pid != entryId) continue;
                    xBillEntryRow.set("planstatus", entryRow.get("planstatus"));
                    xBillEntryRow.set("plansuretime", (Object)new Date());
                }
            }
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{xBillNew});
        }
    }
}

