/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.opplugin.xommftorder;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.business.mftorder.OrderBookDateService;
import kd.bd.mpdm.business.mftorder.OrderCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.om.common.utils.XOmMftOrderChangeLogUtils;
import kd.mmc.om.opplugin.xommftorder.validator.XOmMtfOrderSaveValidator;

public class XOmMtfOrderSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new XOmMtfOrderSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operateKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save")) {
            ArrayList<Long> xMtfOrderIds = new ArrayList<Long>(10);
            DynamicObject[] xMftOrderChangeBills = e.getDataEntities();
            ArrayList<DynamicObject> xMftOrderChangeLogList = new ArrayList<DynamicObject>(xMftOrderChangeBills.length);
            HashMap addSeqMap = new HashMap();
            Map productOrgAndBookDateMap = null;
            Map maxInvOrgAndBookDateMap = null;
            boolean bookDateEqualsBizDate = false;
            HashSet<Long> mftorderEntryIds = new HashSet<Long>(10);
            boolean hasUnExecutedData = false;
            for (int i = 0; i < xMftOrderChangeBills.length; ++i) {
                DynamicObject mtforderChangeBill = xMftOrderChangeBills[i];
                if (this.checkDataExecued(mtforderChangeBill)) continue;
                hasUnExecutedData = true;
                this.updateMtfOrderChangeEntryIdAndSeq(mtforderChangeBill);
                if (null == mtforderChangeBill) continue;
                DynamicObjectCollection entryCol = mtforderChangeBill.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject entry : entryCol) {
                    if (null == entry) continue;
                    long mftorderEntryId = entry.getLong("srcbillentryid");
                    mftorderEntryIds.add(mftorderEntryId);
                }
            }
            if (hasUnExecutedData) {
                bookDateEqualsBizDate = OrderBookDateService.bookDateEqualsBizDate();
            }
            DynamicObject[] manuBills = null;
            if (!mftorderEntryIds.isEmpty()) {
                manuBills = OrderCommonService.queryManuBills(mftorderEntryIds, (String)"om_mftorder");
                if (!bookDateEqualsBizDate) {
                    Map bookdates = OrderBookDateService.makeupOrgDates(mftorderEntryIds, (DynamicObject[])manuBills);
                    productOrgAndBookDateMap = (Map)bookdates.get("productOrgAndBookDateMap");
                    maxInvOrgAndBookDateMap = (Map)bookdates.get("maxInvOrgAndBookDateMap");
                }
            }
            for (int i = 0; i < xMftOrderChangeBills.length; ++i) {
                DynamicObject mtforderChangeBill = xMftOrderChangeBills[i];
                Long xMtfOrderId = (Long)mtforderChangeBill.getPkValue();
                if (this.checkDataExecued(mtforderChangeBill)) continue;
                xMtfOrderIds.add(xMtfOrderId);
                DynamicObjectCollection entryCol = mtforderChangeBill.getDynamicObjectCollection("treeentryentity");
                for (int j = 0; j < entryCol.size(); ++j) {
                    DynamicObject mtfOrderChangeEntry = (DynamicObject)entryCol.get(j);
                    Long xMtfOrderEntryId = mtfOrderChangeEntry.getLong("id");
                    Date bookDate = null;
                    DynamicObject matchEntry = OrderCommonService.matchEntryInfo((DynamicObject)mtfOrderChangeEntry, (DynamicObjectCollection)entryCol);
                    if (bookDateEqualsBizDate) {
                        if (OrderBookDateService.isXbillFillBeginBookDate((DynamicObject)matchEntry, (DynamicObject[])manuBills)) {
                            bookDate = mtforderChangeBill.getDate("billdate");
                        }
                    } else if (OrderBookDateService.isXbillFillBeginBookDate((DynamicObject)matchEntry, (DynamicObject[])manuBills)) {
                        Date xbillDate = mtforderChangeBill.getDate("billdate");
                        bookDate = OrderBookDateService.queryBookDateWithCompare((DynamicObject)mtforderChangeBill, (DynamicObject)matchEntry, (Map)productOrgAndBookDateMap, (Map)maxInvOrgAndBookDateMap, (Date)xbillDate, null, (boolean)false, null, (boolean)false);
                    }
                    xMftOrderChangeLogList.add(XOmMftOrderChangeLogUtils.makeUpXMftorderChangeLog((String)"A", (DynamicObject)mtforderChangeBill, (DynamicObject)mtfOrderChangeEntry, addSeqMap, (Date)bookDate));
                }
            }
            if (!xMtfOrderIds.isEmpty()) {
                this.deleteXMftOrderChangeLogByXMtfOrderIds(xMtfOrderIds);
            }
            this.saveXMftOrderChangeLog(xMftOrderChangeLogList);
        }
    }

    private boolean checkDataExecued(DynamicObject mtforderChangeBill) {
        return mtforderChangeBill.getString("billstatus").equals("C");
    }

    private void updateMtfOrderChangeEntryIdAndSeq(DynamicObject mtforderChangeBill) {
        DynamicObjectCollection entryCols = mtforderChangeBill.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject entryCol : entryCols) {
            String changeType = entryCol.getString("changetype");
            if (!StringUtils.equals((CharSequence)"B", (CharSequence)changeType)) continue;
            this.changeBillForChange(mtforderChangeBill, entryCol);
        }
    }

    private void changeBillForChange(DynamicObject mtforderChangeBill, DynamicObject xMftOrderEntry) {
        block2: {
            String srcbillentryid;
            String srcbillentryseq;
            block3: {
                srcbillentryseq = xMftOrderEntry.getString("srcbillentryseq");
                srcbillentryid = xMftOrderEntry.getString("srcbillentryid");
                if (!StringUtils.isBlank((CharSequence)srcbillentryseq) || !StringUtils.isNotBlank((CharSequence)srcbillentryid)) break block3;
                String srcbillno = xMftOrderEntry.getString("srcbillno");
                QFilter filter = new QFilter("billno", "=", (Object)srcbillno);
                filter.and(new QFilter("treeentryentity.id", "=", (Object)Long.valueOf(srcbillentryid)));
                DynamicObject srcbill = BusinessDataServiceHelper.loadSingle((String)"om_mftorder", (String)"treeentryentity.seq,treeentryentity.id", (QFilter[])new QFilter[]{filter});
                DynamicObjectCollection srcBillEntrys = (DynamicObjectCollection)srcbill.get("treeentryentity");
                for (DynamicObject entry : srcBillEntrys) {
                    String entryid = entry.getString("id");
                    if (!StringUtils.equals((CharSequence)srcbillentryid, (CharSequence)entryid)) continue;
                    xMftOrderEntry.set("srcbillentryseq", (Object)entry.getString("seq"));
                    break block2;
                }
                break block2;
            }
            if (!StringUtils.isBlank((CharSequence)srcbillentryid) || !StringUtils.isNotBlank((CharSequence)srcbillentryseq)) break block2;
            String srcbillno = xMftOrderEntry.getString("srcbillno");
            QFilter filter = new QFilter("billno", "=", (Object)srcbillno);
            filter.and(new QFilter("treeentryentity.seq", "=", (Object)Long.valueOf(srcbillentryseq)));
            DynamicObject srcbill = BusinessDataServiceHelper.loadSingle((String)"om_mftorder", (String)"treeentryentity.seq,treeentryentity.id", (QFilter[])new QFilter[]{filter});
            DynamicObjectCollection srcBillEntrys = (DynamicObjectCollection)srcbill.get("treeentryentity");
            for (DynamicObject entry : srcBillEntrys) {
                String entrySeq = entry.getString("seq");
                if (!StringUtils.equals((CharSequence)srcbillentryseq, (CharSequence)entrySeq)) continue;
                xMftOrderEntry.set("srcbillentryid", (Object)entry.getString("id"));
                break;
            }
        }
    }

    private void deleteXMftOrderChangeLogByXMtfOrderIds(List<Long> xMtfOrderIds) {
        QFilter mftOrderLogFilter = new QFilter("xbillid", "in", xMtfOrderIds);
        mftOrderLogFilter.and(new QFilter("changestatus", "=", (Object)"A"));
        DeleteServiceHelper.delete((String)"om_xmftorderlog", (QFilter[])mftOrderLogFilter.toArray());
    }

    private void saveXMftOrderChangeLog(List<DynamicObject> xMftOrderChangeLogList) {
        int size = xMftOrderChangeLogList.size();
        if (size > 0) {
            DynamicObject[] param = new DynamicObject[size];
            for (int i = 0; i < param.length; ++i) {
                param[i] = xMftOrderChangeLogList.get(i);
            }
            SaveServiceHelper.save((DynamicObject[])param);
        }
    }
}

