/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.om.business.pojo.ReturnResultInfo;

public class BotpHelper {
    private static final Log log = LogFactory.getLog(BotpHelper.class);

    public static ReturnResultInfo botpGenerateTargetBill(Map<Long, Long> sourceIdMap, String sourceEntity, String sourceEntryEntity, String targetEntity, String targetEntryEntity, String status, Map<String, String> param) {
        ReturnResultInfo returnResultInfo = new ReturnResultInfo();
        if (sourceIdMap != null && sourceIdMap.size() > 0) {
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber(sourceEntity);
            pushArgs.setTargetEntityNumber(targetEntity);
            pushArgs.setBuildConvReport(true);
            if (param != null) {
                for (Map.Entry<String, String> entry : param.entrySet()) {
                    pushArgs.addCustomParam(entry.getKey(), entry.getValue());
                }
            }
            String ruleId = null;
            List loadRules = ConvertMetaServiceHelper.loadRules((String)sourceEntity, (String)targetEntity);
            if (loadRules != null && loadRules.size() > 0) {
                for (int i = 0; i < loadRules.size(); ++i) {
                    ConvertRuleElement loadRule = (ConvertRuleElement)loadRules.get(i);
                    boolean bl = loadRule.isEnabled();
                    if (!bl) continue;
                    if (loadRule.isDefRule()) {
                        ruleId = loadRule.getId();
                        break;
                    }
                    if (!StringUtils.isBlank(ruleId)) continue;
                    ruleId = loadRule.getId();
                }
            }
            pushArgs.setRuleId(ruleId);
            ArrayList<ListSelectedRow> sourceEntryRows = new ArrayList<ListSelectedRow>(sourceIdMap.size());
            for (Map.Entry entry : sourceIdMap.entrySet()) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue(entry.getValue());
                row.setEntryPrimaryKeyValue(entry.getKey());
                row.setEntryEntityKey(targetEntryEntity);
                sourceEntryRows.add(row);
            }
            pushArgs.setSelectedRows(sourceEntryRows);
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)targetEntity);
            IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType dataType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dataType);
                }
            };
            List targetBills = null;
            if (!result.isSuccess()) {
                log.info("\u6e90\u5355\u5355\u636e(" + sourceEntity + ")\u4e0b\u63a8\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u5931\u8d25\uff1a" + result.getMessage());
                returnResultInfo.setSuccess(false);
                returnResultInfo.setMessage(result.getMessage());
                return returnResultInfo;
            }
            targetBills = result.loadTargetDataObjects(refDataProvider, mainEntityType);
            log.info("\u6e90\u5355\u5355\u636e(" + sourceEntity + ")\u4e0b\u63a8\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u6210\u529f");
            if (targetBills != null && targetBills.size() > 0) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("isStrict", String.valueOf(Boolean.FALSE));
                option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
                option.setVariableValue("WF", String.valueOf(false));
                OperationResult saveResult = SaveServiceHelper.saveOperate((String)targetEntity, (DynamicObject[])targetBills.toArray(new DynamicObject[0]), (OperateOption)option);
                if (saveResult.isSuccess() && saveResult.getSuccessPkIds().size() > 0) {
                    List saveSuccessPkIds = saveResult.getSuccessPkIds();
                    if (!"submit".equals(status) && !"audit".equals(status)) {
                        log.info("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u4fdd\u5b58\u6210\u529f\uff1a" + saveSuccessPkIds);
                        returnResultInfo.setSuccess(true);
                        returnResultInfo.setSuccessList(saveSuccessPkIds);
                        return returnResultInfo;
                    }
                } else {
                    String errMsg = BotpHelper.buildErrorInfoMessage(saveResult);
                    log.error("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u4fdd\u5b58\u5f02\u5e38\uff1a" + errMsg);
                    returnResultInfo.setSuccess(false);
                    returnResultInfo.setMessage(errMsg);
                    return returnResultInfo;
                }
            }
        }
        returnResultInfo.setSuccess(false);
        return returnResultInfo;
    }

    private static String buildErrorInfoMessage(OperationResult opResult) {
        List allErrorInfos = opResult.getAllErrorInfo();
        StringBuilder sb = new StringBuilder(200);
        sb.append(opResult.getMessage()).append(":\n");
        if (allErrorInfos != null) {
            for (OperateErrorInfo errorInfo : allErrorInfos) {
                String message = errorInfo.getMessage();
                sb.append(message);
            }
        }
        List allErrorOrValidateInfo = opResult.getAllErrorOrValidateInfo();
        for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
            String message = iOperateInfo.getMessage();
            sb.append(message);
        }
        return sb.toString();
    }
}

