/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.business.old;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.enums.QtyTypeEnum;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.om.common.old.MftOldGenStocksUtils;
import org.apache.commons.collections4.CollectionUtils;

public class PurOrderClose {
    private static final String OM_PURORDER = "pm_om_purorderbill";
    private static final String OM_COMPONENTLIST = "om_componentlist";
    private static final String MPDM_TRANSACTOUT = "mpdm_transactout";
    private List<Map<String, Long>> mapList;
    private DynamicObject[] orders;
    private Map<Long, DynamicObject> orderEntryId_stockObjMap = new HashMap<Long, DynamicObject>(16);
    private Set<Long> orderEntryIds;
    private List<DynamicObject> saveStocks = new ArrayList<DynamicObject>(16);
    private List<DynamicObject> saveOrders = new ArrayList<DynamicObject>(16);

    public PurOrderClose(List<Map<String, Long>> mapList) {
        this.mapList = mapList;
        this.initOrders();
        this.initStockMap();
    }

    private void initOrders() {
        HashSet<Long> orderIds = new HashSet<Long>(16);
        this.orderEntryIds = new HashSet<Long>(16);
        for (Map<String, Long> map : this.mapList) {
            Long orderEntryId = map.get("orderentryid");
            this.orderEntryIds.add(orderEntryId);
            Long orderId = map.get("orderid");
            orderIds.add(orderId);
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)OM_PURORDER);
        this.orders = BusinessDataServiceHelper.load((Object[])orderIds.toArray(), (DynamicObjectType)type);
    }

    private void initStockMap() {
        DynamicObject[] stocks;
        HashSet<Long> orderEntryIds = new HashSet<Long>(16);
        for (DynamicObject order : this.orders) {
            DynamicObjectCollection billEntry = order.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billEntry) {
                orderEntryIds.add(entry.getLong("id"));
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("orderentryid");
        sb.append(",transactiontypeid");
        sb.append(",transactiontypeid.deduction");
        sb.append(",baseqty");
        sb.append(",stockentry");
        sb.append(",stockentry.actissueqty");
        sb.append(",stockentry.oprno");
        sb.append(",stockentry.useqty");
        sb.append(",stockentry.feedingqty");
        sb.append(",stockentry.processseq");
        sb.append(",stockentry.rejectedqty");
        sb.append(",stockentry.scrapqty");
        sb.append(",stockentry.demandqty");
        sb.append(",stockentry.standqty");
        sb.append(",stockentry.fixscrap");
        sb.append(",stockentry.qtytype");
        sb.append(",stockentry.isbackflush");
        sb.append(",stockentry.iskeypart");
        sb.append(",stockentry.issuemode");
        sb.append(",stockentry.iscannegative");
        sb.append(",stockentry.wipqty");
        QFilter[] qFilters = new QFilter[]{new QFilter("orderentryid", "in", orderEntryIds)};
        for (DynamicObject stock : stocks = BusinessDataServiceHelper.load((String)OM_COMPONENTLIST, (String)sb.toString(), (QFilter[])qFilters, (String)"orderentryid")) {
            this.orderEntryId_stockObjMap.put(stock.getLong("orderentryid.id"), stock);
        }
    }

    public void doClose() {
        for (DynamicObject order : this.orders) {
            DynamicObjectCollection billEntry = order.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billEntry) {
                boolean existsReturnorder;
                boolean existsFeedorder;
                boolean existsProorder;
                boolean existsManuinbill;
                boolean existsStock;
                long orderEntryId = entry.getLong("id");
                DynamicObject stock = this.orderEntryId_stockObjMap.get(orderEntryId);
                if (stock == null) continue;
                Map map = this.calMaterialQty(stock, order, entry);
                entry.set("pickingpairs", map.get("qty"));
                entry.set("pickstatus", map.get("reqstatus"));
                if (!this.orderEntryIds.contains(orderEntryId)) continue;
                String pickstatus = entry.getString("pickstatus");
                if ("A".equals(pickstatus) || "B".equals(pickstatus) || (existsStock = this.findUnProStock(orderEntryId, this.getControlScope(order))) || (existsManuinbill = PurOrderClose.findUnAuditBillByEntityId(orderEntryId, "im_mdc_ominbill")) || (existsProorder = PurOrderClose.findUnAuditBillByEntityId(orderEntryId, "im_mdc_omproorder")) || (existsFeedorder = PurOrderClose.findUnAuditBillByEntityId(orderEntryId, "im_mdc_omreturnorder")) || (existsReturnorder = PurOrderClose.findUnAuditBillByEntityId(orderEntryId, "im_mdc_omfeedorder")) || entry.getBigDecimal("invbaseqty").compareTo(entry.getBigDecimal("receivebaseqtydown")) < 0) break;
                entry.set("rowclosestatus", (Object)"B");
                this.reCulStockWipqty(orderEntryId);
            }
            this.closeOrderBill(order);
            this.saveOrders.add(order);
        }
        if (!this.saveStocks.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])this.saveStocks.toArray(new DynamicObject[0]));
        }
        if (!this.saveOrders.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])this.saveOrders.toArray(new DynamicObject[0]));
            IDataEntityType dataEntityType = ((DynamicObject)this.saveOrders.get(0).getDynamicObjectCollection("billentry").get(0)).getDataEntityType();
            DataEntityCacheManager cacheManager = new DataEntityCacheManager(dataEntityType);
            cacheManager.removeByDt();
        }
    }

    private void closeOrderBill(DynamicObject order) {
        DynamicObjectCollection orderEntry = order.getDynamicObjectCollection("billentry");
        boolean flag = false;
        for (int i = 0; i < orderEntry.size(); ++i) {
            if ("B".equals(((DynamicObject)orderEntry.get(i)).getString("rowclosestatus"))) continue;
            flag = true;
            return;
        }
        if (!flag) {
            order.set("closestatus", (Object)"B");
            order.set("closedate", (Object)new Date());
            RequestContext requestContext = RequestContext.get();
            long userID = Long.parseLong(requestContext.getUserId());
            order.set("closer", (Object)userID);
        }
    }

    private void reCulStockWipqty(long orderEntryid) {
        DynamicObjectCollection stockEntryDym;
        DynamicObject stockDym = this.orderEntryId_stockObjMap.get(orderEntryid);
        if (stockDym != null && (stockEntryDym = stockDym.getDynamicObjectCollection("stockentry")) != null) {
            for (int i = 0; i < stockEntryDym.size(); ++i) {
                DynamicObject stockEntry = (DynamicObject)stockEntryDym.get(i);
                BigDecimal useQty = MftOldGenStocksUtils.aculOMUseQty((DynamicObject)stockEntry, (Object)stockDym.getDynamicObject("orderentryid").getPkValue(), (DynamicObject)stockDym.getDynamicObject("transactiontypeid"));
                stockEntry.set("useqty", (Object)useQty);
                BigDecimal wipQty = MftOldGenStocksUtils.aculWIPQty((DynamicObject)stockEntry);
                stockEntry.set("wipqty", (Object)wipQty);
            }
            this.saveStocks.add(stockDym);
        }
    }

    private boolean findUnProStock(Long orderEntryid, String controlscope) {
        block5: {
            DynamicObjectCollection stockEntrys;
            block4: {
                DynamicObject stockDym = this.orderEntryId_stockObjMap.get(orderEntryid);
                if (stockDym == null) {
                    return false;
                }
                stockEntrys = stockDym.getDynamicObjectCollection("stockentry");
                if (stockEntrys == null) {
                    return false;
                }
                if (!"C".equals(controlscope) && !"A".equals(controlscope)) break block4;
                for (DynamicObject stockEntry : stockEntrys) {
                    if (!stockEntry.getBoolean("iscannegative") || stockEntry.getBigDecimal("wipqty").compareTo(BigDecimal.ZERO) <= 0) continue;
                    return true;
                }
                break block5;
            }
            if (!"B".equals(controlscope)) break block5;
            for (DynamicObject stockEntry : stockEntrys) {
                if (!stockEntry.getBoolean("iscannegative") || !stockEntry.getBoolean("iskeypart") || stockEntry.getBigDecimal("wipqty").compareTo(BigDecimal.ZERO) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean findUnAuditBillByEntityId(Object pkValue, String entityid) {
        QFilter filter = new QFilter("billentry.manuentryid", "=", pkValue);
        if ("im_mdc_ominbill".equals(entityid)) {
            filter = new QFilter("billentry.mainbillentryid", "=", pkValue);
        }
        filter.and(new QFilter("billstatus", "!=", (Object)"C"));
        return QueryServiceHelper.exists((String)entityid, (QFilter[])new QFilter[]{filter});
    }

    private Map calMaterialQty(DynamicObject stockInfo, DynamicObject orderInfo, DynamicObject orderEntryInfo) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        BigDecimal pickQty = BigDecimal.ZERO;
        String status = "A";
        String reqstatus = "A";
        boolean pickflag = false;
        String controlScope = this.getControlScope(orderInfo);
        DynamicObjectCollection stockEntryColl = stockInfo.getDynamicObjectCollection("stockentry");
        DynamicObject unit = orderEntryInfo.getDynamicObject("unit");
        BigDecimal qty = orderEntryInfo.getBigDecimal("qty");
        for (int i = 0; i < stockEntryColl.size(); ++i) {
            DynamicObject stockEntry = (DynamicObject)stockEntryColl.get(i);
            BigDecimal actissueqty = stockEntry.getBigDecimal("actissueqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockEntry.getBigDecimal("actissueqty");
            BigDecimal feedingqty = stockEntry.getBigDecimal("feedingqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockEntry.getBigDecimal("feedingqty");
            BigDecimal rejectedqty = stockEntry.getBigDecimal("rejectedqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockEntry.getBigDecimal("rejectedqty");
            BigDecimal scrapqty = stockEntry.getBigDecimal("scrapqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockEntry.getBigDecimal("scrapqty");
            BigDecimal demandqty = stockEntry.getBigDecimal("demandqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockEntry.getBigDecimal("demandqty");
            BigDecimal standqty = stockEntry.getBigDecimal("standqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockEntry.getBigDecimal("standqty");
            BigDecimal fixscrap = stockEntry.getBigDecimal("fixscrap").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : stockEntry.getBigDecimal("fixscrap");
            String qtytype = stockEntry.getString("qtytype");
            String isbackflush = stockEntry.getString("isbackflush");
            boolean iskeypart = stockEntry.getBoolean("iskeypart");
            String issuemode = stockEntry.getString("issuemode");
            if ("C".equals(issuemode) || "A".equals(controlScope) && "B".equals(isbackflush) || !iskeypart && "B".equals(controlScope) || demandqty.compareTo(BigDecimal.ZERO) == 0 || standqty.compareTo(BigDecimal.ZERO) == 0) continue;
            if (QtyTypeEnum.REGULAR.getValue().equals(qtytype)) {
                BigDecimal helpqty = actissueqty.add(feedingqty).subtract(rejectedqty).subtract(scrapqty);
                BigDecimal newpickqty = BigDecimal.ZERO;
                if (helpqty.compareTo(demandqty) >= 0) {
                    newpickqty = qty;
                }
                if (newpickqty.compareTo(pickQty) < 0) {
                    pickQty = newpickqty;
                    pickflag = true;
                    continue;
                }
                if (pickflag || pickQty.compareTo(BigDecimal.ZERO) != 0) continue;
                pickQty = newpickqty;
                pickflag = true;
                continue;
            }
            DynamicObject measureunit = BusinessDataServiceHelper.loadSingleFromCache((Object)unit.getPkValue(), (String)"bd_measureunits");
            int precision = measureunit.getInt("precision");
            String precisionaccount = measureunit.getString("precisionaccount");
            int deal = 4;
            switch (precisionaccount) {
                case "2": {
                    deal = 1;
                    break;
                }
                case "3": {
                    deal = 0;
                    break;
                }
                default: {
                    deal = 4;
                }
            }
            BigDecimal helpqty = actissueqty.add(feedingqty).subtract(rejectedqty).subtract(scrapqty);
            BigDecimal newpickqty = helpqty.multiply(qty).divide(demandqty.subtract(fixscrap), precision, deal);
            if (newpickqty.compareTo(pickQty) < 0) {
                pickQty = newpickqty;
                pickflag = true;
                continue;
            }
            if (pickflag || pickQty.compareTo(BigDecimal.ZERO) != 0) continue;
            pickQty = newpickqty;
            pickflag = true;
        }
        resultMap.put("qty", pickQty);
        boolean isExistsMaterialReq = false;
        Map mftproorderMap = BFTrackerServiceHelper.findTargetBills((String)OM_COMPONENTLIST, (Long[])new Long[]{(Long)stockInfo.getPkValue()});
        if (CollectionUtils.isNotEmpty((Collection)((Collection)mftproorderMap.get("im_mdc_omproorder")))) {
            boolean exists;
            QFilter qFilter = new QFilter("id", "in", mftproorderMap.get("im_mdc_omproorder"));
            QFilter qFilter_1 = new QFilter("billstatus", "=", (Object)"C");
            isExistsMaterialReq = exists = QueryServiceHelper.exists((String)"im_mdc_omproorder", (QFilter[])new QFilter[]{qFilter, qFilter_1});
        }
        if (!isExistsMaterialReq && pickQty.compareTo(BigDecimal.ZERO) == 0) {
            reqstatus = "A";
            status = "B";
        } else if (isExistsMaterialReq && pickQty.compareTo(BigDecimal.ZERO) == 0) {
            reqstatus = "B";
            status = "B";
        } else if (pickQty.compareTo(BigDecimal.ZERO) > 0 && pickQty.compareTo(qty) < 0) {
            reqstatus = "B";
            status = "B";
        } else if (pickQty.compareTo(qty) == 0) {
            reqstatus = "C";
            status = "C";
        } else if (pickQty.compareTo(qty) > 0) {
            reqstatus = "D";
            status = "D";
        }
        resultMap.put("reqstatus", reqstatus);
        resultMap.put("status", status);
        return resultMap;
    }

    private String getControlScope(DynamicObject orderInfo) {
        String id = orderInfo.getString("transactiontype");
        DynamicObject info = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)MPDM_TRANSACTOUT);
        if (info == null) {
            return null;
        }
        String controlscope = info.getString("controlscope");
        return controlscope;
    }
}

