/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.business.order;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bd.mpdm.business.mftorder.OrderCommonService;
import kd.bd.mpdm.common.query.mservice.helper.MsBomQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsProcessRouteQueryHelper;
import kd.bd.mpdm.common.utils.MulBaseDataUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.mmc.om.business.order.OrderDefValueSetter;

public class OmMftOrderDataHelper {
    private static final String TRANSTYPE_KEY = "mpdm_transactproduct";

    public static List<DynamicObject> batchSetDefValue(List<DynamicObject> orders) {
        OrderDefValueSetter setter = new OrderDefValueSetter(orders);
        setter.setDefValue();
        return setter.getOrders();
    }

    public static DynamicObject getTransaction(Long orgId) {
        QFilter orgQf = BaseDataServiceHelper.getBaseDataFilter((String)TRANSTYPE_KEY, (Long)orgId);
        QFilter statusQf = new QFilter("status", "=", (Object)"C");
        QFilter enableQf = new QFilter("enable", "=", (Object)"1");
        QFilter isFaultQf = new QFilter("isfault", "=", (Object)true);
        QFilter typeIdQf = new QFilter("transactiontype", "=", (Object)Long.valueOf("1213802446967548928"));
        QFilter[] planA = new QFilter[]{orgQf, statusQf, enableQf, isFaultQf, typeIdQf};
        DynamicObject transType = BusinessDataServiceHelper.loadSingleFromCache((String)TRANSTYPE_KEY, (QFilter[])planA);
        if (transType != null) {
            return transType;
        }
        QFilter domainQf = new QFilter("transactiontype.domain", "=", (Object)"5");
        QFilter[] planB = new QFilter[]{orgQf, statusQf, enableQf, domainQf};
        transType = BusinessDataServiceHelper.loadSingleFromCache((String)TRANSTYPE_KEY, (QFilter[])planB);
        return transType;
    }

    public static Map<Long, DynamicObject> getTransactionMap(Set<Long> orgIds) {
        Objects.requireNonNull(orgIds);
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(orgIds.size());
        for (Long orgId : orgIds) {
            map.put(orgId, OmMftOrderDataHelper.getTransaction(orgId));
        }
        return map;
    }

    public static DynamicObject getBomDynamicObject(DynamicObject material, Long orgID, DynamicObject entryManuversion, DynamicObject transactionType, Date expendbomtime, Map<String, DynamicObject> mBomCacheMap) {
        if (transactionType == null) {
            ErrorCode ec = new ErrorCode("transactionType is null", ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u3002", (String)"OmMftOrderDataHelper_0", (String)"mmc-om-business", (Object[])new Object[0]));
            throw new KDBizException(ec, new Object[0]);
        }
        String keys = material.getPkValue() + "_" + orgID + "_" + transactionType.getPkValue() + "_" + (entryManuversion == null ? Long.valueOf(0L) : entryManuversion.getPkValue());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        keys = keys + dateFormat.format(expendbomtime);
        if (mBomCacheMap != null && mBomCacheMap.containsKey(keys)) {
            return mBomCacheMap.get(keys);
        }
        String selectProperties = "number,enable,id,ecn,type,version,iscoproduct,copentry,copentry.copentrymaterial,yieldrate";
        String orderByStr = "";
        DynamicObjectCollection bomtypes = transactionType.getDynamicObjectCollection("bomtypes");
        List pkValues = MulBaseDataUtils.getPkValuesByMulData((DynamicObjectCollection)bomtypes);
        HashSet bomTypeIDSet = null;
        if (pkValues != null && !pkValues.isEmpty()) {
            bomTypeIDSet = new HashSet(pkValues);
        }
        DynamicObject bom = MsBomQueryHelper.getBomFromCache((DynamicObject)material, (Long)orgID, (DynamicObject)entryManuversion, bomTypeIDSet, (Date)expendbomtime, (String)selectProperties, (String)orderByStr);
        if (mBomCacheMap == null) {
            mBomCacheMap = new HashMap<String, DynamicObject>(16);
        }
        mBomCacheMap.put(keys, bom);
        return mBomCacheMap.get(keys);
    }

    public static DynamicObject getProcessRoute(DynamicObject mftmaterial, DynamicObject org, Map<String, DynamicObject> materialProcessRoutMap) {
        String mapKeys = "PR_" + mftmaterial.getPkValue() + "_" + org.getPkValue();
        if (materialProcessRoutMap != null && materialProcessRoutMap.containsKey(mapKeys)) {
            return materialProcessRoutMap.get(mapKeys);
        }
        if (materialProcessRoutMap == null) {
            materialProcessRoutMap = new HashMap<String, DynamicObject>(16);
        }
        DynamicObject processRoute = null;
        String selectProperties = "id,routeversion.effectdate";
        Map invokeBizService = MsProcessRouteQueryHelper.queryRouteMapFromCache((DynamicObject)mftmaterial, (DynamicObject)org, (String)selectProperties);
        if (invokeBizService != null) {
            Map processrouteMap = invokeBizService;
            OrderCommonService orderCommonService = new OrderCommonService();
            processRoute = orderCommonService.filterByorderBy(processrouteMap);
        }
        materialProcessRoutMap.put(mapKeys, processRoute);
        return materialProcessRoutMap.get(mapKeys);
    }

    public static List<Long> getInwareOrgFilter(Long mftOrg) {
        ArrayList<Long> filterList = new ArrayList<Long>();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)mftOrg, (String)"bos_org");
        boolean isAccounting = org.getBoolean("fisaccounting");
        if (isAccounting) {
            List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)mftOrg);
            if (!allToOrg.isEmpty()) {
                filterList.addAll(allToOrg);
            }
        } else {
            List fromOrgs = OrgUnitServiceHelper.getFromOrgs((String)"04", (Long)mftOrg, (String)"10");
            if (fromOrgs.isEmpty()) {
                Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)mftOrg, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                Integer fromOrg = map == null || map.isEmpty() ? Integer.valueOf(0) : map.get("id");
                Long longFromOrg = (Long)((Object)fromOrg);
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)longFromOrg);
                if (!allToOrg.isEmpty()) {
                    filterList.addAll(allToOrg);
                }
            } else {
                Long fromOrg = (Long)fromOrgs.get(0);
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)fromOrg);
                if (!allToOrg.isEmpty()) {
                    filterList.addAll(allToOrg);
                }
            }
        }
        return filterList;
    }

    public static BigDecimal calLowQty(BigDecimal baseQty, DynamicObject baseUnit, BigDecimal lowLimit) {
        if (baseQty == null || baseUnit == null || lowLimit == null) {
            return BigDecimal.ZERO;
        }
        int basePrecision = baseUnit.getInt("precision");
        String basePrecisionAccount = baseUnit.getString("precisionaccount");
        int basePresisionDeal = OmMftOrderDataHelper.getPrecisionDeal(basePrecisionAccount);
        BigDecimal extraratioqty = baseQty.multiply(BigDecimal.ONE.subtract(lowLimit.divide(BigDecimal.valueOf(100L), 4, 4)));
        extraratioqty = extraratioqty.setScale(basePrecision, basePresisionDeal);
        return extraratioqty;
    }

    public static BigDecimal calHighQty(BigDecimal baseQty, DynamicObject baseUnit, BigDecimal highLimit) {
        if (baseQty == null || baseUnit == null || highLimit == null) {
            return BigDecimal.ZERO;
        }
        int basePrecision = baseUnit.getInt("precision");
        String basePrecisionAccount = baseUnit.getString("precisionaccount");
        int basePresisionDeal = OmMftOrderDataHelper.getPrecisionDeal(basePrecisionAccount);
        BigDecimal extraratioqty = baseQty.multiply(BigDecimal.ONE.add(highLimit.divide(BigDecimal.valueOf(100L), 4, 4)));
        extraratioqty = extraratioqty.setScale(basePrecision, basePresisionDeal);
        return extraratioqty;
    }

    public static int getPrecisionDeal(String precisionaccount) {
        int deal = 4;
        switch (precisionaccount) {
            case "1": {
                deal = 4;
                break;
            }
            case "2": {
                deal = 1;
                break;
            }
            case "3": {
                deal = 0;
                break;
            }
        }
        return deal;
    }

    public static Date calPlanEndTime(Date beginDate, DynamicObject materialPlanInfo, BigDecimal qty) {
        Calendar calendar = Calendar.getInstance();
        if (Objects.isNull(beginDate)) {
            return null;
        }
        calendar.setTime(beginDate);
        Date endDate = null;
        if (materialPlanInfo == null) {
            endDate = calendar.getTime();
            return endDate;
        }
        String leadtimetype = materialPlanInfo.getString("leadtimetype");
        int fixedleadtime = materialPlanInfo.getInt("fixedleadtime");
        int changeleadtime = materialPlanInfo.getInt("changeleadtime");
        int preprocessingtime = materialPlanInfo.getInt("preprocessingtime");
        int postprocessingtime = materialPlanInfo.getInt("postprocessingtime");
        int changebatch = materialPlanInfo.getInt("changebatch");
        if ("A".equals(leadtimetype)) {
            calendar.add(5, fixedleadtime);
        } else if ("B".equals(leadtimetype)) {
            BigDecimal decChangebatch = new BigDecimal(changebatch);
            BigDecimal decChangeleadtime = new BigDecimal(changeleadtime);
            if (changebatch != 0) {
                BigDecimal result = qty.multiply(decChangeleadtime).divide(decChangebatch, 0, 0);
                calendar.add(5, result.intValue());
            }
        }
        calendar.add(5, preprocessingtime);
        calendar.add(5, postprocessingtime);
        endDate = calendar.getTime();
        return endDate;
    }

    public static DynamicObject getInWar(Long mftOrgId, Long inOrgId) {
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)mftOrgId, (String)"bos_org");
        boolean isAccounting = org.getBoolean("fisaccounting");
        if (isAccounting) {
            return org;
        }
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(inOrgId.longValue());
        param.setFromViewType("10");
        param.setToViewType("05");
        param.setDirectViewType("toorg");
        param.setIncludeSelf(true);
        List allToOrg = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
        if (!CollectionUtils.isEmpty((Collection)allToOrg)) {
            return BusinessDataServiceHelper.loadSingleFromCache(allToOrg.get(0), (String)"bos_org");
        }
        return null;
    }
}

