/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.business.order;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bd.mpdm.common.mftorder.utils.CalendarUtils;
import kd.bd.mpdm.common.query.helper.MaterialPlanQueryHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.mmc.om.business.order.OmMftOrderDataHelper;

public class OrderDefValueSetter {
    private static final Log log = LogFactory.getLog(OrderDefValueSetter.class);
    private List<DynamicObject> orders;
    private Map<String, DynamicObject> mBomCacheMap;
    private Map<String, DynamicObject> materialProcessRoutMap;
    private Map<String, DynamicObject> materialMftInfoMap = new HashMap<String, DynamicObject>(16);
    private Map<Long, List<Long>> org_inwareOrgIdsMap = new HashMap<Long, List<Long>>(16);
    private Date nowDate = new Date();
    private int orderEntrySize = 0;

    public OrderDefValueSetter(List<DynamicObject> orders) {
        Objects.requireNonNull(orders);
        this.orders = orders;
        for (DynamicObject order : this.orders) {
            DynamicObjectCollection entryColl = order.getDynamicObjectCollection("treeentryentity");
            this.orderEntrySize += entryColl.size();
        }
    }

    public void setDefValue() {
        ORM orm = ORM.create();
        int i = 0;
        long[] genLongIds = orm.genLongIds("om_mftorder.treeentryentity", this.orderEntrySize);
        for (DynamicObject order : this.orders) {
            DynamicObject org = order.getDynamicObject("org");
            if (org == null) {
                log.info("\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u7a7a");
                continue;
            }
            Long orgId = org.getLong("id");
            DynamicObject transType = order.getDynamicObject("transactiontype");
            if (transType == null) {
                transType = OmMftOrderDataHelper.getTransaction(orgId);
                order.set("transactiontype", (Object)transType);
            }
            DynamicObjectCollection entryColl = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : entryColl) {
                DynamicObject processRoute;
                DynamicObject routereplace;
                BigDecimal yield;
                DynamicObject inWar;
                Date planDate;
                DynamicObject materialPlanInfo;
                Date endTime;
                Date beginDate;
                DynamicObject producedept;
                DynamicObject location;
                DynamicObject warehouse;
                DynamicObject processRoute2;
                DynamicObject bom;
                DynamicObject manuVersion;
                entry.set("id", (Object)genLongIds[i]);
                ++i;
                DynamicObject materialMftInfo = entry.getDynamicObject("material");
                if (materialMftInfo == null) {
                    log.info("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
                    continue;
                }
                DynamicObject baseUnit = entry.getDynamicObject("baseunit");
                if (baseUnit == null) {
                    log.info("\u57fa\u672c\u5355\u4f4d\u4e3a\u7a7a");
                    continue;
                }
                BigDecimal baseQty = entry.getBigDecimal("baseqty");
                if (baseQty == null || BigDecimal.ZERO.compareTo(baseQty) >= 0) {
                    log.info("\u57fa\u672c\u6570\u91cf\u4e3a\u7a7a");
                    continue;
                }
                DynamicObject materialMftInfoCache = this.materialMftInfoMap.get(materialMftInfo.getString("id"));
                if (materialMftInfoCache == null) {
                    materialMftInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)materialMftInfo.getPkValue(), (String)"bd_materialmftinfo");
                    this.materialMftInfoMap.put(materialMftInfo.getString("id"), materialMftInfo);
                } else {
                    materialMftInfo = materialMftInfoCache;
                }
                DynamicObject materialInfo = materialMftInfo.getDynamicObject("masterid");
                Date expendBomTime = entry.getDate("expendbomtime");
                if (expendBomTime == null) {
                    expendBomTime = new Date();
                    entry.set("expendbomtime", (Object)expendBomTime);
                }
                if ((manuVersion = entry.getDynamicObject("manuversion")) == null) {
                    Object materialMftId = materialMftInfo.getPkValue();
                    QFilter materialMftInfoQf = new QFilter("material.id", "=", materialMftId);
                    QFilter beginQtyQf = new QFilter("beginqty", "<=", (Object)baseQty);
                    QFilter endQtyQf = new QFilter("beginqty", ">=", (Object)baseQty);
                    QFilter beginDateQf = new QFilter("begindate", "<=", (Object)entry.getDate("expendbomtime"));
                    QFilter endDateQf = new QFilter("enddate", ">=", (Object)entry.getDate("expendbomtime"));
                    QFilter[] manuVersionQf = new QFilter[]{materialMftInfoQf, beginQtyQf, endQtyQf, beginDateQf, endDateQf};
                    manuVersion = BusinessDataServiceHelper.loadSingleFromCache((String)"pdm_manuversion", (QFilter[])manuVersionQf);
                    entry.set("manuversion", (Object)manuVersion);
                }
                if ((bom = entry.getDynamicObject("bomid")) == null) {
                    bom = OmMftOrderDataHelper.getBomDynamicObject(materialInfo, orgId, manuVersion, transType, expendBomTime, this.mBomCacheMap);
                    entry.set("bomid", (Object)bom);
                }
                if (manuVersion != null) {
                    processRoute2 = manuVersion.getDynamicObject("processroute");
                    entry.set("processroute", (Object)processRoute2);
                } else {
                    processRoute2 = OmMftOrderDataHelper.getProcessRoute(materialMftInfo, org, this.materialProcessRoutMap);
                    entry.set("processroute", (Object)processRoute2);
                }
                DynamicObject inwardept = entry.getDynamicObject("inwardept");
                if (inwardept == null) {
                    DynamicObject inwarorg = materialMftInfo.getDynamicObject("inwarorg");
                    if (inwarorg != null) {
                        entry.set("inwardept", (Object)inwarorg);
                    } else {
                        List<Long> inwardeptIds = this.org_inwareOrgIdsMap.get(orgId);
                        if (inwardeptIds == null) {
                            inwardeptIds = OmMftOrderDataHelper.getInwareOrgFilter(orgId);
                            this.org_inwareOrgIdsMap.put(orgId, inwardeptIds);
                        }
                        if (inwardeptIds != null && !inwardeptIds.isEmpty()) {
                            entry.set("inwardept", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)inwardeptIds.get(0), (String)"bos_org"));
                        }
                    }
                }
                if ((warehouse = entry.getDynamicObject("warehouse")) == null) {
                    entry.set("warehouse", (Object)materialMftInfo.getDynamicObject("inwarehouse"));
                }
                if ((location = entry.getDynamicObject("location")) == null) {
                    entry.set("location", (Object)materialMftInfo.getDynamicObject("inwarelocation"));
                }
                entry.set("iscontrolqty", materialMftInfo.get("isstoragelimit"));
                entry.set("rcvinhighlimit", materialMftInfo.get("rcvinhighlimit"));
                entry.set("inwarmax", (Object)OmMftOrderDataHelper.calHighQty(baseQty, baseUnit, entry.getBigDecimal("rcvinhighlimit")));
                entry.set("rcvinlowlimit", materialMftInfo.get("rcvinlowlimit"));
                entry.set("inwarmin", (Object)OmMftOrderDataHelper.calLowQty(baseQty, baseUnit, entry.getBigDecimal("rcvinlowlimit")));
                DynamicObject unit = entry.getDynamicObject("unit");
                if (unit == null) {
                    entry.set("unit", materialMftInfo.get("mftunit"));
                    unit = materialMftInfo.getDynamicObject("mftunit");
                }
                StringBuilder errMsg = new StringBuilder();
                if (unit != null) {
                    BigDecimal qty = UnitConvertHelper.calculateNewQty((BigDecimal)baseQty, (Long)unit.getLong("id"), (Long)baseUnit.getLong("id"), (Long)materialMftInfo.getLong("masterid.id"), (StringBuilder)errMsg);
                    entry.set("qty", (Object)qty);
                    entry.set("planqty", (Object)qty);
                }
                if ((producedept = entry.getDynamicObject("producedept")) == null) {
                    entry.set("producedept", materialMftInfo.get("departmentorgid"));
                }
                if ((beginDate = entry.getDate("planbegintime")) == null) {
                    beginDate = CalendarUtils.getRecentleWorkDate((DynamicObject)org, (Date)this.nowDate);
                    entry.set("planbegintime", (Object)beginDate);
                }
                if ((endTime = OmMftOrderDataHelper.calPlanEndTime(beginDate, materialPlanInfo = MaterialPlanQueryHelper.getDataCacheByMaterial((DynamicObject)materialInfo, (DynamicObject)org), baseQty)) != null) {
                    entry.set("planendtime", (Object)CalendarUtils.getRecentleWorkDate((DynamicObject)org, (Date)endTime));
                }
                if ((planDate = entry.getDate("planpreparetime")) == null) {
                    planDate = this.nowDate;
                    entry.set("planpreparetime", (Object)planDate);
                }
                if ((inWar = entry.getDynamicObject("inwarconsigner")) == null) {
                    inWar = OmMftOrderDataHelper.getInWar(orgId, entry.getLong("inwardept.id"));
                    entry.set("inwarconsigner", (Object)inWar);
                }
                if ((yield = entry.getBigDecimal("yieldrate")) == null || BigDecimal.ZERO.compareTo(yield) >= 0) {
                    BigDecimal yieldrate;
                    if (bom == null) {
                        if (materialPlanInfo != null) {
                            yieldrate = (BigDecimal)materialPlanInfo.get("yield");
                            entry.set("yieldrate", (Object)yieldrate);
                        } else {
                            entry.set("yieldrate", (Object)1);
                        }
                    } else {
                        yieldrate = (BigDecimal)bom.get("yieldrate");
                        entry.set("yieldrate", (Object)yieldrate);
                    }
                }
                if ((routereplace = entry.getDynamicObject("routereplace")) != null || (processRoute = entry.getDynamicObject("processroute")) == null) continue;
                DynamicObject route = BusinessDataServiceHelper.loadSingle((Object)processRoute.getPkValue(), (String)"pdm_route");
                entry.set("routereplace", route.get("routereplace"));
            }
        }
    }

    public List<DynamicObject> getOrders() {
        return this.orders;
    }
}

