/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.mmc.business.query.helper.BillTypeQueryHelper;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.mmc.om.common.stock.utils.MetaDataHelper;

public class XComponentEdit
extends AbstractBillPlugIn
implements RowClickEventListener,
ClickListener,
HyperLinkClickListener,
BeforeF7SelectListener {
    private String[] xstockfields = new String[]{"biztime", "reason", "remarks", "billno", "mftdeptorgid"};
    private String[] entryLockfields = new String[]{"materialid", "bomreversion", "qtytype", "stockno", "iscannegative", "entryconfiguredcode"};
    private String[] xentryfields = new String[]{"supplymodefield", "supplierfield", "supplyorgfield", "demanddatefield", "setuplocationfield", "isbulkmaterialfield", "issuemodefield", "outorgunitfield", "outwarehousefield", "warehousefield", "locationfield", "batchnofield", "iskeypartfield", "overissuecontrlfield", "childremarksfield", "issinhighlimitfield", "extraratioqtyfield", "issinlowlimitfield", "lackraitioqtyfield", "considerminbatchfield"};
    private static final String ISSTOCKCHANGEX = "isStockChangeX";
    private static final String FALSE = "false";
    private static final String OLDXSTOCKOBJ = "oldXStockObj";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"stockno"});
        this.addClickListeners(new String[]{"transactiontypeid"});
        BasedataEdit tranEdit = (BasedataEdit)this.getView().getControl("transactiontypeid");
        tranEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit purOrg = (BasedataEdit)this.getView().getControl("purorg");
        purOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"stockentry", (CharSequence)entryGrid.getKey())) {
            this.showEntryDetial(this.getSelectEntryRowIndex());
            DynamicObject entryentity = this.getModel().getEntryRowEntity("stockentry", this.getSelectEntryRowIndex());
            if (entryentity == null) {
                return;
            }
            DynamicObject material = entryentity.getDynamicObject("materialid");
            if (material == null) {
                return;
            }
            Boolean enable = this.isUseAuxpty(material);
            this.getView().setEnable(enable, new String[]{"auxpropertyfield"});
        }
    }

    private Boolean isUseAuxpty(DynamicObject material) {
        Object pkValue = material.getDynamicObject("masterid").getPkValue();
        DynamicObject masterid = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
        if (masterid.getBoolean("isuseauxpty")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void showEntryDetial(int i) {
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        String[] billEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"stockentry");
        String[] billEntry2 = MetaDataHelper.getAllPropertyNameNoEntry((IDataEntityType)dt);
        String[] billEntry4 = this.getDifferentFromString(billEntry2, this.xentryfields);
        if ("B".equals(this.getModel().getValue("entrychangetype", i))) {
            this.getView().setEnable(Boolean.FALSE, i, this.entryLockfields);
            this.getView().setEnable(Boolean.FALSE, billEntry4);
            this.setEntryEnableByStatus(i);
            this.setEntryEnable();
        } else if ("C".equals(this.getModel().getValue("entrychangetype", i))) {
            this.getView().setEnable(Boolean.FALSE, i, billEntry1);
            this.getView().setEnable(Boolean.FALSE, billEntry2);
        }
        this.getView().setEnable(Boolean.TRUE, this.xstockfields);
    }

    public int getSelectEntryRowIndex() {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    public void beforeBindData(EventObject e) {
        this.updatePID();
        ORM orm = ORM.create();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("stockentry");
        long[] genLongIds = orm.genLongIds("om_componentlist.stockentry", dynamicObjectCollection.size());
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            Long rowid = dynamicObject.getLong("id");
            if (rowid != 0L) continue;
            dynamicObject.set("id", (Object)genLongIds[i]);
        }
        Object billType = this.getModel().getValue("billtype");
        if (null == billType) {
            super.beforeBindData(e);
        }
    }

    public static Long getDefalutBillType(String billName) {
        DynamicObject dy = BillTypeQueryHelper.getBillTypesCache((String)billName);
        return dy == null ? 0L : dy.getLong("id");
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().clearNoDataRow();
        this.getModel().forceClearNoDataRow();
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        this.getView().setEnable(Boolean.FALSE, MetaDataHelper.getAllPropertyNameNoEntry((IDataEntityType)dt));
        this.getView().setEnable(Boolean.TRUE, this.xstockfields);
        if (!this.isDrawByBOTP(this.getView().getModel(), "stockentry")) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"org", "transactiontypeid", "purorg", "supplier", "billtype"});
        }
        int billEntryCount = this.getModel().getEntryRowCount("stockentry");
        IFormView view = this.getView();
        for (int i = 0; i < billEntryCount; ++i) {
            if (!"B".equals(this.getModel().getValue("entrychangetype", i))) continue;
            view.setEnable(Boolean.FALSE, i, this.entryLockfields);
            if (i != 0) continue;
            this.getView().setEnable(Boolean.FALSE, new String[]{"billtype"});
        }
        this.setEntryEnable();
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl("stockentry");
        grid.setCollapse(false);
    }

    private boolean isDrawByBOTP(IDataModel model, String entryKey) {
        IDataEntityProperty dataEntityProperty;
        int size;
        DynamicObject bill = model.getDataEntity(true);
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryKey);
        if (entrys == null || (size = entrys.size()) == 0) {
            return false;
        }
        LinkSetElement linkSet = ConvertMetaServiceHelper.loadLinkSet((String)model.getDataEntityType().getName());
        if (linkSet == null || linkSet.getItems() == null || linkSet.getItems().isEmpty()) {
            return false;
        }
        String linkEntityKey = entryKey + "_lk";
        List items = linkSet.getItems();
        for (LinkSetItemElement item : items) {
            if (!entryKey.equals(item.getParentEntityKey())) continue;
            linkEntityKey = item.getLinkEntityKey();
            break;
        }
        if ((dataEntityProperty = model.getDataEntityType().findProperty(linkEntityKey)) == null) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObjectCollection linkColl = entry.getDynamicObjectCollection(linkEntityKey);
            if (linkColl == null || linkColl.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private void updatePID() {
        DynamicObject xBill = this.getModel().getDataEntity();
        DynamicObjectCollection xBillEntry = xBill.getDynamicObjectCollection("stockentry");
        for (DynamicObject xBillEntryRow : xBillEntry) {
            DynamicObject srcBillEntryRow;
            Object newPID;
            String srcEntryID = (String)xBillEntryRow.get("stockentryid");
            if (srcEntryID.isEmpty() || "0".equals(xBillEntryRow.get("parentid").toString())) continue;
            QFilter qFilter = new QFilter("stockentry.id", "=", (Object)Long.valueOf(srcEntryID));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"om_componentlist", (String)"stockentry.pid", (QFilter[])new QFilter[]{qFilter});
            if (query.isEmpty() || (newPID = this.getNewPID(srcBillEntryRow = (DynamicObject)query.get(0))) == null) continue;
            xBillEntryRow.set("pid", newPID);
        }
    }

    private Object getNewPID(DynamicObject srcBillEntryRow) {
        DynamicObject xBill = this.getModel().getDataEntity();
        DynamicObjectCollection xBillEntry = xBill.getDynamicObjectCollection("stockentry");
        for (DynamicObject xBillEntryRow : xBillEntry) {
            Long srcPID;
            Long srcLongEntryID;
            String srcEntryID = (String)xBillEntryRow.get("stockentryid");
            if (srcEntryID.isEmpty() || !(srcLongEntryID = Long.valueOf(Long.parseLong(srcEntryID))).equals(srcPID = (Long)srcBillEntryRow.get("stockentry.pid"))) continue;
            return xBillEntryRow.getPkValue();
        }
        return null;
    }

    private void setEntryEnableByStatus(int i) {
        BigDecimal actissueqty = (BigDecimal)this.getModel().getValue("actissueqty", i);
        BigDecimal rejectedqty = (BigDecimal)this.getModel().getValue("rejectedqty", i);
        BigDecimal feedingqty = (BigDecimal)this.getModel().getValue("feedingqty", i);
        BigDecimal allotqty = (BigDecimal)this.getModel().getValue("allotqty", i);
        Boolean s = actissueqty.compareTo(BigDecimal.ZERO) != 0 || rejectedqty.compareTo(BigDecimal.ZERO) != 0 || feedingqty.compareTo(BigDecimal.ZERO) != 0 || allotqty.compareTo(BigDecimal.ZERO) != 0;
        if (s.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isbulkmaterialfield"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"issuemodefield"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"outorgunitfield"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"outwarehousefield"});
        } else if (!this.isJumpLevel(i)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"isbulkmaterialfield"});
        }
    }

    private String[] getDifferentFromString(String[] s1, String[] s2) {
        HashSet<String> hs1 = new HashSet<String>(Arrays.asList(s1));
        HashSet<String> hs2 = new HashSet<String>(Arrays.asList(s2));
        hs1.removeAll(hs2);
        return hs1.toArray(new String[0]);
    }

    private void setEntryEnable() {
        DynamicObjectCollection stockentry = this.getModel().getEntryEntity("stockentry");
        for (int i = 0; i < stockentry.size(); ++i) {
            DynamicObject stockentrydym = (DynamicObject)stockentry.get(i);
            this.setEntryEnable(stockentrydym, i);
        }
    }

    private void setEntryEnable(DynamicObject stockentrydym, int i) {
        DynamicObject trandym = stockentrydym.getDynamicObject("producttransid");
        if (trandym != null) {
            if (trandym.getBoolean("isconsiderloss")) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"wastagerateformula"});
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"scraprate"});
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"fixscrap"});
            } else {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"fixscrap"});
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"scraprate"});
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"wastagerateformula"});
            }
        }
    }

    private void showBillList(String sourcekey) {
        String entityNumber = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)sourcekey, (CharSequence)"stockno")) {
            entityNumber = "om_componentlist";
        }
        if (!StringUtils.isEmpty((CharSequence)entityNumber)) {
            List<QFilter> filters = this.getStockFilter();
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)false);
            showParameter.getListFilterParameter().setQFilters(filters);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, sourcekey);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private List<QFilter> getStockFilter() {
        DynamicObject supplier;
        QFilter planFilter = new QFilter("orderentryid.rowclosestatus", "=", (Object)"A");
        QFilter auditFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter transcationFilter = new QFilter("transactiontypeid.isstockchange", "=", (Object)"1");
        DynamicObject tran = (DynamicObject)this.getModel().getValue("transactiontypeid");
        QFilter transFilter = tran != null ? new QFilter("transactiontypeid.id", "=", tran.getPkValue()) : new QFilter("transactiontypeid", "=", (Object)0L);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter orgFilter = org != null ? new QFilter("org.id", "=", org.getPkValue()) : new QFilter("org.id", "=", (Object)0L);
        DynamicObject purorg = (DynamicObject)this.getModel().getValue("purorg");
        if (purorg != null) {
            orgFilter.and(new QFilter("purorg.id", "=", purorg.getPkValue()));
        }
        if ((supplier = (DynamicObject)this.getModel().getValue("supplier")) != null) {
            orgFilter.and(new QFilter("supplier.id", "=", supplier.getPkValue()));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(planFilter);
        filters.add(auditFilter);
        filters.add(transcationFilter);
        filters.add(transFilter);
        filters.add(orgFilter);
        return filters;
    }

    public void click(EventObject evt) {
        Control sourceField = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)sourceField.getKey(), (CharSequence)"stockno")) {
            this.showBillList(sourceField.getKey());
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionKey = e.getActionId();
        int currentRowIndex = this.getSelectEntryRowIndex();
        if (e.getReturnData() != null) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
            Object pk = rows.get(0).getPrimaryKeyValue();
            if (StringUtils.equalsIgnoreCase((CharSequence)"stockno", (CharSequence)actionKey)) {
                DynamicObject stock = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"om_componentlist");
                if (stock != null) {
                    this.getPageCache().put(ISSTOCKCHANGEX, "true");
                    this.setStockInfo(stock, currentRowIndex);
                    this.getPageCache().put(ISSTOCKCHANGEX, FALSE);
                } else {
                    this.setStockInfo(null, currentRowIndex);
                }
            }
        }
    }

    private void setStockInfo(DynamicObject stock, int currentRowIndex) {
        if (stock == null) {
            this.getModel().setValue("stockid", null, currentRowIndex);
            this.getModel().setValue("stockno", null, currentRowIndex);
            this.getModel().setValue("productbaseqty", null, currentRowIndex);
            this.getModel().setValue("productbaseunit", null, currentRowIndex);
            this.getModel().setValue("producttransid", null, currentRowIndex);
            this.getModel().setValue("entryorderentryid", null, currentRowIndex);
            this.getModel().setValue("backflushtime", null, currentRowIndex);
            this.getModel().setValue("backflushtimefield", null);
            this.getModel().setValue("qtynumerator", (Object)BigDecimal.ZERO, currentRowIndex);
            this.getModel().setValue("standqty", (Object)BigDecimal.ZERO, currentRowIndex);
            this.getModel().setValue("demandqty", (Object)BigDecimal.ZERO, currentRowIndex);
            this.getModel().setValue("outqty", (Object)BigDecimal.ZERO, currentRowIndex);
        } else {
            DynamicObject transac;
            this.getModel().setValue("stockid", (Object)stock.getPkValue().toString(), currentRowIndex);
            this.getModel().setValue("stockno", stock.get("billno"), currentRowIndex);
            this.getModel().setValue("productbaseqty", stock.get("baseqty"), currentRowIndex);
            this.getModel().setValue("productbaseunit", stock.get("baseunitid"), currentRowIndex);
            this.getModel().setValue("producttransid", stock.get("transactiontypeid"), currentRowIndex);
            this.getModel().setValue("orderentryid", stock.get("orderentryid"), currentRowIndex);
            this.getModel().setValue("entryorderentryid", stock.get("orderentryid"), currentRowIndex);
            this.getModel().setValue("componentno", (Object)stock.getString("orderno"), currentRowIndex);
            this.getModel().setValue("productno", stock.get("productid"), currentRowIndex);
            this.getModel().setValue("demanddatefield", stock.get("demanddatefield"), currentRowIndex);
            this.getModel().setValue("productconfiguredcode", stock.get("configuredcode"), currentRowIndex);
            this.getModel().setValue("entrytracknumber", stock.get("tracknumber"), currentRowIndex);
            String isbackflush = (String)this.getModel().getValue("isbackflush", currentRowIndex);
            if ("B".equals(isbackflush) && (transac = (DynamicObject)stock.get("transactiontypeid")) != null) {
                this.getModel().setValue("backflushtime", transac.get("backflushtime"), currentRowIndex);
                this.getModel().setValue("backflushtimefield", transac.get("backflushtime"));
            }
            this.getModel().setValue("outqty", (Object)BigDecimal.ZERO, currentRowIndex);
            this.getModel().setValue("qtynumerator", (Object)BigDecimal.ZERO, currentRowIndex);
            this.getModel().setValue("standqty", (Object)BigDecimal.ZERO, currentRowIndex);
            this.getModel().setValue("demandqty", (Object)BigDecimal.ZERO, currentRowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        int[] selectRows = entryGrid.getSelectRows();
        FormOperate op = (FormOperate)e.getSource();
        if (StringUtils.equals((CharSequence)"draw", (CharSequence)op.getOperateKey())) {
            Object org = this.getModel().getValue("org");
            Object tran = this.getModel().getValue("transactiontypeid");
            Object supplier = this.getModel().getValue("supplier");
            Object purOrg = this.getModel().getValue("purorg");
            StringBuilder err = new StringBuilder();
            if (org == null) {
                err.append(ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\u4e3a\u7a7a\uff0c", (String)"XComponentEdit_0", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            }
            if (tran == null) {
                err.append(ResManager.loadKDString((String)"\u59d4\u5916\u4e8b\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c", (String)"XComponentEdit_1", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            }
            if (supplier == null) {
                err.append(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u4e3a\u7a7a\uff0c", (String)"XComponentEdit_2", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            }
            if (purOrg == null) {
                err.append(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u4e3a\u7a7a\uff0c", (String)"XComponentEdit_3", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            }
            if (err.length() > 0) {
                err.append(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u9009\u5355\u3002", (String)"XComponentEdit_4", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                this.getView().showTipNotification(err.toString());
                e.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)"newentry", (CharSequence)op.getOperateKey())) {
            Object org = this.getModel().getValue("org");
            Object tran = this.getModel().getValue("transactiontypeid");
            Object purorg = this.getModel().getValue("purorg");
            Object supplier = this.getModel().getValue("supplier");
            StringBuilder err = new StringBuilder();
            if (org == null) {
                err.append(ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\u4e3a\u7a7a\uff0c", (String)"XComponentEdit_0", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            }
            if (tran == null) {
                err.append(ResManager.loadKDString((String)"\u59d4\u5916\u4e8b\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c", (String)"XComponentEdit_1", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            }
            if (supplier == null) {
                err.append(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u4e3a\u7a7a\uff0c", (String)"XComponentEdit_2", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            }
            if (purorg == null) {
                err.append(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u4e3a\u7a7a\uff0c", (String)"XComponentEdit_3", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            }
            if (err.length() > 0) {
                err.append(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u589e\u884c\u3002", (String)"XComponentEdit_5", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                this.getView().showTipNotification(err.toString());
                e.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)"copyentryrow", (CharSequence)op.getOperateKey()) && selectRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\u3002", (String)"XComponentEdit_6", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        int[] selectRows = entryGrid.getSelectRows();
        FormOperate op = (FormOperate)e.getSource();
        if (StringUtils.equals((CharSequence)"copyentryrow", (CharSequence)op.getOperateKey())) {
            if (selectRows.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\u3002", (String)"XComponentEdit_6", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            } else if (selectRows.length == 1) {
                int addRow = this.getModel().getEntryRowCount("stockentry");
                this.getModel().setValue("entrychangetype", (Object)"A", addRow - 1);
            }
        } else if (StringUtils.equals((CharSequence)"audit", (CharSequence)op.getOperateKey())) {
            this.getView().updateView();
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultTrans();
    }

    private void setDefaultTrans() {
        DynamicObject purorg = (DynamicObject)this.getModel().getValue("purorg");
        if (purorg == null) {
            return;
        }
        QFilter qFilter = new QFilter("isfault", "=", (Object)"1");
        qFilter.and(new QFilter("createorg", "=", purorg.getPkValue()));
        qFilter.and(new QFilter("transactiontype", "=", (Object)Long.valueOf("738166303168232448")));
        qFilter.and(new QFilter("isfault", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("isstockchange", "=", (Object)"1"));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"mpdm_transactout", (String)"number,name", (QFilter[])new QFilter[]{qFilter});
        if (load != null && load.length == 1) {
            this.getModel().setItemValueByNumber("transactiontypeid", load[0].getString("number"));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        Object stockid;
        if (StringUtils.equals((CharSequence)"stockno", (CharSequence)arg0.getFieldName()) && (stockid = this.getModel().getValue("stockid", arg0.getRowIndex())) != null) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("om_componentlist");
            showParameter.setPkId(stockid);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("true".equals(this.getPageCache().get(ISSTOCKCHANGEX))) {
            return;
        }
        this.getPageCache().put(ISSTOCKCHANGEX, "true");
        int currentIndex = this.getSelectEntryRowIndex();
        if ("transactiontypeid".equals(key)) {
            DynamicObject newObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldObj = (DynamicObject)e.getChangeSet()[0].getOldValue();
            String oldtran = "";
            if (newObj == null) {
                this.getPageCache().put(ISSTOCKCHANGEX, "true");
                this.getModel().setValue("transactiontypeid", (Object)oldObj);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u59d4\u5916\u4e8b\u52a1\u7c7b\u578b\u4e0d\u53ef\u6e05\u7a7a\u3002", (String)"XComponentEdit_7", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                this.getPageCache().put(ISSTOCKCHANGEX, FALSE);
                return;
            }
            String newtran = newObj.getPkValue().toString();
            if (oldObj != null) {
                oldtran = oldObj.getPkValue().toString();
            }
            this.getPageCache().put("newXStockObj", newtran);
            this.getPageCache().put(OLDXSTOCKOBJ, oldtran);
            if (oldObj != null && !newtran.equals(this.getPageCache().get(OLDXSTOCKOBJ))) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("tranChange", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u201c\u59d4\u5916\u4e8b\u52a1\u7c7b\u578b\u201d\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u786e\u8ba4\u5207\u6362\uff1f", (String)"XComponentEdit_8", (String)"mmc-om-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            }
        } else if ("stockno".equals(key)) {
            String stockno = (String)this.getModel().getValue("stockno", currentIndex);
            if (!StringUtils.isBlank((CharSequence)stockno)) {
                QFilter filter = new QFilter("billno", "=", (Object)stockno);
                List<QFilter> filters = this.getStockFilter();
                filters.add(filter);
                QFilter[] filterArray = new QFilter[filters.size()];
                DynamicObject stock = BusinessDataServiceHelper.loadSingle((String)"om_componentlist", (String)"", (QFilter[])filters.toArray(filterArray));
                if (stock == null) {
                    this.setStockInfo(null, currentIndex);
                } else {
                    DynamicObject stockdym = BusinessDataServiceHelper.loadSingle((Object)stock.getPkValue(), (String)"om_componentlist");
                    this.setStockInfo(stockdym, currentIndex);
                }
            } else {
                this.setStockInfo(null, currentIndex);
            }
        }
        this.getPageCache().put(ISSTOCKCHANGEX, FALSE);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"tranChange", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                int entryNum = this.getModel().getEntryRowCount("stockentry");
                for (int i = 0; i < entryNum; ++i) {
                    this.getModel().deleteEntryRow("stockentry", 0);
                }
                this.showEntryDetial();
                this.getModel().setValue("transactiontypeid", (Object)this.getPageCache().get("newXStockObj"));
            } else {
                this.getPageCache().put(ISSTOCKCHANGEX, "true");
                this.getModel().setValue("transactiontypeid", (Object)this.getPageCache().get(OLDXSTOCKOBJ));
                this.getPageCache().put(ISSTOCKCHANGEX, FALSE);
            }
        }
    }

    private void setControlState(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"bomversionfield", "auxpropertyfield", "supplymodefield", "supplierfield", "batchnofield", "supplyorgfield", "warehousefield", "locationfield", "outorgunitfield", "outwarehousefield", "issuemodefield", "backflushfield", "backflushtimefield", "iskeypartfield", "overissuecontrlfield", "issinhighlimitfield", "extraratioqtyfield", "issinlowlimitfield", "lackraitioqtyfield", "leadtimefield", "demanddatefield", "workprocedurefield", "setuplocationfield", "childremarksfield", "rejectedqtyfield", "feedingqtyfield", "scrapqtyfield", "wipqtyfield", "oprnofield", "processseqfield", "oprworkcenterfield", "outsupplyfield", "machiningtypefield", "cansendqtyfield", "considerminbatchfield"});
    }

    private void showEntryDetial() {
        IDataModel model = this.getModel();
        model.setValue("seqfield", null);
        model.setValue("materielfield", null);
        model.setValue("materialunitidfield", null);
        model.setValue("bomversionfield", null);
        model.setValue("auxpropertyfield", null);
        model.setValue("supplymodefield", null);
        model.setValue("supplierfield", null);
        model.setValue("batchnofield", null);
        model.setValue("supplyorgfield", null);
        model.setValue("warehousefield", null);
        model.setValue("locationfield", null);
        model.setValue("outorgunitfield", null);
        model.setValue("outwarehousefield", null);
        model.setValue("issuemodefield", null);
        model.setValue("backflushfield", null);
        model.setValue("backflushtimefield", null);
        model.setValue("iskeypartfield", (Object)Boolean.FALSE);
        model.setValue("considerminbatchfield", (Object)Boolean.FALSE);
        model.setValue("overissuecontrlfield", null);
        model.setValue("issinhighlimitfield", null);
        model.setValue("extraratioqtyfield", null);
        model.setValue("issinlowlimitfield", null);
        model.setValue("lackraitioqtyfield", null);
        model.setValue("leadtimefield", null);
        model.setValue("demanddatefield", null);
        model.setValue("setuplocationfield", null);
        model.setValue("childremarksfield", null);
        model.setValue("seqfield_qty", null);
        model.setValue("materielfield_qty", null);
        model.setValue("materialunitidfield_qty", null);
        model.setValue("standqtyfield_qty", null);
        model.setValue("demandqtyfield", null);
        model.setValue("actissueqtyfield", null);
        model.setValue("rejectedqtyfield", (Object)BigDecimal.ZERO);
        model.setValue("feedingqtyfield", (Object)BigDecimal.ZERO);
        model.setValue("scrapqtyfield", (Object)BigDecimal.ZERO);
        model.setValue("wipqtyfield", (Object)BigDecimal.ZERO);
        model.setValue("cansendqtyfield", (Object)BigDecimal.ZERO);
        this.setControlState(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"transactiontypeid", (CharSequence)fieldKey)) {
            ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter qfilter = new QFilter("isstockchange", "=", (Object)"1");
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        } else if (StringUtils.equals((CharSequence)"purorg", (CharSequence)fieldKey)) {
            e.getFormShowParameter().setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        }
    }

    public boolean isJumpLevel(int rowIndex) {
        if (rowIndex == -1) {
            return false;
        }
        return (Boolean)this.getModel().getValue("isjumplevel", rowIndex);
    }

    public boolean isJumpLevel(DynamicObject stockEntry) {
        return stockEntry.getBoolean("isjumplevel");
    }
}

