/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.formplugin;

import java.util.EventObject;
import kd.bd.mpdm.formplugin.stockchange.StockChangeTplEdit;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class XOmMftStockEdit
extends StockChangeTplEdit {
    private static final String ISSTOCKCHANGEX = "isStockChangeX";
    private static final String FALSE = "false";
    private static final String OLDXSTOCKSUPOBJ = "oldXStockSupObj";
    private static final String SUPPLIERTOP = "suppliertop";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultTrans();
    }

    private void setDefaultTrans() {
        DynamicObject dept = (DynamicObject)this.getModel().getValue("org");
        if (dept == null) {
            return;
        }
        QFilter qFilter = new QFilter("isfault", "=", (Object)"1");
        QFilter planFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_transactproduct", (Long)Long.parseLong(dept.getPkValue().toString()));
        qFilter.and(planFilter);
        qFilter.and(new QFilter("pomorom", "=", (Object)"O"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("isstockchange", "=", (Object)"1"));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"mpdm_transactproduct", (String)"number,name", (QFilter[])new QFilter[]{qFilter});
        if (load != null && load.length == 1) {
            this.getModel().setItemValueByNumber("transactiontypeid", load[0].getString("number"));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.TRUE, new String[]{SUPPLIERTOP});
    }

    public void entryRowClick(RowClickEvent evt) {
        DynamicObject material;
        super.entryRowClick(evt);
        this.getView().setEnable(Boolean.TRUE, new String[]{SUPPLIERTOP});
        DynamicObject entryentity = this.getModel().getEntryRowEntity("stockentry", this.getSelectEntryRowIndex());
        if (entryentity != null && (material = entryentity.getDynamicObject("materialid")) != null) {
            this.getView().setEnable(this.isUseAuxpty(material), new String[]{"auxpropertyfield"});
        }
    }

    private Boolean isUseAuxpty(DynamicObject material) {
        Object pkValue = material.getDynamicObject("masterid").getPkValue();
        DynamicObject masterid = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
        if (masterid.getBoolean("isuseauxpty")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection stockEntrys = dataEntity.getDynamicObjectCollection("stockentry");
        if (!stockEntrys.isEmpty() && stockEntrys.size() > 0) {
            DynamicObject orderf7 = ((DynamicObject)stockEntrys.get(0)).getDynamicObject("entryorderentryid");
            DynamicObject supply = orderf7 == null ? null : orderf7.getDynamicObject("supplier");
            for (DynamicObject stockEntry : stockEntrys) {
                DynamicObject newSupply;
                DynamicObject newOrderf7 = stockEntry.getDynamicObject("entryorderentryid");
                DynamicObject dynamicObject = newSupply = orderf7 == null ? null : newOrderf7.getDynamicObject("supplier");
                if (stockEntry.getBoolean("islead")) {
                    return;
                }
                if (supply == newSupply) continue;
                this.getModel().setValue(SUPPLIERTOP, null);
                return;
            }
            this.getModel().setValue(SUPPLIERTOP, (Object)supply);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("true".equals(this.getPageCache().get(ISSTOCKCHANGEX))) {
            return;
        }
        this.getPageCache().put(ISSTOCKCHANGEX, "true");
        if (SUPPLIERTOP.equals(key)) {
            DynamicObject newObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldObj = (DynamicObject)e.getChangeSet()[0].getOldValue();
            String newtran = newObj == null ? "0" : newObj.getPkValue().toString();
            String oldtran = oldObj == null ? "0" : oldObj.getPkValue().toString();
            this.getPageCache().put("newXStockSupObj", newtran);
            this.getPageCache().put(OLDXSTOCKSUPOBJ, oldtran);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("stockentry");
            Object billStatus = this.getModel().getValue("billstatus");
            if ("A".equals(billStatus) && !newtran.equals(this.getPageCache().get(OLDXSTOCKSUPOBJ)) && entryEntity != null && !entryEntity.isEmpty()) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("tranSupChange", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u5207\u6362\u201c\u59d4\u5916\u52a0\u5de5\u5546\u201d\u5c06\u6e05\u9664\u7ec4\u4ef6\u660e\u7ec6\u4fe1\u606f\uff0c\u786e\u8ba4\u5207\u6362\uff1f", (String)"XOmMftStockEdit_0", (String)"mmc-om-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            }
        }
        this.getPageCache().put(ISSTOCKCHANGEX, FALSE);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"tranSupChange", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                int entryNum = this.getModel().getEntryRowCount("stockentry");
                for (int i = 0; i < entryNum; ++i) {
                    this.getModel().deleteEntryRow("stockentry", 0);
                }
                super.showEntryDetial();
                this.getModel().setValue(SUPPLIERTOP, (Object)Long.parseLong(this.getPageCache().get("newXStockSupObj")));
            } else {
                this.getPageCache().put(ISSTOCKCHANGEX, "true");
                this.getModel().setValue(SUPPLIERTOP, null);
                if (!"0".equals(this.getPageCache().get(OLDXSTOCKSUPOBJ))) {
                    this.getModel().setValue(SUPPLIERTOP, (Object)Long.parseLong(this.getPageCache().get(OLDXSTOCKSUPOBJ)));
                }
                this.getPageCache().put(ISSTOCKCHANGEX, FALSE);
            }
        }
    }
}

