/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.formplugin.order;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bd.mpdm.common.mftorder.utils.MftOrderToProorderUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.om.business.helper.OmOrderSplitHelper;
import kd.mmc.om.common.order.OrderBusinessHelper;
import kd.mmc.om.common.utils.OMBigDecimaUtil;
import kd.mpscmm.msplan.mservice.service.datafetch.util.DataSourceFetchDataUtil;

public class OMMftOrderEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String COPY = "copy";
    public static final String DONOTHING = "donothing";
    public static String[] FIELDS = new String[]{"supplier", "purorg", "producedept"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit purorg = (BasedataEdit)this.getView().getControl("purorg");
        purorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supplier = (BasedataEdit)this.getView().getControl("supplier");
        supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKey;
        super.itemClick(evt);
        switch (operationKey = evt.getItemKey()) {
            case "ompushpick": 
            case "ompushreceive": 
            case "ompushreturn": 
            case "ompushomcmplin": 
            case "ompushtrans": 
            case "ompushreq": {
                this.pushPick(operationKey);
                break;
            }
        }
    }

    private void pushPick(String type) {
        StringBuilder errorMsg;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u5206\u5f55", (String)"OMMftOrderEdit_9", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            return;
        }
        IFormView view = this.getView();
        IBillView billView = (IBillView)view;
        ConvertOpParameter opParameter = null;
        if ("ompushreceive".equals(type) || "ompushomcmplin".equals(type)) {
            opParameter = OrderBusinessHelper.getReceiveConvertOpParameter((String)type);
            ListSelectedRowCollection selectedRows = this.getListSelectedRows(selectRows);
            if (selectedRows.isEmpty()) {
                String billno = this.getModel().getValue("billno").toString();
                String format = String.format(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355%s\u4e0b\u6e38\u65e0\u91c7\u8d2d\u8ba2\u5355\u6570\u636e\u3002", (String)"OMMftOrderEdit_8", (String)"mmc-om-formplugin", (Object[])new Object[0]), billno);
                this.getView().showMessage(format);
                return;
            }
            opParameter.setSelectedRows(selectedRows);
            if (opParameter != null && opParameter.getSelectedRows().size() == 0) {
                String billno = this.getModel().getValue("billno").toString();
                String format = String.format(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355%s\u5173\u8054\u7684\u91c7\u8d2d\u8ba2\u5355\u65e0\u4e0b\u63a8\u6570\u636e\u3002", (String)"OMMftOrderEdit_10", (String)"mmc-om-formplugin", (Object[])new Object[0]), billno);
                this.getView().showMessage(format);
                return;
            }
        } else if ("ompushtrans".equals(type)) {
            StringBuilder thisErrormsg = this.pushCheck();
            if (thisErrormsg.length() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u8c03\u62e8\u5931\u8d25\u3002", (String)"OMMftOrderEdit_23", (String)"mmc-om-formplugin", (Object[])new Object[0]), thisErrormsg.toString(), null);
                return;
            }
            opParameter = MftOrderToProorderUtil.buildParameter(null, (IBillView)billView, (String)type);
            if (opParameter != null && opParameter.getSelectedRows().size() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u5173\u8054\u7684\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\u4e2d\u6ca1\u6709\u9700\u8981\u4e0b\u63a8\u7684\u6570\u636e\u3002", (String)"OMMftOrderEdit_24", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if ("ompushreq".equals(type)) {
            errorMsg = this.pushCheck();
            if (errorMsg.length() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u9886\u6599\u7533\u8bf7\u5931\u8d25\u3002", (String)"OMMftOrderEdit_25", (String)"mmc-om-formplugin", (Object[])new Object[0]), errorMsg.toString(), null);
                return;
            }
            opParameter = MftOrderToProorderUtil.buildParameter(null, (IBillView)billView, (String)type);
            if (opParameter != null && opParameter.getSelectedRows().size() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u5173\u8054\u7684\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\u4e2d\u6ca1\u6709\u9700\u8981\u4e0b\u63a8\u7684\u6570\u636e\u3002", (String)"OMMftOrderEdit_24", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                return;
            }
        } else {
            errorMsg = this.pushCheck();
            if (errorMsg.length() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u9886\u6599\u5931\u8d25\u3002", (String)"OMMftOrderEdit_11", (String)"mmc-om-formplugin", (Object[])new Object[0]), errorMsg.toString(), null);
                return;
            }
            opParameter = MftOrderToProorderUtil.buildParameter(null, (IBillView)billView, (String)type);
            if (opParameter != null && opParameter.getSelectedRows().size() == 0) {
                String billno = this.getModel().getValue("billno").toString();
                String format = String.format(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355%1$s\u5173\u8054\u7684\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\u65e0\u4e0b\u63a8\u6570\u636e\u3002", (String)"OMMftOrderEdit_12", (String)"mmc-om-formplugin", (Object[])new Object[0]), billno);
                this.getView().showMessage(format);
                return;
            }
        }
        String opParameterJson = SerializationUtils.toJsonString((Object)opParameter);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getCustomParams().put("opparam", opParameterJson);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4e0b\u63a8", (String)"OMMftOrderEdit_13", (String)"mmc-om-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("mft_botp_convertop");
        this.getView().showForm(showParameter);
    }

    private ListSelectedRowCollection getListSelectedRows(int[] selectRows) {
        ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
        HashSet<Object> entryPks = new HashSet<Object>(4);
        for (int i = 0; i < selectRows.length; ++i) {
            DynamicObject entry = this.getModel().getEntryRowEntity("treeentryentity", selectRows[i]);
            Object pkValue = entry.getPkValue();
            entryPks.add(pkValue);
        }
        if (!entryPks.isEmpty()) {
            QFilter qFilter = new QFilter("billentry.mftorderentryid", "in", entryPks);
            QFilter[] qFilters = new QFilter[]{qFilter};
            String algoStr = "omQueryPur";
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoStr, (String)"pm_purorderbill", (String)"id,billentry.id", (QFilter[])qFilters, null);){
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    ListSelectedRow row = new ListSelectedRow(next.get("id"));
                    row.setEntryEntityKey("billentry");
                    row.setEntryPrimaryKeyValue(next.get("billentry.id"));
                    selectedRows.add((Object)row);
                }
            }
        }
        return selectedRows;
    }

    private StringBuilder pushCheck() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        IDataModel model = this.getModel();
        StringBuilder errorMsg = new StringBuilder();
        if (entryGrid.getSelectRows().length >= 1) {
            IBillModel billModel = (IBillModel)this.getView().getModel();
            String billNo = (String)model.getValue("billno");
            for (int i = 0; i < entryGrid.getSelectRows().length; ++i) {
                StringJoiner tErrormsg = new StringJoiner(";");
                int index = entryGrid.getSelectRows()[i];
                DynamicObject entry = billModel.getEntryRowEntity("treeentryentity", index);
                if (entry == null) continue;
                String producttype = entry.getString("producttype");
                String planstatus = entry.getString("planstatus");
                String bizstatus = entry.getString("bizstatus");
                int count = 0;
                if (!"C".equals(producttype)) {
                    tErrormsg.add(ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u578b\u4e0d\u4e3a\u4e3b\u4ea7\u54c1", (String)"OMMftOrderEdit_14", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                    ++count;
                }
                if (!"A".equals(bizstatus)) {
                    tErrormsg.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u201c\u6b63\u5e38\u201d", (String)"OMMftOrderEdit_15", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                    ++count;
                }
                if (!"C".equals(planstatus)) {
                    tErrormsg.add(ResManager.loadKDString((String)"\u8ba1\u5212\u72b6\u6001\u4e0d\u4e3a\u201c\u4e0b\u8fbe\u201d", (String)"OMMftOrderEdit_16", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                    ++count;
                }
                if (count == 0) {
                    return new StringBuilder();
                }
                if (tErrormsg.length() <= 0) continue;
                String mgs = String.format(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\uff1a %1$s \u7b2c[%2$s]\u884c\uff0c", (String)"OMMftOrderEdit_22", (String)"mmc-om-formplugin", (Object[])new Object[0]), billNo, entry.get("seq"));
                StringBuilder sb = new StringBuilder();
                sb.insert(0, mgs);
                sb.append(tErrormsg);
                sb.append("\u3002");
                sb.append("\n");
                errorMsg.append((CharSequence)sb);
            }
        }
        return errorMsg;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        FormOperate operate = (FormOperate)e.getSource();
        if ("ordersplitom".equals(key)) {
            this.bforeOrdersplitOm(operate, e);
        }
        StringBuilder sb = new StringBuilder();
        if (DONOTHING.equalsIgnoreCase(operate.getType())) {
            int[] allSelectRows;
            IDataModel model = this.getView().getModel();
            String billno = (String)model.getValue("billno");
            EntryGrid entrygrid = (EntryGrid)this.getView().getControl("treeentryentity");
            for (int rowIndex : allSelectRows = entrygrid.getSelectRows()) {
                Object entryPk = ((DynamicObject)this.getModel().getEntryEntity("treeentryentity").get(rowIndex)).getPkValue();
                sb.append(billno).append(',').append(entryPk).append("@@@");
            }
        }
        operate.getOption().setVariableValue("operateOption", sb.toString());
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        DynamicObject dataEntity;
        Object pid;
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        TreeEntryGrid entity = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        int[] selectRows = entity.getSelectRows();
        if (selectRows.length > 0 && rowDataEntities.length > 0 && (pid = (dataEntity = rowDataEntities[0].getDataEntity()).get("pid")) != null && Long.parseLong(pid.toString()) != 0L) {
            for (String field : FIELDS) {
                dataEntity.set(field, this.getModel().getValue(field, selectRows[0]));
                this.getView().updateView(field, dataEntity.getInt("seq") - 1);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        Control con = (Control)e.getSource();
        switch (key = con.getKey()) {
            case "purorg": {
                this.beforePurOrgF7Select(e);
                break;
            }
            case "supplier": {
                this.beforeSupplierF7Select(e);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object billstatus;
        String name;
        IDataEntityProperty property = e.getProperty();
        switch (name = property.getName()) {
            case "purorg": {
                this.purOrgChanged(e);
                break;
            }
            case "supplier": {
                this.supplierChanged(e);
                break;
            }
        }
        Object isinitbill = this.getModel().getValue("isinitbill");
        if (isinitbill != null && Boolean.parseBoolean(isinitbill.toString()) && "A".equals(billstatus = this.getModel().getValue("billstatus"))) {
            this.intiBillPropertyChanged(e);
        }
    }

    private void purOrgChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        String name = e.getProperty().getName();
        DynamicObject dataEntity = changeData.getDataEntity();
        this.getModel().beginInit();
        dataEntity.set("supplier", null);
        this.getView().updateView("supplier", dataEntity.getInt("seq") - 1);
        DynamicObjectCollection treeentryentity = this.getModel().getEntryEntity("treeentryentity");
        treeentryentity.stream().filter(a -> a.getLong("pid") == dataEntity.getLong("id")).forEach(a -> {
            a.set(name, dataEntity.get(name));
            a.set("supplier", null);
            this.getView().updateView(name, a.getInt("seq") - 1);
            this.getView().updateView("supplier", a.getInt("seq") - 1);
        });
        this.getModel().endInit();
    }

    private void supplierChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        String name = e.getProperty().getName();
        DynamicObject dataEntity = changeData.getDataEntity();
        this.getModel().beginInit();
        DynamicObjectCollection treeentryentity = this.getModel().getEntryEntity("treeentryentity");
        treeentryentity.stream().filter(a -> a.getLong("pid") == dataEntity.getLong("id")).forEach(a -> {
            a.set(name, dataEntity.get(name));
            this.getView().updateView(name, a.getInt("seq") - 1);
        });
        this.getModel().endInit();
    }

    private void beforePurOrgF7Select(BeforeF7SelectEvent e) {
        FormShowParameter formShowParameter = e.getFormShowParameter();
        if (formShowParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)formShowParameter;
            listShowParameter.setMultiSelect(false);
        }
    }

    private void beforeSupplierF7Select(BeforeF7SelectEvent e) {
        int row = e.getRow();
        Object value = this.getModel().getValue("purorg", row);
        if (value == null) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"OMMftOrderEdit_21", (String)"mmc-om-formplugin", (Object[])new Object[0]));
        }
    }

    private void intiBillPropertyChanged(PropertyChangedArgs e) {
        String name;
        IDataEntityProperty property = e.getProperty();
        switch (name = property.getName()) {
            case "entryquainwaqty": 
            case "entryunquainwaqty": 
            case "entryscrinwaqty": {
                this.calculateStockQty();
                break;
            }
            case "entryqualifiedqty": 
            case "entryacceptqty": 
            case "entryworkwasteqty": 
            case "entrymtlcostqty": 
            case "entryreworkqty": 
            case "entryrepairqty": {
                this.calculateRptQty();
                break;
            }
        }
    }

    private void calculateStockQty() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        if (entryGrid.getSelectRows().length == 0) {
            return;
        }
        int entryIndex = entryGrid.getSelectRows()[0];
        if (entryIndex == -1) {
            return;
        }
        BigDecimal entryquainwaqty = OMBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("entryquainwaqty"));
        BigDecimal entryunquainwaqty = OMBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("entryunquainwaqty"));
        BigDecimal entryscrinwaqty = OMBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("entryscrinwaqty"));
        BigDecimal entrystockqty = entryquainwaqty.add(entryunquainwaqty).add(entryscrinwaqty);
        this.getModel().setValue("entrystockqty", (Object)entrystockqty);
        this.getModel().setValue("quainwaqty", (Object)entryquainwaqty, entryIndex);
        this.getModel().setValue("unquainwaqty", (Object)entryunquainwaqty, entryIndex);
        this.getModel().setValue("scrinwaqty", (Object)entryscrinwaqty, entryIndex);
        this.getModel().setValue("stockqty", (Object)entrystockqty, entryIndex);
        this.getModel().setValue("purauditqty", (Object)entrystockqty, entryIndex);
        this.getModel().setValue("purpushqty", (Object)entrystockqty, entryIndex);
    }

    private void calculateRptQty() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        if (entryGrid.getSelectRows().length == 0) {
            return;
        }
        int entryIndex = entryGrid.getSelectRows()[0];
        if (entryIndex == -1) {
            return;
        }
        BigDecimal entryqualifiedqty = OMBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("entryqualifiedqty"));
        BigDecimal entryacceptqty = OMBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("entryacceptqty"));
        BigDecimal entryworkwasteqty = OMBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("entryworkwasteqty"));
        BigDecimal entrymtlcostqty = OMBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("entrymtlcostqty"));
        BigDecimal entryreworkqty = OMBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("entryreworkqty"));
        BigDecimal entryrepairqty = OMBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("entryrepairqty"));
        BigDecimal entryrptqty = entryqualifiedqty.add(entryacceptqty).add(entryworkwasteqty).add(entrymtlcostqty).add(entryreworkqty).add(entryrepairqty);
        this.getModel().setValue("entryrptqty", (Object)entryrptqty);
        this.getModel().setValue("entryreportqty", (Object)entryrptqty);
        BigDecimal entryscrapqty = entrymtlcostqty.add(entryworkwasteqty);
        this.getModel().setValue("entryscrapqty", (Object)entryscrapqty);
        this.getModel().setValue("qualifiedqty", (Object)entryqualifiedqty, entryIndex);
        this.getModel().setValue("acceptqty", (Object)entryacceptqty, entryIndex);
        this.getModel().setValue("workwasteqty", (Object)entryworkwasteqty, entryIndex);
        this.getModel().setValue("mtlcostqty", (Object)entrymtlcostqty, entryIndex);
        this.getModel().setValue("reworkqty", (Object)entryreworkqty, entryIndex);
        this.getModel().setValue("repairqty", (Object)entryrepairqty, entryIndex);
        this.getModel().setValue("rptqty", (Object)entryrptqty, entryIndex);
        this.getModel().setValue("reportqty", (Object)entryrptqty, entryIndex);
        this.getModel().setValue("scrapqty", (Object)entryscrapqty, entryIndex);
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("treeentryentity");
        for (DynamicObject entry : entryColl) {
            BigDecimal entryquainwaqty = OMBigDecimaUtil.toBigDecimal((Object)entry.get("quainwaqty"));
            BigDecimal entryunquainwaqty = OMBigDecimaUtil.toBigDecimal((Object)entry.get("unquainwaqty"));
            BigDecimal entryscrinwaqty = OMBigDecimaUtil.toBigDecimal((Object)entry.get("scrinwaqty"));
            BigDecimal qty = entryquainwaqty.add(entryunquainwaqty).add(entryscrinwaqty);
            entry.set("purauditqty", (Object)qty);
            entry.set("purpushqty", (Object)qty);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("cps_count".equals(key)) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("status", "=", (Object)"C"));
            filters.add(new QFilter("enable", "=", (Object)"1"));
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"mrp_cps_planpro", (boolean)false);
            showParameter.getListFilterParameter().setQFilters(filters);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        switch (key) {
            case "ordersplitom": {
                this.afterOrderSplitOm(e);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionKey = e.getActionId();
        if (e.getReturnData() != null && "cps_count".equals(actionKey)) {
            Set<Long> set;
            Long orderId;
            Object entryPk;
            DynamicObject orderEntry;
            int i;
            ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
            Object pk = rows.get(0).getPrimaryKeyValue();
            DynamicObject orderObj = this.getModel().getDataEntity();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
            HashMap<Long, Set<Long>> selectOrderIdMap = new HashMap<Long, Set<Long>>(16);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
            HashMap<Long, String> billNoMap = new HashMap<Long, String>(16);
            if (entryGrid.getSelectRows().length == 0) {
                for (i = 0; i < entryEntity.size(); ++i) {
                    orderEntry = (DynamicObject)entryEntity.get(i);
                    entryPk = orderEntry.getPkValue();
                    orderId = (Long)orderObj.getPkValue();
                    set = (HashSet<Long>)selectOrderIdMap.get(orderId);
                    if (set == null) {
                        set = new HashSet<Long>(16);
                    }
                    set.add((Long)entryPk);
                    selectOrderIdMap.put(orderId, set);
                    billNoMap.put(orderId, orderObj.getString("billno"));
                }
            } else {
                for (i = 0; i < entryGrid.getSelectRows().length; ++i) {
                    orderEntry = this.getModel().getEntryRowEntity("treeentryentity", entryGrid.getSelectRows()[i]);
                    entryPk = orderEntry.getPkValue();
                    orderId = (Long)orderObj.getPkValue();
                    set = (Set)selectOrderIdMap.get(orderId);
                    if (set == null) {
                        set = new HashSet(16);
                    }
                    set.add((Long)entryPk);
                    selectOrderIdMap.put(orderId, set);
                    billNoMap.put(orderId, orderObj.getString("billno"));
                }
            }
            Long dataSourceId = 0L;
            DynamicObjectCollection query = QueryServiceHelper.query((String)"mrp_cps_planpro", (String)"number,scentryentity.entryisscmrpoperat,scentryentity.resourceregisters,scentryentity.entrysupplyres,scentryentity.entrysupplyres.number", (QFilter[])new QFilter[]{new QFilter("id", "=", pk)});
            for (DynamicObject queryEntry : query) {
                if (!"om_mftorder".equals(queryEntry.getString("scentryentity.entrysupplyres.number"))) continue;
                dataSourceId = queryEntry.getLong("scentryentity.resourceregisters");
            }
            if ("0".equals(dataSourceId.toString())) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6307\u5b9a\u7684\u9f50\u5957\u5206\u6790\u65b9\u6848\u3010%1$s\u3011\u4e2d\u7684\u4f9b\u5e94\u53c2\u6570\u6570\u636e\u6e90\u914d\u7f6e\u4e0d\u5305\u62ec\u59d4\u5916\u5de5\u5355\u3002", (String)"OMMftOrderEdit_26", (String)"mmc-om-formplugin", (Object[])new Object[0]), ((DynamicObject)query.get(0)).getString("number")));
                return;
            }
            DataSet dataSetByModel = DataSourceFetchDataUtil.getDataSetByModel((Long)dataSourceId, null);
            Iterator iterator = dataSetByModel.iterator();
            HashSet<Long> billEntryIdSet = new HashSet<Long>();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                billEntryIdSet.add(row.getLong("entryentity.billentryid"));
            }
            HashSet<String> unpassOrderNo = new HashSet<String>(16);
            List<Long[]> idEntryidValues = this.getOrderIdEntryIdList(billEntryIdSet, selectOrderIdMap, billNoMap, unpassOrderNo);
            if (unpassOrderNo.isEmpty()) {
                Long resId = (Long)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mrp", (String)"IRunCPSService", (String)"startCPS", (Object[])new Object[]{pk, "om_mftorder", idEntryidValues});
                if (resId != null) {
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setFormId("mrp_cps_calc_log");
                    showParameter.setPkId((Object)resId);
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setStatus(OperationStatus.VIEW);
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            } else if (billNoMap.size() > unpassOrderNo.size()) {
                JSONArray josnArray = new JSONArray();
                for (Long[] orderInfo : idEntryidValues) {
                    JSONObject josnStr = new JSONObject();
                    josnStr.put("orderid", (Object)orderInfo[0]);
                    josnStr.put("orderentryid", (Object)orderInfo[1]);
                    josnArray.add((Object)josnStr);
                }
                this.getView().getPageCache().put("idEntryidValues", josnArray.toString());
                this.getView().getPageCache().put("planproid", pk.toString());
                ConfirmCallBackListener callback = new ConfirmCallBackListener("startCPSConfirm", (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u9009\u4e2d%1$s\u6761\u5355\u636e\uff0c\u6709%2$s\u6761\u4e0d\u7b26\u5408\u9f50\u5957\u5206\u6790\u65b9\u6848\u6761\u4ef6\uff0c\u5355\u636e\u7f16\u53f7\u4e3a%3$s\u3002\u662f\u5426\u7ee7\u7eed\u8ba1\u7b97\uff1f", (String)"OMMftOrderEdit_27", (String)"mmc-om-formplugin", (Object[])new Object[0]), billNoMap.size(), unpassOrderNo.size(), ((Object)unpassOrderNo).toString()), MessageBoxOptions.YesNo, callback);
            } else if (billNoMap.size() == unpassOrderNo.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u5de5\u5355\u6570\u636e\u5747\u4e0d\u7b26\u5408\u9f50\u5957\u5206\u6790\u65b9\u6848\u7684\u6570\u636e\u6e90\u6761\u4ef6\u3002", (String)"OMMftOrderEdit_28", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if ("startCPSConfirm".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            String jsonstring = this.getView().getPageCache().get("idEntryidValues");
            JSONArray josnArray = JSONArray.parseArray((String)jsonstring);
            ArrayList<Long[]> idEntryidValues = new ArrayList<Long[]>(16);
            for (int i = 0; i < josnArray.size(); ++i) {
                JSONObject josnStr = (JSONObject)josnArray.get(i);
                Long[] orderLong = new Long[]{josnStr.getLong("orderid"), josnStr.getLong("orderentryid")};
                idEntryidValues.add(orderLong);
            }
            String planproid = this.getView().getPageCache().get("planproid");
            Long resId = (Long)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mrp", (String)"IRunCPSService", (String)"startCPS", (Object[])new Object[]{Long.parseLong(planproid), "om_mftorder", idEntryidValues});
            if (resId != null) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId("mrp_cps_calc_log");
                showParameter.setPkId((Object)resId);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    private List<Long[]> getOrderIdEntryIdList(Set<Long> billEntryIdSet, Map<Long, Set<Long>> selectOrderIdMap, Map<Long, String> billNoMap, Set<String> unpassOrderNo) {
        HashSet<Long> unpassOrderId = new HashSet<Long>(16);
        for (Map.Entry<Long, Set<Long>> m : selectOrderIdMap.entrySet()) {
            Long orderId = m.getKey();
            Set<Long> orderEntryIdSet = m.getValue();
            for (Long orderEntryId : orderEntryIdSet) {
                if (billEntryIdSet.contains(orderEntryId)) continue;
                unpassOrderId.add(orderId);
                unpassOrderNo.add(billNoMap.get(orderId));
            }
        }
        ArrayList<Long[]> idEntryidValues = new ArrayList<Long[]>(16);
        for (Map.Entry<Long, Set<Long>> m : selectOrderIdMap.entrySet()) {
            Long orderId = m.getKey();
            if (unpassOrderId.contains(orderId)) continue;
            for (Long orderEntryId : m.getValue()) {
                Long[] orderLong = new Long[]{orderId, orderEntryId};
                idEntryidValues.add(orderLong);
            }
        }
        return idEntryidValues;
    }

    private void bforeOrdersplitOm(FormOperate operate, BeforeDoOperationEventArgs e) {
        TreeEntryGrid orderEntry = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        int[] selectRows = orderEntry.getSelectRows();
        if (selectRows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u4ea7\u54c1\u4fe1\u606f\u3002", (String)"MftOrderEditTpl_39", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        ArrayList<Long> billSelectRowList = new ArrayList<Long>(10);
        for (int i = 0; i < selectRows.length; ++i) {
            DynamicObject entry = this.getModel().getEntryRowEntity("treeentryentity", orderEntry.getSelectRows()[i]);
            billSelectRowList.add(entry.getLong("id"));
        }
        if (billSelectRowList.size() <= 0) {
            e.setCancel(true);
            return;
        }
        String jsonString = SerializationUtils.toJsonString(billSelectRowList);
        operate.getOption().setVariableValue("billSelectRowList", jsonString);
        operate.getOption().setVariableValue("isFromMftOrderBill", "true");
    }

    private void afterOrderSplitOm(AfterDoOperationEventArgs e) {
        boolean isSuccess = e.getOperationResult().isSuccess();
        FormOperate operate = (FormOperate)e.getSource();
        if (isSuccess) {
            FormShowParameter showParameter = OmOrderSplitHelper.splitOrderShowForm();
            showParameter.setCustomParam("isFromMftOrderBill", (Object)"true");
            String billSelectRowList = operate.getOption().getVariableValue("billSelectRowList");
            showParameter.setCustomParam("billSelectRowList", (Object)billSelectRowList);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (null != org) {
                long mainOrgId = org.getLong("id");
                showParameter.setCustomParam("mainOrgId", (Object)mainOrgId);
            }
            this.getView().showForm(showParameter);
        }
    }
}

