/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.formplugin.order;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bd.mpdm.common.mftorder.utils.MftOrderToProorderUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.om.business.helper.OmOrderSplitHelper;
import kd.mmc.om.common.order.OrderBusinessHelper;
import kd.mpscmm.msplan.mservice.service.datafetch.util.DataSourceFetchDataUtil;

public class OMMftOrderList
extends AbstractListPlugin {
    private static final String BILLLISTAP = "billlistap";
    private static final String[] OP_KEYS = new String[]{"invalid", "planconfirm", "transmit", "untransmit", "beginwork", "unbeginwork", "endwork", "unendwork", "hangup", "unhangup", "shut", "unshut", "calmaterial"};

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "ordersplitom": {
                this.beforeOrderSplitOm(operate);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        boolean isSuccess;
        super.afterDoOperation(e);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        String key = e.getOperateKey();
        if (Arrays.asList(OP_KEYS).contains(key)) {
            billList.refresh();
        }
        if ("cps_count".equals(key)) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("status", "=", (Object)"C"));
            filters.add(new QFilter("enable", "=", (Object)"1"));
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"mrp_cps_planpro", (boolean)false);
            showParameter.getListFilterParameter().setQFilters(filters);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        if ("ordersplitom".equals(key) && (isSuccess = e.getOperationResult().isSuccess())) {
            this.afterOrderSplitOm((FormOperate)e.getSource());
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionKey = e.getActionId();
        if (e.getReturnData() != null && "cps_count".equals(actionKey)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
            Object pk = rows.get(0).getPrimaryKeyValue();
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            ListSelectedRowCollection selects = billList.getSelectedRows();
            HashMap<Long, Set<Long>> selectOrderIdMap = new HashMap<Long, Set<Long>>(16);
            HashMap<Long, String> billNoMap = new HashMap<Long, String>(16);
            for (int i = 0; i < selects.size(); ++i) {
                ListSelectedRow row = selects.get(i);
                Object entryPk = row.getEntryPrimaryKeyValue();
                if (entryPk == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5355\u636e\u5206\u5f55\u7684\u4e3b\u952e\uff0c\u8bf7\u68c0\u67e5\u5217\u8868\u6570\u636e\u663e\u793a\u7684\u51c6\u786e\u6027\u3002", (String)"OMMftOrderList_24", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                }
                Long orderId = (Long)row.getPrimaryKeyValue();
                HashSet<Long> set = (HashSet<Long>)selectOrderIdMap.get(orderId);
                if (set == null) {
                    set = new HashSet<Long>(16);
                }
                set.add((Long)entryPk);
                selectOrderIdMap.put(orderId, set);
                billNoMap.put(orderId, row.getBillNo());
            }
            Long dataSourceId = 0L;
            DynamicObjectCollection query = QueryServiceHelper.query((String)"mrp_cps_planpro", (String)"number,scentryentity.entryisscmrpoperat,scentryentity.resourceregisters,scentryentity.entrysupplyres,scentryentity.entrysupplyres.number", (QFilter[])new QFilter[]{new QFilter("id", "=", pk)});
            for (DynamicObject queryEntry : query) {
                if (!"om_mftorder".equals(queryEntry.getString("scentryentity.entrysupplyres.number"))) continue;
                dataSourceId = queryEntry.getLong("scentryentity.resourceregisters");
            }
            if ("0".equals(dataSourceId.toString())) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6307\u5b9a\u7684\u9f50\u5957\u5206\u6790\u65b9\u6848\u3010%1$s\u3011\u4e2d\u7684\u4f9b\u5e94\u53c2\u6570\u6570\u636e\u6e90\u914d\u7f6e\u4e0d\u5305\u62ec\u59d4\u5916\u5de5\u5355\u3002", (String)"OMMftOrderList_25", (String)"mmc-om-formplugin", (Object[])new Object[0]), ((DynamicObject)query.get(0)).getString("number")));
                return;
            }
            DataSet dataSetByModel = DataSourceFetchDataUtil.getDataSetByModel((Long)dataSourceId, null);
            Iterator iterator = dataSetByModel.iterator();
            HashSet<Long> billEntryIdSet = new HashSet<Long>();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                billEntryIdSet.add(row.getLong("entryentity.billentryid"));
            }
            HashSet<String> unpassOrderNo = new HashSet<String>(16);
            List<Long[]> idEntryidValues = this.getOrderIdEntryIdList(billEntryIdSet, selectOrderIdMap, billNoMap, unpassOrderNo);
            if (unpassOrderNo.isEmpty()) {
                Long resId = (Long)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mrp", (String)"IRunCPSService", (String)"startCPS", (Object[])new Object[]{pk, "om_mftorder", idEntryidValues});
                if (resId != null) {
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setFormId("mrp_cps_calc_log");
                    showParameter.setPkId((Object)resId);
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setStatus(OperationStatus.VIEW);
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            } else if (billNoMap.size() > unpassOrderNo.size()) {
                JSONArray josnArray = new JSONArray();
                for (Long[] orderInfo : idEntryidValues) {
                    JSONObject josnStr = new JSONObject();
                    josnStr.put("orderid", (Object)orderInfo[0]);
                    josnStr.put("orderentryid", (Object)orderInfo[1]);
                    josnArray.add((Object)josnStr);
                }
                this.getView().getPageCache().put("idEntryidValues", josnArray.toString());
                this.getView().getPageCache().put("planproid", pk.toString());
                ConfirmCallBackListener callback = new ConfirmCallBackListener("startCPSConfirm", (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u9009\u4e2d%1$s\u6761\u5355\u636e\uff0c\u6709%2$s\u6761\u4e0d\u7b26\u5408\u9f50\u5957\u5206\u6790\u65b9\u6848\u6761\u4ef6\uff0c\u5355\u636e\u7f16\u53f7\u4e3a%3$s\u3002\u662f\u5426\u7ee7\u7eed\u8ba1\u7b97\uff1f", (String)"OMMftOrderList_26", (String)"mmc-om-formplugin", (Object[])new Object[0]), billNoMap.size(), unpassOrderNo.size(), ((Object)unpassOrderNo).toString()), MessageBoxOptions.YesNo, callback);
            } else if (billNoMap.size() == unpassOrderNo.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u5de5\u5355\u6570\u636e\u5747\u4e0d\u7b26\u5408\u9f50\u5957\u5206\u6790\u65b9\u6848\u7684\u6570\u636e\u6e90\u6761\u4ef6\u3002", (String)"OMMftOrderList_27", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if ("startCPSConfirm".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            String jsonstring = this.getView().getPageCache().get("idEntryidValues");
            JSONArray josnArray = JSONArray.parseArray((String)jsonstring);
            ArrayList<Long[]> idEntryidValues = new ArrayList<Long[]>(16);
            for (int i = 0; i < josnArray.size(); ++i) {
                JSONObject josnStr = (JSONObject)josnArray.get(i);
                Long[] orderLong = new Long[]{josnStr.getLong("orderid"), josnStr.getLong("orderentryid")};
                idEntryidValues.add(orderLong);
            }
            String planproid = this.getView().getPageCache().get("planproid");
            Long resId = (Long)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mrp", (String)"IRunCPSService", (String)"startCPS", (Object[])new Object[]{Long.parseLong(planproid), "om_mftorder", idEntryidValues});
            if (resId != null) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId("mrp_cps_calc_log");
                showParameter.setPkId((Object)resId);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    private List<Long[]> getOrderIdEntryIdList(Set<Long> billEntryIdSet, Map<Long, Set<Long>> selectOrderIdMap, Map<Long, String> billNoMap, Set<String> unpassOrderNo) {
        HashSet<Long> unpassOrderId = new HashSet<Long>(16);
        for (Map.Entry<Long, Set<Long>> m : selectOrderIdMap.entrySet()) {
            Long orderId = m.getKey();
            Set<Long> orderEntryIdSet = m.getValue();
            for (Long orderEntryId : orderEntryIdSet) {
                if (billEntryIdSet.contains(orderEntryId)) continue;
                unpassOrderId.add(orderId);
                unpassOrderNo.add(billNoMap.get(orderId));
            }
        }
        ArrayList<Long[]> idEntryidValues = new ArrayList<Long[]>(16);
        for (Map.Entry<Long, Set<Long>> m : selectOrderIdMap.entrySet()) {
            Long orderId = m.getKey();
            if (unpassOrderId.contains(orderId)) continue;
            for (Long orderEntryId : m.getValue()) {
                Long[] orderLong = new Long[]{orderId, orderEntryId};
                idEntryidValues.add(orderLong);
            }
        }
        return idEntryidValues;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "ompushpick": 
            case "ompushreceive": 
            case "ompushreturn": 
            case "ompushomcmplin": 
            case "ompushtrans": 
            case "ompushreq": {
                this.pushPick(itemKey);
                break;
            }
        }
    }

    private void pushPick(String type) {
        StringBuilder thisErrormsg;
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selects = billList.getSelectedRows();
        IFormView view = this.getView();
        if (null == selects || selects.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"OMMftOrderList_9", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            return;
        }
        ConvertOpParameter opParameter = null;
        if ("ompushreceive".equals(type) || "ompushomcmplin".equals(type)) {
            opParameter = OrderBusinessHelper.getReceiveConvertOpParameter((String)type);
            ListSelectedRowCollection selectedRows = this.getListSelectedRows(selects);
            if (selectedRows.isEmpty()) {
                String format = String.format(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u4e0b\u6e38\u65e0\u91c7\u8d2d\u8ba2\u5355\u6570\u636e\u3002", (String)"OMMftOrderList_8", (String)"mmc-om-formplugin", (Object[])new Object[0]), new Object[0]);
                this.getView().showMessage(format);
                return;
            }
            opParameter.setSelectedRows(selectedRows);
            if (opParameter != null && opParameter.getSelectedRows().size() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u5173\u8054\u7684\u91c7\u8d2d\u8ba2\u5355\u4e0d\u5b58\u5728\u9700\u8981\u4e0b\u63a8\u7684\u6570\u636e\u3002", (String)"OMMftOrderList_10", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if ("ompushpick".equals(type) || "ompushreturn".equals(type)) {
            thisErrormsg = this.pushCheck(selects);
            if (thisErrormsg.length() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u9886\u6599\u5931\u8d25\u3002", (String)"OMMftOrderList_11", (String)"mmc-om-formplugin", (Object[])new Object[0]), thisErrormsg.toString(), null);
                return;
            }
            opParameter = MftOrderToProorderUtil.buildParameter((IFormView)view, null, (String)type);
            if (opParameter != null && opParameter.getSelectedRows().size() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u5173\u8054\u7684\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\u65e0\u4e0b\u63a8\u6570\u636e\u3002", (String)"OMMftOrderList_12", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if ("ompushreq".equals(type)) {
            thisErrormsg = this.pushCheck(selects);
            if (thisErrormsg.length() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u9886\u6599\u7533\u8bf7\u5931\u8d25\u3002", (String)"OMMftOrderList_23", (String)"mmc-om-formplugin", (Object[])new Object[0]), thisErrormsg.toString(), null);
                return;
            }
            opParameter = MftOrderToProorderUtil.buildParameter((IFormView)view, null, (String)type);
            if (opParameter != null && opParameter.getSelectedRows().size() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u5173\u8054\u7684\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\u65e0\u4e0b\u63a8\u6570\u636e\u3002", (String)"OMMftOrderList_12", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if ("ompushtrans".equals(type)) {
            thisErrormsg = this.pushCheck(selects);
            if (thisErrormsg.length() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u8c03\u62e8\u5931\u8d25\u3002", (String)"OMMftOrderList_21", (String)"mmc-om-formplugin", (Object[])new Object[0]), thisErrormsg.toString(), null);
                return;
            }
            opParameter = MftOrderToProorderUtil.buildParameter((IFormView)view, null, (String)type);
            if (opParameter != null && opParameter.getSelectedRows().size() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u5173\u8054\u7684\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\u65e0\u4e0b\u63a8\u6570\u636e\u3002", (String)"OMMftOrderList_12", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        String opParameterJson = SerializationUtils.toJsonString((Object)opParameter);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getCustomParams().put("opparam", opParameterJson);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4e0b\u63a8", (String)"OMMftOrderList_13", (String)"mmc-om-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("mft_botp_convertop");
        this.getView().showForm(showParameter);
    }

    private ListSelectedRowCollection getListSelectedRows(ListSelectedRowCollection selects) {
        ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
        HashSet<Object> entryPks = new HashSet<Object>(4);
        for (int i = 0; i < selects.size(); ++i) {
            ListSelectedRow row = selects.get(i);
            Object entryPk = row.getEntryPrimaryKeyValue();
            if (entryPk == null) continue;
            entryPks.add(entryPk);
        }
        if (!entryPks.isEmpty()) {
            QFilter qFilter = new QFilter("billentry.mftorderentryid", "in", entryPks);
            QFilter[] qFilters = new QFilter[]{qFilter};
            String algoStr = "omQueryPur";
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoStr, (String)"pm_purorderbill", (String)"id,billentry.id", (QFilter[])qFilters, null);){
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    ListSelectedRow row = new ListSelectedRow(next.get("id"));
                    row.setEntryEntityKey("billentry");
                    row.setEntryPrimaryKeyValue(next.get("billentry.id"));
                    selectedRows.add((Object)row);
                }
            }
        }
        return selectedRows;
    }

    private StringBuilder pushCheck(ListSelectedRowCollection selects) {
        StringBuilder thisErrormsg = new StringBuilder();
        if (!selects.isEmpty()) {
            HashSet<Object> entryPkSet = new HashSet<Object>(selects.size());
            for (ListSelectedRow row : selects) {
                Object entryPk = row.getEntryPrimaryKeyValue();
                if (entryPk == null) continue;
                entryPkSet.add(entryPk);
            }
            if (entryPkSet.isEmpty()) {
                thisErrormsg.append(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5355\u636e\u5206\u5f55\u7684\u4e3b\u952e\uff0c\u8bf7\u68c0\u67e5\u5217\u8868\u6570\u636e\u7684\u51c6\u786e\u6027\u3002", (String)"OMMftOrderList_22", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                return thisErrormsg;
            }
            QFilter qfilter = new QFilter("treeentryentity.id", "in", entryPkSet);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-OMMftOrderList-getDataMap", (String)"om_mftorder", (String)"billno,treeentryentity.id entryid,treeentryentity.producttype producttype ,treeentryentity.planstatus planstatus ,treeentryentity.bizstatus bizstatus ,treeentryentity.seq seq", (QFilter[])new QFilter[]{qfilter}, (String)"");){
                while (ds.hasNext()) {
                    Row dsRow = ds.next();
                    String producttype = dsRow.getString("producttype");
                    String planstatus = dsRow.getString("planstatus");
                    String bizstatus = dsRow.getString("bizstatus");
                    StringJoiner tErrormsg = new StringJoiner(";");
                    if (!"C".equals(producttype)) {
                        tErrormsg.add(ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u578b\u4e0d\u4e3a\u4e3b\u4ea7\u54c1", (String)"OMMftOrderList_14", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                    }
                    if (!"A".equals(bizstatus)) {
                        tErrormsg.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u201c\u6b63\u5e38\u201d", (String)"OMMftOrderList_15", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                    }
                    if (!"C".equals(planstatus)) {
                        tErrormsg.add(ResManager.loadKDString((String)"\u8ba1\u5212\u72b6\u6001\u4e0d\u4e3a\u201c\u4e0b\u8fbe\u201d", (String)"OMMftOrderList_16", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                    }
                    if (tErrormsg.length() <= 0) continue;
                    String mgs = String.format(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355%1$s\u7b2c%2$s\u884c:", (String)"OMMftOrderList_20", (String)"mmc-om-formplugin", (Object[])new Object[0]), dsRow.getString("billno"), dsRow.getInteger("seq"));
                    StringBuilder sb = new StringBuilder();
                    sb.append(mgs);
                    sb.append(tErrormsg);
                    sb.append("\u3002");
                    sb.append("\n");
                    thisErrormsg.append((CharSequence)sb);
                }
            }
        }
        return thisErrormsg;
    }

    private void beforeOrderSplitOm(FormOperate operate) {
        BillList OrderBillList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selects = OrderBillList.getSelectedRows();
        ArrayList<Long> billSelectRowList = new ArrayList<Long>(10);
        for (int i = 0; i < selects.size(); ++i) {
            ListSelectedRow row = selects.get(i);
            long billSelectRowId = Long.parseLong(row.getEntryPrimaryKeyValue().toString());
            billSelectRowList.add(billSelectRowId);
        }
        if (billSelectRowList.size() > 0) {
            String jsonString = SerializationUtils.toJsonString(billSelectRowList);
            operate.getOption().setVariableValue("billSelectRowList", jsonString);
        }
    }

    private void afterOrderSplitOm(FormOperate operate) {
        FormShowParameter showParameter = OmOrderSplitHelper.splitOrderShowForm();
        showParameter.setCustomParam("isFromMftOrderBill", (Object)"true");
        String billSelectRowList = operate.getOption().getVariableValue("billSelectRowList", "");
        showParameter.setCustomParam("billSelectRowList", (Object)billSelectRowList);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selects = billList.getSelectedRows();
        long mainOrgId = selects.isEmpty() ? RequestContext.get().getOrgId() : selects.get(0).getMainOrgId();
        showParameter.setCustomParam("mainOrgId", (Object)mainOrgId);
        this.getView().showForm(showParameter);
    }
}

