/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.formplugin.processreport;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.manuftech.bean.ManuFetchEntryBean;
import kd.bd.mpdm.common.manuftech.bean.ManuFetchEntryBeanUtils;
import kd.bd.mpdm.common.manuftech.utils.ChangeEntryStartOrCompletionTimeUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCalcWriteValueEventArgs;
import kd.bos.entity.botp.plugin.args.AfterCloseRowEventArgs;
import kd.bos.entity.botp.plugin.args.AfterCommitAmountEventArgs;
import kd.bos.entity.botp.plugin.args.AfterExcessCheckEventArgs;
import kd.bos.entity.botp.plugin.args.AfterReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeCloseRowEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeCreateArticulationRowEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeExcessCheckEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeExecWriteBackRuleEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeTrackEventArgs;
import kd.bos.entity.botp.plugin.args.FinishWriteBackEventArgs;
import kd.bos.entity.botp.plugin.args.PreparePropertysEventArgs;
import kd.bos.entity.botp.plugin.args.RollbackSaveEventArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.om.common.manuftech.utils.ChangeTechnicsBillEntryStatus;
import kd.mmc.om.common.utils.MftGenStocksUtils;

public class OMProcessReportBackWrite
extends AbstractWriteBackPlugIn {
    private static final Log logger = LogFactory.getLog(OMProcessReportBackWrite.class);
    private static final String POM_MFTORDER = "om_mftorder";
    private static final String POM_MFTSTOCK = "om_mftstock";
    private Map<String, DynamicObject> tarMap = new HashMap<String, DynamicObject>();

    public LinkSetItemElement getCurrLinkSetItem() {
        return super.getCurrLinkSetItem();
    }

    public String getOpType() {
        return super.getOpType();
    }

    public BillEntityType getTargetSubMainType() {
        return super.getTargetSubMainType();
    }

    public void setContext(BillEntityType targetSubMainType, String opType, LinkSetItemElement linkSetItem) {
        super.setContext(targetSubMainType, opType, linkSetItem);
    }

    public void preparePropertys(PreparePropertysEventArgs e) {
        super.preparePropertys(e);
        e.getFieldKeys().add("completqty2");
        e.getFieldKeys().add("manufactureentryid");
        e.getFieldKeys().add("oprentryid");
        e.getFieldKeys().add("srcorderid2");
        e.getFieldKeys().add("srcorderentryid2");
        e.getFieldKeys().add("repactualbegintime");
        e.getFieldKeys().add("repactualfinishtime");
        e.getFieldKeys().add("reportdate");
    }

    public void beforeTrack(BeforeTrackEventArgs e) {
        super.beforeTrack(e);
    }

    public void beforeCreateArticulationRow(BeforeCreateArticulationRowEventArgs e) {
        super.beforeCreateArticulationRow(e);
    }

    public void beforeExecWriteBackRule(BeforeExecWriteBackRuleEventArgs e) {
        super.beforeExecWriteBackRule(e);
    }

    public void afterCalcWriteValue(AfterCalcWriteValueEventArgs e) {
        super.afterCalcWriteValue(e);
    }

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
    }

    public void afterReadSourceBill(AfterReadSourceBillEventArgs e) {
        super.afterReadSourceBill(e);
    }

    public void afterCommitAmount(AfterCommitAmountEventArgs e) {
        super.afterCommitAmount(e);
        DynamicObject activeRow = e.getTargetActiveRow();
        String opType = this.getOpType();
        if (!"delete".equalsIgnoreCase(opType)) {
            DynamicObject parent = (DynamicObject)activeRow.getParent();
            this.tarMap.put(parent.getString("id"), parent);
        } else {
            Long billId = e.getTargetRowId().getBillId();
            QFilter billqf = new QFilter("id", "in", (Object)billId);
            String selectColumn = "id,reportdate,manufactureentryid,mroorderentryid,oprentryid,completbaseqty,ischargeoff,srcorderid2,srcorderentryid2,completqty2,qualifyqty2,receiveqty2,workwasteqty2,scrapqty2,junkqty2,repairqty2,reworkqty2,repactualbegintime,repactualfinishtime";
            this.tarMap.put(billId.toString(), BusinessDataServiceHelper.loadSingle((String)"om_processreport", (String)selectColumn, (QFilter[])new QFilter[]{billqf}));
        }
    }

    public void beforeExcessCheck(BeforeExcessCheckEventArgs e) {
        super.beforeExcessCheck(e);
    }

    public void afterExcessCheck(AfterExcessCheckEventArgs e) {
        super.afterExcessCheck(e);
    }

    public void beforeCloseRow(BeforeCloseRowEventArgs e) {
        super.beforeCloseRow(e);
    }

    public void afterCloseRow(AfterCloseRowEventArgs e) {
        super.afterCloseRow(e);
    }

    public void beforeSaveSourceBill(BeforeSaveSourceBillEventArgs e) {
        super.beforeSaveSourceBill(e);
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        ArrayList list = new ArrayList(10);
        this.tarMap.forEach((k, v) -> {
            DynamicObjectCollection sumentitys = v.getDynamicObjectCollection("sumentry");
            for (DynamicObject obj : sumentitys) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)obj.getString("oprentryid"))) continue;
                DynamicObjectCollection dynamicObjectCollection = obj.getDynamicObjectCollection("repsubentryentity");
                Optional<DynamicObject> min = dynamicObjectCollection.stream().min(Comparator.comparing(x -> x.getDate("repactualbegintime")));
                Optional<DynamicObject> max = dynamicObjectCollection.stream().max(Comparator.comparing(x -> x.getDate("repactualfinishtime")));
                list.add(ManuFetchEntryBeanUtils.buildBean((Long)obj.getLong("oprentryid"), min, max, (Date)v.getDate("reportdate")));
            }
        });
        Map<Long, List<ManuFetchEntryBean>> map = list.stream().collect(Collectors.groupingBy(ManuFetchEntryBean::getOprEntry));
        HashMap dateMap = new HashMap(16);
        map.forEach((k, v) -> {
            ManuFetchEntryBean max = v.stream().max(Comparator.comparing(ManuFetchEntryBean::getMax)).orElseGet(() -> new ManuFetchEntryBean());
            ManuFetchEntryBean min = v.stream().min(Comparator.comparing(ManuFetchEntryBean::getMin)).orElseGet(() -> new ManuFetchEntryBean());
            ManuFetchEntryBean bean = new ManuFetchEntryBean();
            bean.setOprEntry(k);
            bean.setMin(min.getMin());
            bean.setMax(max.getMax());
            dateMap.put(k, bean);
        });
        this.tarMap.forEach((k, v) -> {
            DynamicObjectCollection sumentitys = v.getDynamicObjectCollection("sumentry");
            for (DynamicObject obj : sumentitys) {
                DynamicObjectCollection otherProductEntity = obj.getDynamicObjectCollection("otherproductentity");
                for (DynamicObject otherEntry : otherProductEntity) {
                    this.rewriteOrtherProductInfo(otherEntry, this.getOpType().toLowerCase());
                }
                Long entryPkvalue = Long.valueOf(obj.getString("oprentryid"));
                if (entryPkvalue == null) continue;
                DynamicObject manftech = BusinessDataServiceHelper.loadSingle((String)"om_mfttechnics", (String)"id", (QFilter[])new QFilter[]{new QFilter("oprentryentity.id", "=", (Object)entryPkvalue)});
                manftech = BusinessDataServiceHelper.loadSingle((Object)manftech.getPkValue(), (String)"om_mfttechnics");
                DynamicObjectCollection manftechEntrys = manftech.getDynamicObjectCollection("oprentryentity");
                for (DynamicObject manftechentry : manftechEntrys) {
                    if (!manftechentry.getPkValue().toString().equals(entryPkvalue.toString())) continue;
                    ManuFetchEntryBean manuFetchEntryBean = (ManuFetchEntryBean)dateMap.get(entryPkvalue);
                    if ("audit".equalsIgnoreCase(this.getOpType())) {
                        if (StringUtils.equals((CharSequence)"10070", (CharSequence)obj.getString("confirmoprstatus"))) {
                            if (manftechentry.getBigDecimal("oprqty").compareTo(manftechentry.getBigDecimal("oprtotalqualifiedqty").add(manftechentry.getBigDecimal("oprtotalreceiveqty"))) <= 0) {
                                ChangeEntryStartOrCompletionTimeUtil.changeEntryStartOrCompletionTimeToFinish((DynamicObject)manftechentry, (Date)manuFetchEntryBean.getMin(), (Date)manuFetchEntryBean.getMax());
                                ChangeTechnicsBillEntryStatus.changeEntryStatus((String)"F", (boolean)false, (String)"row_finish", (Object)entryPkvalue, (DynamicObject)manftech, (DynamicObjectCollection)manftechEntrys);
                                continue;
                            }
                            ChangeEntryStartOrCompletionTimeUtil.changeEntryStartOrCompletionTimeToStart((DynamicObject)manftechentry, (Date)manuFetchEntryBean.getMin());
                            ChangeTechnicsBillEntryStatus.changeEntryStatus((String)"E", (boolean)false, (String)"row_start", (Object)entryPkvalue, (DynamicObject)manftech, (DynamicObjectCollection)manftechEntrys);
                            continue;
                        }
                        if (!StringUtils.equals((CharSequence)"10080", (CharSequence)obj.getString("confirmoprstatus"))) continue;
                        ChangeEntryStartOrCompletionTimeUtil.changeEntryStartOrCompletionTimeToFinish((DynamicObject)manftechentry, (Date)manuFetchEntryBean.getMin(), (Date)manuFetchEntryBean.getMax());
                        ChangeTechnicsBillEntryStatus.changeEntryStatus((String)"F", (boolean)false, (String)"row_finish", (Object)entryPkvalue, (DynamicObject)manftech, (DynamicObjectCollection)manftechEntrys);
                        continue;
                    }
                    if (!"unaudit".equalsIgnoreCase(this.getOpType()) || manftechentry.getBigDecimal("oprqty").compareTo(manftechentry.getBigDecimal("oprtotalqualifiedqty")) <= 0) continue;
                    manftechentry.set("actualcompletiontime", null);
                    ChangeTechnicsBillEntryStatus.changeEntryStatus((String)"E", (boolean)false, (String)"row_unstart", (Object)entryPkvalue, (DynamicObject)manftech, (DynamicObjectCollection)manftechEntrys);
                }
            }
            this.calUserQty((DynamicObject)v, this.getOpType().toLowerCase());
        });
    }

    public void finishWriteBack(FinishWriteBackEventArgs e) {
        super.finishWriteBack(e);
    }

    public void rollbackSave(RollbackSaveEventArgs e) {
        super.rollbackSave(e);
    }

    private void rewriteOrtherProductInfo(DynamicObject otherentry, String option) {
        String srcorderid = otherentry.getString("srcorderid2");
        String srcorderentryid = otherentry.getString("srcorderentryid2");
        if (srcorderid != null && srcorderentryid != null && !srcorderid.trim().isEmpty()) {
            DynamicObject mftorder = BusinessDataServiceHelper.loadSingle((Object)srcorderid, (String)POM_MFTORDER);
            DynamicObjectCollection orderentrys = mftorder.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject ordentry : orderentrys) {
                if (!ordentry.getPkValue().toString().equals(srcorderentryid)) continue;
                if ("audit".equals(option)) {
                    ordentry.set("qualifiedqty", (Object)ordentry.getBigDecimal("qualifiedqty").add(otherentry.getBigDecimal("qualifyqty2")));
                    ordentry.set("workwasteqty", (Object)ordentry.getBigDecimal("workwasteqty").add(otherentry.getBigDecimal("workwasteqty2")));
                    ordentry.set("mtlcostqty", (Object)ordentry.getBigDecimal("mtlcostqty").add(otherentry.getBigDecimal("scrapqty2")));
                    ordentry.set("acceptqty", (Object)ordentry.getBigDecimal("acceptqty").add(otherentry.getBigDecimal("receiveqty2")));
                    ordentry.set("scrapqty", (Object)ordentry.getBigDecimal("scrapqty").add(otherentry.getBigDecimal("junkqty2")));
                    ordentry.set("repairqty", (Object)ordentry.getBigDecimal("repairqty").add(otherentry.getBigDecimal("repairqty2")));
                    ordentry.set("reworkqty", (Object)ordentry.getBigDecimal("reworkqty").add(otherentry.getBigDecimal("reworkqty2")));
                    ordentry.set("reportqty", (Object)ordentry.getBigDecimal("reportqty").add(otherentry.getBigDecimal("completqty2")));
                } else if ("unaudit".equals(option)) {
                    ordentry.set("qualifiedqty", (Object)ordentry.getBigDecimal("qualifiedqty").subtract(otherentry.getBigDecimal("qualifyqty2")));
                    ordentry.set("workwasteqty", (Object)ordentry.getBigDecimal("workwasteqty").subtract(otherentry.getBigDecimal("workwasteqty2")));
                    ordentry.set("mtlcostqty", (Object)ordentry.getBigDecimal("mtlcostqty").subtract(otherentry.getBigDecimal("scrapqty2")));
                    ordentry.set("acceptqty", (Object)ordentry.getBigDecimal("acceptqty").subtract(otherentry.getBigDecimal("receiveqty2")));
                    ordentry.set("scrapqty", (Object)ordentry.getBigDecimal("scrapqty").subtract(otherentry.getBigDecimal("junkqty2")));
                    ordentry.set("repairqty", (Object)ordentry.getBigDecimal("repairqty").subtract(otherentry.getBigDecimal("repairqty2")));
                    ordentry.set("reworkqty", (Object)ordentry.getBigDecimal("reworkqty").subtract(otherentry.getBigDecimal("reworkqty2")));
                    ordentry.set("reportqty", (Object)ordentry.getBigDecimal("reportqty").subtract(otherentry.getBigDecimal("completqty2")));
                } else if ("save".equals(option) || "draft".equals(option)) {
                    ordentry.set("rptqty", (Object)ordentry.getBigDecimal("rptqty").add(otherentry.getBigDecimal("completqty2")));
                } else if ("delete".equals(option)) {
                    ordentry.set("rptqty", (Object)ordentry.getBigDecimal("rptqty").subtract(otherentry.getBigDecimal("completqty2")));
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mftorder});
            }
        }
    }

    private void calUserQty(DynamicObject bill, String operateKey) {
        for (DynamicObject sumentry : bill.getDynamicObjectCollection("sumentry")) {
            Long oprEntryId = sumentry.getLong("oprentryid");
            Long orderEntryId = sumentry.getDynamicObject("manufactureentryid").getLong("id");
            if (oprEntryId == null) continue;
            DynamicObject manftech = BusinessDataServiceHelper.loadSingle((String)"om_mfttechnics", (String)"id", (QFilter[])new QFilter[]{new QFilter("oprentryentity.id,oprentryentity", "=", (Object)oprEntryId)});
            if (!"B".equals((manftech = BusinessDataServiceHelper.loadSingle((Object)manftech.getPkValue(), (String)"om_mfttechnics")).getDynamicObject("transactiontype").get("deduction"))) {
                return;
            }
            QFilter[] qFilter = new QFilter[]{new QFilter("orderid", "=", manftech.get("manufactureorderid")), new QFilter("orderentryid", "=", (Object)orderEntryId)};
            DynamicObjectCollection stock = QueryServiceHelper.query((String)POM_MFTSTOCK, (String)"id", (QFilter[])qFilter);
            for (DynamicObject object : stock) {
                DynamicObject pomMftStock = BusinessDataServiceHelper.loadSingle((Object)object.get(0), (String)POM_MFTSTOCK);
                DynamicObjectCollection manftechEntrys = manftech.getDynamicObjectCollection("oprentryentity");
                for (DynamicObject manftechentry : manftechEntrys) {
                    if (!manftechentry.getPkValue().toString().equals(oprEntryId.toString())) continue;
                    DynamicObjectCollection stockentry = pomMftStock.getDynamicObjectCollection("stockentry");
                    for (DynamicObject dynamicObject : stockentry) {
                        BigDecimal actissueQty = dynamicObject.getBigDecimal("actissueqty");
                        BigDecimal rejectedQty = dynamicObject.getBigDecimal("rejectedqty");
                        BigDecimal feedingQty = dynamicObject.getBigDecimal("feedingqty");
                        boolean isCanNegative = dynamicObject.getBoolean("iscannegative");
                        BigDecimal useQty = BigDecimal.ZERO;
                        if (!isCanNegative) {
                            useQty = this.changeStockWipqty(dynamicObject, orderEntryId);
                        }
                        dynamicObject.set("useqty", (Object)useQty);
                        if ("audit".equals(operateKey)) {
                            dynamicObject.set("wipqty", (Object)actissueQty.subtract(rejectedQty).add(feedingQty).subtract(useQty));
                            continue;
                        }
                        if (!"unaudit".equals(operateKey)) continue;
                        dynamicObject.set("useqty", (Object)BigDecimal.ZERO);
                        dynamicObject.set("wipqty", (Object)actissueQty.subtract(rejectedQty).add(feedingQty).add(BigDecimal.ZERO));
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{pomMftStock});
            }
        }
    }

    private BigDecimal changeStockWipqty(DynamicObject stockEntry, Long orderEntryId) {
        try {
            return MftGenStocksUtils.aculUseQtyC((DynamicObject)stockEntry, (Object)orderEntryId);
        }
        catch (Exception ex) {
            throw new KDException((Throwable)ex, new ErrorCode("OmServiceOrderCloseOpAction", ex.getMessage() != null ? ex.getMessage() : ex.toString()), new Object[0]);
        }
    }
}

