/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.formplugin.quota;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.util.JSONUtils;
import kd.mmc.om.business.helper.BotpHelper;
import kd.mmc.om.business.pojo.ReturnResultInfo;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class MftQuotaPushOrderPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(MftQuotaPushOrderPlugin.class);
    private static final String BD_MEASUREUNITS = "bd_measureunits";
    private static final String BD_MEASUREUNITS_ID = "id";
    private static final int zero = 0;
    private static final String ORG = "org";
    private static final String ENTRYID = "entryid";
    private static final String BILLENTRY = "billentry";
    private static final String SAVE = "save";
    private static final String SUCCESSLIST = "successlist";
    private static final String ISQUOTA = "isquota";
    private static final String QUOTA = "quota";

    public void afterCreateNewData(EventObject evt) {
        IDataModel model = this.getModel();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List applyBillEntryId = (List)formShowParameter.getCustomParam(ENTRYID);
        String bizTime = String.valueOf(this.getModel().getValue("biztime"));
        Long quotaScheme = (Long)formShowParameter.getCustomParam("quotascheme");
        String entityName = (String)formShowParameter.getCustomParam("entityid");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        EntityType EntryEntityType = (EntityType)dataEntityType.getAllEntities().get(BILLENTRY);
        Set matchKeys = (Set)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"msbdQuotaService", (String)"quotaQueryMatchKey", (Object[])new Object[]{quotaScheme});
        if (matchKeys.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u914d\u989d\u5e94\u7528\u65b9\u6848\uff0c\u6216\u5339\u914d\u6761\u4ef6\u4e3a\u7a7a\u3002", (String)"MftQuotaPushOrderPlugin_0", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("billentry.id", "in", (Object)applyBillEntryId);
        HashSet<String> selectlistFields = new HashSet<String>(10);
        if (matchKeys.contains(ORG)) {
            selectlistFields.add(ORG);
        }
        if (matchKeys.contains("material")) {
            selectlistFields.add("billentry.material");
            selectlistFields.add("billentry.materialmasterid");
        }
        if (matchKeys.contains("procedure")) {
            if (EntryEntityType.findProperty("workproid") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u914d\u989d\u5e94\u7528\u65b9\u6848\u5339\u914d\u6761\u4ef6\u4e2d\uff0c\u201c\u5de5\u5e8f\u201d\u5728\u5355\u636e\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u914d\u989d\u5e94\u7528\u65b9\u6848\u914d\u7f6e\u3002", (String)"MftQuotaPushOrderPlugin_10", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                return;
            }
            selectlistFields.add("billentry.workproid");
        }
        Collections.addAll(selectlistFields, BD_MEASUREUNITS_ID, "billno", "billentry.id", "billentry.seq");
        Collections.addAll(selectlistFields, "billentry.qty", "billentry.joinqty", "billentry.unit", "billentry.baseqty", "billentry.joinbaseqty", "billentry.baseunit", "billentry.auxqty", "billentry.auxunit");
        String selectFields = selectlistFields.stream().collect(Collectors.joining(","));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"billentry.id");
        if (!rows.isEmpty()) {
            Integer dataNum = rows.size();
            HashMap<String, Serializable> QuotaCalParam = new HashMap<String, Serializable>(16);
            LinkedHashMap dataInfos = new LinkedHashMap(16);
            for (DynamicObject row : rows) {
                HashMap<String, Object> dataInfo = new HashMap<String, Object>(16);
                if (matchKeys.contains(ORG)) {
                    dataInfo.put(ORG, row.get(ORG));
                }
                if (matchKeys.contains("material")) {
                    if (row.get("billentry.materialmasterid") == null || row.get("billentry.materialmasterid").equals(0L)) {
                        DynamicObject materialpur = MaterialQueryHelper.getDataCacheByID((Object)row.get("billentry.material"));
                        dataInfo.put("material", materialpur == null ? Long.valueOf(0L) : materialpur.get("masterid"));
                    } else {
                        dataInfo.put("material", row.get("billentry.materialmasterid"));
                    }
                }
                if (matchKeys.contains("validdate")) {
                    dataInfo.put("validdate", bizTime);
                }
                if (matchKeys.contains("procedure")) {
                    dataInfo.put("procedure", row.get("billentry.workproid"));
                }
                BigDecimal quotaQty = row.getBigDecimal("billentry.baseqty").subtract(row.getBigDecimal("billentry.joinbaseqty"));
                dataInfo.put("baseQty", quotaQty);
                dataInfo.put("baseUnit", row.get("billentry.baseunit"));
                dataInfos.put(row.get("billentry.id").toString(), dataInfo);
            }
            QuotaCalParam.put("quotaSchemeID", quotaScheme);
            QuotaCalParam.put("dataInfos", dataInfos);
            Map quotaResult = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"msbdQuotaService", (String)"quotaCalculateService", (Object[])new Object[]{QuotaCalParam});
            Boolean isSuccess = (Boolean)quotaResult.get("success");
            if (isSuccess == null || !isSuccess.booleanValue()) {
                if (quotaResult.get("detail") != null && !quotaResult.get("detail").equals("")) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e%1$s", (String)"MftQuotaPushOrderPlugin_1", (String)"mmc-om-formplugin", (Object[])new Object[0]), quotaResult.get("detail")));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u59d4\u5916\u914d\u989d\u5b9a\u4e49\u3001\u914d\u989d\u5e94\u7528\u65b9\u6848\u914d\u7f6e\u6216\u5339\u914d\u6761\u4ef6\u7684\u7b26\u5408\u60c5\u51b5\u3002", (String)"MftQuotaPushOrderPlugin_2", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                }
                return;
            }
            log.info("\u914d\u989d\u7ed3\u679c\u5448\u73b0\u5230\u754c\u9762\u5f00\u59cb\uff1a" + LocalDateTime.now());
            List quotaRecordDetails = (List)quotaResult.get("quotaRecordDetails");
            if (quotaRecordDetails != null) {
                HashSet<Object> unitColl = new HashSet<Object>(rows.size());
                HashMap<Long, Long> idMap = new HashMap<Long, Long>(rows.size());
                for (DynamicObject row : rows) {
                    Long unitId = row.getLong("billentry.unit");
                    Long baseUnitId = row.getLong("billentry.baseunit");
                    Long auxUnitId = row.getLong("billentry.auxunit");
                    unitColl.add(unitId);
                    unitColl.add(baseUnitId);
                    if (auxUnitId != null && auxUnitId != 0L) {
                        unitColl.add(auxUnitId);
                    }
                    Long entryId = row.getLong("billentry.id");
                    Long billId = row.getLong(BD_MEASUREUNITS_ID);
                    idMap.put(entryId, billId);
                }
                QFilter qFilter1 = new QFilter(BD_MEASUREUNITS_ID, "in", unitColl);
                Map units = BusinessDataServiceHelper.loadFromCache((String)BD_MEASUREUNITS, (QFilter[])new QFilter[]{qFilter1});
                int rowId = 0;
                for (DynamicObject rowData : rows) {
                    for (int n = 0; n < quotaRecordDetails.size(); ++n) {
                        Map quotaInfos;
                        Map recordDetail = (Map)quotaRecordDetails.get(n);
                        if (recordDetail.get("dataSuccess") == null || !((Boolean)recordDetail.get("dataSuccess")).booleanValue() || !rowData.getString("billentry.id").equals(recordDetail.get("dataKey").toString()) || (quotaInfos = (Map)recordDetail.get("quotaCalculateResultInfos")) == null) continue;
                        for (int m = 1; m < 999; ++m) {
                            List quotaedInfoLst = (List)quotaInfos.get(m);
                            if (quotaedInfoLst == null) continue;
                            model.batchCreateNewEntryRow("resultentryentity", quotaedInfoLst.size());
                            BigDecimal qtyZero = new BigDecimal(0);
                            for (int i = 0; i < quotaedInfoLst.size(); ++i) {
                                BigDecimal maxBaseQty = new BigDecimal(((Map)quotaedInfoLst.get(i)).get("maxBaseQty") != null ? ((Map)quotaedInfoLst.get(i)).get("maxBaseQty").toString() : qtyZero.toString());
                                BigDecimal minBaseQty = new BigDecimal(((Map)quotaedInfoLst.get(i)).get("minBaseQty") != null ? ((Map)quotaedInfoLst.get(i)).get("minBaseQty").toString() : qtyZero.toString());
                                BigDecimal packageBaseQty = new BigDecimal(((Map)quotaedInfoLst.get(i)).get("packageBaseQty") != null ? ((Map)quotaedInfoLst.get(i)).get("packageBaseQty").toString() : qtyZero.toString());
                                model.setValue("supplyrank", (Object)m, rowId);
                                model.setValue("resultmaterial", (Object)rowData.getLong("billentry.material"), rowId);
                                model.setValue("resultsupplier", ((Map)quotaedInfoLst.get(i)).get("supplier"), rowId);
                                model.setValue("quotarate", ((Map)quotaedInfoLst.get(i)).get("quotarate"), rowId);
                                BigDecimal allotbaseqty = new BigDecimal(((Map)quotaedInfoLst.get(i)).get("quotaedBaseQty") != null ? ((Map)quotaedInfoLst.get(i)).get("quotaedBaseQty").toString() : qtyZero.toString());
                                BigDecimal baseQty = new BigDecimal(((Map)quotaedInfoLst.get(i)).get("srcAdjustBaseQty") != null ? ((Map)quotaedInfoLst.get(i)).get("srcAdjustBaseQty").toString() : qtyZero.toString());
                                DynamicObject baseUnit = (DynamicObject)units.get(rowData.getLong("billentry.baseunit"));
                                Long baseUnitId = baseUnit == null ? 0L : baseUnit.getLong(BD_MEASUREUNITS_ID);
                                DynamicObject unit = (DynamicObject)units.get(rowData.getLong("billentry.unit"));
                                Long unitId = unit == null ? 0L : unit.getLong(BD_MEASUREUNITS_ID);
                                DynamicObject auxUnit = (DynamicObject)units.get(rowData.getLong("billentry.auxunit"));
                                Long auxUnitId = auxUnit == null ? 0L : auxUnit.getLong(BD_MEASUREUNITS_ID);
                                if (((Map)quotaedInfoLst.get(i)).get("material") != null) {
                                    Long materialID = Long.valueOf(((Map)quotaedInfoLst.get(i)).get("material").toString());
                                    BigDecimal qty = UnitConvertHelper.calculateNewQty((BigDecimal)baseQty, (Long)unitId, (Long)baseUnitId, (Long)materialID, (StringBuilder)new StringBuilder());
                                    BigDecimal allotqty = UnitConvertHelper.calculateNewQty((BigDecimal)allotbaseqty, (Long)unitId, (Long)baseUnitId, (Long)materialID, (StringBuilder)new StringBuilder());
                                    BigDecimal auxQty = UnitConvertHelper.calculateNewQty((BigDecimal)baseQty, (Long)auxUnitId, (Long)baseUnitId, (Long)materialID, (StringBuilder)new StringBuilder());
                                    BigDecimal maxQty = UnitConvertHelper.calculateNewQty((BigDecimal)maxBaseQty, (Long)unitId, (Long)baseUnitId, (Long)materialID, (StringBuilder)new StringBuilder());
                                    BigDecimal minQty = UnitConvertHelper.calculateNewQty((BigDecimal)minBaseQty, (Long)unitId, (Long)baseUnitId, (Long)materialID, (StringBuilder)new StringBuilder());
                                    model.setValue("quotaqty", (Object)qty, rowId);
                                    model.setValue("allotqty", (Object)allotqty, rowId);
                                    model.setValue("auxqty", (Object)auxQty, rowId);
                                    model.setValue("maxbillqty", (Object)maxQty, rowId);
                                    model.setValue("minbillqty", (Object)minQty, rowId);
                                }
                                model.setValue("baseqty", (Object)baseQty, rowId);
                                model.setValue("baseunit", (Object)baseUnit, rowId);
                                model.setValue("resultunit", (Object)unit, rowId);
                                model.setValue("auxunit", (Object)auxUnit, rowId);
                                model.setValue("packagebatchqty", (Object)packageBaseQty, rowId);
                                DynamicObject purQuota = BusinessDataServiceHelper.loadSingleFromCache((String)"pm_purquota", (QFilter[])new QFilter[]{new QFilter(BD_MEASUREUNITS_ID, "in", ((Map)quotaedInfoLst.get(i)).get("quotaId"))});
                                model.setValue("purquotanum", (Object)purQuota, rowId);
                                DynamicObject quotacalrule = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_quotacalrule", (QFilter[])new QFilter[]{new QFilter(BD_MEASUREUNITS_ID, "in", recordDetail.get("quotaCalRuleID"))});
                                model.setValue("quotacalrule", (Object)quotacalrule, rowId);
                                model.setValue("srcbillentryid", (Object)rowData.getLong("billentry.id"), rowId);
                                model.setValue("srcbillid", idMap.get(rowData.get("billentry.id")), rowId);
                                ++rowId;
                            }
                        }
                    }
                }
                String result = String.format(ResManager.loadKDString((String)"\u6839\u636e\u914d\u989d\u8ba1\u7b97\uff0c\u9009\u4e2d\u7684%1$s\u884c\u7533\u8bf7\u5355\u5206\u5f55\u4e2d\u6709%2$s\u884c\u88ab\u62c6\u5206\u4e3a%3$s\u884c\u3002", (String)"MftQuotaPushOrderPlugin_3", (String)"mmc-om-formplugin", (Object[])new Object[0]), dataNum, quotaRecordDetails.size(), rowId);
                Label labelAp = (Label)this.getView().getControl("labelap");
                labelAp.setText(result);
                log.info("\u914d\u989d\u7ed3\u679c\u5448\u73b0\u5230\u754c\u9762\u7ed3\u675f\uff1a" + LocalDateTime.now());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Date biztime = (Date)model.getValue("biztime");
        if (biztime == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u5355\u65e5\u671f\u3002", (String)"MftQuotaPushOrderPlugin_4", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            DynamicObject dataEntity = changeData.getDataEntity();
            int rowIndex = changeData.getRowIndex();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                return;
            }
            if (!"quotaqty".equals(fieldKey)) continue;
            DynamicObject auxUnit = dataEntity.getDynamicObject("auxunit");
            Long auxUnitId = auxUnit == null ? 0L : auxUnit.getLong(BD_MEASUREUNITS_ID);
            DynamicObject material = dataEntity.getDynamicObject("resultmaterial");
            DynamicObject masterid = material.getDynamicObject("masterid");
            if (null == masterid) {
                return;
            }
            Long materialmasterid = (Long)masterid.getPkValue();
            DynamicObject baseUnit = dataEntity.getDynamicObject("baseunit");
            Long baseUnitId = baseUnit == null ? 0L : baseUnit.getLong(BD_MEASUREUNITS_ID);
            DynamicObject resultUnit = dataEntity.getDynamicObject("resultunit");
            Long resultUnitId = resultUnit == null ? 0L : resultUnit.getLong(BD_MEASUREUNITS_ID);
            BigDecimal resultQty = (BigDecimal)newValue;
            BigDecimal baseUnitQty = UnitConvertHelper.calculateNewQty((BigDecimal)resultQty, (Long)baseUnitId, (Long)resultUnitId, (Long)materialmasterid, (StringBuilder)new StringBuilder());
            model.setValue("baseqty", (Object)baseUnitQty, rowIndex);
            String unitConvertDir = masterid.getString("unitconvertdir");
            if (!StringUtils.equals((CharSequence)"A", (CharSequence)unitConvertDir) && !StringUtils.equals((CharSequence)"C", (CharSequence)unitConvertDir)) continue;
            BigDecimal changeAuxQty = UnitConvertHelper.calculateNewQty((BigDecimal)resultQty, (Long)auxUnitId, (Long)resultUnitId, (Long)materialmasterid, (StringBuilder)new StringBuilder());
            model.setValue("auxqty", (Object)changeAuxQty, rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if ("generateorder".equals(key)) {
            DynamicObject bill = model.getDataEntity(true);
            DynamicObjectCollection entryRow = bill.getDynamicObjectCollection("resultentryentity");
            ArrayList<Integer> qtyEmptyRow = new ArrayList<Integer>(10);
            EntryGrid entry = (EntryGrid)this.getControl("resultentryentity");
            int[] selectRows = entry.getSelectRows();
            int size = selectRows.length > entryRow.size() ? entryRow.size() : selectRows.length;
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                DynamicObject row = (DynamicObject)entryRow.get(rowIndex);
                BigDecimal quotaqty = row.getBigDecimal("quotaqty");
                if (BigDecimal.ZERO.compareTo(quotaqty) != 0) continue;
                int rowNum = rowIndex + 1;
                qtyEmptyRow.add(rowNum);
            }
            if (qtyEmptyRow.size() > 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u914d\u989d\u6570\u91cf\u201d\u3002", (String)"MftQuotaPushOrderPlugin_5", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c", (String)"MftQuotaPushOrderPlugin_6", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            } else {
                ArrayListValuedHashMap rowSupplier = new ArrayListValuedHashMap(selectRows.length);
                for (int i = 0; i < selectRows.length; ++i) {
                    int rowIndex = selectRows[i];
                    DynamicObject supplier = (DynamicObject)this.getModel().getValue("resultsupplier", rowIndex);
                    Long supplierId = (Long)supplier.getPkValue();
                    DynamicObject row = this.getModel().getEntryRowEntity("resultentryentity", rowIndex);
                    rowSupplier.put((Object)supplierId, (Object)row);
                }
                this.createOrder(selectRows, (MultiValuedMap<Long, DynamicObject>)rowSupplier);
            }
        }
    }

    protected void createOrder(int[] selectRows, MultiValuedMap<Long, DynamicObject> rowSupplier) {
        HashMap<Long, Long> sourceIdMap = new HashMap<Long, Long>(selectRows.length);
        HashMap<String, String> param = new HashMap<String, String>(selectRows.length);
        HashMap<String, Object> subParam = new HashMap<String, Object>(16);
        HashMap<Boolean, String> isSuccess = new HashMap<Boolean, String>(rowSupplier.size());
        ArrayList successList = new ArrayList(selectRows.length);
        Date bizTime = (Date)this.getModel().getValue("biztime");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityName = (String)formShowParameter.getCustomParam("entityid");
        for (Long groupKey : rowSupplier.keySet()) {
            param.put("biztime", String.valueOf(bizTime.getTime()));
            param.put(ISQUOTA, QUOTA);
            Collection groupValue = rowSupplier.get((Object)groupKey);
            Iterator iterator = groupValue.iterator();
            while (iterator.hasNext()) {
                DynamicObject entryRow = (DynamicObject)iterator.next();
                BigDecimal baseQty = entryRow.getBigDecimal("baseqty");
                if (baseQty != null && baseQty.compareTo(BigDecimal.ZERO) == 0) continue;
                subParam.put("supplier", entryRow.getDynamicObject("resultsupplier").getPkValue());
                subParam.put("qty", entryRow.getBigDecimal("quotaqty"));
                subParam.put("baseqty", baseQty);
                subParam.put("auxqty", entryRow.getBigDecimal("auxqty"));
                try {
                    param.put(entryRow.get("srcbillentryid").toString(), JSONUtils.toString(subParam));
                }
                catch (IOException e) {
                    log.error(e.fillInStackTrace());
                    throw new KDBizException(ResManager.loadKDString((String)"JSON\u8f6c\u6362\u5f02\u5e38\u3002", (String)"MftQuotaPushOrderPlugin_7", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                }
                Long billEntryID = entryRow.getLong("srcbillentryid");
                Long billID = entryRow.getLong("srcbillid");
                sourceIdMap.put(billEntryID, billID);
                subParam.clear();
            }
            String targetBySrcBill = this.getTargetBySrcBill(entityName);
            if (StringUtils.isEmpty((CharSequence)targetBySrcBill)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u5b9e\u4f53%1$s\u672a\u83b7\u53d6\u5230\u5206\u5f55\u914d\u7f6e\u4fe1\u606f\u3002", (String)"MftQuotaPushOrderPlugin_8", (String)"mmc-om-formplugin", (Object[])new Object[0]), entityName));
            }
            String[] split = targetBySrcBill.split(",");
            ReturnResultInfo resultInfo = BotpHelper.botpGenerateTargetBill(sourceIdMap, (String)entityName, (String)BILLENTRY, (String)split[0], (String)split[1], (String)SAVE, param);
            if (resultInfo.isSuccess()) {
                successList.addAll(resultInfo.getSuccessList());
            }
            isSuccess.put(resultInfo.isSuccess(), resultInfo.getMessage());
            param.clear();
            sourceIdMap.clear();
        }
        boolean flag = true;
        String message = null;
        for (Map.Entry entryInfo : isSuccess.entrySet()) {
            if (entryInfo.getKey() == null || !((Boolean)entryInfo.getKey()).equals(Boolean.FALSE)) continue;
            message = (String)entryInfo.getValue();
            flag = false;
            break;
        }
        if (flag) {
            HashMap<String, Cloneable> returnData = new HashMap<String, Cloneable>(2);
            returnData.put("biztime", bizTime);
            returnData.put(SUCCESSLIST, successList);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u4e0b\u63a8%1$s\u3002", (String)"MftQuotaPushOrderPlugin_9", (String)"mmc-om-formplugin", (Object[])new Object[0]), message));
        }
    }

    private String getTargetBySrcBill(String srcBill) {
        HashMap<String, String> mapping = new HashMap<String, String>(2);
        mapping.put("pm_outapplybill", "pm_om_purorderbill,billentry");
        mapping.put("pm_purapplybill", "om_mftorder,treeentryentity");
        return (String)mapping.get(srcBill);
    }
}

