/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.formplugin.quota;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class MftQutoOrderOprPlugin
extends AbstractFormPlugin
implements BeforeBindDataListener {
    private static final String CREATION = "qyeryopr";
    private static final String PCREATION = "creation";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList != null) {
            billList.addBeforeBindDataListener((BeforeBindDataListener)this);
        }
        this.addClickListeners(new String[]{"procedure"});
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
        IDataModel model = this.getModel();
        BillList param = (BillList)beforeBindDataEvent.getSource();
        FilterParameter filterParameter = param.getFilterParameter();
        List qFilters = filterParameter.getQFilters();
        QFilter qFilter = this.getQFilter();
        if (qFilter != null) {
            qFilters.add(qFilter);
            String s = SerializationUtils.toJsonString((Object)qFilter);
            this.getPageCache().put("filter", s);
        } else {
            this.getPageCache().remove("filter");
        }
    }

    private QFilter getQFilter() {
        QFilter qFilter = null;
        List<Object> procedurStrs = this.getQueryProcedurIds();
        if (procedurStrs != null && !procedurStrs.isEmpty()) {
            qFilter = new QFilter("billentry.workproexp", "in", procedurStrs);
        }
        return qFilter;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        BillList billList = (BillList)this.getControl("billlistap");
        switch (key) {
            case "importapply": {
                QFilter qFilter = this.getQFilter();
                FilterParameter filterParameter = billList.getFilterParameter();
                List qFilters = filterParameter.getQFilters();
                if (qFilter != null) {
                    qFilters.add(qFilter);
                }
                billList.clearSelection();
                billList.refresh();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"procedure", (CharSequence)control.getKey())) {
            QFilter qFilter = new QFilter("status", "=", (Object)"C");
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            ListFilterParameter lfp = new ListFilterParameter();
            lfp.setFilter(qFilter);
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"mpdm_workprocedure", (boolean)true);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            lsp.setListFilterParameter(lfp);
            lsp.setUseOrgId(((Long)org.getPkValue()).longValue());
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CREATION));
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    private List<Object> getQueryProcedurIds() {
        String procedures = (String)this.getModel().getValue("procedure");
        ArrayList<Object> procedureStrs = new ArrayList<Object>(16);
        if (StringUtils.isNotEmpty((CharSequence)procedures)) {
            String[] split = procedures.split(";");
            for (int i = 0; i < split.length; ++i) {
                procedureStrs.add(split[i]);
            }
        }
        return procedureStrs;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        IDataModel model = this.getModel();
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)CREATION)) {
            HashSet<String> values = new HashSet<String>(10);
            ListSelectedRowCollection returnDatas = (ListSelectedRowCollection)e.getReturnData();
            if (returnDatas == null || returnDatas.size() < 1) {
                return;
            }
            for (ListSelectedRow returnData : returnDatas) {
                if (!StringUtils.isNotEmpty((CharSequence)returnData.getName())) continue;
                values.add(returnData.getName());
            }
            if (values.size() > 0) {
                model.setValue("procedure", (Object)String.join((CharSequence)";", values));
                this.getView().updateView("procedure");
            }
        }
    }
}

