/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.formplugin.quota.tpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.helper.OrgHelper;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.mmc.om.common.enums.StatusEnum;

public class MftQuotaOrderTplPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
BeforeBindDataListener {
    private static final Log log = LogFactory.getLog(MftQuotaOrderTplPlugin.class);
    private static final String ISQUOTACONTROL = "isquotacontrol";
    private static final String CREATION = "creation";
    private static final String SUCCESSLIST = "successlist";
    public static final String OM_QUOTAPUSHORDER = "om_quotapushorder";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getListUserOption().setMergeRow(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        BasedataEdit qutoScheme = (BasedataEdit)this.getControl("quotascheme");
        MulBasedataEdit querymaterial = (MulBasedataEdit)this.getControl("querymaterial");
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (billList != null) {
            billList.addBeforeBindDataListener((BeforeBindDataListener)this);
        }
        if (querymaterial != null) {
            querymaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (qutoScheme != null) {
            qutoScheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (newValue == null) {
            if ("org".equals(propName)) {
                model.setValue("querymaterial", null);
                return;
            }
            if ("billtype".equals(propName)) {
                model.setValue("quotascheme", null);
                return;
            }
        } else {
            if ("org".equals(propName)) {
                model.setValue("querymaterial", null);
                return;
            }
            if ("billtype".equals(propName)) {
                model.setValue("quotascheme", null);
                return;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"quotascheme", (CharSequence)propName)) {
                DynamicObject qutoScheme = (DynamicObject)newValue;
                Set matchKeys = (Set)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"msbdQuotaService", (String)"quotaQueryMatchKey", (Object[])new Object[]{qutoScheme.getPkValue()});
                if (matchKeys.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u914d\u989d\u5e94\u7528\u65b9\u6848\uff0c\u6216\u5339\u914d\u6761\u4ef6\u4e3a\u7a7a\u3002", (String)"MftQuotaOrderTplPlugin_7", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                    model.setValue("quotascheme", oldValue);
                    return;
                }
                DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
                if (billType != null) {
                    DynamicObject billformid = billType.getDynamicObject("billformid");
                    String entityName = billformid == null ? "" : billformid.getString("number");
                    MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
                    EntityType EntryEntityType = (EntityType)dataEntityType.getAllEntities().get("billentry");
                    if (matchKeys.contains("procedure") && EntryEntityType.findProperty("workproid") == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u914d\u989d\u5e94\u7528\u65b9\u6848\u5339\u914d\u6761\u4ef6\u4e2d\uff0c\u201c\u5de5\u5e8f\u201d\u5728\u5355\u636e\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u914d\u989d\u5e94\u7528\u65b9\u6848\u914d\u7f6e\u3002", (String)"MftQuotaOrderTplPlugin_8", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                        model.setValue("quotascheme", oldValue);
                        return;
                    }
                }
            }
        }
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
        BillList param = (BillList)beforeBindDataEvent.getSource();
        QFilter qFilter = this.getQFilter();
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setFilter(qFilter);
        param.setFilterParameter(filterParameter);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        BillList billList = (BillList)this.getControl("billlistap");
        Date currentDate = new Date();
        model.setValue("applydate_startdate", (Object)DateUtils.getStartOfDay((Date)currentDate));
        model.setValue("applydate_enddate", (Object)DateUtils.getEndOfDay((Date)currentDate));
        Long defaultOrg = OrgHelper.getDefaultOrg((String)this.getView().getEntityId(), (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
        if (defaultOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6709\u6743\u9650\u7684\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"MftQuotaOrderTplPlugin_0", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            billList.clearData();
            return;
        }
        model.setValue("org", (Object)defaultOrg);
        QFilter qFilter = this.getQFilter();
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setFilter(qFilter);
        billList.setFilterParameter(filterParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Object billTYpe;
        Object purchaseorg;
        String fieldKey = e.getProperty().getName();
        String formId = this.getView().getEntityId();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if ("org".equals(fieldKey)) {
            List hasPermissionOrg = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
            QFilter filterOrg = new QFilter("id", "in", (Object)hasPermissionOrg);
            showParameter.getListFilterParameter().setFilter(filterOrg);
        }
        if ("querymaterial".equals(fieldKey) && (purchaseorg = this.getModel().getValue("org")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"MftQuotaOrderTplPlugin_1", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if ("quotascheme".equals(fieldKey) && (billTYpe = this.getModel().getValue("billtype")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"MftQuotaOrderTplPlugin_6", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        DynamicObject purOrg = (DynamicObject)this.getModel().getValue("org");
        switch (key) {
            case "importapply": {
                List<Object> queryMaterialIds = this.getQueryMaterialIds();
                if (queryMaterialIds == null || queryMaterialIds.size() <= 500000) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u67e5\u8be2\u8303\u56f4\u8fc7\u5927\uff0c\u8bf7\u7f29\u5c0f\u8303\u56f4\u3002", (String)"MftQuotaOrderTplPlugin_2", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "quotacalculate": {
                DynamicObject quotaScheme = (DynamicObject)this.getModel().getValue("quotascheme");
                if (quotaScheme == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u914d\u989d\u5e94\u7528\u65b9\u6848\u3002", (String)"MftQuotaOrderTplPlugin_3", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRow = billList.getSelectedRows();
                if (selectedRow == null || selectedRow.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c", (String)"MftQuotaOrderTplPlugin_4", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (selectedRow == null || selectedRow.size() <= 5000) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u7f29\u5c0f\u6570\u636e\u8303\u56f4\u3002", (String)"MftQuotaOrderTplPlugin_5", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        BillList billList = (BillList)this.getControl("billlistap");
        switch (key) {
            case "importapply": {
                QFilter qFilter = this.getQFilter();
                FilterParameter filterParameter = new FilterParameter();
                filterParameter.setFilter(qFilter);
                billList.setFilterParameter(filterParameter);
                billList.clearSelection();
                billList.refresh();
                break;
            }
            case "quotacalculate": {
                ListSelectedRowCollection selectedRow = billList.getSelectedRows();
                if (selectedRow == null || selectedRow.isEmpty()) break;
                this.openCreateOrder();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        BillList billList = (BillList)this.getControl("billlistap");
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals(CREATION)) {
            FilterParameter filterParameter = new FilterParameter();
            QFilter qFilter1 = this.getQFilter();
            String s = this.getPageCache().get("filter");
            if (StringUtils.isNotEmpty((CharSequence)s)) {
                QFilter f = (QFilter)SerializationUtils.fromJsonString((String)s, QFilter.class);
                qFilter1.and(f);
            }
            filterParameter.setFilter(qFilter1);
            billList.setFilterParameter(filterParameter);
            billList.refresh();
            billList.clearSelection();
            DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtype");
            String entityNum = null;
            if (billtype != null) {
                DynamicObject billformid = billtype.getDynamicObject("billformid");
                entityNum = billformid == null ? "" : billformid.getString("number");
            }
            Object returnDataObj = closedCallBackEvent.getReturnData();
            log.info("\u914d\u989d\u4e0b\u5355\u751f\u6210\u7684\u76ee\u6807\u5355ID" + returnDataObj);
            if (returnDataObj instanceof Map && StringUtils.isNotBlank((CharSequence)entityNum)) {
                Map returnData = (Map)returnDataObj;
                List successList = (List)returnData.get(SUCCESSLIST);
                ListShowParameter lsp = new ListShowParameter();
                String targetBySrcBill = this.getTargetBySrcBill(entityNum);
                String[] split = targetBySrcBill.split(",");
                lsp.setBillFormId(split[0]);
                lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                QFilter qFilter = new QFilter("id", "in", (Object)successList);
                ListFilterParameter lfp = new ListFilterParameter();
                lfp.setFilter(qFilter);
                lsp.setListFilterParameter(lfp);
                lsp.setUseOrgId(((Long)org.getPkValue()).longValue());
                this.getView().showForm((FormShowParameter)lsp);
            }
        }
    }

    private String getTargetBySrcBill(String srcBill) {
        HashMap<String, String> mapping = new HashMap<String, String>(2);
        mapping.put("pm_outapplybill", "pm_om_purorderbill,billentry");
        mapping.put("pm_purapplybill", "om_mftorder,treeentryentity");
        return (String)mapping.get(srcBill);
    }

    private void openCreateOrder() {
        BillList billList = (BillList)this.getControl("billlistap");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject quotaScheme = (DynamicObject)this.getModel().getValue("quotascheme");
        DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtype");
        ListSelectedRowCollection selectedRow = billList.getSelectedRows();
        HashSet<Long> purApplyBillId = new HashSet<Long>(selectedRow.size());
        for (ListSelectedRow listSelectedRow : selectedRow) {
            if (listSelectedRow == null || listSelectedRow.getPrimaryKeyValue() == null) continue;
            Long entryId = (Long)listSelectedRow.getEntryPrimaryKeyValue();
            purApplyBillId.add(entryId);
        }
        String entityNum = null;
        if (billtype != null) {
            DynamicObject billformid = billtype.getDynamicObject("billformid");
            entityNum = billformid == null ? "" : billformid.getString("number");
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(OM_QUOTAPUSHORDER);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("entityid", (Object)entityNum);
        fsp.setCustomParam("entryid", purApplyBillId);
        fsp.setCustomParam("org", org.getPkValue());
        fsp.setCustomParam("quotascheme", quotaScheme.getPkValue());
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CREATION));
        this.getView().showForm(fsp);
    }

    private QFilter getQFilter() {
        List<Object> queryMaterialIds;
        DynamicObject bizUser;
        DynamicObject dept;
        DynamicObject currency;
        Date endDate;
        Date startDate;
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        QFilter qFilter = new QFilter("org", "=", org.getPkValue());
        qFilter.and(new QFilter("billstatus", "=", (Object)StatusEnum.AUDITED.getCode()));
        qFilter.and(new QFilter("closestatus", "=", (Object)"A"));
        qFilter.and(new QFilter("billentry.material.isquotacontrol", "=", (Object)Boolean.TRUE));
        qFilter.and(new QFilter("billentry.supplier", "=", (Object)0L));
        qFilter.and(new QFilter("billentry.rowclosestatus", "=", (Object)"A"));
        qFilter.and(new QFilter("billentry.rowterminatestatus", "=", (Object)"A"));
        qFilter.and(new QFilter("billentry.qty", ">", (Object)"billentry.joinqty", true));
        DynamicObject billType = (DynamicObject)model.getValue("billtype");
        if (billType != null) {
            qFilter.and(new QFilter("billtype", "=", billType.getPkValue()));
        }
        if ((startDate = (Date)model.getValue("applydate_startdate")) != null) {
            qFilter.and(new QFilter("biztime", ">=", (Object)startDate));
        }
        if ((endDate = (Date)model.getValue("applydate_enddate")) != null) {
            qFilter.and(new QFilter("biztime", "<=", (Object)DateUtils.getEndOfDay((Date)endDate)));
        }
        if ((currency = (DynamicObject)model.getValue("currency")) != null) {
            qFilter.and(new QFilter("currency", "=", currency.getPkValue()));
        }
        if ((dept = (DynamicObject)model.getValue("querydept")) != null) {
            qFilter.and(new QFilter("dept", "=", dept.getPkValue()));
        }
        if ((bizUser = (DynamicObject)model.getValue("querybizuser")) != null) {
            qFilter.and(new QFilter("bizuser", "=", bizUser.getPkValue()));
        }
        if ((queryMaterialIds = this.getQueryMaterialIds()) != null && !queryMaterialIds.isEmpty()) {
            qFilter.and(new QFilter("billentry.material", "in", queryMaterialIds));
        }
        return qFilter;
    }

    private List<Object> getQueryMaterialIds() {
        DynamicObjectCollection materials = (DynamicObjectCollection)this.getModel().getValue("querymaterial");
        ArrayList<Object> materialIds = new ArrayList<Object>(16);
        if (materials != null && materials.size() > 0) {
            for (int i = 0; i < materials.size(); ++i) {
                DynamicObject material = (DynamicObject)materials.get(i);
                materialIds.add(((DynamicObject)material.get("fbasedataid")).getPkValue());
            }
        }
        return materialIds;
    }
}

