/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.formplugin.technics;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bd.mpdm.formplugin.manufacturemodel.TechnicsTplEditPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.mmc.om.business.technics.OMTechnicsHelper;
import kd.mmc.om.common.utils.OMBigDecimaUtil;

public class OMTechnicsEditPlugin
extends TechnicsTplEditPlugin {
    protected String getOrderBillType() {
        return "om_mftorder";
    }

    protected String getOrderBillName() {
        return ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355", (String)"OMTechnicsEditPlugin_0", (String)"mmc-om-formplugin", (Object[])new Object[0]);
    }

    protected String getStockBillType() {
        return "om_mftstock";
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setSkipNoField(true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object isinitbill = this.getModel().getValue("isinitbill");
        if (isinitbill != null && Boolean.parseBoolean(isinitbill.toString())) {
            this.intiBillPropertyChanged(e);
        }
    }

    private void intiBillPropertyChanged(PropertyChangedArgs e) {
        String name;
        IDataEntityProperty property = e.getProperty();
        switch (name = property.getName()) {
            case "oprtotalinqty1": 
            case "oprtotaloutqty1": 
            case "oprtotalqualifiedqty1": 
            case "oprtotalreceiveqty1": 
            case "oprtotalwasteqty1": 
            case "oprtotalmaterialqty1": 
            case "oprtotalreworkqty1": 
            case "oprrepairedqty1": {
                this.calculateQty();
                break;
            }
        }
    }

    private void calculateQty() {
        int entryIndex = (Integer)this.getModel().getValue("row2");
        if (entryIndex < 0) {
            return;
        }
        if ("1".equals(this.getPageCache().get("flag"))) {
            return;
        }
        BigDecimal oprtotalinqty1 = OMBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("oprtotalinqty1"));
        BigDecimal oprtotaloutqty1 = OMBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("oprtotaloutqty1"));
        BigDecimal oprtotalqualifiedqty1 = OMBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("oprtotalqualifiedqty1"));
        BigDecimal oprtotalreceiveqty1 = OMBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("oprtotalreceiveqty1"));
        BigDecimal oprtotalwasteqty1 = OMBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("oprtotalwasteqty1"));
        BigDecimal oprtotalmaterialqty1 = OMBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("oprtotalmaterialqty1"));
        BigDecimal oprtotalreworkqty1 = OMBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("oprtotalreworkqty1"));
        BigDecimal oprrepairedqty1 = OMBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("oprrepairedqty1"));
        BigDecimal pushreworkreportqty1 = OMBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("pushreworkreportqty1"));
        BigDecimal reworkreportqty1 = OMBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("reworkreportqty1"));
        this.getPageCache().put("flag", "1");
        BigDecimal pushreportqty1 = oprtotalqualifiedqty1.add(oprtotalreceiveqty1).add(oprtotalwasteqty1).add(oprtotalmaterialqty1).add(oprtotalreworkqty1).add(oprrepairedqty1);
        this.getModel().setValue("pushreportqty1", (Object)pushreportqty1);
        BigDecimal oprtotalreportqty1 = oprtotalqualifiedqty1.add(oprtotalreceiveqty1).add(oprtotalwasteqty1).add(oprtotalmaterialqty1).add(oprtotalreworkqty1).add(oprrepairedqty1);
        this.getModel().setValue("oprtotalreportqty1", (Object)oprtotalreportqty1);
        BigDecimal oprtotaljunkqty1 = oprtotalmaterialqty1.add(oprtotalwasteqty1);
        this.getModel().setValue("oprtotaljunkqty1", (Object)oprtotaljunkqty1);
        this.getModel().setValue("oprtotalinqty", (Object)oprtotalinqty1, entryIndex);
        this.getModel().setValue("oprtotaloutqty", (Object)oprtotaloutqty1, entryIndex);
        this.getModel().setValue("oprtotalqualifiedqty", (Object)oprtotalqualifiedqty1, entryIndex);
        this.getModel().setValue("oprtotalreceiveqty", (Object)oprtotalreceiveqty1, entryIndex);
        this.getModel().setValue("oprtotalwasteqty", (Object)oprtotalwasteqty1, entryIndex);
        this.getModel().setValue("oprtotalmaterialqty", (Object)oprtotalmaterialqty1, entryIndex);
        this.getModel().setValue("oprtotalreworkqty", (Object)oprtotalreworkqty1, entryIndex);
        this.getModel().setValue("oprrepairedqty", (Object)oprrepairedqty1, entryIndex);
        this.getModel().setValue("pushreportqty", (Object)pushreportqty1, entryIndex);
        this.getModel().setValue("oprtotalreportqty", (Object)oprtotalreportqty1, entryIndex);
        this.getModel().setValue("oprtotaljunkqty", (Object)oprtotaljunkqty1, entryIndex);
        DynamicObject manTechicsInfo = this.getModel().getDataEntity();
        DynamicObject techisInfo = this.getModel().getEntryRowEntity("oprentryentity", entryIndex);
        Map manftechMap = OMTechnicsHelper.getManftechMap((DynamicObject)manTechicsInfo, (DynamicObject)techisInfo);
        BigDecimal oprtotalinbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalinqty1);
        this.getModel().setValue("oprtotalinbaseqty1", (Object)oprtotalinbaseqty1);
        this.getModel().setValue("oprtotalinbaseqty", (Object)oprtotalinbaseqty1, entryIndex);
        BigDecimal oprtotaloutbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotaloutqty1);
        this.getModel().setValue("oprtotaloutbaseqty1", (Object)oprtotaloutbaseqty1);
        this.getModel().setValue("oprtotaloutbaseqty", (Object)oprtotaloutbaseqty1, entryIndex);
        BigDecimal pushreportbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)pushreportqty1);
        this.getModel().setValue("pushreportbaseqty1", (Object)pushreportbaseqty1);
        this.getModel().setValue("pushreportbaseqty", (Object)pushreportbaseqty1, entryIndex);
        BigDecimal pushreworkreportbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)pushreworkreportqty1);
        this.getModel().setValue("pushreworkreportbaseqty1", (Object)pushreworkreportbaseqty1);
        this.getModel().setValue("pushreworkreportbaseqty", (Object)pushreworkreportbaseqty1, entryIndex);
        BigDecimal oprtotalreportbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalreportqty1);
        this.getModel().setValue("oprtotalreportbaseqty1", (Object)oprtotalreportbaseqty1);
        this.getModel().setValue("oprtotalreportbaseqty", (Object)oprtotalreportbaseqty1, entryIndex);
        BigDecimal reworkreportbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)reworkreportqty1);
        this.getModel().setValue("reworkreportbaseqty1", (Object)reworkreportbaseqty1);
        this.getModel().setValue("reworkreportbaseqty", (Object)reworkreportbaseqty1, entryIndex);
        BigDecimal oprtotalqualifiedbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalqualifiedqty1);
        this.getModel().setValue("oprtotalqualifiedbaseqty1", (Object)oprtotalqualifiedbaseqty1);
        this.getModel().setValue("oprtotalqualifiedbaseqty", (Object)oprtotalqualifiedbaseqty1, entryIndex);
        BigDecimal oprtotalreceivebaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalreceiveqty1);
        this.getModel().setValue("oprtotalreceivebaseqty1", (Object)oprtotalreceivebaseqty1);
        this.getModel().setValue("oprtotalreceivebaseqty", (Object)oprtotalreceivebaseqty1, entryIndex);
        BigDecimal oprtotalwastebaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalwasteqty1);
        this.getModel().setValue("oprtotalwastebaseqty1", (Object)oprtotalwastebaseqty1);
        this.getModel().setValue("oprtotalwastebaseqty", (Object)oprtotalwastebaseqty1, entryIndex);
        BigDecimal oprtotalmaterialbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalmaterialqty1);
        this.getModel().setValue("oprtotalmaterialbaseqty1", (Object)oprtotalmaterialbaseqty1);
        this.getModel().setValue("oprtotalmaterialbaseqty", (Object)oprtotalmaterialbaseqty1, entryIndex);
        BigDecimal oprtotaljunkbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotaljunkqty1);
        this.getModel().setValue("oprtotaljunkbaseqty1", (Object)oprtotaljunkbaseqty1);
        this.getModel().setValue("oprtotaljunkbaseqty", (Object)oprtotaljunkbaseqty1, entryIndex);
        BigDecimal oprtotalreworkbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalreworkqty1);
        this.getModel().setValue("oprtotalreworkbaseqty1", (Object)oprtotalreworkbaseqty1);
        this.getModel().setValue("oprtotalreworkbaseqty", (Object)oprtotalreworkbaseqty1, entryIndex);
        this.getPageCache().put("flag", "0");
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        IDataModel model = this.getModel();
        StringBuilder err = new StringBuilder();
        DynamicObject dataEntity = model.getDataEntity();
        boolean isinitbill = dataEntity.getBoolean("isinitbill");
        if (!isinitbill) {
            err.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u7684\u5355\u636e\u4e3a\u975e\u521d\u59cb\u5316\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"OMTechnicsEditPlugin_1", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            ArrayList<String> errors = new ArrayList<String>(2);
            errors.add(err.toString());
            e.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), errors);
            return;
        }
        DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject entry : entryColl) {
            this.calculateQtyAfterImport(entry);
        }
    }

    private void calculateQtyAfterImport(DynamicObject entry) {
        if ("1".equals(this.getPageCache().get("flag"))) {
            return;
        }
        BigDecimal oprtotalinqty1 = OMBigDecimaUtil.toBigDecimal((Object)entry.get("oprtotalinqty"));
        BigDecimal oprtotaloutqty1 = OMBigDecimaUtil.toBigDecimal((Object)entry.get("oprtotaloutqty"));
        BigDecimal oprtotalqualifiedqty1 = OMBigDecimaUtil.toBigDecimal((Object)entry.get("oprtotalqualifiedqty"));
        BigDecimal oprtotalreceiveqty1 = OMBigDecimaUtil.toBigDecimal((Object)entry.get("oprtotalreceiveqty"));
        BigDecimal oprtotalwasteqty1 = OMBigDecimaUtil.toBigDecimal((Object)entry.get("oprtotalwasteqty"));
        BigDecimal oprtotalmaterialqty1 = OMBigDecimaUtil.toBigDecimal((Object)entry.get("oprtotalmaterialqty"));
        BigDecimal oprtotalreworkqty1 = OMBigDecimaUtil.toBigDecimal((Object)entry.get("oprtotalreworkqty"));
        BigDecimal oprrepairedqty1 = OMBigDecimaUtil.toBigDecimal((Object)entry.get("oprrepairedqty"));
        BigDecimal pushreworkreportqty1 = OMBigDecimaUtil.toBigDecimal((Object)entry.get("pushreworkreportqty"));
        BigDecimal reworkreportqty1 = OMBigDecimaUtil.toBigDecimal((Object)entry.get("reworkreportqty"));
        this.getPageCache().put("flag", "1");
        BigDecimal pushreportqty1 = oprtotalqualifiedqty1.add(oprtotalreceiveqty1).add(oprtotalwasteqty1).add(oprtotalmaterialqty1).add(oprtotalreworkqty1).add(oprrepairedqty1);
        BigDecimal oprtotalreportqty1 = oprtotalqualifiedqty1.add(oprtotalreceiveqty1).add(oprtotalwasteqty1).add(oprtotalmaterialqty1).add(oprtotalreworkqty1).add(oprrepairedqty1);
        BigDecimal oprtotaljunkqty1 = oprtotalmaterialqty1.add(oprtotalwasteqty1);
        entry.set("oprtotalinqty", (Object)oprtotalinqty1);
        entry.set("oprtotaloutqty", (Object)oprtotaloutqty1);
        entry.set("oprtotalqualifiedqty", (Object)oprtotalqualifiedqty1);
        entry.set("oprtotalreceiveqty", (Object)oprtotalreceiveqty1);
        entry.set("oprtotalwasteqty", (Object)oprtotalwasteqty1);
        entry.set("oprtotalmaterialqty", (Object)oprtotalmaterialqty1);
        entry.set("oprtotalreworkqty", (Object)oprtotalreworkqty1);
        entry.set("oprrepairedqty", (Object)oprrepairedqty1);
        entry.set("pushreportqty", (Object)pushreportqty1);
        entry.set("oprtotalreportqty", (Object)oprtotalreportqty1);
        entry.set("oprtotaljunkqty", (Object)oprtotaljunkqty1);
        DynamicObject manTechicsInfo = this.getModel().getDataEntity();
        Map manftechMap = OMTechnicsHelper.getManftechMap((DynamicObject)manTechicsInfo, (DynamicObject)entry);
        BigDecimal oprtotalinbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalinqty1);
        entry.set("oprtotalinbaseqty", (Object)oprtotalinbaseqty1);
        BigDecimal oprtotaloutbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotaloutqty1);
        entry.set("oprtotaloutbaseqty", (Object)oprtotaloutbaseqty1);
        BigDecimal pushreportbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)pushreportqty1);
        entry.set("pushreportbaseqty", (Object)pushreportbaseqty1);
        BigDecimal pushreworkreportbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)pushreworkreportqty1);
        entry.set("pushreworkreportbaseqty", (Object)pushreworkreportbaseqty1);
        BigDecimal oprtotalreportbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalreportqty1);
        entry.set("oprtotalreportbaseqty", (Object)oprtotalreportbaseqty1);
        BigDecimal reworkreportbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)reworkreportqty1);
        entry.set("reworkreportbaseqty", (Object)reworkreportbaseqty1);
        BigDecimal oprtotalqualifiedbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalqualifiedqty1);
        entry.set("oprtotalqualifiedbaseqty", (Object)oprtotalqualifiedbaseqty1);
        BigDecimal oprtotalreceivebaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalreceiveqty1);
        entry.set("oprtotalreceivebaseqty", (Object)oprtotalreceivebaseqty1);
        BigDecimal oprtotalwastebaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalwasteqty1);
        entry.set("oprtotalwastebaseqty", (Object)oprtotalwastebaseqty1);
        BigDecimal oprtotalmaterialbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalmaterialqty1);
        entry.set("oprtotalmaterialbaseqty", (Object)oprtotalmaterialbaseqty1);
        BigDecimal oprtotaljunkbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotaljunkqty1);
        entry.set("oprtotaljunkbaseqty", (Object)oprtotaljunkbaseqty1);
        BigDecimal oprtotalreworkbaseqty1 = OMTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalreworkqty1);
        entry.set("oprtotalreworkbaseqty", (Object)oprtotalreworkbaseqty1);
        this.getPageCache().put("flag", "0");
    }
}

