/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.formplugin.xmftorder;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.om.common.order.consts.OmManuBillConsts;
import kd.mmc.om.common.stock.utils.MetaDataHelper;
import kd.mmc.om.formplugin.order.enums.ChangeTypeEnum;
import kd.mmc.om.formplugin.order.enums.ManuBillBizStatusEnum;
import kd.mmc.om.formplugin.order.enums.ManuBillPlanStatusEnum;
import kd.mmc.om.formplugin.order.enums.ManuBillProductTypeEnum;

public class XOmMftOrderEdit
extends AbstractBillPlugIn
implements ClickListener,
RowClickEventListener,
HyperLinkClickListener,
BeforeF7SelectListener {
    private static final String XMFTORDERX = "xommftorderX";
    private static final String FALSE = "false";
    private static Log log = LogFactory.getLog(XOmMftOrderEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"srcbillid"});
        this.addClickListeners(new String[]{"srcbillno"});
        BasedataEdit supplier = (BasedataEdit)this.getView().getControl("supplier");
        supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        this.updatePID();
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate op = (FormOperate)e.getSource();
        if (StringUtils.equals((CharSequence)"draw", (CharSequence)op.getOperateKey())) {
            Object org = this.getModel().getValue("org");
            Object tran = this.getModel().getValue("transactiontype");
            StringBuilder err = new StringBuilder();
            if (org == null) {
                err.append(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u7a7a\uff0c", (String)"XOmMftOrderEdit_0", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            }
            if (tran == null) {
                err.append(ResManager.loadKDString((String)"\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c", (String)"XOmMftOrderEdit_1", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            }
            if (err.length() > 0) {
                err.append(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u9009\u5355\u3002", (String)"XOmMftOrderEdit_2", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                this.getView().showTipNotification(err.toString());
                e.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)"newentry", (CharSequence)op.getOperateKey())) {
            Object org = this.getModel().getValue("org");
            Object tran = this.getModel().getValue("transactiontype");
            StringBuilder err = new StringBuilder();
            if (org == null) {
                err.append(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u7a7a\uff0c", (String)"XOmMftOrderEdit_0", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            }
            if (tran == null) {
                err.append(ResManager.loadKDString((String)"\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c", (String)"XOmMftOrderEdit_1", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            }
            if (err.length() > 0) {
                err.append(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u589e\u884c\u3002", (String)"XOmMftOrderEdit_3", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                this.getView().showTipNotification(err.toString());
                e.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeDates;
        String key = e.getProperty().getName();
        if ("true".equals(this.getPageCache().get(XMFTORDERX))) {
            return;
        }
        this.getPageCache().put(XMFTORDERX, "true");
        int currentIndex = this.getSelectEntryRowIndex();
        block8: for (ChangeData changeData : changeDates = e.getChangeSet()) {
            switch (key) {
                case "purorg": {
                    this.purOrgChange(changeData, key);
                    continue block8;
                }
                case "supplier": {
                    this.supplierChanged(changeData, key);
                    continue block8;
                }
            }
        }
        if ("transactiontype".equals(key)) {
            DynamicObject newObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldObj = (DynamicObject)e.getChangeSet()[0].getOldValue();
            String oldtran = "";
            if (newObj == null) {
                this.getPageCache().put(XMFTORDERX, "true");
                this.getModel().setValue("transactiontype", (Object)oldObj);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u4e0d\u53ef\u6e05\u7a7a\u3002", (String)"XOmMftOrderEdit_4", (String)"mmc-om-formplugin", (Object[])new Object[0]));
                this.getPageCache().put(XMFTORDERX, FALSE);
                return;
            }
            String newtran = newObj.getPkValue().toString();
            if (oldObj != null) {
                oldtran = oldObj.getPkValue().toString();
            }
            this.getPageCache().put("newXOrderObj", newtran);
            this.getPageCache().put("oldXOrderObj", oldtran);
            if (oldObj != null && !newtran.equals(this.getPageCache().get("oldXOrderObj"))) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("tranChange", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u5207\u6362\u201c\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u201d\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u786e\u8ba4\u5207\u6362\uff1f", (String)"XOmMftOrderEdit_5", (String)"mmc-om-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            }
        } else if ("srcbillno".equals(key)) {
            String orderno = (String)this.getModel().getValue("srcbillno", currentIndex);
            if (!StringUtils.isBlank((CharSequence)orderno)) {
                QFilter filter = new QFilter("billno", "=", (Object)orderno);
                List<QFilter> filters = this.getOrderFilter();
                filters.add(filter);
                QFilter[] filterArray = new QFilter[filters.size()];
                DynamicObject order = BusinessDataServiceHelper.loadSingle((String)"om_mftorder", (String)"", (QFilter[])filters.toArray(filterArray));
                if (order == null) {
                    this.setOrderInfo(null, currentIndex);
                } else {
                    DynamicObject stockdym = BusinessDataServiceHelper.loadSingle((Object)order.getPkValue(), (String)"om_mftorder");
                    this.setOrderInfo(stockdym, currentIndex);
                }
            } else {
                this.setOrderInfo(null, currentIndex);
            }
        }
        this.getPageCache().put(XMFTORDERX, FALSE);
    }

    private void supplierChanged(ChangeData changeData, String key) {
        Map<Integer, Boolean> integerBooleanMap = null;
        DynamicObject dataEntity = changeData.getDataEntity();
        Long pkValue = (Long)dataEntity.getPkValue();
        int rowIndex = changeData.getRowIndex();
        HashSet<Integer> rowIndexs = new HashSet<Integer>(16);
        rowIndexs.add(rowIndex);
        this.getModel().beginInit();
        DynamicObjectCollection treeentryentity = this.getModel().getEntryEntity("treeentryentity");
        for (int i = 0; i < treeentryentity.size(); ++i) {
            Boolean flag;
            DynamicObject row = (DynamicObject)treeentryentity.get(i);
            if (!Objects.equals(pkValue, row.getLong("pid"))) continue;
            integerBooleanMap = integerBooleanMap == null ? this.sourcePushPurApplyOrOrder() : integerBooleanMap;
            Boolean bl = flag = integerBooleanMap.get(i) == null ? Boolean.TRUE : integerBooleanMap.get(i);
            if (!flag.booleanValue()) continue;
            this.getModel().setValue(key, dataEntity.get(key), i);
            rowIndexs.add(i);
        }
        this.getModel().endInit();
        for (Integer index : rowIndexs) {
            this.getView().updateView(key, index.intValue());
        }
    }

    private void purOrgChange(ChangeData changeData, String key) {
        Map<Integer, Boolean> integerBooleanMap = null;
        IDataModel model = this.getModel();
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        Long pkValue = (Long)changeData.getDataEntity().getPkValue();
        HashSet<Integer> rowIndexs = new HashSet<Integer>(16);
        rowIndexs.add(rowIndex);
        model.beginInit();
        model.setValue("supplier", null, rowIndex);
        DynamicObjectCollection treeentryentity = this.getModel().getEntryEntity("treeentryentity");
        for (int i = 0; i < treeentryentity.size(); ++i) {
            Boolean flag;
            DynamicObject row = (DynamicObject)treeentryentity.get(i);
            if (!pkValue.equals(row.getLong("pid"))) continue;
            integerBooleanMap = integerBooleanMap == null ? this.sourcePushPurApplyOrOrder() : integerBooleanMap;
            Boolean bl = flag = integerBooleanMap.get(i) == null ? Boolean.TRUE : integerBooleanMap.get(i);
            if (!flag.booleanValue()) continue;
            model.setValue(key, newValue, i);
            model.setValue("supplier", null, i);
            rowIndexs.add(i);
        }
        this.getModel().endInit();
        for (Integer index : rowIndexs) {
            this.getView().updateView("purorg", index.intValue());
            this.getView().updateView("supplier", index.intValue());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"tranChange", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                int entryNum = this.getModel().getEntryRowCount("treeentryentity");
                for (int i = entryNum - 1; i >= 0; --i) {
                    this.getModel().deleteEntryRow("treeentryentity", i);
                }
                this.showEntryDetial();
                this.getModel().setValue("transactiontype", (Object)this.getPageCache().get("newXOrderObj"));
            } else {
                this.getPageCache().put(XMFTORDERX, "true");
                this.getModel().setValue("transactiontype", (Object)this.getPageCache().get("oldXOrderObj"));
                this.getPageCache().put(XMFTORDERX, FALSE);
            }
        }
    }

    private void showEntryDetial() {
        this.getModel().setValue("entrymaterial", null);
        this.getModel().setValue("entrybatchno", null);
        this.getModel().setValue("entryauxproperty", null);
        this.getModel().setValue("entryyieldrate", null);
        this.getModel().setValue("entryestscrapqty", null);
        this.getModel().setValue("entryinwardept", null);
        this.getModel().setValue("entrywarehouse", null);
        this.getModel().setValue("entrylocation", null);
        this.getModel().setValue("entryiscontrolqty", null);
        this.getModel().setValue("entryinwarmax", null);
        this.getModel().setValue("entryinwarmin", null);
        this.getModel().setValue("entryrcvinhighlimit", null);
        this.getModel().setValue("entryrcvinlowlimit", null);
        this.getModel().setValue("entryoutputoperation", null);
        this.getModel().setValue("entryrptqty", null);
        this.getModel().setValue("entryreportqty", null);
        this.getModel().setValue("entryworkwasteqty", null);
        this.getModel().setValue("entrymtlcostqty", null);
        this.getModel().setValue("entryqualifiedqty", null);
        this.getModel().setValue("entryunqualifiedqty", null);
        this.getModel().setValue("entryscrapqty", null);
        this.getModel().setValue("entryrepairqty", null);
        this.getModel().setValue("entryreworkqty", null);
        this.getModel().setValue("entrypickingpairs", null);
        this.getModel().setValue("entrystockqty", null);
        this.getModel().setValue("entryquainwaqty", null);
        this.getModel().setValue("entryunquainwaqty", null);
        this.getModel().setValue("entryscrinwaqty", null);
        this.getModel().setValue("entryrepinwaqty", null);
        this.getModel().setValue("entryplansuretime", null);
        this.getModel().setValue("entrytransmittime", null);
        this.getModel().setValue("entrystartworktime", null);
        this.getModel().setValue("entryendworktime", null);
        this.getModel().setValue("entryclosetime", null);
        this.getModel().setValue("entrycompletime", null);
        this.getModel().setValue("entrysourcebilltype", null);
        this.getModel().setValue("entrysourcebillnumber", null);
        this.getModel().setValue("entrysourceentryseq", null);
        this.getModel().setValue("entryunit", null);
        this.getModel().setValue("entryseq", (Object)-1);
        this.getModel().setValue("entrybaseunit", null);
        this.getModel().setValue("entrybaseqty", null);
        this.getModel().setValue("entryauxptyunit", null);
        this.getModel().setValue("entryauxptyqty", null);
        this.lockSomeControls();
    }

    private void lockSomeControls() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"entrybatchno"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryauxproperty"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryinwardept"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entrywarehouse"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entrylocation"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryiscontrolqty"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryinwarmax"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryinwarmin"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryoutputoperation"});
    }

    private void updatePID() {
        DynamicObject xBill = this.getModel().getDataEntity();
        DynamicObjectCollection xBillEntry = xBill.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject xBillEntryRow : xBillEntry) {
            String srcEntryID = (String)xBillEntryRow.get("srcbillentryid");
            if (srcEntryID.isEmpty()) continue;
            QFilter qFilter = new QFilter("treeentryentity.id", "=", (Object)Long.valueOf(srcEntryID));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"om_mftorder", (String)this.buildSelect(), (QFilter[])new QFilter[]{qFilter});
            if (query.isEmpty()) continue;
            DynamicObject srcBillEntryRow = (DynamicObject)query.get(0);
            Object newPID = this.getNewPID(srcBillEntryRow);
            if (newPID != null) {
                xBillEntryRow.set("pid", newPID);
            }
            xBillEntryRow.set("planstatus", srcBillEntryRow.get("treeentryentity.planstatus"));
            xBillEntryRow.set("taskstatus", srcBillEntryRow.get("treeentryentity.taskstatus"));
            xBillEntryRow.set("kittingstatus", srcBillEntryRow.get("treeentryentity.kittingstatus"));
            xBillEntryRow.set("pickstatus", srcBillEntryRow.get("treeentryentity.pickstatus"));
            xBillEntryRow.set("bizstatus", srcBillEntryRow.get("treeentryentity.bizstatus"));
        }
    }

    private String buildSelect() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("treeentryentity").append(".pid,");
        sBuilder.append("treeentryentity").append('.').append("planstatus").append(',');
        sBuilder.append("treeentryentity").append('.').append("taskstatus").append(',');
        sBuilder.append("treeentryentity").append('.').append("kittingstatus").append(',');
        sBuilder.append("treeentryentity").append('.').append("pickstatus").append(',');
        sBuilder.append("treeentryentity").append('.').append("bizstatus");
        return sBuilder.toString();
    }

    private Object getNewPID(DynamicObject srcBillEntryRow) {
        DynamicObject xBill = this.getModel().getDataEntity();
        DynamicObjectCollection xBillEntry = xBill.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject xBillEntryRow : xBillEntry) {
            Long srcPID;
            Long srcLongEntryID;
            String srcEntryID = (String)xBillEntryRow.get("srcbillentryid");
            if (srcEntryID.isEmpty() || !(srcLongEntryID = Long.valueOf(Long.parseLong(srcEntryID))).equals(srcPID = (Long)srcBillEntryRow.get("treeentryentity.pid"))) continue;
            return xBillEntryRow.getPkValue();
        }
        return null;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().clearNoDataRow();
        this.getModel().forceClearNoDataRow();
        int billEntryCount = this.getModel().getEntryRowCount("treeentryentity");
        if (billEntryCount == 0) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"billtype"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"billtype"});
        }
        this.setEntryEnable();
    }

    private void setEntryEnable() {
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        int billEntryCount = this.getModel().getEntryRowCount("treeentryentity");
        String[] billEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"treeentryentity");
        String[] billEntry3 = this.getDifferentFromString(billEntry1, OmManuBillConsts.getEntryFields((String)"a"));
        for (int i = 0; i < billEntryCount; ++i) {
            if ("B".equals(this.getModel().getValue("changetype", i))) {
                this.getView().setEnable(Boolean.FALSE, i, billEntry3);
                String taskStatus = (String)this.getModel().getValue("taskstatus", i);
                if (!"B".equals(taskStatus)) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"planbegintime"});
                continue;
            }
            if (!"C".equals(this.getModel().getValue("changetype", i))) continue;
            this.getView().setEnable(Boolean.FALSE, i, billEntry1);
        }
        Map<Integer, Boolean> res = this.sourcePushPurApplyOrOrder();
        for (Map.Entry<Integer, Boolean> tempt : res.entrySet()) {
            Integer i = tempt.getKey();
            Boolean value = tempt.getValue();
            this.getView().setEnable(value, i.intValue(), new String[]{"purorg"});
            this.getView().setEnable(value, i.intValue(), new String[]{"supplier"});
        }
    }

    private Map<Integer, Boolean> sourcePushPurApplyOrOrder() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection treeentryentity = dataEntity.getDynamicObjectCollection("treeentryentity");
        HashMap<Integer, Boolean> res = new HashMap<Integer, Boolean>(treeentryentity.size());
        HashMap<Long, Integer> entrySeqMapper = new HashMap<Long, Integer>(treeentryentity.size());
        for (int i = 0; i < treeentryentity.size(); ++i) {
            String changetype;
            DynamicObject dynamicObject = (DynamicObject)treeentryentity.get(i);
            String srcbillentryid = dynamicObject.getString("srcbillentryid");
            if (StringUtils.isBlank((CharSequence)srcbillentryid) || !Objects.equals(changetype = dynamicObject.getString("changetype"), "B")) continue;
            entrySeqMapper.put(Long.valueOf(srcbillentryid), i);
            res.put(i, true);
        }
        log.info("\u6536\u96c6\u5206\u5f55\u884c\u5f97\u5230\u7684\u7ed3\u679c" + entrySeqMapper);
        if (entrySeqMapper == null || entrySeqMapper.size() == 0) {
            return res;
        }
        QFilter pmOutPurOrderOrApplyFiliter = new QFilter("billentry.mftorderentryid", "in", entrySeqMapper.keySet());
        try (DataSet pmOutOrder = QueryServiceHelper.queryDataSet((String)"query_pmPurOutOrder", (String)"pm_purorderbill", (String)"billentry.mftorderentryid", (QFilter[])pmOutPurOrderOrApplyFiliter.toArray(), null);
             DataSet pmApplyOrder = QueryServiceHelper.queryDataSet((String)"query_pmApplyOrder", (String)"pm_purapplybill", (String)"billentry.mftorderentryid", (QFilter[])pmOutPurOrderOrApplyFiliter.toArray(), null);){
            if (!pmOutOrder.isEmpty() || !pmApplyOrder.isEmpty()) {
                Integer rowIndex;
                String srcbillentryid;
                Row next;
                while (pmOutOrder.hasNext()) {
                    next = pmOutOrder.next();
                    srcbillentryid = next.getString("billentry.mftorderentryid");
                    if (!entrySeqMapper.containsKey(Long.valueOf(srcbillentryid))) continue;
                    rowIndex = (Integer)entrySeqMapper.get(Long.valueOf(srcbillentryid));
                    res.put(rowIndex, false);
                }
                while (pmApplyOrder.hasNext()) {
                    next = pmApplyOrder.next();
                    srcbillentryid = next.getString("billentry.mftorderentryid");
                    if (!entrySeqMapper.containsKey(Long.valueOf(srcbillentryid))) continue;
                    rowIndex = (Integer)entrySeqMapper.get(Long.valueOf(srcbillentryid));
                    res.put(rowIndex, false);
                }
            }
        }
        return res;
    }

    private String[] getDifferentFromString(String[] s1, String[] s2) {
        HashSet<String> hs1 = new HashSet<String>(Arrays.asList(s1));
        HashSet<String> hs2 = new HashSet<String>(Arrays.asList(s2));
        hs1.removeAll(hs2);
        return hs1.toArray(new String[0]);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rows = e.getRowDataEntities();
        if ("treeentryentity".equals(entryName)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
            HashMap id_map = new HashMap(4);
            for (DynamicObject entry : entryEntity) {
                long id = entry.getLong("id");
                long pid = entry.getLong("pid");
                if (pid != 0L) continue;
                HashMap<String, Object> data = new HashMap<String, Object>(2);
                data.put("srcbillno", entry.get("srcbillno"));
                data.put("srcbillid", entry.get("srcbillid"));
                id_map.put(id, data);
            }
            for (RowDataEntity row : rows) {
                Map data;
                DynamicObject dataEntity = row.getDataEntity();
                long pid = dataEntity.getLong("pid");
                int rowIndex = row.getRowIndex();
                if (pid != 0L && null != (data = (Map)id_map.get(pid))) {
                    this.getModel().setValue("srcbillno", data.get("srcbillno"), rowIndex);
                    this.getModel().setValue("srcbillid", data.get("srcbillid"), rowIndex);
                }
                this.getModel().setValue("changetype", (Object)"A", rowIndex);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        int row = evt.getRow();
        if ("treeentryentity".equals(entryGrid.getKey())) {
            String changeType = (String)this.getModel().getValue("changetype", row);
            if (ChangeTypeEnum.MODIFY.getValue().equals(changeType) || ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                this.getView().setEnable(Boolean.FALSE, OmManuBillConsts.getOtherFields());
                this.unlockLoacation(row);
            }
        }
    }

    public void click(EventObject evt) {
        Control sourceField = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)sourceField.getKey(), (CharSequence)"srcbillno")) {
            this.showBillList(sourceField.getKey());
        }
    }

    private void showBillList(String sourcekey) {
        String entityNumber = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)sourcekey, (CharSequence)"srcbillno")) {
            entityNumber = "om_mftorder";
        }
        if (!StringUtils.isEmpty((CharSequence)entityNumber)) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
            qFilters.add(new QFilter("treeentryentity.planstatus", "in", (Object)new Object[]{ManuBillPlanStatusEnum.TRANSMIT.getValue(), ManuBillPlanStatusEnum.PLANSURE.getValue()}));
            qFilters.add(new QFilter("treeentryentity.bizstatus", "=", (Object)ManuBillBizStatusEnum.NORMAL.getValue()));
            qFilters.add(new QFilter("isinitbill", "=", (Object)false));
            DynamicObject tran = (DynamicObject)this.getModel().getValue("transactiontype");
            QFilter transFilter = tran != null ? new QFilter("transactiontype", "=", tran.getPkValue()) : new QFilter("transactiontype", "=", (Object)0L);
            qFilters.add(transFilter);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            QFilter orgFilter = org != null ? new QFilter("org", "=", org.getPkValue()) : new QFilter("org", "=", (Object)0L);
            qFilters.add(orgFilter);
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)false);
            showParameter.getListFilterParameter().setQFilters(qFilters);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, sourcekey);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionKey = e.getActionId();
        int currentRowIndex = this.getSelectEntryRowIndex();
        if (e.getReturnData() != null) {
            DynamicObject mftorder;
            ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
            Object pk = rows.get(0).getPrimaryKeyValue();
            if (StringUtils.equalsIgnoreCase((CharSequence)"srcbillno", (CharSequence)actionKey) && (mftorder = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"om_mftorder")) != null) {
                this.getPageCache().put(XMFTORDERX, "true");
                this.getModel().setValue("srcbillid", (Object)rows.get(0).getPrimaryKeyValue().toString(), currentRowIndex);
                this.getModel().setValue("srcbillno", (Object)rows.get(0).getBillNo(), currentRowIndex);
                this.getPageCache().put(XMFTORDERX, FALSE);
            }
        }
    }

    public int getSelectEntryRowIndex() {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        int rowIndex;
        String operationKey = evt.getOperateKey();
        if ("save".equals(operationKey)) {
            this.setEntryEnable();
        }
        if ((rowIndex = this.getSelectEntryRowIndex()) == -1) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"cancelentry")) {
            this.getModel().setValue("changetype", (Object)"C", rowIndex);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"insertentry")) {
            String producttype = (String)this.getModel().getValue("producttype", rowIndex);
            if (!ManuBillProductTypeEnum.MAIN.getValue().equals(producttype)) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"srcbillno"});
            }
        }
    }

    private List<QFilter> getOrderFilter() {
        QFilter planFilter = new QFilter("treeentryentity.planstatus", "in", (Object)new String[]{ManuBillPlanStatusEnum.TRANSMIT.getValue(), ManuBillPlanStatusEnum.PLANSURE.getValue()});
        QFilter bizFilter = new QFilter("treeentryentity.bizstatus", "=", (Object)ManuBillBizStatusEnum.NORMAL.getValue());
        QFilter auditFilter = new QFilter("billstatus", "=", (Object)"C");
        DynamicObject tran = (DynamicObject)this.getModel().getValue("transactiontype");
        QFilter transFilter = tran != null ? new QFilter("transactiontype.id", "=", tran.getPkValue()) : new QFilter("transactiontype.id", "=", (Object)0L);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter orgFilter = org != null ? new QFilter("org.id", "=", org.getPkValue()) : new QFilter("org.id", "=", (Object)0L);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(planFilter);
        filters.add(bizFilter);
        filters.add(auditFilter);
        filters.add(transFilter);
        filters.add(orgFilter);
        return filters;
    }

    private void setOrderInfo(DynamicObject order, int currentRowIndex) {
        if (order == null) {
            this.getModel().setValue("srcbillid", null, currentRowIndex);
            this.getModel().setValue("srcbillno", null, currentRowIndex);
        } else {
            this.getModel().setValue("srcbillid", (Object)order.getPkValue().toString(), currentRowIndex);
            this.getModel().setValue("srcbillno", order.get("billno"), currentRowIndex);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        Object stockid;
        if (StringUtils.equals((CharSequence)"srcbillno", (CharSequence)arg0.getFieldName()) && (stockid = this.getModel().getValue("srcbillid", arg0.getRowIndex())) != null) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("om_mftorder");
            showParameter.setPkId(stockid);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void unlockLoacation(int rowindex) {
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse");
        if (warehouse == null) {
            return;
        }
        boolean isopenlocation = (warehouse = BusinessDataServiceHelper.loadSingleFromCache((Object)warehouse.getPkValue(), (String)"bd_warehouse")).getBoolean("isopenlocation");
        if (isopenlocation) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"entrylocation"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entrylocation"});
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        if (null != sourceDataList && sourceDataList.size() > 0) {
            for (Map sourceData : sourceDataList) {
                JSONArray arrEntrys = (JSONArray)sourceData.get("treeentryentity");
                if (arrEntrys == null) continue;
                for (int i = 0; i < arrEntrys.size(); ++i) {
                    JSONObject entryObj = arrEntrys.getJSONObject(i);
                    if (entryObj == null) continue;
                    this.autoFilldataFromImport(entryObj, sourceData);
                }
            }
        }
    }

    private void autoFilldataFromImport(JSONObject entryObj, Map<String, Object> sourceData) {
        this.autoFillPlanPrepareTime(entryObj);
    }

    private void autoFillPlanPrepareTime(JSONObject entryObj) {
        Object planpreparetimeobj = entryObj.get((Object)"planpreparetime");
        Object planbegintime = entryObj.get((Object)"planbegintime");
        if (planpreparetimeobj == null && planbegintime != null) {
            entryObj.put("planpreparetime", planbegintime);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        Control con = (Control)e.getSource();
        switch (key = con.getKey()) {
            case "purorg": {
                this.beforePurOrgF7Select(e);
                break;
            }
            case "supplier": {
                this.beforeSupplierF7Select(e);
                break;
            }
        }
    }

    private void beforePurOrgF7Select(BeforeF7SelectEvent e) {
        FormShowParameter formShowParameter = e.getFormShowParameter();
        if (formShowParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)formShowParameter;
            listShowParameter.setMultiSelect(false);
        }
    }

    private void beforeSupplierF7Select(BeforeF7SelectEvent e) {
        int row = e.getRow();
        Object value = this.getModel().getValue("purorg", row);
        if (value == null) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"OMMftOrderEdit_21", (String)"mmc-om-formplugin", (Object[])new Object[0]));
        }
    }
}

