/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.om.mservice.api.IMftstockAutoPushService;

public class MftstockAutoPushImpl
implements IMftstockAutoPushService {
    private static final String OM_MFTSTOCK = "om_mftstock";
    private static final String PUR_MODULELIST = "pur_modulelist";
    private static final String ISSUCCESS = "isSuccess";
    private static final String SUCCESSMAP = "successMap";
    private static final String ERRORMSG = "errorMsg";
    private static final Log log = LogFactory.getLog(MftstockAutoPushImpl.class);

    public Map<String, Object> mftstockAutoPushByOrderEntryIds(Map<String, Set<Long>> orderEntryIdsMap) {
        HashMap<String, Object> pushResult = new HashMap<String, Object>(16);
        Set<Long> orderEntryIds = orderEntryIdsMap.get("orderEntryIds");
        if (orderEntryIds == null || orderEntryIds.isEmpty()) {
            return pushResult;
        }
        HashMap<Long, Long> orderEntryId2StockId = new HashMap<Long, Long>(orderEntryIds.size());
        String algoKey = "kd.mmc.om.mservice.QueryMftstockImpl.queryMftstockByOrderentryid";
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)algoKey, (String)OM_MFTSTOCK, (String)"id,orderentryid", (QFilter[])new QFilter("orderentryid", "in", orderEntryIds).and(new QFilter("billstatus", "=", (Object)"C")).toArray(), null);){
            for (Row row : dataset) {
                orderEntryId2StockId.put(row.getLong("orderentryid"), row.getLong("id"));
            }
        }
        if (orderEntryId2StockId.isEmpty()) {
            pushResult.put(ISSUCCESS, Boolean.FALSE);
            pushResult.put(ERRORMSG, ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u53ef\u4e0b\u63a8\u7684\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\u3002", (String)"MftstockAutoPushImpl_3", (String)"mmc-om-mservice", (Object[])new Object[0]));
            return pushResult;
        }
        this.pushStock(orderEntryIds, orderEntryId2StockId, pushResult);
        return pushResult;
    }

    private void pushStock(Set<Long> orderEntryIds, Map<Long, Long> orderEntryId2StockId, Map<String, Object> pushResult) {
        ConvertRuleElement convertRuleElementParam = this.getBotpRule(OM_MFTSTOCK, PUR_MODULELIST, "1987796612847507456");
        if (convertRuleElementParam == null) {
            String errorMessage = ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"MftstockAutoPushImpl_1", (String)"mmc-om-mservice", (Object[])new Object[0]);
            throw new KDException(new ErrorCode("SRMERRORCODE005", errorMessage), new Object[]{errorMessage});
        }
        PushArgs pushArgs = new PushArgs();
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(16);
        pushArgs.setSourceEntityNumber(convertRuleElementParam.getSourceEntityNumber());
        pushArgs.setTargetEntityNumber(convertRuleElementParam.getTargetEntityNumber());
        pushArgs.setBuildConvReport(true);
        pushArgs.setRuleId(convertRuleElementParam.getId());
        for (Long stockId : orderEntryId2StockId.values()) {
            ListSelectedRow listSelectedRow = new ListSelectedRow((Object)orderEntryId2StockId.size());
            listSelectedRow.setPrimaryKeyValue((Object)stockId);
            selectedRowList.add(listSelectedRow);
        }
        pushArgs.setSelectedRows(selectedRowList);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (result.isSuccess()) {
            StringBuilder errorMsg = new StringBuilder().append(result.getMessage());
            for (SourceBillReport billReport : result.getBillReports()) {
                errorMsg.append(billReport.getFailMessage());
            }
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)pushArgs.getTargetEntityNumber());
            IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
                }
            };
            List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
            try {
                String errMsg;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
                Set<Object> successIds = new HashSet(targetData.size());
                OperationResult operationResult = SaveServiceHelper.saveOperate((String)pushArgs.getTargetEntityNumber(), (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)operateOption);
                if (operationResult != null) {
                    if (operationResult.isSuccess() && operationResult.getSuccessPkIds().size() > 0) {
                        successIds = operationResult.getSuccessPkIds().stream().map(v -> Long.parseLong(v.toString())).collect(Collectors.toSet());
                        if (!operationResult.getAllErrorOrValidateInfo().isEmpty()) {
                            errMsg = operationResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.joining("\n"));
                            errorMsg.append(';').append(errMsg);
                        }
                    } else {
                        pushResult.put(ISSUCCESS, Boolean.FALSE);
                        pushResult.put(SUCCESSMAP, new HashMap());
                        errorMsg.append(';').append(operationResult.getMessage()).append(System.lineSeparator());
                        operationResult.getAllErrorOrValidateInfo().forEach(row -> errorMsg.append(row.getMessage()).append(System.lineSeparator()));
                        pushResult.put(ERRORMSG, errorMsg.toString());
                        return;
                    }
                }
                if (!successIds.isEmpty() && (operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)pushArgs.getTargetEntityNumber(), (Object[])successIds.toArray(new Long[0]), (OperateOption)operateOption)) != null) {
                    if (operationResult.isSuccess() && operationResult.getSuccessPkIds().size() > 0) {
                        successIds = operationResult.getSuccessPkIds().stream().map(v -> Long.parseLong(v.toString())).collect(Collectors.toSet());
                        if (!operationResult.getAllErrorOrValidateInfo().isEmpty()) {
                            errMsg = operationResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.joining("\n"));
                            errorMsg.append(';').append(errMsg);
                        }
                    } else {
                        pushResult.put(ISSUCCESS, Boolean.FALSE);
                        pushResult.put(SUCCESSMAP, new HashMap());
                        errorMsg.append(';').append(operationResult.getMessage()).append(System.lineSeparator());
                        operationResult.getAllErrorOrValidateInfo().forEach(row -> errorMsg.append(row.getMessage()).append(System.lineSeparator()));
                        pushResult.put(ERRORMSG, errorMsg.toString());
                        return;
                    }
                }
                if (!successIds.isEmpty() && (operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)pushArgs.getTargetEntityNumber(), (Object[])successIds.toArray(new Long[0]), (OperateOption)operateOption)) != null) {
                    if (operationResult.isSuccess() && operationResult.getSuccessPkIds().size() > 0) {
                        successIds = operationResult.getSuccessPkIds().stream().map(v -> Long.parseLong(v.toString())).collect(Collectors.toSet());
                        if (!operationResult.getAllErrorOrValidateInfo().isEmpty()) {
                            errMsg = operationResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.joining("\n"));
                            errorMsg.append(';').append(errMsg);
                        }
                    } else {
                        pushResult.put(ISSUCCESS, Boolean.FALSE);
                        pushResult.put(SUCCESSMAP, new HashMap());
                        errorMsg.append(';').append(operationResult.getMessage()).append(System.lineSeparator());
                        operationResult.getAllErrorOrValidateInfo().forEach(row -> errorMsg.append(row.getMessage()).append(System.lineSeparator()));
                        pushResult.put(ERRORMSG, errorMsg.toString());
                        return;
                    }
                }
                pushResult.put(ISSUCCESS, Boolean.TRUE);
                pushResult.put(ERRORMSG, errorMsg.toString());
                HashMap<Long, Long> successOrderEntryId2StockId = new HashMap<Long, Long>(successIds.size());
                try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"query-pur_modulelist", (String)pushArgs.getTargetEntityNumber(), (String)"mftorderentryid", (QFilter[])new QFilter("id", "in", successIds).toArray(), null);){
                    for (Row row2 : dataset) {
                        Long orderEntryId = row2.getLong("mftorderentryid");
                        successOrderEntryId2StockId.put(orderEntryId, orderEntryId2StockId.get(orderEntryId));
                    }
                }
                pushResult.put(SUCCESSMAP, successOrderEntryId2StockId);
            }
            catch (Throwable throwable) {
                pushResult.put(ISSUCCESS, Boolean.FALSE);
                pushResult.put(SUCCESSMAP, new HashMap());
                pushResult.put(ERRORMSG, throwable.getMessage());
            }
        } else {
            pushResult.put(ISSUCCESS, Boolean.FALSE);
            pushResult.put(SUCCESSMAP, new HashMap());
            String loadKDString = ResManager.loadKDString((String)"\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\u4e0b\u63a8\u5355\u636e\u5f02\u5e38\uff1a", (String)"MftstockAutoPushImpl_2", (String)"mmc-om-mservice", (Object[])new Object[0]);
            StringBuilder message = new StringBuilder();
            message.append(loadKDString).append(System.lineSeparator());
            message.append(result.getMessage());
            result.getBillReports().forEach(row -> message.append(row.getFailMessage()));
            pushResult.put(ERRORMSG, message.toString());
        }
    }

    private ConvertRuleElement getBotpRule(String sourceEntity, String targetEntity, String ruleId) {
        ConvertRuleElement convertRuleElementParam = null;
        if (!StringUtils.isEmpty((Object)ruleId)) {
            convertRuleElementParam = ConvertMetaServiceHelper.loadRule((String)ruleId);
        } else {
            List ruleList = ConvertMetaServiceHelper.loadRules((String)sourceEntity, (String)targetEntity);
            if (ruleList != null && !ruleList.isEmpty()) {
                for (ConvertRuleElement convertRuleElement : ruleList) {
                    if (convertRuleElement.isEnabled() && convertRuleElement.isDefRule()) {
                        convertRuleElementParam = convertRuleElement;
                        break;
                    }
                    if (!convertRuleElement.isEnabled()) continue;
                    convertRuleElementParam = convertRuleElement;
                }
            }
        }
        return convertRuleElementParam;
    }
}

