/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.mservice;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.om.common.stock.utils.CreateStockPlanUtils;
import kd.mmc.om.common.stock.utils.OutPurApplyData;
import kd.mmc.om.mservice.api.IMftstockplanService;

public class MftstockplanServiceImpl
implements IMftstockplanService {
    private static final Log logger = LogFactory.getLog(MftstockplanServiceImpl.class);
    String billstatus = "billstatus";
    String auditdate = "auditdate";
    String auditor = "auditor";

    public ErrorCode createMftstockplan(DynamicObject[] outPurapplybills, String operation) {
        if (outPurapplybills == null || outPurapplybills.length < 1) {
            return null;
        }
        String mftstockplanName = "om_mftstockplan";
        if (StringUtils.isBlank((CharSequence)operation)) {
            return new ErrorCode("createOutstockplan Error", ResManager.loadKDString((String)"\u4f20\u5165\u7684\u64cd\u4f5c\u540d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MftstockplanServiceImpl_0", (String)"mmc-om-mservice", (Object[])new Object[0]));
        }
        OutPurApplyData baseData = CreateStockPlanUtils.getStockPlans((DynamicObject[])outPurapplybills, (String)operation, (String)mftstockplanName);
        if (baseData == null) {
            return null;
        }
        this.updateStockStatus(operation, baseData);
        ArrayList<DynamicObject> savedataEntities = new ArrayList<DynamicObject>(outPurapplybills.length);
        ArrayList<DynamicObject> updatedataEntities = new ArrayList<DynamicObject>(outPurapplybills.length);
        HashSet<Long> deleteStockIds = new HashSet<Long>(outPurapplybills.length);
        savedataEntities.addAll(baseData.getSaveStocks());
        updatedataEntities.addAll(baseData.getUpdateStocks());
        deleteStockIds.addAll(baseData.getDeleteOrderEntryIds());
        Map orderErrInfoMap = baseData.getOrderErrInfoMap();
        StringBuilder errormsg = new StringBuilder(200);
        for (DynamicObject obj : outPurapplybills) {
            String err = (String)orderErrInfoMap.get((Long)obj.getPkValue());
            if (err == null) continue;
            errormsg.append(err);
            OperateErrorInfo errorInfo = new OperateErrorInfo("genOneOmStock", ErrorLevel.FatalError, obj.getPkValue());
            errorInfo.setMessage(obj.getString("billno") + ":" + org.apache.commons.lang.StringUtils.strip((String)err, (String)"[]"));
            errorInfo.setTitle(ResManager.loadKDString((String)"\u751f\u6210\u59d4\u5916\u7528\u6599\u6e05\u5355", (String)"MftstockplanServiceImpl_1", (String)"mmc-om-mservice", (Object[])new Object[0]));
        }
        MftstockplanServiceImpl.handleStock(mftstockplanName, savedataEntities, updatedataEntities, deleteStockIds);
        ErrorCode errorcode = null;
        if (errormsg.length() > 0) {
            errorcode = new ErrorCode("genOneOmStock", errormsg.toString());
        }
        return errorcode;
    }

    private void updateStockStatus(String operation, OutPurApplyData baseData) {
        Map stockMap = baseData.getStockMap();
        if (stockMap.size() > 0) {
            block8: for (DynamicObject stock : stockMap.values()) {
                switch (operation) {
                    case "submit": {
                        stock.set(this.billstatus, (Object)"B");
                        continue block8;
                    }
                    case "audit": {
                        stock.set(this.billstatus, (Object)"C");
                        stock.set(this.auditdate, (Object)baseData.getNowDate());
                        stock.set(this.auditor, (Object)baseData.getUser());
                        continue block8;
                    }
                }
                stock.set(this.billstatus, (Object)"A");
                stock.set(this.auditdate, null);
                stock.set(this.auditor, null);
            }
        }
    }

    public static void handleStock(String stockname, List<DynamicObject> savedataEntities, List<DynamicObject> updatedataEntities, Set<Long> deleteStockIds) {
        if (!deleteStockIds.isEmpty()) {
            MftstockplanServiceImpl.deleteOrderStock(deleteStockIds, stockname);
        }
        if (!(savedataEntities = savedataEntities.stream().filter(val -> val.getDynamicObjectCollection("stockentry") != null && val.getDynamicObjectCollection("stockentry").size() > 0).collect(Collectors.toList())).isEmpty()) {
            IDataEntityType type = ((DynamicObject)savedataEntities.get(0)).getDataEntityType();
            DBRoute rt = new DBRoute(type.getDBRouteKey());
            SequenceReader seqReader = new SequenceReader(rt);
            seqReader.autoSetPrimaryKey(savedataEntities, type);
            OperateOption create = OperateOption.create();
            create.setVariableValue("ishasright", "true");
            create.setVariableValue("ignorewarn", "true");
            create.setVariableValue("ignoreinteraction", "true");
            OperationResult saveOperate = SaveServiceHelper.saveOperate((String)stockname, (DynamicObject[])savedataEntities.toArray(new DynamicObject[savedataEntities.size()]), (OperateOption)create);
            if (!saveOperate.isSuccess()) {
                throw new KDBizException(new ErrorCode("AutoGenerateStock3", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25,\u4fdd\u5b58\u59d4\u5916\u7528\u6599\u6e05\u5355\u5f02\u5e38\uff1a%1$s", (String)"MftstockplanServiceImpl_4", (String)"mmc-om-mservice", (Object[])new Object[0]), MftstockplanServiceImpl.dealErrorInfo(saveOperate))), new Object[0]);
            }
        }
        if (!updatedataEntities.isEmpty()) {
            long start = System.currentTimeMillis();
            MftstockplanServiceImpl.updateBill(updatedataEntities);
            long end = System.currentTimeMillis() - start;
            logger.info("" + end);
        }
    }

    public static void updateBill(List<DynamicObject> updatedataEntities) {
        SaveServiceHelper.update((DynamicObject[])updatedataEntities.toArray(new DynamicObject[updatedataEntities.size()]));
    }

    public static void deleteOrderStock(Set<Long> orderEntryidSet, String entityType) {
        if (orderEntryidSet == null || orderEntryidSet.size() == 0) {
            return;
        }
        HashSet<Long> delStockIdtoOrderEntryIds = new HashSet<Long>(orderEntryidSet.size());
        QFilter filter = new QFilter("sourcebillid", "in", orderEntryidSet);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)MftstockplanServiceImpl.class.getName(), (String)entityType, (String)"id", (QFilter[])new QFilter[]{filter}, (String)"");){
            for (Row arow : ds) {
                delStockIdtoOrderEntryIds.add(arow.getLong("id"));
            }
        }
        if (delStockIdtoOrderEntryIds.isEmpty()) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"delete", (String)entityType, (Object[])delStockIdtoOrderEntryIds.toArray(new Long[delStockIdtoOrderEntryIds.size()]), (OperateOption)option);
        if (!executeOperate.isSuccess()) {
            throw new KDBizException(new ErrorCode("AutoGenerateStock3", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25,\u81ea\u52a8\u5220\u9664\u59d4\u5916\u7528\u6599\u8ba1\u5212\u5f02\u5e38\uff1a%1$s", (String)"MftstockplanServiceImpl_5", (String)"mmc-om-mservice", (Object[])new Object[0]), MftstockplanServiceImpl.dealErrorInfo(executeOperate))), new Object[0]);
        }
    }

    private static StringBuilder dealErrorInfo(OperationResult executeResult) {
        StringBuilder er = new StringBuilder(100);
        if (executeResult == null) {
            return er.append("no detial error info,please search logs.");
        }
        String message = executeResult.getMessage();
        if (StringUtils.isNotBlank((CharSequence)message)) {
            er.append(message);
        }
        for (IOperateInfo errInfo : executeResult.getAllErrorOrValidateInfo()) {
            String billMessage = errInfo.getMessage();
            if (!StringUtils.isNotEmpty((CharSequence)billMessage) || StringUtils.equals((CharSequence)"null", (CharSequence)billMessage)) continue;
            er.append(billMessage);
        }
        return er;
    }
}

