/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mmc.om.mservice.api.IOmForSrmService;

public class OmForSrmServiceImpl
implements IOmForSrmService {
    private static final String RECEIVEBASEQTYSUM = "receiveBaseQtySum";
    private static final String INBASEQTYSUM = "inBaseQtySum";
    public static final String MAINBILLENTRYID = "mainbillentryid";
    public static final String BASEQTY = "baseqty";
    public static final String ENTITY_PURRECEIVEBILL = "im_purreceivebill";
    public static final String ENTITY_IM_MDC_OMCMPLINBILL = "im_mdc_omcmplinbill";
    private static final String IS_SUCCESS = "isSuccess";
    private static final String SUCCESS_BILLIDS = "successBillIds";
    private static final String ERROR_MSG = "errorMsg";
    public static final String SRCSYSBILLENTRYID = "srcsysbillentryid";

    public Map<Long, String> getWarehouseBySupplierId(Map<String, Set<Long>> supplierIdsMap) {
        HashMap<Long, String> supplierId2WarehouseId = new HashMap<Long, String>(16);
        Set<Long> supplierIds = supplierIdsMap.get("supplierIds");
        if (supplierIds == null || supplierIds.isEmpty()) {
            return supplierId2WarehouseId;
        }
        String algoKey = "kd.mmc.om.mservice.OmForSrmServiceImpl.getWarehouseBySupplierId";
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("supplier.id", "in", supplierIds));
        qFilters.add(new QFilter("inwarehouse.enable", "=", (Object)Character.valueOf('1')));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"om_warehouseset", (String)"inwarehouse,inlocation,supplier", (QFilter[])qFilters.toArray(new QFilter[2]), null);){
            for (Row row : dataSet) {
                supplierId2WarehouseId.put(row.getLong("supplier"), row.getLong("inwarehouse") + "-" + row.getLong("inlocation"));
            }
        }
        return supplierId2WarehouseId;
    }

    public Map<String, String> getWarehouseBySupplierIdAndOrg(Map<String, Set<String>> paramMapMap) {
        HashMap<String, String> supplierId2WarehouseId = new HashMap<String, String>(16);
        Set<String> supplierIdAndOrgIds = paramMapMap.get("supplierIdAndOrgId");
        if (supplierIdAndOrgIds == null || supplierIdAndOrgIds.isEmpty()) {
            return supplierId2WarehouseId;
        }
        HashSet<Long> supplierIds = new HashSet<Long>(supplierIdAndOrgIds.size());
        HashSet<Long> orgIds = new HashSet<Long>(supplierIdAndOrgIds.size());
        for (String supplierIdAndOrgId : supplierIdAndOrgIds) {
            supplierIds.add(Long.parseLong(supplierIdAndOrgId.split("-")[0]));
            orgIds.add(Long.parseLong(supplierIdAndOrgId.split("-")[1]));
        }
        String algoKey = "kd.mmc.om.mservice.OmForSrmServiceImpl.getWarehouseBySupplierIdAndOrg";
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter("supplier.id", "in", supplierIds));
        qFilters.add(new QFilter("inwarehouse.enable", "=", (Object)Character.valueOf('1')));
        qFilters.add(new QFilter("inorg.id", "in", orgIds));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"om_warehouseset", (String)"inwarehouse,inlocation,supplier,inorg", (QFilter[])qFilters.toArray(new QFilter[3]), null);){
            for (Row row : dataSet) {
                Long inwarehouse = row.getLong("inwarehouse");
                Long inlocation = row.getLong("inlocation");
                Long supplier = row.getLong("supplier");
                Long inorg = row.getLong("inorg");
                String supplierIdAndOrgId = supplier + "-" + inorg;
                if (!supplierIdAndOrgIds.contains(supplierIdAndOrgId)) continue;
                supplierId2WarehouseId.put(supplierIdAndOrgId, inwarehouse + "-" + inlocation);
            }
        }
        return supplierId2WarehouseId;
    }

    public Map<String, Map<String, String>> getInWarehouseBaseQtyByMainBillId(Map<String, String> paramMap) {
        HashMap<String, Map<String, String>> mainSumBaseQty = new HashMap<String, Map<String, String>>(2);
        if (paramMap == null || paramMap.isEmpty()) {
            return mainSumBaseQty;
        }
        String coreBillEntryIds = paramMap.get("coreBillEntryIds");
        if (StringUtils.isBlank((CharSequence)coreBillEntryIds)) {
            return mainSumBaseQty;
        }
        List mainBillEntryIdList = (List)SerializationUtils.fromJsonString((String)coreBillEntryIds, List.class);
        if (mainBillEntryIdList.isEmpty()) {
            return mainSumBaseQty;
        }
        TableDefine receiveBillTable = EntityMetadataCache.loadTableDefine((String)ENTITY_PURRECEIVEBILL, (String)ENTITY_PURRECEIVEBILL);
        Long receiveTableId = receiveBillTable.getTableId();
        QFilter qtyFilter = new QFilter("isvirtualbill", "=", (Object)"0").and("ischargeoff", "=", (Object)"0").and("ischargeoffed", "=", (Object)"0").and("billentry.baseqty", ">", (Object)BigDecimal.ZERO).and("billentry.mainbillentryid", "in", (Object)mainBillEntryIdList);
        DataSet receiveSumData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)ENTITY_PURRECEIVEBILL, (String)"billentry.mainbillentryid as mainbillentryid, billentry.baseqty as baseqty", (QFilter[])qtyFilter.toArray(), null).groupBy(new String[]{MAINBILLENTRYID}).sum(BASEQTY).finish();
        if (receiveSumData != null) {
            for (Row row : receiveSumData) {
                Long mainBillEntryId = row.getLong(MAINBILLENTRYID);
                BigDecimal baseQtySum = row.getBigDecimal(BASEQTY);
                mainSumBaseQty.putIfAbsent(String.valueOf(mainBillEntryId), new HashMap(1));
                Map sumBaseQty = (Map)mainSumBaseQty.get(String.valueOf(mainBillEntryId));
                sumBaseQty.put(RECEIVEBASEQTYSUM, baseQtySum.toPlainString());
            }
        }
        QFilter billFilter = new QFilter("billentry.mainbillentryid", "in", (Object)mainBillEntryIdList);
        List inBillIdList = QueryServiceHelper.queryPrimaryKeys((String)this.getClass().getName(), (String)ENTITY_IM_MDC_OMCMPLINBILL, (QFilter[])billFilter.toArray(), null, (int)-1);
        List distinctBillIds = inBillIdList.stream().distinct().collect(Collectors.toList());
        Long[] inBillIds = (Long[])inBillIdList.stream().map(Long.class::cast).toArray(Long[]::new);
        Map linkUpNodes = BFTrackerServiceHelper.loadBillLinkUpNodes((String)ENTITY_IM_MDC_OMCMPLINBILL, (Long[])inBillIds, (boolean)false);
        block1: for (Map.Entry linkUpNodeEntry : linkUpNodes.entrySet()) {
            Long inBillId = (Long)linkUpNodeEntry.getKey();
            List allSourceNodes = ((BFRowLinkUpNode)linkUpNodeEntry.getValue()).findAllSourceNodes();
            for (BFRowLinkUpNode allSourceNode : allSourceNodes) {
                BFRowId rowId = allSourceNode.getRowId();
                Long mainTableId = rowId.getMainTableId();
                if (!receiveTableId.equals(mainTableId)) continue;
                distinctBillIds.remove(inBillId);
                continue block1;
            }
        }
        if (distinctBillIds.isEmpty()) {
            return mainSumBaseQty;
        }
        qtyFilter.and("id", "in", distinctBillIds);
        DataSet inSumData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)ENTITY_IM_MDC_OMCMPLINBILL, (String)"billentry.mainbillentryid as mainbillentryid, billentry.baseqty as baseqty", (QFilter[])qtyFilter.toArray(), null).groupBy(new String[]{MAINBILLENTRYID}).sum(BASEQTY).finish();
        if (inSumData != null) {
            for (Row row : inSumData) {
                String mainBillEntryId = row.getString(MAINBILLENTRYID);
                BigDecimal baseQtySum = row.getBigDecimal(BASEQTY);
                mainSumBaseQty.putIfAbsent(mainBillEntryId, new HashMap(1));
                Map sumBaseQty = (Map)mainSumBaseQty.get(mainBillEntryId);
                sumBaseQty.put(INBASEQTYSUM, baseQtySum.toPlainString());
            }
        }
        return mainSumBaseQty;
    }

    public Map<String, Map<String, Object>> deleteOmBill(Map<String, Set<Long>> billTypeAndBillIds) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>(billTypeAndBillIds.size());
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        for (Map.Entry<String, Set<Long>> entry : billTypeAndBillIds.entrySet()) {
            String billType = entry.getKey();
            Set<Long> billIds = entry.getValue();
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)billType, (Object[])billIds.toArray(new Long[0]), (OperateOption)operateOption);
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (operationResult.getSuccessPkIds().size() == billIds.size()) {
                map.put(IS_SUCCESS, Boolean.TRUE);
                map.put(SUCCESS_BILLIDS, billIds);
                map.put(ERROR_MSG, new HashMap());
            } else {
                map.put(IS_SUCCESS, Boolean.FALSE);
                map.put(SUCCESS_BILLIDS, operationResult.getSuccessPkIds().stream().map(v -> Long.parseLong(v.toString())).collect(Collectors.toSet()));
                HashMap<Long, String> idAndErrorMsg = new HashMap<Long, String>();
                for (IOperateInfo operateInfo : operationResult.getAllErrorOrValidateInfo()) {
                    Long billId = Long.parseLong(operateInfo.getPkValue().toString());
                    String msg = operateInfo.getMessage();
                    if (idAndErrorMsg.get(billId) != null) {
                        idAndErrorMsg.put(billId, (String)idAndErrorMsg.get(billId) + ";" + msg);
                        continue;
                    }
                    idAndErrorMsg.put(billId, msg);
                }
                map.put(ERROR_MSG, idAndErrorMsg);
            }
            result.put(billType, map);
        }
        return result;
    }

    public Map<String, Map<String, String>> getStockSumBaseQty(Map<String, String> paramMap) {
        Map sumBaseQty;
        BigDecimal baseQtySum;
        String srcSysBillEntryId;
        HashMap<String, Map<String, String>> stockSumBaseQty = new HashMap<String, Map<String, String>>(2);
        String salOutStockEntryIds = paramMap.get("salOutStockEntryIds");
        if (StringUtils.isBlank((CharSequence)salOutStockEntryIds)) {
            return stockSumBaseQty;
        }
        List stockEntryIdList = (List)SerializationUtils.fromJsonString((String)salOutStockEntryIds, List.class);
        if (stockEntryIdList == null || stockEntryIdList.isEmpty()) {
            return stockSumBaseQty;
        }
        QFilter qtyFilter = new QFilter("isvirtualbill", "=", (Object)"0").and("ischargeoff", "=", (Object)"0").and("ischargeoffed", "=", (Object)"0").and("billentry.baseqty", ">", (Object)BigDecimal.ZERO).and("billentry.srcsysbillentryid", "in", (Object)stockEntryIdList);
        DataSet receiveSumData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)ENTITY_PURRECEIVEBILL, (String)"billentry.srcsysbillentryid as srcsysbillentryid, billentry.baseqty as baseqty", (QFilter[])qtyFilter.toArray(), null).groupBy(new String[]{SRCSYSBILLENTRYID}).sum(BASEQTY).finish();
        DataSet inSumData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)ENTITY_IM_MDC_OMCMPLINBILL, (String)"billentry.saleoutstockentryid as srcsysbillentryid, billentry.baseqty as baseqty", (QFilter[])qtyFilter.toArray(), null).groupBy(new String[]{SRCSYSBILLENTRYID}).sum(BASEQTY).finish();
        if (receiveSumData != null) {
            for (Row row : receiveSumData) {
                srcSysBillEntryId = row.getString(SRCSYSBILLENTRYID);
                baseQtySum = row.getBigDecimal(BASEQTY);
                stockSumBaseQty.putIfAbsent(srcSysBillEntryId, new HashMap(1));
                sumBaseQty = (Map)stockSumBaseQty.get(srcSysBillEntryId);
                sumBaseQty.put(RECEIVEBASEQTYSUM, baseQtySum.toPlainString());
            }
        }
        if (inSumData != null) {
            for (Row row : inSumData) {
                srcSysBillEntryId = row.getString(SRCSYSBILLENTRYID);
                baseQtySum = row.getBigDecimal(BASEQTY);
                stockSumBaseQty.putIfAbsent(srcSysBillEntryId, new HashMap(1));
                sumBaseQty = (Map)stockSumBaseQty.get(srcSysBillEntryId);
                sumBaseQty.put(INBASEQTYSUM, baseQtySum.toPlainString());
            }
        }
        return stockSumBaseQty;
    }
}

