/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.mservice;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mmc.om.mservice.api.IOmStockDealInvService;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.collections.MapUtils;

public class OmStockDealInvSchemeImpl
implements IOmStockDealInvService {
    public void dealInvShecheme(ExtendedDataEntity[] entitys, Object o) {
        long userId = UserServiceHelper.getCurrentUserId();
        for (int i = 0; i < entitys.length; ++i) {
            ExtendedDataEntity entity = entitys[i];
            DynamicObject obj = entity.getDataEntity();
            DynamicObject outOrg = obj.getDynamicObject("outorg");
            DynamicObject org = obj.getDynamicObject("org");
            Long inOrgId = (Long)org.getPkValue();
            Long orgId = (Long)outOrg.getPkValue();
            this.setCurrency(obj, inOrgId);
            Map<Object, DynamicObject> operatorGroupMap = this.getOperatorGroupMap(orgId);
            this.initDept(userId, orgId, operatorGroupMap, obj);
            this.initOperatorAndGroup(userId, operatorGroupMap, obj);
            DynamicObject invScheme = obj.getDynamicObject("invscheme");
            invScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)invScheme.getPkValue(), (String)"im_invscheme", (String)this.getAllSelector());
            boolean isInUpdate = invScheme.getBoolean("isinupdate");
            boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
            boolean isInv = outOrg.getBoolean("fisinventory");
            if (isInv && orgId.compareTo(inOrgId) == 0) {
                obj.set("transtype", (Object)"A");
                obj.set("outoperator", obj.get("operator"));
            } else {
                obj.set("transtype", (Object)"B");
            }
            DynamicObjectCollection entrycols = obj.getDynamicObjectCollection("billentry");
            int size = entrycols.size();
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                DynamicObject entry = (DynamicObject)entrycols.get(rowIndex);
                DynamicObject material = entry.getDynamicObject("material");
                BigDecimal minpackqty = material.getBigDecimal("minpackqty");
                if (BigDecimal.ZERO.compareTo(minpackqty) >= 0) continue;
                entry.set("baseqty", (Object)minpackqty);
            }
        }
    }

    private void dealInvScheme(DynamicObject outOrg, DynamicObject org, DynamicObject invScheme, DynamicObject entry, boolean isInUpdate, boolean isOutUpdate) {
        String ownerType = null;
        String keeperType = null;
        DynamicObject invStatus = null;
        DynamicObject defaltInvType = null;
        if (isInUpdate) {
            ownerType = invScheme.getString("ownertype");
            keeperType = invScheme.getString("keepertype");
            invStatus = this.getDefaultInvStatus(invScheme);
            defaltInvType = this.getDefaltInvtype(invScheme);
            entry.set("ownertype", (Object)ownerType);
            if (null != ownerType && StringUtils.equals((CharSequence)"bd_supplier", (CharSequence)ownerType)) {
                entry.set("owner", this.getOwner(entry.getLong("srcbillentryid")));
            }
            entry.set("invtype", (Object)defaltInvType);
            entry.set("invstatus", (Object)invStatus);
            entry.set("keepertype", (Object)keeperType);
            if (null != keeperType && StringUtils.equals((CharSequence)"bd_supplier", (CharSequence)keeperType)) {
                entry.set("keeper", this.getSupplier(entry.getLong("srcbillid")));
            } else {
                entry.set("keeper", (Object)org);
            }
        }
        String outOwnerType = null;
        String outKeeperType = null;
        DynamicObject outInvStatus = null;
        DynamicObject defaltOutInvType = null;
        if (isOutUpdate) {
            outOwnerType = invScheme.getString("outownertype");
            outKeeperType = invScheme.getString("outkeepertype");
            outInvStatus = this.getDefaultOutInvStatus(invScheme);
            defaltOutInvType = this.getDefaltOutInvtype(invScheme);
            entry.set("outownertype", (Object)outOwnerType);
            if (null != outOwnerType && StringUtils.equals((CharSequence)"bd_supplier", (CharSequence)outOwnerType)) {
                entry.set("outowner", this.getOwner(entry.getLong("srcbillentryid")));
            }
            entry.set("outinvtype", (Object)defaltOutInvType);
            entry.set("outinvstatus", (Object)outInvStatus);
            entry.set("outkeepertype", (Object)outKeeperType);
            if (null != outKeeperType && StringUtils.equals((CharSequence)"bd_supplier", (CharSequence)outKeeperType)) {
                entry.set("outkeeper", this.getSupplier(entry.getLong("srcbillid")));
            } else {
                entry.set("outkeeper", (Object)outOrg);
            }
        }
    }

    private void setCurrency(DynamicObject obj, Long orgId) {
        Long currency;
        Map<String, Long> currencyinfo = OmStockDealInvSchemeImpl.getCurrencyAndExRateTable(orgId);
        HashMap<Long, Long> currencyMap = new HashMap<Long, Long>(128);
        if (null != currencyinfo && MapUtils.isNotEmpty(currencyinfo) && (currency = currencyinfo.get("baseCurrencyID")) != null && !currency.equals(0L)) {
            currencyMap.put(orgId, currency);
            HashSet baseCurrencyIds = new HashSet(currencyMap.values());
            QFilter filter = new QFilter("id", "in", baseCurrencyIds);
            Map bdCurrency = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (QFilter[])new QFilter[]{filter});
            if (MapUtils.isNotEmpty((Map)bdCurrency)) {
                Long currencyId = (Long)currencyMap.get(orgId);
                obj.set("settlescurrency", bdCurrency.get(currencyId));
            }
        }
    }

    public static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map map;
        Map mapOrg;
        if (orgId != 0L && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)false, (Boolean)true)) != null && mapOrg.get("id") != null && (map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")))) != null && map.size() != 0) {
            return map;
        }
        return Collections.emptyMap();
    }

    private void initOperatorAndGroup(long userId, Map<Object, DynamicObject> operatorGroupMap, DynamicObject obj) {
        if (operatorGroupMap.size() != 0) {
            QFilter qFilter11 = new QFilter("operatorgrpid", "in", operatorGroupMap.keySet());
            QFilter qFilter12 = new QFilter("operatorid", "=", (Object)userId);
            QFilter qFilter3 = new QFilter("invalid", "=", (Object)"0");
            DynamicObject operator = BusinessDataServiceHelper.loadSingle((String)"bd_operator", (String)"operatorid,operatornumber,operatorname,operatorgrpid,opergrpnumber,opergrpname,opergrptype", (QFilter[])new QFilter[]{qFilter11, qFilter12, qFilter3});
            if (operator != null) {
                obj.set("operator", (Object)operator);
                obj.set("outoperator", (Object)operator);
                DynamicObject operatorgroup = BusinessDataServiceHelper.loadSingle((Object)operator.getLong("operatorgrpid"), (String)"bd_operatorgroup");
                obj.set("operatorgroup", (Object)operatorgroup);
                obj.set("outoperatorgroup", (Object)operatorgroup);
            }
        }
    }

    private void initDept(long userId, Long orgId, Map<Object, DynamicObject> operatorGroupMap, DynamicObject obj) {
        if (operatorGroupMap.size() != 0) {
            QFilter qFilter11 = new QFilter("operatorgrpid", "in", operatorGroupMap.keySet());
            QFilter qFilter12 = new QFilter("operatorid", "=", (Object)userId);
            QFilter qFilter3 = new QFilter("invalid", "=", (Object)"0");
            DynamicObject operator = BusinessDataServiceHelper.loadSingle((String)"bd_operator", (String)"operatorid", (QFilter[])new QFilter[]{qFilter11, qFilter12, qFilter3});
            if (null == operator) {
                this.initDeptByOrg(orgId, obj);
            } else {
                this.initDeptByOperator(operator, orgId, obj);
            }
        }
    }

    private void initDeptByOperator(DynamicObject operator, Long orgId, DynamicObject obj) {
        List deptids = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)false);
        if (deptids != null && deptids.size() > 0) {
            List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)operator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
            if (userdeptIds != null && userdeptIds.size() > 0) {
                for (Long deptId : userdeptIds) {
                    if (!deptids.contains(deptId)) continue;
                    DynamicObject org = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
                    org.set("id", (Object)deptId);
                    obj.set("dept", (Object)org);
                    obj.set("outdept", (Object)org);
                    break;
                }
            }
        } else {
            List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)operator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
            if (userdeptIds != null && userdeptIds.size() > 0) {
                Long deptId = (Long)userdeptIds.get(0);
                DynamicObject org = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
                org.set("id", (Object)deptId);
                obj.set("dept", (Object)org);
                obj.set("outdept", (Object)org);
            }
        }
    }

    private void initDeptByOrg(Long orgId, DynamicObject obj) {
        List deptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
        if (deptIds != null && deptIds.size() > 0) {
            Long deptId = (Long)deptIds.get(0);
            DynamicObject org = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
            org.set("id", (Object)deptId);
            obj.set("dept", (Object)org);
            obj.set("outdept", (Object)org);
            return;
        }
        deptIds = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)true);
        if (deptIds != null && deptIds.size() > 0 && deptIds.contains(orgId)) {
            DynamicObject org = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
            org.set("id", (Object)orgId);
            obj.set("dept", (Object)org);
            obj.set("outdept", (Object)org);
        }
    }

    private Map<Object, DynamicObject> getOperatorGroupMap(Long orgId) {
        QFilter qFilter01 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        QFilter qFilter02 = new QFilter("operatorgrouptype", "=", (Object)"KCZ");
        qFilter02.and("enable", "=", (Object)"1");
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter01, qFilter02});
        return map;
    }

    private Object getOwner(long id) {
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"om_mftstock", (String)"stockentry.supplierid", (QFilter[])new QFilter[]{new QFilter("stockentry.id", "=", (Object)id)});
        Object supplierId = ((DynamicObject)colls.get(0)).get("stockentry.supplierid");
        return BusinessDataServiceHelper.loadSingleFromCache((Object)supplierId, (String)"bd_supplier");
    }

    private Object getSupplier(long id) {
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"om_mftstock", (String)"orderentryid.supplier", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        Object supplierId = ((DynamicObject)colls.get(0)).get("orderentryid.supplier");
        return BusinessDataServiceHelper.loadSingleFromCache((Object)supplierId, (String)"bd_supplier");
    }

    private String getAllSelector() {
        return "id,billform,number,name,enable,transceivertype,isnotupdate,isinupdate,ownertype,keepertype,invtypeentry.invtype,invtypeentry.invtypeisdefault,isoutupdate,outinvtype,outownertype,outkeepertype,outinvtypeentry.outinvtype,outinvtypeentry.outinvtypeisdefault,bitypeentry.biztype,outinvstatusentry.outinvstatusisdefault,invstatusentry.invstatusisdefault,invstatusentry.invstatus,outinvstatusentry.outinvstatus";
    }

    private DynamicObject getDefaultOutInvStatus(DynamicObject invScheme) {
        return OmStockDealInvSchemeImpl.getDefaultInvTypeOrStatus(invScheme, "outinvstatusentry", "outinvstatusisdefault", "outinvstatus");
    }

    private DynamicObject getDefaultInvStatus(DynamicObject invScheme) {
        return OmStockDealInvSchemeImpl.getDefaultInvTypeOrStatus(invScheme, "invstatusentry", "invstatusisdefault", "invstatus");
    }

    private static DynamicObject getDefaultInvTypeOrStatus(DynamicObject invScheme, String invTypeOrStatusEntry, String invTypeOrStatusIsDefault, String invTypeOrStatus) {
        DynamicObjectCollection entries = invScheme.getDynamicObjectCollection(invTypeOrStatusEntry);
        DynamicObject defaultInvTypeOrStatus = null;
        if (entries != null && entries.size() > 0) {
            for (DynamicObject entry : entries) {
                if (!entry.getBoolean(invTypeOrStatusIsDefault)) continue;
                defaultInvTypeOrStatus = entry.getDynamicObject(invTypeOrStatus);
                break;
            }
            if (defaultInvTypeOrStatus == null) {
                defaultInvTypeOrStatus = ((DynamicObject)entries.get(0)).getDynamicObject(invTypeOrStatus);
            }
        }
        return defaultInvTypeOrStatus;
    }

    private DynamicObject getDefaltOutInvtype(DynamicObject invScheme) {
        return OmStockDealInvSchemeImpl.getDefaultInvTypeOrStatus(invScheme, "outinvtypeentry", "outinvtypeisdefault", "outinvtype");
    }

    private DynamicObject getDefaltInvtype(DynamicObject invScheme) {
        return OmStockDealInvSchemeImpl.getDefaultInvTypeOrStatus(invScheme, "invtypeentry", "invtypeisdefault", "invtype");
    }
}

