/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.mservice.old;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.om.business.old.PurOrderClose;
import kd.mmc.om.common.old.MftOldGenStocksUtils;
import kd.mmc.om.common.old.PurOrderCalMaterialUtils;
import kd.mmc.om.mservice.api.old.IOmPmOrderCloseService;

public class OmPmOrderCloseImpl
implements IOmPmOrderCloseService {
    private static final Log logger = LogFactory.getLog(OmPmOrderCloseImpl.class);
    public static final String OM_PURORDER = "pm_om_purorderbill";

    public void closeOrder(Long orderEntryid, Long orderid) {
        DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)orderid, (String)OM_PURORDER);
        if (order != null) {
            PurOrderCalMaterialUtils.calMaterial((String)OM_PURORDER, (Object)order.getPkValue());
            DynamicObjectCollection orderEntry = order.getDynamicObjectCollection("billentry");
            for (int i = 0; i < orderEntry.size(); ++i) {
                String pickstatus;
                if (!orderEntryid.equals(((DynamicObject)orderEntry.get(i)).getPkValue())) continue;
                DynamicObject orderEntryDym = (DynamicObject)orderEntry.get(i);
                boolean labelNum = false;
                DynamicObjectCollection query = QueryServiceHelper.query((String)OM_PURORDER, (String)"billentry.pickstatus", (QFilter[])new QFilter[]{new QFilter("billentry.id", "=", orderEntryDym.getPkValue())});
                if (!query.isEmpty() && ("A".equals(pickstatus = (String)((DynamicObject)query.get(0)).get(0)) || "B".equals(pickstatus))) {
                    return;
                }
                DynamicObject transactiontype = QueryServiceHelper.queryOne((String)"mpdm_transactout", (String)"id,name,number,controlscope", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)order.getLong("transactiontype"))});
                boolean existsStock = OmPmOrderCloseImpl.findUnProStock(orderEntryid, transactiontype.getString("controlscope"));
                if (existsStock) {
                    return;
                }
                boolean existsManuinbill = OmPmOrderCloseImpl.findUnAuditBillByEntityId(orderEntryid, "im_mdc_ominbill");
                if (existsManuinbill) {
                    return;
                }
                boolean existsProorder = OmPmOrderCloseImpl.findUnAuditBillByEntityId(orderEntryid, "im_mdc_omproorder");
                if (existsProorder) {
                    return;
                }
                boolean existsFeedorder = OmPmOrderCloseImpl.findUnAuditBillByEntityId(orderEntryid, "im_mdc_omreturnorder");
                if (existsFeedorder) {
                    return;
                }
                boolean existsReturnorder = OmPmOrderCloseImpl.findUnAuditBillByEntityId(orderEntryid, "im_mdc_omfeedorder");
                if (existsReturnorder) {
                    return;
                }
                if (((DynamicObject)orderEntry.get(i)).getBigDecimal("invbaseqty").compareTo(((DynamicObject)orderEntry.get(i)).getBigDecimal("receivebaseqtydown")) < 0) {
                    return;
                }
                if (labelNum) continue;
                orderEntryDym.set("rowclosestatus", (Object)"B");
                SaveServiceHelper.update((DynamicObject)order);
                DynamicObjectCollection entryEntity = order.getDynamicObjectCollection("billentry");
                if (!entryEntity.isEmpty()) {
                    IDataEntityType dataEntityType = ((DynamicObject)entryEntity.get(0)).getDataEntityType();
                    DataEntityCacheManager cacheManager = new DataEntityCacheManager(dataEntityType);
                    cacheManager.removeByDt();
                }
                OmPmOrderCloseImpl.reCulStockWipqty(orderEntryid);
            }
            OmPmOrderCloseImpl.closeOrderBill(order);
        }
    }

    private static void closeOrderBill(DynamicObject order) {
        DynamicObjectCollection orderEntry = order.getDynamicObjectCollection("billentry");
        boolean flag = false;
        for (int i = 0; i < orderEntry.size(); ++i) {
            if ("B".equals(((DynamicObject)orderEntry.get(i)).getString("rowclosestatus"))) continue;
            flag = true;
            return;
        }
        if (!flag) {
            order.set("closestatus", (Object)"B");
            order.set("closedate", (Object)new Date());
            RequestContext requestContext = RequestContext.get();
            long userID = Long.parseLong(requestContext.getUserId());
            order.set("closer", (Object)userID);
            SaveServiceHelper.update((DynamicObject)order);
            DynamicObjectCollection entryEntity = order.getDynamicObjectCollection("billentry");
            if (!entryEntity.isEmpty()) {
                IDataEntityType dataEntityType = ((DynamicObject)entryEntity.get(0)).getDataEntityType();
                DataEntityCacheManager cacheManager = new DataEntityCacheManager(dataEntityType);
                cacheManager.removeByDt();
            }
        }
    }

    private static boolean findUnProStock(Long orderEntryid, String controlscope) {
        block5: {
            DynamicObjectCollection stockEntrys;
            block4: {
                QFilter filter2 = new QFilter("orderentryid", "=", (Object)orderEntryid);
                DynamicObject stockDym = BusinessDataServiceHelper.loadSingle((String)"om_componentlist", (String)"stockentry,stockentry.iscannegative,stockentry.wipqty,stockentry.iskeypart", (QFilter[])new QFilter[]{filter2});
                if (stockDym == null) {
                    return false;
                }
                stockEntrys = stockDym.getDynamicObjectCollection("stockentry");
                if (stockEntrys == null) {
                    return false;
                }
                if (!"C".equals(controlscope) && !"A".equals(controlscope)) break block4;
                for (DynamicObject stockEntry : stockEntrys) {
                    if (!stockEntry.getBoolean("iscannegative") || stockEntry.getBigDecimal("wipqty").compareTo(BigDecimal.ZERO) <= 0) continue;
                    return true;
                }
                break block5;
            }
            if (!"B".equals(controlscope)) break block5;
            for (DynamicObject stockEntry : stockEntrys) {
                if (!stockEntry.getBoolean("iscannegative") || !stockEntry.getBoolean("iskeypart") || stockEntry.getBigDecimal("wipqty").compareTo(BigDecimal.ZERO) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private static void reCulStockWipqty(long orderEntryid) {
        DynamicObjectCollection stockEntryDym;
        QFilter filter2 = new QFilter("orderentryid", "=", (Object)orderEntryid);
        DynamicObject stockDym = BusinessDataServiceHelper.loadSingle((String)"om_componentlist", (String)"transactiontypeid,orderentryid,baseqty,transactiontypeid.deduction,stockentry,stockentry.demandqty,stockentry.wipqty,stockentry.useqty,stockentry.iscannegative,stockentry.qtytype,stockentry.actissueqty,stockentry.feedingqty,stockentry.rejectedqty,stockentry.oprno,stockentry.processseq", (QFilter[])new QFilter[]{filter2});
        if (stockDym != null && (stockEntryDym = stockDym.getDynamicObjectCollection("stockentry")) != null) {
            for (int i = 0; i < stockEntryDym.size(); ++i) {
                DynamicObject stockEntry = (DynamicObject)stockEntryDym.get(i);
                BigDecimal useQty = MPDMMftGenStocksUtils.aculOMUseQty((DynamicObject)stockEntry, (Object)stockDym.getDynamicObject("orderentryid").getPkValue(), (DynamicObject)stockDym.getDynamicObject("transactiontypeid"));
                stockEntry.set("useqty", (Object)useQty);
                BigDecimal wipQty = MftOldGenStocksUtils.aculWIPQty((DynamicObject)stockEntry);
                stockEntry.set("wipqty", (Object)wipQty);
            }
            SaveServiceHelper.update((DynamicObject)stockDym);
        }
    }

    private static boolean findUnAuditBillByEntityId(Object pkValue, String entityid) {
        QFilter filter = new QFilter("billentry.manuentryid", "=", pkValue);
        if ("im_mdc_ominbill".equals(entityid)) {
            filter = new QFilter("billentry.mainbillentryid", "=", pkValue);
        }
        filter.and(new QFilter("billstatus", "!=", (Object)"C"));
        return QueryServiceHelper.exists((String)entityid, (QFilter[])new QFilter[]{filter});
    }

    public void closeOrder(List<Map<String, Long>> mapList) {
        if (mapList == null || mapList.isEmpty()) {
            logger.info("\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        PurOrderClose close = new PurOrderClose(mapList);
        close.doClose();
    }
}

