/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.mservice.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;

public class OutApplyBillUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(OutApplyBillUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        ThreadPools.executeOnceIncludeRequestContext((String)"OutApplyBillUpgradeServiceImpl", (Runnable)ThreadLifeCycleManager.wrapRunnable(() -> this.doUpgrade(scmRoute, result)));
        return result;
    }

    private void doUpgrade(DBRoute scmRoute, UpgradeResult result) {
        try (AlgoContext context = Algo.newContext();){
            String switchSql = "SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = ? ";
            try (DataSet countSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)switchSql, (Object[])new String[]{"t_mpdm_workprocedure"});){
                if (!countSet.hasNext()) {
                    String logstr = "OutApplyBillUpgradeServiceImpl upgrade t_pm_om_applybillentry ,t_mpdm_workprocedure has not exists.";
                    log.error(logstr);
                    result.setLog(logstr);
                    result.setSuccess(true);
                    return;
                }
            }
            countSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)switchSql, (Object[])new String[]{"t_pm_om_applybillentry"});
            var7_10 = null;
            try {
                if (!countSet.hasNext()) {
                    String logstr = "OutApplyBillUpgradeServiceImpl upgrade t_pm_om_applybillentry ,t_pm_om_applybillentry has not exists.";
                    log.error(logstr);
                    result.setLog(logstr);
                    result.setSuccess(true);
                    return;
                }
            }
            catch (Throwable logstr) {
                var7_10 = logstr;
                throw logstr;
            }
            finally {
                if (countSet != null) {
                    if (var7_10 != null) {
                        try {
                            countSet.close();
                        }
                        catch (Throwable throwable) {
                            var7_10.addSuppressed(throwable);
                        }
                    } else {
                        countSet.close();
                    }
                }
            }
            SqlBuilder sql = new SqlBuilder();
            sql.append("select t.fentryid,d.fid workproid", new Object[0]);
            sql.append("from t_pm_om_applybillentry t ", new Object[0]);
            sql.append("left join t_mpdm_workprocedure d on t.fworkpronumber = d.fnumber ", new Object[0]);
            sql.append("where t.fworkpronumber is not null ", new Object[0]);
            sql.append("and t.fworkproid <> d.fid ", new Object[0]);
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
            try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (SqlBuilder)sql);){
                for (Row row : dataSet) {
                    paramsList.add(new Object[]{row.get("workproid"), row.get("fentryid")});
                }
            }
            if (CollectionUtils.isNotEmpty(paramsList)) {
                String updateSql = "update t_pm_om_applybillentry set fworkproid = ? where fentryid = ?";
                List partition = ListUtils.partition(paramsList, (int)1000);
                for (List objects : partition) {
                    this.batchExcuteUpdate(DBRoute.of((String)"scm"), updateSql, objects);
                }
                log.info("OutApplyBillUpgradeServiceImpl upgrade t_pm_om_applybillentry end,count:" + paramsList.size());
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            result.setLog(e.toString());
            result.setSuccess(false);
        }
    }

    private void batchExcuteUpdate(DBRoute dbKey, String updateSql, List<Object[]> objects) {
        DB.executeBatch((DBRoute)dbKey, (String)updateSql, objects);
    }
}

